/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TypeAdapters$EnumTypeAdapter<T extends Enum<T>>
extends TypeAdapter<T> {
    private final Map<String, T> nameToConstant = new HashMap<String, T>();
    private final Map<T, String> constantToName = new HashMap<T, String>();

    public TypeAdapters$EnumTypeAdapter(Class<T> clazz) {
        try {
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                String string = enum_.name();
                SerializedName serializedName = clazz.getField(string).getAnnotation(SerializedName.class);
                if (serializedName != null) {
                    string = serializedName.value();
                }
                this.nameToConstant.put(string, enum_);
                this.constantToName.put(enum_, string);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError();
        }
    }

    @Override
    public T read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        return (T)((Enum)this.nameToConstant.get(jsonReader.nextString()));
    }

    @Override
    public void write(JsonWriter jsonWriter, T t2) {
        jsonWriter.value(t2 == null ? null : this.constantToName.get(t2));
    }
}

