/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.metro;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;

public class MetroGraphicsUtils
extends SynthGraphicsUtils {
    private Map<?, ?> desktopHints;

    public static RenderingHints getRenderingHints(Graphics2D graphics2D, Map<?, ?> map, RenderingHints renderingHints) {
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        } else {
            renderingHints.clear();
        }
        if (map.isEmpty()) {
            return renderingHints;
        }
        for (Object obj : map.keySet()) {
            RenderingHints.Key key = (RenderingHints.Key)obj;
            Object object = graphics2D.getRenderingHint(key);
            renderingHints.put(key, object);
        }
        return renderingHints;
    }

    @Override
    public void paintText(SynthContext synthContext, Graphics graphics, String string, int n2, int n3, int n4) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.desktopHints == null) {
            object = Toolkit.getDefaultToolkit();
            this.desktopHints = (Map)((Toolkit)object).getDesktopProperty("awt.font.desktophints");
        }
        object = null;
        RenderingHints renderingHints = null;
        if (this.desktopHints != null) {
            renderingHints = MetroGraphicsUtils.getRenderingHints(graphics2D, this.desktopHints, null);
            graphics2D.addRenderingHints(this.desktopHints);
        } else {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        super.paintText(synthContext, graphics, string, n2, n3, n4);
        if (renderingHints != null) {
            graphics2D.addRenderingHints(renderingHints);
        } else if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    public static BufferedImage loadImage(String string) {
        try {
            return ImageIO.read(MetroGraphicsUtils.class.getClassLoader().getResource("org/jackhuang/metro/images/" + string));
        }
        catch (Exception exception) {
            System.err.println("Error loading image \"org/jackhuang/metro/images/" + string + "\"");
            exception.printStackTrace();
            return null;
        }
    }

    public static Color getWebColor(String string) {
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        return new Color(Integer.parseInt(string.substring(0, 2), 16), Integer.parseInt(string.substring(2, 4), 16), Integer.parseInt(string.substring(4, 6), 16));
    }

    public static Color getWebColorWithAlpha(String string) {
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        return new Color(Integer.parseInt(string.substring(0, 2), 16), Integer.parseInt(string.substring(2, 4), 16), Integer.parseInt(string.substring(4, 6), 16), Integer.parseInt(string.substring(6, 8), 16));
    }

    public static Color getMidWebColor(String string, String string2) {
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if (string2.startsWith("#")) {
            string2 = string2.substring(1);
        }
        int n2 = Integer.parseInt(string.substring(0, 2), 16);
        int n3 = Integer.parseInt(string.substring(2, 4), 16);
        int n4 = Integer.parseInt(string.substring(4, 6), 16);
        int n5 = Integer.parseInt(string2.substring(0, 2), 16);
        int n6 = Integer.parseInt(string2.substring(2, 4), 16);
        int n7 = Integer.parseInt(string2.substring(4, 6), 16);
        int n8 = n2 + (n5 - n2) / 2;
        int n9 = n3 + (n6 - n3) / 2;
        int n10 = n4 + (n7 - n4) / 2;
        return new Color(n8, n9, n10);
    }

    public static Color getMidWebColor(String string, String string2, int n2) {
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if (string2.startsWith("#")) {
            string2 = string2.substring(1);
        }
        int n3 = Integer.parseInt(string.substring(0, 2), 16);
        int n4 = Integer.parseInt(string.substring(2, 4), 16);
        int n5 = Integer.parseInt(string.substring(4, 6), 16);
        int n6 = Integer.parseInt(string2.substring(0, 2), 16);
        int n7 = Integer.parseInt(string2.substring(2, 4), 16);
        int n8 = Integer.parseInt(string2.substring(4, 6), 16);
        int n9 = n3 + (n6 - n3) * n2 / 100;
        int n10 = n4 + (n7 - n4) * n2 / 100;
        int n11 = n5 + (n8 - n5) * n2 / 100;
        return new Color(n9, n10, n11);
    }

    public static Color getMidWebColor(Color color, Color color2, int n2) {
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        int n6 = color.getAlpha();
        int n7 = color2.getRed();
        int n8 = color2.getGreen();
        int n9 = color2.getBlue();
        int n10 = color2.getAlpha();
        int n11 = n3 + (n7 - n3) * n2 / 100;
        int n12 = n4 + (n8 - n4) * n2 / 100;
        int n13 = n5 + (n9 - n5) * n2 / 100;
        int n14 = n6 + (n10 - n6) * n2 / 100;
        return new Color(n11, n12, n13, n14);
    }

    public static BufferedImage createCompatibleTranslucentImage(int n2, int n3) {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(n2, n3, 3);
    }

    public static BufferedImage getAlphaMask(BufferedImage bufferedImage, int n2, int n3) {
        int n4 = (n2 - bufferedImage.getWidth()) / 2;
        int n5 = (n3 - bufferedImage.getHeight()) / 2;
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 10);
        int[] nArray = new int[bufferedImage.getWidth() * bufferedImage.getHeight()];
        WritableRaster writableRaster = bufferedImage.getAlphaRaster();
        writableRaster.getPixels(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray);
        bufferedImage2.getRaster().setPixels(n4, n5, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray);
        return bufferedImage2;
    }

    public static BufferedImage createColorMaskImage(BufferedImage bufferedImage, Color color) {
        int n2 = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = MetroGraphicsUtils.createCompatibleTranslucentImage(n3, n4);
        byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        int[] nArray = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = byArray[i2] << 24 | n2;
        }
        return bufferedImage2;
    }

    public static Kernel[] getSeparateGaussianKernel(int n2) {
        int n3;
        float[] fArray = new float[n2 * 2 + 1];
        double d2 = 0.0;
        int n4 = 2 * n2 + 1;
        double d3 = (double)n2 / 3.0;
        double d4 = 2.0 * Math.pow(d3, 2.0);
        double d5 = Math.PI * d4;
        double d6 = Math.sqrt(d5);
        for (n3 = 0; n3 < n4; ++n3) {
            fArray[n3] = (float)(Math.pow(Math.E, (double)(-((n3 - n2) * (n3 - n2))) / d4) / d6);
            d2 += (double)fArray[n3];
        }
        n3 = 0;
        while (n3 < n4) {
            int n5 = n3++;
            fArray[n5] = (float)((double)fArray[n5] / d2);
        }
        Kernel kernel = new Kernel(n4, 1, fArray);
        Kernel kernel2 = new Kernel(1, n4, fArray);
        return new Kernel[]{kernel, kernel2};
    }
}

