/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$1;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$Adapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$BoundField;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final Excluder excluder;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingStrategy, Excluder excluder) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingStrategy;
        this.excluder = excluder;
    }

    public boolean excludeField(Field field, boolean bl2) {
        return !this.excluder.excludeClass(field.getType(), bl2) && !this.excluder.excludeField(field, bl2);
    }

    private String getFieldName(Field field) {
        SerializedName serializedName = field.getAnnotation(SerializedName.class);
        return serializedName == null ? this.fieldNamingPolicy.translateName(field) : serializedName.value();
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Class<T> clazz = typeToken.getRawType();
        if (!Object.class.isAssignableFrom(clazz)) {
            return null;
        }
        ObjectConstructor<T> objectConstructor = this.constructorConstructor.get(typeToken);
        return new ReflectiveTypeAdapterFactory$Adapter(objectConstructor, this.getBoundFields(gson, typeToken, clazz), null);
    }

    private ReflectiveTypeAdapterFactory$BoundField createBoundField(Gson gson, Field field, String string, TypeToken<?> typeToken, boolean bl2, boolean bl3) {
        boolean bl4 = Primitives.isPrimitive(typeToken.getRawType());
        return new ReflectiveTypeAdapterFactory$1(this, string, bl2, bl3, gson, typeToken, field, bl4);
    }

    private Map<String, ReflectiveTypeAdapterFactory$BoundField> getBoundFields(Gson gson, TypeToken<?> typeToken, Class<?> clazz) {
        LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField> linkedHashMap = new LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField>();
        if (clazz.isInterface()) {
            return linkedHashMap;
        }
        Type type = typeToken.getType();
        while (clazz != Object.class) {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                boolean bl2 = this.excludeField(field, true);
                boolean bl3 = this.excludeField(field, false);
                if (!bl2 && !bl3) continue;
                field.setAccessible(true);
                Type type2 = $Gson$Types.resolve(typeToken.getType(), clazz, field.getGenericType());
                ReflectiveTypeAdapterFactory$BoundField reflectiveTypeAdapterFactory$BoundField = this.createBoundField(gson, field, this.getFieldName(field), TypeToken.get(type2), bl2, bl3);
                ReflectiveTypeAdapterFactory$BoundField reflectiveTypeAdapterFactory$BoundField2 = linkedHashMap.put(reflectiveTypeAdapterFactory$BoundField.name, reflectiveTypeAdapterFactory$BoundField);
                if (reflectiveTypeAdapterFactory$BoundField2 == null) continue;
                throw new IllegalArgumentException(type + " declares multiple JSON fields named " + reflectiveTypeAdapterFactory$BoundField2.name);
            }
            typeToken = TypeToken.get($Gson$Types.resolve(typeToken.getType(), clazz, clazz.getGenericSuperclass()));
            clazz = typeToken.getRawType();
        }
        return linkedHashMap;
    }
}

