/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.metro.painters;

import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import org.jackhuang.metro.MetroGraphicsUtils;

public class InternalFramePainter
extends SynthPainter {
    private static final BufferedImage FRAME_IMG = MetroGraphicsUtils.loadImage("inner_frame.png");
    private static final BufferedImage FRAME_IMG_NONFOCUSED = MetroGraphicsUtils.loadImage("inner_frame_defocused.png");
    private static final BufferedImage FRAME_CLOSE_DULL = MetroGraphicsUtils.loadImage("frame_close_dull.png");
    private static final BufferedImage FRAME_CLOSE = MetroGraphicsUtils.loadImage("frame_close.png");
    private static final BufferedImage FRAME_CLOSE_OVER = MetroGraphicsUtils.loadImage("frame_close_over.png");
    private static final BufferedImage FRAME_CLOSE_PRESSED = MetroGraphicsUtils.loadImage("frame_close_pressed.png");
    private static final BufferedImage FRAME_MAXIMIZE_DULL = MetroGraphicsUtils.loadImage("frame_maximize_dull.png");
    private static final BufferedImage FRAME_MAXIMIZE = MetroGraphicsUtils.loadImage("frame_maximize.png");
    private static final BufferedImage FRAME_MAXIMIZE_OVER = MetroGraphicsUtils.loadImage("frame_maximize_over.png");
    private static final BufferedImage FRAME_MAXIMIZE_PRESSED = MetroGraphicsUtils.loadImage("frame_maximize_pressed.png");
    private static final BufferedImage FRAME_MENU_BTN_DULL = MetroGraphicsUtils.loadImage("frame_menu_btn_dull.png");
    private static final BufferedImage FRAME_MENU_BTN = MetroGraphicsUtils.loadImage("frame_menu_btn.png");
    private static final BufferedImage FRAME_MENU_BTN_OVER = MetroGraphicsUtils.loadImage("frame_menu_btn_over.png");
    private static final BufferedImage FRAME_MENU_BTN_PRESSED = MetroGraphicsUtils.loadImage("frame_menu_btn_pressed.png");
    private static final BufferedImage FRAME_MINIMIZE_DULL = MetroGraphicsUtils.loadImage("frame_minimize_dull.png");
    private static final BufferedImage FRAME_MINIMIZE = MetroGraphicsUtils.loadImage("frame_minimize.png");
    private static final BufferedImage FRAME_MINIMIZE_OVER = MetroGraphicsUtils.loadImage("frame_minimize_over.png");
    private static final BufferedImage FRAME_MINIMIZE_PRESSED = MetroGraphicsUtils.loadImage("frame_minimize_pressed.png");
    private static final BufferedImage FRAME_WINDOWIZE_DULL = MetroGraphicsUtils.loadImage("frame_windowize_dull.png");
    private static final BufferedImage FRAME_WINDOWIZE = MetroGraphicsUtils.loadImage("frame_windowize.png");
    private static final BufferedImage FRAME_WINDOWIZE_OVER = MetroGraphicsUtils.loadImage("frame_windowize_over.png");
    private static final BufferedImage FRAME_WINDOWIZE_PRESSED = MetroGraphicsUtils.loadImage("frame_windowize_pressed.png");

    @Override
    public void paintDesktopPaneBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(new GradientPaint(n2, n3, MetroGraphicsUtils.getWebColor("476f8f"), n2, n3 + n5, MetroGraphicsUtils.getWebColor("2b4960")));
        graphics2D.fillRect(n2, n3, n4, n5);
    }

    @Override
    public void paintDesktopPaneBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    @Override
    public void paintInternalFrameBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.setColor(MetroGraphicsUtils.getWebColor("EBEDF2"));
        graphics.fillRect(n2 + 1, n3 + 1, n4 - 2, n5 - 2);
    }

    @Override
    public void paintInternalFrameBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        Color color;
        BufferedImage bufferedImage;
        if (((JInternalFrame)synthContext.getComponent()).isSelected()) {
            bufferedImage = FRAME_IMG;
            color = MetroGraphicsUtils.getWebColor("2b2e33");
        } else {
            bufferedImage = FRAME_IMG_NONFOCUSED;
            color = MetroGraphicsUtils.getWebColor("525761");
        }
        graphics.setColor(color);
        graphics.drawLine(n2, n3 + 1, n2, n5 - 2);
        graphics.drawLine(n2 + n4 - 1, n3 + 1, n2 + n4 - 1, n5 - 2);
        graphics.drawLine(n2 + 1, n3, n2 + n4 - 2, n3);
        graphics.drawLine(n2 + 1, n3 + n5 - 1, n2 + n4 - 2, n3 + n5 - 1);
        graphics.drawImage(bufferedImage, n2 + 1, n3 + 1, n2 + 6, n3 + 25, 0, 0, 5, 24, null);
        graphics.drawImage(bufferedImage, n2 + 1, n3 + 25, n2 + 6, n3 + n5 - 6, 0, 25, 5, 26, null);
        graphics.drawImage(bufferedImage, n2 + 1, n3 + n5 - 6, n2 + 6, n3 + n5 - 1, 0, 25, 5, 29, null);
        graphics.drawImage(bufferedImage, n2 + 6, n3 + n5 - 6, n2 + n4 - 6, n3 + n5 - 1, 6, 25, 7, 29, null);
        graphics.drawImage(bufferedImage, n2 + n4 - 6, n3 + 1, n2 + n4, n3 + 25, 6, 0, 12, 24, null);
        graphics.drawImage(bufferedImage, n2 + n4 - 6, n3 + 25, n2 + n4, n3 + n5 - 6, 6, 25, 12, 26, null);
        graphics.drawImage(bufferedImage, n2 + n4 - 6, n3 + n5 - 6, n2 + n4, n3 + n5 - 1, 6, 25, 12, 29, null);
    }

    @Override
    public void paintInternalFrameTitlePaneBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        BufferedImage bufferedImage = (synthContext.getComponentState() & 0x200) != 0 ? FRAME_IMG : FRAME_IMG_NONFOCUSED;
        graphics.drawImage(bufferedImage, n2, n3, n2 + n4, n3 + 24, 6, 0, 7, 24, null);
    }

    @Override
    public void paintInternalFrameTitlePaneBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    @Override
    public void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        JButton jButton = (JButton)synthContext.getComponent();
        if ("InternalFrameTitlePane.menuButton".equals(jButton.getName())) {
            if (InternalFramePainter.isNotSelected(jButton)) {
                graphics.drawImage(FRAME_MENU_BTN_DULL, n2, n3, jButton);
            } else if ((synthContext.getComponentState() & 4) != 0) {
                graphics.drawImage(FRAME_MENU_BTN_PRESSED, n2, n3, jButton);
            } else if ((synthContext.getComponentState() & 2) != 0) {
                graphics.drawImage(FRAME_MENU_BTN_OVER, n2, n3, jButton);
            } else {
                graphics.drawImage(FRAME_MENU_BTN, n2, n3, jButton);
            }
        } else if ("InternalFrameTitlePane.iconifyButton".equals(jButton.getName())) {
            if (InternalFramePainter.isNotSelected(jButton)) {
                graphics.drawImage(FRAME_MAXIMIZE_DULL, n2, n3, jButton);
            } else if ((synthContext.getComponentState() & 4) != 0) {
                graphics.drawImage(FRAME_MINIMIZE_PRESSED, n2, n3, jButton);
            } else if ((synthContext.getComponentState() & 2) != 0) {
                graphics.drawImage(FRAME_MINIMIZE_OVER, n2, n3, jButton);
            } else {
                graphics.drawImage(FRAME_MINIMIZE, n2, n3, jButton);
            }
        } else if ("InternalFrameTitlePane.maximizeButton".equals(jButton.getName())) {
            if (InternalFramePainter.isMaximized(jButton)) {
                if (InternalFramePainter.isNotSelected(jButton)) {
                    graphics.drawImage(FRAME_WINDOWIZE_DULL, n2, n3, jButton);
                } else if ((synthContext.getComponentState() & 4) != 0) {
                    graphics.drawImage(FRAME_WINDOWIZE_PRESSED, n2, n3, jButton);
                } else if ((synthContext.getComponentState() & 2) != 0) {
                    graphics.drawImage(FRAME_WINDOWIZE_OVER, n2, n3, jButton);
                } else {
                    graphics.drawImage(FRAME_WINDOWIZE, n2, n3, jButton);
                }
            } else if (InternalFramePainter.isNotSelected(jButton)) {
                graphics.drawImage(FRAME_MAXIMIZE_DULL, n2, n3, jButton);
            } else if ((synthContext.getComponentState() & 4) != 0) {
                graphics.drawImage(FRAME_MAXIMIZE_PRESSED, n2, n3, jButton);
            } else if ((synthContext.getComponentState() & 2) != 0) {
                graphics.drawImage(FRAME_MAXIMIZE_OVER, n2, n3, jButton);
            } else {
                graphics.drawImage(FRAME_MAXIMIZE, n2, n3, jButton);
            }
        } else if ("InternalFrameTitlePane.closeButton".equals(jButton.getName())) {
            if (InternalFramePainter.isNotSelected(jButton)) {
                graphics.drawImage(FRAME_CLOSE_DULL, n2, n3, jButton);
            } else if ((synthContext.getComponentState() & 4) != 0) {
                graphics.drawImage(FRAME_CLOSE_PRESSED, n2, n3, jButton);
            } else if ((synthContext.getComponentState() & 2) != 0) {
                graphics.drawImage(FRAME_CLOSE_OVER, n2, n3, jButton);
            } else {
                graphics.drawImage(FRAME_CLOSE, n2, n3, jButton);
            }
        }
    }

    private static boolean isMaximized(JButton jButton) {
        for (Container container = jButton.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JInternalFrame)) continue;
            return ((JInternalFrame)container).isMaximum();
        }
        return false;
    }

    private static boolean isNotSelected(JButton jButton) {
        for (Container container = jButton.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JInternalFrame)) continue;
            return !((JInternalFrame)container).isSelected();
        }
        return true;
    }
}

