/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.metro.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;
import org.jackhuang.metro.MetroGraphicsUtils;
import org.jackhuang.metro.ui.ScrollBarUI$1;
import org.jackhuang.metro.ui.ScrollBarUI$2;
import org.jackhuang.metro.ui.ScrollBarUI$3;
import org.jackhuang.metro.ui.ScrollButton;

public class ScrollBarUI
extends MetalScrollBarUI {
    private static final BufferedImage BACKGROUND_ENABLED = MetroGraphicsUtils.loadImage("scroll_enabled.png");
    private static final BufferedImage BACKGROUND_DISABLED = MetroGraphicsUtils.loadImage("scroll_disabled.png");
    private static final BufferedImage SCROLL_DEC_NORMAL = MetroGraphicsUtils.loadImage("scroll_dec_normal.png");
    private static final BufferedImage SCROLL_DEC_OVER = MetroGraphicsUtils.loadImage("scroll_dec_over.png");
    private static final BufferedImage SCROLL_DEC_PRESSED = MetroGraphicsUtils.loadImage("scroll_dec_pressed.png");
    private static final BufferedImage SCROLL_INC_NORMAL = MetroGraphicsUtils.loadImage("scroll_inc_normal.png");
    private static final BufferedImage SCROLL_INC_OVER = MetroGraphicsUtils.loadImage("scroll_inc_over.png");
    private static final BufferedImage SCROLL_INC_PRESSED = MetroGraphicsUtils.loadImage("scroll_inc_pressed.png");
    private static final BufferedImage SCROLL_THUMB_NORMAL = MetroGraphicsUtils.loadImage("scroll_thumb_normal.png");
    private static final BufferedImage SCROLL_THUMB_OVER = MetroGraphicsUtils.loadImage("scroll_thumb_over.png");
    private static final BufferedImage SCROLL_THUMB_PRESSED = MetroGraphicsUtils.loadImage("scroll_thumb_pressed.png");
    private boolean incBtnMouseOver;
    private boolean incBtnMousePressed;
    private boolean decBtnMouseOver;
    private boolean decBtnMousePressed;
    private boolean thumbMousePressed;

    public static ComponentUI createUI(JComponent jComponent) {
        return new ScrollBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(true);
        jComponent.addMouseListener(new ScrollBarUI$1(this));
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        return new Dimension(15, 15);
    }

    @Override
    protected JButton createDecreaseButton(int n2) {
        this.decreaseButton = new ScrollButton(n2, this.scrollBarWidth, this.isFreeStanding);
        this.decreaseButton.addMouseListener(new ScrollBarUI$2(this));
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int n2) {
        this.increaseButton = new ScrollButton(n2, this.scrollBarWidth, this.isFreeStanding);
        this.increaseButton.addMouseListener(new ScrollBarUI$3(this));
        return this.increaseButton;
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = this.decBtnMousePressed ? SCROLL_DEC_PRESSED : (bufferedImage = this.decBtnMouseOver ? SCROLL_DEC_OVER : SCROLL_DEC_NORMAL);
        BufferedImage bufferedImage3 = this.incBtnMousePressed ? SCROLL_INC_PRESSED : (this.incBtnMouseOver ? SCROLL_INC_OVER : SCROLL_INC_NORMAL);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        int n2 = this.scrollbar.getWidth();
        if (this.scrollbar.getOrientation() == 1) {
            n2 = this.scrollbar.getHeight();
            graphics2D.scale(1.0, -1.0);
            graphics2D.rotate(-1.5707963267948966, 0.0, 0.0);
        }
        if (this.scrollbar.isEnabled()) {
            graphics.drawImage(bufferedImage, 0, 0, this.scrollbar);
            graphics.drawImage(bufferedImage3, n2 - 15, 0, this.scrollbar);
        }
        graphics2D.setTransform(affineTransform);
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (this.scrollbar.isEnabled()) {
            BufferedImage bufferedImage = this.thumbMousePressed ? SCROLL_THUMB_PRESSED : (this.isThumbRollover() ? SCROLL_THUMB_OVER : SCROLL_THUMB_NORMAL);
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            Rectangle rectangle2 = rectangle;
            if (this.scrollbar.getOrientation() == 1) {
                rectangle2 = new Rectangle(rectangle.y, rectangle.x, rectangle.height, rectangle.width);
                graphics2D.scale(1.0, -1.0);
                graphics2D.rotate(-1.5707963267948966, 0.0, 0.0);
            }
            graphics.drawImage(bufferedImage, rectangle2.x, rectangle2.y, rectangle2.x + 14, rectangle2.y + 15, 0, 0, 14, 15, this.scrollbar);
            graphics.drawImage(bufferedImage, rectangle2.x + 14, rectangle2.y, rectangle2.x + rectangle2.width - 14, rectangle2.y + 15, 16, 0, 17, 15, this.scrollbar);
            graphics.drawImage(bufferedImage, rectangle2.x + rectangle2.width - 14, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + 15, 24, 0, 38, 15, this.scrollbar);
            graphics2D.setTransform(affineTransform);
        }
    }

    static /* synthetic */ boolean access$002(ScrollBarUI scrollBarUI, boolean bl2) {
        scrollBarUI.thumbMousePressed = bl2;
        return scrollBarUI.thumbMousePressed;
    }

    static /* synthetic */ JScrollBar access$100(ScrollBarUI scrollBarUI) {
        return scrollBarUI.scrollbar;
    }

    static /* synthetic */ boolean access$202(ScrollBarUI scrollBarUI, boolean bl2) {
        scrollBarUI.decBtnMouseOver = bl2;
        return scrollBarUI.decBtnMouseOver;
    }

    static /* synthetic */ boolean access$302(ScrollBarUI scrollBarUI, boolean bl2) {
        scrollBarUI.decBtnMousePressed = bl2;
        return scrollBarUI.decBtnMousePressed;
    }

    static /* synthetic */ boolean access$402(ScrollBarUI scrollBarUI, boolean bl2) {
        scrollBarUI.incBtnMouseOver = bl2;
        return scrollBarUI.incBtnMouseOver;
    }

    static /* synthetic */ boolean access$502(ScrollBarUI scrollBarUI, boolean bl2) {
        scrollBarUI.incBtnMousePressed = bl2;
        return scrollBarUI.incBtnMousePressed;
    }
}

