local assets=
{
	Asset("ANIM", "anim/slurtle_shellpieces.zip"),
}

local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()

	MakeInventoryPhysics(inst)

	inst.AnimState:SetBank("slurtle_shellpieces")
	inst.AnimState:SetBuild("slurtle_shellpieces")
	inst.AnimState:PlayAnimation("idle")

	inst:AddComponent("inspectable")

	inst:AddComponent("inventoryitem")
local function OnDeploy (inst, pt)
    local golf = SpawnPrefab("slurtle_shellpieces")
    golf.Transform:SetPosition(pt.x, pt.y, pt.z)
    golf.AnimState:SetBank("bulb")
    golf.AnimState:SetBuild("bulb")
    golf.AnimState:PlayAnimation("idle")
    golf.Transform:SetScale(0.8, 0.8, 0.8)
    golf.components.inventoryitem.canbepickedup = false
    MakeSmallBurnable(golf)
    golf:AddComponent("perishable")
    golf.components.perishable:SetPerishTime(TUNING.PERISH_ONE_DAY)
    golf.components.perishable:StartPerishing()
    golf.components.perishable.onperishreplacement = "ash"
    golf:AddComponent("workable")
    golf.components.workable:SetWorkAction(ACTIONS.HAMMER)
    golf.components.workable:SetWorkLeft(10)
    golf.components.workable:SetOnFinishCallback(function(golf)
        SpawnPrefab("ground_chunks_breaking").Transform:SetPosition(golf.Transform:GetWorldPosition())
        golf:Remove()
    end )
    golf.components.workable:SetOnWorkCallback(function(golf)
        local pt2 = Vector3(golf.Transform:GetWorldPosition())
        local pos = Vector3(GetPlayer().Transform:GetWorldPosition())
        golf.Physics:SetMotorVelOverride((pt2.x-pos.x)*13,0,(pt2.z-pos.z)*13)
        golf:DoTaskInTime(0.2, function() golf.Physics:ClearMotorVelOverride() end )
        GetPlayer().components.sanity:DoDelta(5)
    end )
    golf:DoPeriodicTask(.05, function(golf)
        local pos2 = Vector3(golf.Transform:GetWorldPosition())
        local ents = TheSim:FindEntities(pos2.x,pos2.y,pos2.z, 0.5)
        for k,v in pairs(ents) do
            if v.prefab == "rabbithole" then
               GetPlayer().SoundEmitter:PlaySound("dontstarve/wilson/use_axe_tree")
               golf:Remove()
               GetPlayer().components.sanity:DoDelta(50)
            end
        end
    end )
    golf:AddTag("golfs")
    inst.components.stackable:Get():Remove()
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy
local function onsave(inst, data)
    if inst:HasTag("golfs") then
        data.golfs = true
    end
end
local function onload(inst, data)
  if data and data.golfs then
    inst.AnimState:SetBank("bulb")
    inst.AnimState:SetBuild("bulb")
    inst.AnimState:PlayAnimation("idle")
    inst.Transform:SetScale(0.8, 0.8, 0.8)
    inst.components.inventoryitem.canbepickedup = false
    MakeSmallBurnable(inst)
    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_ONE_DAY)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "ash"
    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(10)
    inst.components.workable:SetOnFinishCallback(function(inst)
        SpawnPrefab("ground_chunks_breaking").Transform:SetPosition(inst.Transform:GetWorldPosition())
        inst:Remove()
    end )
    inst.components.workable:SetOnWorkCallback(function(inst)
        local pt2 = Vector3(inst.Transform:GetWorldPosition())
        local pos = Vector3(GetPlayer().Transform:GetWorldPosition())
        inst.Physics:SetMotorVelOverride((pt2.x-pos.x)*13,0,(pt2.z-pos.z)*13)
        inst:DoTaskInTime(0.2, function() inst.Physics:ClearMotorVelOverride() end )
        GetPlayer().components.sanity:DoDelta(5)
    end )
    inst:DoPeriodicTask(.05, function(inst)
        local pos2 = Vector3(inst.Transform:GetWorldPosition())
        local ents = TheSim:FindEntities(pos2.x,pos2.y,pos2.z, 0.5)
        for k,v in pairs(ents) do
            if v.prefab == "rabbithole" then
               GetPlayer().SoundEmitter:PlaySound("dontstarve/wilson/use_axe_tree")
               inst:Remove()
               GetPlayer().components.sanity:DoDelta(50)
            end
        end
    end )
    inst:AddTag("golfs")
  end
end
    inst.OnSave = onsave
    inst.OnLoad = onload

	inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_LARGEITEM

	return inst
end


return Prefab("common/inventory/slurtle_shellpieces", fn, assets) 
