require "util"
local Screen = require "widgets/screen"
local Button = require "widgets/button"
local AnimButton = require "widgets/animbutton"
local ImageButton = require "widgets/imagebutton"
local Menu = require "widgets/menu"
local Grid = require "widgets/grid"
local Text = require "widgets/text"
local Image = require "widgets/image"
local UIAnim = require "widgets/uianim"
local Spinner = require "widgets/spinner"
local NumericSpinner = require "widgets/numericspinner"
local Widget = require "widgets/widget"

--require "screens/popupdialog"


local text_font = UIFONT--NUMBERFONT

local enableDisableOptions = { { text = STRINGS.UI.OPTIONS.DISABLED, data = false }, { text = STRINGS.UI.OPTIONS.ENABLED, data = true } }
local spinnerFont = { font = BUTTONFONT, size = 30 }


CheatsScreen = Class(Screen, function(self, in_game)
	Screen._ctor(self, "CheatsScreen")
	SetPause(true)
	self.in_game = in_game

	self.options = {
		infHealth = Profile:GetValue("infhealth"),
		infHunger = Profile:GetValue("infhunger"),
		infSanity = Profile:GetValue("infsanity"),
		infTools = Profile:GetValue("inftooluses"),
		infHeatStone = Profile:GetValue("infheatstone"),
		noPerish = Profile:GetValue("noperish"),
		oneHitKill = Profile:GetValue("onehitkill"),
		infArmor = Profile:GetValue("infarmor"),
		infCampfire = Profile:GetValue("infcampfire"),
		oneHitBreak = Profile:GetValue("onehitbreak")
		
	}


	self.working = deepcopy( self.options )
	
	
    self.black = self:AddChild(Image("images/global.xml", "square.tex"))
    self.black:SetVRegPoint(ANCHOR_MIDDLE)
    self.black:SetHRegPoint(ANCHOR_MIDDLE)
    self.black:SetVAnchor(ANCHOR_MIDDLE)
    self.black:SetHAnchor(ANCHOR_MIDDLE)
    self.black:SetScaleMode(SCALEMODE_FILLSCREEN)
	self.black:SetTint(0,0,0,.25)	
    
	self.root = self:AddChild(Widget("ROOT"))
    self.root:SetVAnchor(ANCHOR_MIDDLE)
    self.root:SetHAnchor(ANCHOR_MIDDLE)
    self.root:SetPosition(0,0,0)
    self.root:SetScaleMode(SCALEMODE_PROPORTIONAL)
    
	local shield = self.root:AddChild( Image( "images/globalpanels.xml", "panel.tex" ) )
	shield:SetPosition( 0,0,0 )
	shield:SetSize( 1000, 700 )		
	
	

	self.menu = self.root:AddChild(Menu(nil, -60, false))
	self.menu:SetPosition(240 , -220 ,0)

	self.grid = self.root:AddChild(Grid())
	self.grid:InitSize(2, 7, 400, -70)
	self.grid:SetPosition(-250, 175, 0)
	self:DoInit()
	self:InitializeSpinners()

	self.default_focus = self.menu

end)


function CheatsScreen:OnControl(control, down)
    if CheatsScreen._base.OnControl(self, control, down) then return true end
    
    if (control == CONTROL_PAUSE or control == CONTROL_CANCEL) and not down then
		self:Accept()
		return true
    end
end


function CheatsScreen:Accept()
	self.options = deepcopy( self.working )

	Profile:SetValue("infhealth", self.options.infHealth)
	Profile:SetValue("infhunger", self.options.infHunger)
	Profile:SetValue("infsanity", self.options.infSanity)
	Profile:SetValue("inftooluses", self.options.infTools)
	Profile:SetValue("infheatstone", self.options.infHeatStone)
	Profile:SetValue("noperish", self.options.noPerish)
	Profile:SetValue("onehitkill", self.options.oneHitKill)
	Profile:SetValue("infarmor", self.options.infArmor)
	Profile:SetValue("infcampfire", self.options.infCampfire)
	Profile:SetValue("onehitbreak", self.options.oneHitBreak)
	
	Profile:Save()	
	
	TheFrontEnd:PopScreen()
	SetPause(false)
end



local function MakeMenu(offset, menuitems)
	local menu = Widget("OptionsMenu")	
	local pos = Vector3(0,0,0)
	for k,v in ipairs(menuitems) do
		local button = menu:AddChild(ImageButton())
	    button:SetPosition(pos)
	    button:SetText(v.text)
	    button.text:SetColour(0,0,0,1)
	    button:SetOnClick( v.cb )
	    button:SetFont(BUTTONFONT)
	    button:SetTextSize(40)    
	    pos = pos + offset  
	end
	return menu
end

function CheatsScreen:CreateSpinnerGroup( text, spinner )
	local label_width = 200
	spinner:SetTextColour(0,0,0,1)
	local group = Widget( "SpinnerGroup" )
	local label = group:AddChild( Text( BODYTEXTFONT, 30, text ) )
	label:SetPosition( -label_width/2, 0, 0 )
	label:SetRegionSize( label_width, 50 )
	label:SetHAlign( ANCHOR_RIGHT )
	
	group:AddChild( spinner )
	spinner:SetPosition( 125, 0, 0 )
	
	--pass focus down to the spinner
	group.focus_forward = spinner
	return group
end


function CheatsScreen:UpdateMenu()
	self.menu:Clear()

	self.menu:AddItem(STRINGS.UI.OPTIONS.CLOSE, function() self:Accept() end)
end


function CheatsScreen:DoInit()
	self:UpdateMenu()
	

	local this = self
	
	self.infHealthSpinner = Spinner( enableDisableOptions )
	self.infHealthSpinner.OnChanged =
		function( _, data )
			this.working.infHealth = data
			self:UpdateMenu()
		end
		
	self.infHungerSpinner = Spinner( enableDisableOptions )
	self.infHungerSpinner.OnChanged =
		function( _, data )
			this.working.infHunger = data
			self:UpdateMenu()
		end
		
	self.infSanitySpinner = Spinner( enableDisableOptions )
	self.infSanitySpinner.OnChanged =
		function( _, data )
			this.working.infSanity = data
			self:UpdateMenu()
		end
		
	self.infToolsSpinner = Spinner( enableDisableOptions )
	self.infToolsSpinner.OnChanged =
		function( _, data )
			this.working.infTools = data
			self:UpdateMenu()
		end
		
	self.infHeatStoneSpinner = Spinner( enableDisableOptions )
	self.infHeatStoneSpinner.OnChanged =
		function( _, data )
			this.working.infHeatStone = data
			self:UpdateMenu()
		end
		
	self.noPerishSpinner = Spinner( enableDisableOptions )
	self.noPerishSpinner.OnChanged =
		function( _, data )
			this.working.noPerish = data
			self:UpdateMenu()
		end
		
	self.oneHitKillSpinner = Spinner( enableDisableOptions )
	self.oneHitKillSpinner.OnChanged =
		function( _, data )
			this.working.oneHitKill = data
			self:UpdateMenu()
		end
	
	self.infArmorSpinner = Spinner( enableDisableOptions )
	self.infArmorSpinner.OnChanged =
		function( _, data )
			this.working.infArmor = data
			self:UpdateMenu()
		end
	
	self.infCampfireSpinner = Spinner( enableDisableOptions )
	self.infCampfireSpinner.OnChanged =
		function( _, data )
			this.working.infCampfire = data
			self:UpdateMenu()
		end
	
	self.oneHitBreakSpinner = Spinner( enableDisableOptions )
	self.oneHitBreakSpinner.OnChanged =
		function( _, data )
			this.working.oneHitBreak = data
			self:UpdateMenu()
		end
	
	
	local left_spinners = {}
	local right_spinners = {}
	

	table.insert( left_spinners, { "Inf. Health", self.infHealthSpinner } )
	table.insert( left_spinners, { "Inf. Hunger", self.infHungerSpinner } )
	table.insert( left_spinners, { "Inf. Sanity", self.infSanitySpinner } )
	table.insert( left_spinners, { "Inf. Tool Uses", self.infToolsSpinner } )
	table.insert( left_spinners, { "Inf. HeatStone Warmth", self.infHeatStoneSpinner } )
	table.insert( left_spinners, { "Food Doesn't Perish", self.noPerishSpinner } )
	
	table.insert( right_spinners, { "One Hit Kill", self.oneHitKillSpinner } )
	table.insert( right_spinners, { "Inf. Armor", self.infArmorSpinner } )
	table.insert( right_spinners, { "Inf. Campfire", self.infCampfireSpinner } )
	table.insert( right_spinners, { "One Hit Break", self.oneHitBreakSpinner } )
	

	self.grid:InitSize(2, 7, 400, -70)

	for k,v in ipairs(left_spinners) do
		self.grid:AddItem(self:CreateSpinnerGroup(v[1], v[2]), 1, k)	
	end

	for k,v in ipairs(right_spinners) do
		self.grid:AddItem(self:CreateSpinnerGroup(v[1], v[2]), 2, k)	
	end

end

local function EnabledOptionsIndex( enabled )
	if enabled then
		return 2
	else
		return 1
	end
end

function CheatsScreen:InitializeSpinners()

	self.infHealthSpinner:SetSelectedIndex( EnabledOptionsIndex( self.working.infHealth ) )
	self.infHungerSpinner:SetSelectedIndex( EnabledOptionsIndex( self.working.infHunger ) )
	self.infSanitySpinner:SetSelectedIndex( EnabledOptionsIndex( self.working.infSanity ) )
	self.infToolsSpinner:SetSelectedIndex( EnabledOptionsIndex( self.working.infTools ) )
	self.infHeatStoneSpinner:SetSelectedIndex( EnabledOptionsIndex( self.working.infHeatStone ) )
	self.noPerishSpinner:SetSelectedIndex( EnabledOptionsIndex( self.working.noPerish ) )
	self.oneHitKillSpinner:SetSelectedIndex( EnabledOptionsIndex( self.working.oneHitKill ) )
	self.infArmorSpinner:SetSelectedIndex( EnabledOptionsIndex( self.working.infArmor ) )
	self.infCampfireSpinner:SetSelectedIndex( EnabledOptionsIndex( self.working.infCampfire ) )
	self.oneHitBreakSpinner:SetSelectedIndex( EnabledOptionsIndex( self.working.oneHitBreak ) )
	
end

