/*
 * Decompiled with CFR 0.152.
 */
package com.chunkbase.mod.forge.mods.villageinfossp.villagedata;

import java.io.Serializable;
import java.util.List;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class VillageData
implements Serializable {
    private int id;
    private int centerX;
    private int centerY;
    private int centerZ;
    private int numVillagers;
    private int numDoors;
    private int numGolems;
    private int radius;
    private int reputation;
    private boolean areBreeding;
    private boolean villageFound;

    private VillageData() {
    }

    public int getId() {
        return this.id;
    }

    public int getRadius() {
        return this.radius;
    }

    public boolean isVillageFound() {
        return this.villageFound;
    }

    public int getNumDoors() {
        return this.numDoors;
    }

    public int getReputation() {
        return this.reputation;
    }

    public boolean areBreeding() {
        return this.areBreeding;
    }

    public ChunkCoordinates getCenter() {
        return new ChunkCoordinates(this.centerX, this.centerY, this.centerZ);
    }

    public int getNumVillagers() {
        return this.numVillagers;
    }

    public int getNumGolems() {
        return this.numGolems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VillageData that = (VillageData)o;
        if (!this.villageFound && !that.villageFound) {
            return true;
        }
        if (this.areBreeding != that.areBreeding) {
            return false;
        }
        if (this.centerX != that.centerX) {
            return false;
        }
        if (this.centerY != that.centerY) {
            return false;
        }
        if (this.centerZ != that.centerZ) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.numDoors != that.numDoors) {
            return false;
        }
        if (this.numGolems != that.numGolems) {
            return false;
        }
        if (this.numVillagers != that.numVillagers) {
            return false;
        }
        if (this.radius != that.radius) {
            return false;
        }
        if (this.reputation != that.reputation) {
            return false;
        }
        return this.villageFound == that.villageFound;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.centerX;
        result = 31 * result + this.centerY;
        result = 31 * result + this.centerZ;
        result = 31 * result + this.numVillagers;
        result = 31 * result + this.numDoors;
        result = 31 * result + this.numGolems;
        result = 31 * result + this.radius;
        result = 31 * result + this.reputation;
        result = 31 * result + (this.areBreeding ? 1 : 0);
        result = 31 * result + (this.villageFound ? 1 : 0);
        return result;
    }

    public static VillageData build(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        WorldServer worldServer = DimensionManager.getWorld((int)player.field_71093_bK);
        if (worldServer == null) {
            return null;
        }
        VillageData ret = new VillageData();
        VillageCollection vlgc = worldServer.field_72982_D;
        Village closestVillage = vlgc.func_75550_a(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v), 5000);
        if (closestVillage == null) {
            ret.villageFound = false;
            return ret;
        }
        ret.numGolems = VillageData.getNumGolems(worldServer, closestVillage);
        ChunkCoordinates center = closestVillage.func_75577_a();
        ret.centerX = center.field_71574_a;
        ret.centerY = center.field_71572_b;
        ret.centerZ = center.field_71573_c;
        ret.numDoors = closestVillage.func_75567_c();
        ret.numVillagers = closestVillage.func_75562_e();
        ret.radius = closestVillage.func_75568_b();
        ret.reputation = closestVillage.func_82684_a(player.func_70005_c_());
        ret.areBreeding = closestVillage.func_82686_i();
        ret.id = closestVillage.hashCode();
        ret.villageFound = true;
        return ret;
    }

    private static int getNumGolems(WorldServer worldServer, Village closestVillage) {
        if (closestVillage != null && worldServer != null) {
            List list = worldServer.func_72872_a(EntityIronGolem.class, AxisAlignedBB.func_72330_a((double)(closestVillage.func_75577_a().field_71574_a - closestVillage.func_75568_b()), (double)(closestVillage.func_75577_a().field_71572_b - 4), (double)(closestVillage.func_75577_a().field_71573_c - closestVillage.func_75568_b()), (double)(closestVillage.func_75577_a().field_71574_a + closestVillage.func_75568_b()), (double)(closestVillage.func_75577_a().field_71572_b + 4), (double)(closestVillage.func_75577_a().field_71573_c + closestVillage.func_75568_b())));
            return list.size();
        }
        return 0;
    }
}

