/*
 * Decompiled with CFR 0.152.
 */
package com.stormister.rediscovered;

import com.stormister.rediscovered.EntityGoodDragonPart;
import com.stormister.rediscovered.IEntityMultiPartRed;
import com.stormister.rediscovered.mod_Rediscovered;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityGoodDragon
extends EntityLiving
implements IEntityMultiPartRed,
IMob {
    public double targetX;
    public double targetY;
    public double targetZ;
    public double[][] ringBuffer = new double[64][3];
    public int ringBufferIndex = -1;
    public EntityGoodDragonPart[] dragonPartArray;
    public EntityGoodDragonPart dragonPartHead = new EntityGoodDragonPart(this, "head", 6.0f, 6.0f);
    public EntityGoodDragonPart dragonPartBody = new EntityGoodDragonPart(this, "body", 8.0f, 8.0f);
    public EntityGoodDragonPart dragonPartTail1 = new EntityGoodDragonPart(this, "tail", 4.0f, 4.0f);
    public EntityGoodDragonPart dragonPartTail2 = new EntityGoodDragonPart(this, "tail", 4.0f, 4.0f);
    public EntityGoodDragonPart dragonPartTail3 = new EntityGoodDragonPart(this, "tail", 4.0f, 4.0f);
    public EntityGoodDragonPart dragonPartTailSpike1;
    public EntityGoodDragonPart dragonPartTailSpike2;
    public EntityGoodDragonPart dragonPartTailSpike3;
    public EntityGoodDragonPart dragonPartTailSpike4;
    public EntityGoodDragonPart dragonPartTailSpike5;
    public EntityGoodDragonPart dragonPartWing1 = new EntityGoodDragonPart(this, "wing", 4.0f, 4.0f);
    public EntityGoodDragonPart dragonPartWing2 = new EntityGoodDragonPart(this, "wing", 4.0f, 4.0f);
    public float prevAnimTime = 0.0f;
    public float animTime = 0.0f;
    public boolean forceNewTarget = false;
    public boolean angry = false;
    public boolean renderTailSpike = false;
    public int health = 100;
    public boolean slowed = false;
    private Entity target;
    public int deathTicks = 0;
    public EntityEnderCrystal healingEnderCrystal = null;

    public EntityGoodDragon(World par1World) {
        super(par1World);
        this.dragonPartTailSpike1 = new EntityGoodDragonPart(this, "tail", 2.0f, 2.0f);
        this.dragonPartTailSpike2 = new EntityGoodDragonPart(this, "tail", 2.0f, 2.0f);
        this.dragonPartTailSpike3 = new EntityGoodDragonPart(this, "tail", 2.0f, 2.0f);
        this.dragonPartTailSpike4 = new EntityGoodDragonPart(this, "tail", 2.0f, 2.0f);
        this.dragonPartTailSpike5 = new EntityGoodDragonPart(this, "tail", 2.0f, 2.0f);
        this.dragonPartArray = new EntityGoodDragonPart[]{this.dragonPartHead, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartWing1, this.dragonPartWing2, this.dragonPartTailSpike1, this.dragonPartTailSpike2, this.dragonPartTailSpike3, this.dragonPartTailSpike4, this.dragonPartTailSpike5};
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(16.0f, 8.0f);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.targetY = 100.0;
        this.field_70158_ak = true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)new Byte(0));
    }

    public double[] getMovementOffsets(int par1, float par2) {
        if (this.func_110138_aP() <= 0.0f) {
            par2 = 0.0f;
        }
        par2 = 1.0f - par2;
        int var3 = this.ringBufferIndex - par1 * 1 & 0x3F;
        int var4 = this.ringBufferIndex - par1 * 1 - 1 & 0x3F;
        double[] var5 = new double[3];
        double var6 = this.ringBuffer[var3][0];
        double var8 = MathHelper.func_76138_g((double)(this.ringBuffer[var4][0] - var6));
        var5[0] = var6 + var8 * (double)par2;
        var6 = this.ringBuffer[var3][1];
        var8 = this.ringBuffer[var4][1] - var6;
        var5[1] = var6 + var8 * (double)par2;
        var5[2] = this.ringBuffer[var3][2] + (this.ringBuffer[var4][2] - this.ringBuffer[var3][2]) * (double)par2;
        return var5;
    }

    public void func_70636_d() {
        float f1;
        float f;
        if (this.field_70170_p.field_72995_K) {
            f = MathHelper.func_76134_b((float)(this.animTime * (float)Math.PI * 2.0f));
            f1 = MathHelper.func_76134_b((float)(this.prevAnimTime * (float)Math.PI * 2.0f));
            if (f1 <= -0.3f && f >= -0.3f) {
                this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.enderdragon.wings", 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
            }
        }
        this.prevAnimTime = this.animTime;
        if (this.func_110143_aJ() <= 0.0f) {
            f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_72869_a("largeexplode", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
        } else {
            float f3;
            double d2;
            double d1;
            double d3;
            this.updateDragonEnderCrystal();
            f = 0.2f / (MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 10.0f + 1.0f);
            this.animTime = this.slowed ? (this.animTime += f * 0.5f) : (this.animTime += (f *= (float)Math.pow(2.0, this.field_70181_x)));
            this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
            if (this.ringBufferIndex < 0) {
                for (int i = 0; i < this.ringBuffer.length; ++i) {
                    this.ringBuffer[i][0] = this.field_70177_z;
                    this.ringBuffer[i][1] = this.field_70163_u;
                }
            }
            if (++this.ringBufferIndex == this.ringBuffer.length) {
                this.ringBufferIndex = 0;
            }
            this.ringBuffer[this.ringBufferIndex][0] = this.field_70177_z;
            this.ringBuffer[this.ringBufferIndex][1] = this.field_70163_u;
            if (this.field_70170_p.field_72995_K) {
                if (this.field_70716_bi > 0) {
                    d3 = this.field_70165_t + (this.field_70709_bj - this.field_70165_t) / (double)this.field_70716_bi;
                    double d0 = this.field_70163_u + (this.field_70710_bk - this.field_70163_u) / (double)this.field_70716_bi;
                    d1 = this.field_70161_v + (this.field_110152_bk - this.field_70161_v) / (double)this.field_70716_bi;
                    d2 = MathHelper.func_76138_g((double)(this.field_70712_bm - (double)this.field_70177_z));
                    this.field_70177_z = (float)((double)this.field_70177_z + d2 / (double)this.field_70716_bi);
                    this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70705_bn - (double)this.field_70125_A) / (double)this.field_70716_bi);
                    --this.field_70716_bi;
                    this.func_70107_b(d3, d0, d1);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else {
                d3 = this.targetX - this.field_70165_t;
                double d0 = this.targetY - this.field_70163_u;
                d1 = this.targetZ - this.field_70161_v;
                d2 = d3 * d3 + d0 * d0 + d1 * d1;
                if (this.target != null) {
                    this.targetX = this.target.field_70165_t;
                    this.targetZ = this.target.field_70161_v;
                    double d4 = this.targetX - this.field_70165_t;
                    double d5 = this.targetZ - this.field_70161_v;
                    double d6 = Math.sqrt(d4 * d4 + d5 * d5);
                    double d7 = (double)0.4f + d6 / 80.0 - 1.0;
                    if (d7 > 10.0) {
                        d7 = 10.0;
                    }
                    this.targetY = this.target.field_70121_D.field_72338_b + d7;
                } else {
                    this.targetX += this.field_70146_Z.nextGaussian() * 2.0;
                    this.targetZ += this.field_70146_Z.nextGaussian() * 2.0;
                }
                if (this.forceNewTarget || d2 < 100.0 || d2 > 22500.0 || this.field_70123_F || this.field_70124_G) {
                    this.setNewTarget();
                }
                if ((d0 /= (double)MathHelper.func_76133_a((double)(d3 * d3 + d1 * d1))) < (double)(-(f3 = 0.6f))) {
                    d0 = -f3;
                }
                if (d0 > (double)f3) {
                    d0 = f3;
                }
                this.field_70181_x += d0 * (double)0.1f;
                this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
                double d8 = 180.0 - Math.atan2(d3, d1) * 180.0 / Math.PI;
                double d9 = MathHelper.func_76138_g((double)(d8 - (double)this.field_70177_z));
                if (d9 > 50.0) {
                    d9 = 50.0;
                }
                if (d9 < -50.0) {
                    d9 = -50.0;
                }
                Vec3 vec3 = Vec3.func_72443_a((double)(this.targetX - this.field_70165_t), (double)(this.targetY - this.field_70163_u), (double)(this.targetZ - this.field_70161_v)).func_72432_b();
                Vec3 vec31 = Vec3.func_72443_a((double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)), (double)this.field_70181_x, (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)))).func_72432_b();
                float f4 = (float)(vec31.func_72430_b(vec3) + 0.5) / 1.5f;
                if (f4 < 0.0f) {
                    f4 = 0.0f;
                }
                this.field_70704_bt *= 0.8f;
                float f5 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 1.0f + 1.0f;
                double d10 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 1.0 + 1.0;
                if (d10 > 40.0) {
                    d10 = 40.0;
                }
                this.field_70704_bt = (float)((double)this.field_70704_bt + d9 * ((double)0.7f / d10 / (double)f5));
                this.field_70177_z += this.field_70704_bt * 0.1f;
                float f6 = (float)(2.0 / (d10 + 1.0));
                float f7 = 0.06f;
                this.func_70060_a(0.0f, -1.0f, f7 * (f4 * f6 + (1.0f - f6)));
                if (this.slowed) {
                    this.func_70091_d(this.field_70159_w * (double)0.8f, this.field_70181_x * (double)0.8f, this.field_70179_y * (double)0.8f);
                } else {
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                Vec3 vec32 = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y).func_72432_b();
                float f8 = (float)(vec32.func_72430_b(vec31) + 1.0) / 2.0f;
                f8 = 0.8f + 0.15f * f8;
                this.field_70159_w *= (double)f8;
                this.field_70179_y *= (double)f8;
                this.field_70181_x *= (double)0.91f;
            }
            this.field_70761_aq = this.field_70177_z;
            this.dragonPartHead.field_70131_O = 3.0f;
            this.dragonPartHead.field_70130_N = 3.0f;
            this.dragonPartTail1.field_70131_O = 2.0f;
            this.dragonPartTail1.field_70130_N = 2.0f;
            this.dragonPartTail2.field_70131_O = 2.0f;
            this.dragonPartTail2.field_70130_N = 2.0f;
            this.dragonPartTail3.field_70131_O = 2.0f;
            this.dragonPartTail3.field_70130_N = 2.0f;
            this.dragonPartBody.field_70131_O = 3.0f;
            this.dragonPartBody.field_70130_N = 5.0f;
            this.dragonPartWing1.field_70131_O = 2.0f;
            this.dragonPartWing1.field_70130_N = 4.0f;
            this.dragonPartWing2.field_70131_O = 3.0f;
            this.dragonPartWing2.field_70130_N = 4.0f;
            f1 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f / 180.0f * (float)Math.PI;
            float f2 = MathHelper.func_76134_b((float)f1);
            float f9 = -MathHelper.func_76126_a((float)f1);
            float f10 = this.field_70177_z * (float)Math.PI / 180.0f;
            float f11 = MathHelper.func_76126_a((float)f10);
            float f12 = MathHelper.func_76134_b((float)f10);
            this.dragonPartBody.func_70071_h_();
            this.dragonPartBody.func_70012_b(this.field_70165_t + (double)(f11 * 0.5f), this.field_70163_u, this.field_70161_v - (double)(f12 * 0.5f), 0.0f, 0.0f);
            this.dragonPartWing1.func_70071_h_();
            this.dragonPartWing1.func_70012_b(this.field_70165_t + (double)(f12 * 4.5f), this.field_70163_u + 2.0, this.field_70161_v + (double)(f11 * 4.5f), 0.0f, 0.0f);
            this.dragonPartWing2.func_70071_h_();
            this.dragonPartWing2.func_70012_b(this.field_70165_t - (double)(f12 * 4.5f), this.field_70163_u + 2.0, this.field_70161_v - (double)(f11 * 4.5f), 0.0f, 0.0f);
            if (!this.field_70170_p.field_72995_K && this.field_70737_aN == 0) {
                this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing1.field_70121_D.func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0)));
                this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartWing2.field_70121_D.func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0)));
                this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.dragonPartHead.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            }
            double[] adouble = this.getMovementOffsets(5, 1.0f);
            double[] adouble1 = this.getMovementOffsets(0, 1.0f);
            f3 = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f - this.field_70704_bt * 0.01f));
            float f13 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f - this.field_70704_bt * 0.01f));
            this.dragonPartHead.func_70071_h_();
            this.dragonPartHead.func_70012_b(this.field_70165_t + (double)(f3 * 5.5f * f2), this.field_70163_u + (adouble1[1] - adouble[1]) * 1.0 + (double)(f9 * 5.5f), this.field_70161_v - (double)(f13 * 5.5f * f2), 0.0f, 0.0f);
            for (int j = 0; j < 3; ++j) {
                EntityGoodDragonPart entitydragonpart = null;
                if (j == 0) {
                    entitydragonpart = this.dragonPartTail1;
                }
                if (j == 1) {
                    entitydragonpart = this.dragonPartTail2;
                }
                if (j == 2) {
                    entitydragonpart = this.dragonPartTail3;
                }
                double[] adouble2 = this.getMovementOffsets(12 + j * 2, 1.0f);
                float f14 = this.field_70177_z * (float)Math.PI / 180.0f + this.simplifyAngle(adouble2[0] - adouble[0]) * (float)Math.PI / 180.0f * 1.0f;
                float f15 = MathHelper.func_76126_a((float)f14);
                float f16 = MathHelper.func_76134_b((float)f14);
                float f17 = 1.5f;
                float f18 = (float)(j + 1) * 2.0f;
                entitydragonpart.func_70071_h_();
                entitydragonpart.func_70012_b(this.field_70165_t - (double)((f11 * f17 + f15 * f18) * f2), this.field_70163_u + (adouble2[1] - adouble[1]) * 1.0 - (double)((f18 + f17) * f9) + 1.5, this.field_70161_v + (double)((f12 * f17 + f16 * f18) * f2), 0.0f, 0.0f);
            }
        }
    }

    private void updateDragonEnderCrystal() {
        if (this.healingEnderCrystal != null) {
            if (this.healingEnderCrystal.field_70128_L) {
                if (!this.field_70170_p.field_72995_K) {
                    this.attackEntityFromPart(this.dragonPartHead, DamageSource.field_76377_j, 10.0f);
                }
                this.healingEnderCrystal = null;
            } else if (this.field_70173_aa % 10 == 0 && this.func_110138_aP() < this.func_110138_aP()) {
                ++this.health;
            }
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            float var1 = 32.0f;
            List var2 = this.field_70170_p.func_72872_a(EntityEnderCrystal.class, this.field_70121_D.func_72314_b((double)var1, (double)var1, (double)var1));
            EntityEnderCrystal var3 = null;
            double var4 = Double.MAX_VALUE;
            for (EntityEnderCrystal var7 : var2) {
                double var8 = var7.func_70068_e((Entity)this);
                if (!(var8 < var4)) continue;
                var4 = var8;
                var3 = var7;
            }
            this.healingEnderCrystal = var3;
        }
    }

    private void collideWithEntities(List par1List) {
        double var2 = (this.dragonPartBody.field_70121_D.field_72340_a + this.dragonPartBody.field_70121_D.field_72336_d) / 2.0;
        double var4 = (this.dragonPartBody.field_70121_D.field_72339_c + this.dragonPartBody.field_70121_D.field_72334_f) / 2.0;
        for (Entity var7 : par1List) {
            if (!(var7 instanceof EntityLiving)) continue;
            double var8 = var7.field_70165_t - var2;
            double var10 = var7.field_70161_v - var4;
            double var12 = var8 * var8 + var10 * var10;
            var7.func_70024_g(var8 / var12 * 4.0, (double)0.2f, var10 / var12 * 4.0);
        }
    }

    private void attackEntitiesInList(List par1List) {
        if (this.angry) {
            for (int var2 = 0; var2 < par1List.size(); ++var2) {
                Entity var3 = (Entity)par1List.get(var2);
                if (!(var3 instanceof EntityLivingBase)) continue;
                var3.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10.0f);
            }
        }
    }

    private void setNewTarget() {
        this.forceNewTarget = false;
        if (this.field_70146_Z.nextInt(3) == 0 && !this.field_70170_p.field_73010_i.isEmpty()) {
            this.target = (Entity)this.field_70170_p.field_73010_i.get(this.field_70146_Z.nextInt(this.field_70170_p.field_73010_i.size()));
        } else {
            double d2;
            double d1;
            double d0;
            boolean flag = false;
            do {
                this.targetY = 70.0f + this.field_70146_Z.nextFloat() * 50.0f;
                this.targetX += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
                this.targetZ += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
            } while (!(flag = (d0 = this.field_70165_t - this.targetX) * d0 + (d1 = this.field_70163_u - this.targetY) * d1 + (d2 = this.field_70161_v - this.targetZ) * d2 > 100.0));
            this.target = null;
        }
    }

    private float simplifyAngle(double par1) {
        return (float)MathHelper.func_76138_g((double)par1);
    }

    @Override
    public boolean mount(EntityPlayer par1EntityPlayer) {
        par1EntityPlayer.field_70177_z = this.field_70177_z;
        par1EntityPlayer.field_70125_A = this.field_70125_A;
        if (!(this.field_70170_p.field_72995_K || this.field_70153_n != null && this.field_70153_n != par1EntityPlayer)) {
            par1EntityPlayer.func_70078_a((Entity)this);
        }
        return true;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W() - 2.5, this.field_70161_v);
        }
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB par1AxisAlignedBB) {
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int k = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        int l = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    Block j2 = this.field_70170_p.func_147439_a(k1, l1, i2);
                    Block block = j2;
                    if (block == null) continue;
                    if (block.canEntityDestroy((IBlockAccess)this.field_70170_p, k1, l1, i2, (Entity)this) && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        flag1 = this.field_70170_p.func_147468_f(k1, l1, i2) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            double d0 = par1AxisAlignedBB.field_72340_a + (par1AxisAlignedBB.field_72336_d - par1AxisAlignedBB.field_72340_a) * (double)this.field_70146_Z.nextFloat();
            double d1 = par1AxisAlignedBB.field_72338_b + (par1AxisAlignedBB.field_72337_e - par1AxisAlignedBB.field_72338_b) * (double)this.field_70146_Z.nextFloat();
            double d2 = par1AxisAlignedBB.field_72339_c + (par1AxisAlignedBB.field_72334_f - par1AxisAlignedBB.field_72339_c) * (double)this.field_70146_Z.nextFloat();
            this.field_70170_p.func_72869_a("largeexplode", d0, d1, d2, 0.0, 0.0, 0.0);
        }
        return flag;
    }

    @Override
    public boolean attackEntityFromPart(EntityGoodDragonPart par1EntityGoodDragonPart, DamageSource par2DamageSource, float par3) {
        if (par1EntityGoodDragonPart != this.dragonPartHead) {
            par3 = par3 / 4.0f + 1.0f;
        }
        float var4 = this.field_70177_z * (float)Math.PI / 180.0f;
        float var5 = MathHelper.func_76126_a((float)var4);
        float var6 = MathHelper.func_76134_b((float)var4);
        this.targetX = this.field_70165_t + (double)(var5 * 5.0f) + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 2.0f);
        this.targetY = this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.0f) + 1.0;
        this.targetZ = this.field_70161_v - (double)(var6 * 5.0f) + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 2.0f);
        this.target = null;
        if (par2DamageSource.func_76346_g() instanceof EntityPlayer || par2DamageSource.func_94541_c()) {
            this.angry = true;
            this.func_82195_e(par2DamageSource, par3);
        }
        return true;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        return false;
    }

    protected boolean func_82195_e(DamageSource par1DamageSource, float par2) {
        return super.func_70097_a(par1DamageSource, par2);
    }

    public boolean func_70094_T() {
        return false;
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float var1 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float var2 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float var3 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)var1, this.field_70163_u + 2.0 + (double)var2, this.field_70161_v + (double)var3, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0) {
                int var5;
                for (int var4 = 1000; var4 > 0; var4 -= var5) {
                    var5 = EntityXPOrb.func_70527_a((int)var4);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, var5));
                }
            }
            if (this.deathTicks == 1) {
                this.field_70170_p.func_72926_e(1018, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            }
        }
        this.func_70091_d(0.0, 0.1f, 0.0);
        this.field_70761_aq = this.field_70177_z += 20.0f;
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            int var5;
            for (int var4 = 2000; var4 > 0; var4 -= var5) {
                var5 = EntityXPOrb.func_70527_a((int)var4);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, var5));
            }
            this.createEnderPortal(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v));
            this.func_70106_y();
        }
    }

    private void createEnderPortal(int par1, int par2) {
        int var3 = 64;
        int var4 = 4;
        for (int var5 = var3 - 1; var5 <= var3 + 32; ++var5) {
            for (int var6 = par1 - var4; var6 <= par1 + var4; ++var6) {
                for (int var7 = par2 - var4; var7 <= par2 + var4; ++var7) {
                    double var8 = var6 - par1;
                    double var10 = var7 - par2;
                    double var12 = var8 * var8 + var10 * var10;
                    if (!(var12 <= ((double)var4 - 0.5) * ((double)var4 - 0.5))) continue;
                    if (var5 < var3) {
                        if (!(var12 <= ((double)(var4 - 1) - 0.5) * ((double)(var4 - 1) - 0.5))) continue;
                        this.field_70170_p.func_147449_b(var6, var5, var7, mod_Rediscovered.CryingObsidian);
                        continue;
                    }
                    if (var5 > var3) {
                        this.field_70170_p.func_147449_b(var6, var5, var7, Blocks.field_150350_a);
                        continue;
                    }
                    if (var12 > ((double)(var4 - 1) - 0.5) * ((double)(var4 - 1) - 0.5)) {
                        this.field_70170_p.func_147449_b(var6, var5, var7, mod_Rediscovered.CryingObsidian);
                        continue;
                    }
                    this.field_70170_p.func_147449_b(var6, var5, var7, (Block)Blocks.field_150480_ab);
                }
            }
        }
        this.field_70170_p.func_147449_b(par1, var3 + 0, par2, mod_Rediscovered.CryingObsidian);
        this.field_70170_p.func_147449_b(par1, var3 + 1, par2, mod_Rediscovered.CryingObsidian);
        this.field_70170_p.func_147449_b(par1, var3 + 2, par2, mod_Rediscovered.CryingObsidian);
        this.field_70170_p.func_147449_b(par1, var3 + 3, par2, mod_Rediscovered.CryingObsidian);
        this.field_70170_p.func_147449_b(par1, var3 + 4, par2, mod_Rediscovered.DragonEggRed);
    }

    protected void func_70623_bb() {
    }

    public Entity[] func_70021_al() {
        return this.dragonPartArray;
    }

    public boolean func_70067_L() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getDragonHealth() {
        return this.field_70180_af.func_75679_c(16);
    }

    protected String func_70639_aQ() {
        return "mob.enderdragon.growl";
    }

    protected String func_70621_aR() {
        return "mob.enderdragon.hit";
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    @Override
    public World func_82194_d() {
        return this.field_70170_p;
    }
}

