/*
 * Decompiled with CFR 0.152.
 */
package com.stormister.rediscovered;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedPlayer
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "RediscoveredPlayerSkyRespawnCoords";
    private final EntityPlayer player;
    private int respawnX = 0;
    private int respawnY = 64;
    private int respawnZ = 0;

    public ExtendedPlayer(EntityPlayer player) {
        this.player = player;
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new ExtendedPlayer(player));
    }

    public static final ExtendedPlayer get(EntityPlayer player) {
        return (ExtendedPlayer)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a("RespawnX", this.respawnX);
        properties.func_74768_a("RespawnY", this.respawnY);
        properties.func_74768_a("RespawnZ", this.respawnZ);
        compound.func_74782_a(EXT_PROP_NAME, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(EXT_PROP_NAME);
        this.respawnX = properties.func_74762_e("RespawnX");
        this.respawnY = properties.func_74762_e("RespawnY");
        this.respawnZ = properties.func_74762_e("RespawnZ");
    }

    public void init(Entity entity, World world) {
    }

    public void setRespawn(int x, int y, int z) {
        this.respawnX = x;
        this.respawnY = y;
        this.respawnZ = z;
        System.out.println("[REDISCOVERED]Respawn coords from NBT: " + this.respawnX + "/" + this.respawnY + "/" + this.respawnZ);
    }

    public BlockPos getRespawn() {
        BlockPos coordinates = new BlockPos(this.respawnX, this.respawnY, this.respawnZ);
        return coordinates;
    }
}

