/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.init;

import cyano.basemetals.init.Blocks;
import cyano.basemetals.init.Items;
import cyano.basemetals.init.Materials;
import cyano.basemetals.material.MetalMaterial;
import cyano.basemetals.registry.CrusherRecipeRegistry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public abstract class Recipes {
    private static boolean initDone = false;

    public static void init() {
        if (initDone) {
            return;
        }
        Materials.init();
        Blocks.init();
        Items.init();
        Recipes.initPureVanillaCrusherRecipes();
        Recipes.initVanillaRecipes();
        Recipes.initMetalRecipes();
        initDone = true;
    }

    private static void initPureVanillaCrusherRecipes() {
        CrusherRecipeRegistry.addNewCrusherRecipe("stone", new ItemStack(net.minecraft.init.Blocks.field_150347_e, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe("cobblestone", new ItemStack(net.minecraft.init.Blocks.field_150351_n, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe(net.minecraft.init.Blocks.field_150351_n, new ItemStack((Block)net.minecraft.init.Blocks.field_150354_m, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe("sandstone", new ItemStack((Block)net.minecraft.init.Blocks.field_150354_m, 4));
        CrusherRecipeRegistry.addNewCrusherRecipe(net.minecraft.init.Blocks.field_180395_cM, new ItemStack((Block)net.minecraft.init.Blocks.field_150354_m, 4, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe(net.minecraft.init.Blocks.field_150426_aN, new ItemStack(net.minecraft.init.Items.field_151114_aO, 4));
        CrusherRecipeRegistry.addNewCrusherRecipe("oreLapis", new ItemStack(net.minecraft.init.Items.field_151100_aR, 8, 4));
        CrusherRecipeRegistry.addNewCrusherRecipe(net.minecraft.init.Blocks.field_150450_ax, new ItemStack(net.minecraft.init.Items.field_151137_ax, 4));
        CrusherRecipeRegistry.addNewCrusherRecipe(net.minecraft.init.Blocks.field_150451_bX, new ItemStack(net.minecraft.init.Items.field_151137_ax, 9));
        CrusherRecipeRegistry.addNewCrusherRecipe(net.minecraft.init.Items.field_151120_aE, new ItemStack(net.minecraft.init.Items.field_151102_aT, 2));
        CrusherRecipeRegistry.addNewCrusherRecipe(net.minecraft.init.Items.field_151103_aS, new ItemStack(net.minecraft.init.Items.field_151100_aR, 3, 15));
        CrusherRecipeRegistry.addNewCrusherRecipe(net.minecraft.init.Items.field_151072_bj, new ItemStack(net.minecraft.init.Items.field_151065_br, 2));
        CrusherRecipeRegistry.addNewCrusherRecipe("oreQuartz", new ItemStack(net.minecraft.init.Items.field_151128_bU, 2));
        CrusherRecipeRegistry.addNewCrusherRecipe("blockQuartz", new ItemStack(net.minecraft.init.Items.field_151128_bU, 4));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack(net.minecraft.init.Blocks.field_180397_cI, 1, 0), new ItemStack(net.minecraft.init.Items.field_179562_cC, 4));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack(net.minecraft.init.Blocks.field_180397_cI, 1, 1), new ItemStack(net.minecraft.init.Items.field_179562_cC, 9));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack(net.minecraft.init.Blocks.field_180397_cI, 1, 2), new ItemStack(net.minecraft.init.Items.field_179562_cC, 8));
        CrusherRecipeRegistry.addNewCrusherRecipe(net.minecraft.init.Blocks.field_180398_cJ, new ItemStack(net.minecraft.init.Items.field_179563_cD, 3));
        CrusherRecipeRegistry.addNewCrusherRecipe(net.minecraft.init.Blocks.field_180399_cE, new ItemStack(net.minecraft.init.Items.field_151123_aH, 9));
    }

    private static void initVanillaRecipes() {
        OreDictionary.registerOre((String)"barsIron", (Block)net.minecraft.init.Blocks.field_150411_aY);
        OreDictionary.registerOre((String)"bars", (Block)net.minecraft.init.Blocks.field_150411_aY);
        OreDictionary.registerOre((String)"doorIron", (Item)net.minecraft.init.Items.field_151139_aw);
        OreDictionary.registerOre((String)"door", (Item)net.minecraft.init.Items.field_151139_aw);
        OreDictionary.registerOre((String)"doorWood", (Item)net.minecraft.init.Items.field_179570_aq);
        OreDictionary.registerOre((String)"doorWood", (Item)net.minecraft.init.Items.field_179567_at);
        OreDictionary.registerOre((String)"doorWood", (Item)net.minecraft.init.Items.field_179569_ar);
        OreDictionary.registerOre((String)"doorWood", (Item)net.minecraft.init.Items.field_179571_av);
        OreDictionary.registerOre((String)"doorWood", (Item)net.minecraft.init.Items.field_179568_as);
        OreDictionary.registerOre((String)"doorWood", (Item)net.minecraft.init.Items.field_179572_au);
        OreDictionary.registerOre((String)"door", (Item)net.minecraft.init.Items.field_179570_aq);
        OreDictionary.registerOre((String)"door", (Item)net.minecraft.init.Items.field_179567_at);
        OreDictionary.registerOre((String)"door", (Item)net.minecraft.init.Items.field_179569_ar);
        OreDictionary.registerOre((String)"door", (Item)net.minecraft.init.Items.field_179571_av);
        OreDictionary.registerOre((String)"door", (Item)net.minecraft.init.Items.field_179568_as);
        OreDictionary.registerOre((String)"door", (Item)net.minecraft.init.Items.field_179572_au);
        CrusherRecipeRegistry.addNewCrusherRecipe("oreIron", new ItemStack(Items.iron_powder, 2));
        CrusherRecipeRegistry.addNewCrusherRecipe("blockIron", new ItemStack(Items.iron_powder, 9));
        CrusherRecipeRegistry.addNewCrusherRecipe("ingotIron", new ItemStack(Items.iron_powder, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe("oreGold", new ItemStack(Items.gold_powder, 2));
        CrusherRecipeRegistry.addNewCrusherRecipe("blockGold", new ItemStack(Items.gold_powder, 9));
        CrusherRecipeRegistry.addNewCrusherRecipe("ingotGold", new ItemStack(Items.gold_powder, 1));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.iron_nugget, 9), new Object[]{new ItemStack(net.minecraft.init.Items.field_151042_j)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(net.minecraft.init.Items.field_151042_j), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), Items.iron_nugget}));
        GameRegistry.addSmelting((Item)Items.iron_powder, (ItemStack)new ItemStack(net.minecraft.init.Items.field_151042_j), (float)0.0f);
        GameRegistry.addSmelting((Item)Items.gold_powder, (ItemStack)new ItemStack(net.minecraft.init.Items.field_151043_k), (float)0.0f);
        CrusherRecipeRegistry.addNewCrusherRecipe("oreCoal", new ItemStack(Items.carbon_powder, 2));
        CrusherRecipeRegistry.addNewCrusherRecipe("blockCoal", new ItemStack(Items.carbon_powder, 9));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack(net.minecraft.init.Items.field_151044_h, 1, 0), new ItemStack(Items.carbon_powder, 1));
        CrusherRecipeRegistry.addNewCrusherRecipe(new ItemStack(net.minecraft.init.Items.field_151044_h, 1, 1), new ItemStack(Items.carbon_powder, 1));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(net.minecraft.init.Blocks.field_150402_ci), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), Items.carbon_powder}));
    }

    private static void initMetalRecipes() {
        List<MetalMaterial> exceptions = Arrays.asList(Materials.vanilla_iron, Materials.vanilla_gold, Materials.vanilla_diamond, Materials.vanilla_stone, Materials.vanilla_wood);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.wood_crackhammer), new Object[]{"x", "/", "/", Character.valueOf('x'), "logWood", Character.valueOf('/'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.stone_crackhammer), new Object[]{"x", "/", "/", Character.valueOf('x'), net.minecraft.init.Blocks.field_150417_aV, Character.valueOf('/'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.iron_crackhammer), new Object[]{"x", "/", "/", Character.valueOf('x'), "blockIron", Character.valueOf('/'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.diamond_crackhammer), new Object[]{"x", "/", "/", Character.valueOf('x'), "blockDiamond", Character.valueOf('/'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.iron_plate, 3), new Object[]{"xxx", Character.valueOf('x'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.gold_plate, 3), new Object[]{"xxx", Character.valueOf('x'), "ingotGold"}));
        for (MetalMaterial metal : Materials.getAllMetals()) {
            if (exceptions.contains(metal)) continue;
            String baseName = metal.getName() + "_";
            String oreDictName = metal.getCapitalizedName();
            Item axe = Items.getItemByName(baseName + "axe");
            Item blend = Items.getItemByName(baseName + "blend");
            Item boots = Items.getItemByName(baseName + "boots");
            Item chestplate = Items.getItemByName(baseName + "chestplate");
            Item crackhammer = Items.getItemByName(baseName + "crackhammer");
            Item door = Items.getItemByName(baseName + "door_item");
            Item helmet = Items.getItemByName(baseName + "helmet");
            Item hoe = Items.getItemByName(baseName + "hoe");
            Item ingot = Items.getItemByName(baseName + "ingot");
            Item leggings = Items.getItemByName(baseName + "leggings");
            Item nugget = Items.getItemByName(baseName + "nugget");
            Item pickaxe = Items.getItemByName(baseName + "pickaxe");
            Item powder = Items.getItemByName(baseName + "powder");
            Item shovel = Items.getItemByName(baseName + "shovel");
            Item sword = Items.getItemByName(baseName + "sword");
            Block bars = Blocks.getBlockByName(baseName + "bars");
            Block block = Blocks.getBlockByName(baseName + "block");
            Block plate = Blocks.getBlockByName(baseName + "plate");
            Block ore = Blocks.getBlockByName(baseName + "ore");
            Block trapdoor = Blocks.getBlockByName(baseName + "trapdoor");
            if (ore != null && powder != null) {
                CrusherRecipeRegistry.addNewCrusherRecipe("ore" + oreDictName, new ItemStack(powder, 2));
            }
            if (ore != null && ingot != null) {
                GameRegistry.addSmelting((Block)ore, (ItemStack)new ItemStack(ingot, 1), (float)metal.getOreSmeltXP());
            }
            if (ingot != null && powder != null) {
                CrusherRecipeRegistry.addNewCrusherRecipe("ingot" + oreDictName, new ItemStack(powder, 1));
                GameRegistry.addSmelting((Item)powder, (ItemStack)new ItemStack(ingot, 1), (float)metal.getOreSmeltXP());
            }
            if (ingot != null && blend != null) {
                GameRegistry.addSmelting((Item)blend, (ItemStack)new ItemStack(ingot, 1), (float)metal.getOreSmeltXP());
            }
            if (ingot != null && nugget != null) {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(nugget, 9), new Object[]{new ItemStack(ingot)}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ingot), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nugget" + oreDictName}));
            }
            if (ingot != null && block != null) {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(ingot, 9), new Object[]{new ItemStack(block)}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(block), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "ingot" + oreDictName}));
            }
            if (ingot != null && plate != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(plate, 3), new Object[]{"xxx", Character.valueOf('x'), "ingot" + oreDictName}));
                GameRegistry.addSmelting((Block)plate, (ItemStack)new ItemStack(ingot, 1), (float)metal.getOreSmeltXP());
            }
            if (block != null && powder != null) {
                CrusherRecipeRegistry.addNewCrusherRecipe("block" + oreDictName, new ItemStack(powder, 9));
            }
            if (ingot != null && bars != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(bars, 16), new Object[]{"xxx", "xxx", Character.valueOf('x'), "ingot" + oreDictName}));
                OreDictionary.registerOre((String)"bars", (Block)bars);
            }
            if (ingot != null && door != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(door, 3), new Object[]{"xx", "xx", "xx", Character.valueOf('x'), "ingot" + oreDictName}));
                OreDictionary.registerOre((String)"door", (Item)door);
            }
            if (ingot != null && trapdoor != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(trapdoor), new Object[]{"xx", "xx", Character.valueOf('x'), "ingot" + oreDictName}));
                OreDictionary.registerOre((String)"trapdoor", (Block)trapdoor);
            }
            if (ingot != null && boots != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(boots), new Object[]{"x x", "x x", Character.valueOf('x'), "ingot" + oreDictName}));
            }
            if (ingot != null && helmet != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(helmet), new Object[]{"xxx", "x x", Character.valueOf('x'), "ingot" + oreDictName}));
            }
            if (ingot != null && chestplate != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(chestplate), new Object[]{"x x", "xxx", "xxx", Character.valueOf('x'), "ingot" + oreDictName}));
            }
            if (ingot != null && leggings != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(leggings), new Object[]{"xxx", "x x", "x x", Character.valueOf('x'), "ingot" + oreDictName}));
            }
            if (ingot != null && axe != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(axe), new Object[]{"xx", "x/", " /", Character.valueOf('x'), "ingot" + oreDictName, Character.valueOf('/'), "stickWood"}));
            }
            if (ingot != null && axe != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(axe), new Object[]{"xx", "/x", "/ ", Character.valueOf('x'), "ingot" + oreDictName, Character.valueOf('/'), "stickWood"}));
            }
            if (block != null && crackhammer != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(crackhammer), new Object[]{"x", "/", "/", Character.valueOf('x'), "block" + oreDictName, Character.valueOf('/'), "stickWood"}));
            }
            if (ingot != null && hoe != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(hoe), new Object[]{"xx", " /", " /", Character.valueOf('x'), "ingot" + oreDictName, Character.valueOf('/'), "stickWood"}));
            }
            if (ingot != null && hoe != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(hoe), new Object[]{"xx", "/ ", "/ ", Character.valueOf('x'), "ingot" + oreDictName, Character.valueOf('/'), "stickWood"}));
            }
            if (ingot != null && pickaxe != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(pickaxe), new Object[]{"xxx", " / ", " / ", Character.valueOf('x'), "ingot" + oreDictName, Character.valueOf('/'), "stickWood"}));
            }
            if (ingot != null && shovel != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(shovel), new Object[]{"x", "/", "/", Character.valueOf('x'), "ingot" + oreDictName, Character.valueOf('/'), "stickWood"}));
            }
            if (ingot != null && sword != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(sword), new Object[]{"x", "x", "/", Character.valueOf('x'), "ingot" + oreDictName, Character.valueOf('/'), "stickWood"}));
            }
            if (ingot == null || pickaxe == null) continue;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(net.minecraft.init.Items.field_151133_ar), new Object[]{"x x", " x ", Character.valueOf('x'), "ingot" + oreDictName}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.brass_blend, 3), new Object[]{"dustCopper", "dustCopper", "dustZinc"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.bronze_blend, 4), new Object[]{"dustCopper", "dustCopper", "dustCopper", "dustTin"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.steel_blend, 8), new Object[]{"dustIron", "dustIron", "dustIron", "dustIron", "dustIron", "dustIron", "dustIron", "dustIron", "dustCarbon"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.steel_blend, 8), new Object[]{"dustIron", "dustIron", "dustIron", "dustIron", "dustIron", "dustIron", "dustIron", "dustIron", "dustCoal"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.invar_blend, 3), new Object[]{"dustIron", "dustIron", "dustNickel"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.electrum_blend, 2), new Object[]{"dustSilver", "dustGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.mithril_blend, 3), new Object[]{"dustSilver", "dustSilver", "dustColdiron", "ingotMercury"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.aquarium_blend, 3), new Object[]{"dustCopper", "dustCopper", "dustZinc", net.minecraft.init.Items.field_179563_cD, net.minecraft.init.Items.field_179563_cD, net.minecraft.init.Items.field_179563_cD}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(net.minecraft.init.Blocks.field_150408_cc, 6), new Object[]{"x/x", "x*x", "x/x", Character.valueOf('x'), Items.steel_ingot, Character.valueOf('/'), "stickWood", Character.valueOf('*'), net.minecraft.init.Blocks.field_150429_aA}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(net.minecraft.init.Blocks.field_150319_E, 6), new Object[]{"x x", "x-x", "x*x", Character.valueOf('x'), Items.steel_ingot, Character.valueOf('/'), "stickWood", Character.valueOf('-'), net.minecraft.init.Blocks.field_150456_au, Character.valueOf('*'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(net.minecraft.init.Blocks.field_150448_aq, 16), new Object[]{"x x", "x/x", "x x", Character.valueOf('x'), Items.steel_ingot, Character.valueOf('/'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(net.minecraft.init.Blocks.field_150443_bT), new Object[]{"xx", Character.valueOf('x'), Items.steel_ingot}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)net.minecraft.init.Blocks.field_150479_bC), new Object[]{"x  ", "/  ", "w  ", Character.valueOf('x'), Items.steel_ingot, Character.valueOf('/'), "stickWood", Character.valueOf('w'), "plankWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(net.minecraft.init.Items.field_151033_d), new Object[]{Items.steel_ingot, net.minecraft.init.Items.field_151145_ak}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)net.minecraft.init.Blocks.field_150438_bZ), new Object[]{"x x", "x/x", " x ", Character.valueOf('x'), Items.steel_ingot, Character.valueOf('/'), "chestWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(net.minecraft.init.Items.field_151143_au), new Object[]{"x x", "xxx", Character.valueOf('x'), Items.steel_ingot}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)net.minecraft.init.Blocks.field_150331_J), new Object[]{"www", "sxs", "s*s", Character.valueOf('x'), Items.steel_ingot, Character.valueOf('w'), "plankWood", Character.valueOf('s'), "cobblestone", Character.valueOf('*'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)net.minecraft.init.Items.field_151097_aZ), new Object[]{"x ", " x", Character.valueOf('x'), Items.steel_ingot}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)net.minecraft.init.Items.field_151097_aZ), new Object[]{" x", "x ", Character.valueOf('x'), Items.steel_ingot}));
        CrusherRecipeRegistry.addNewCrusherRecipe("oreMercury", new ItemStack(Items.mercury_powder, 2));
        GameRegistry.addSmelting((Item)Items.mercury_powder, (ItemStack)new ItemStack(Items.mercury_ingot, 1), (float)0.0f);
        GameRegistry.addSmelting((Block)Blocks.mercury_ore, (ItemStack)new ItemStack(Items.mercury_ingot, 1), (float)1.0f);
    }
}

