/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.items;

import cyano.basemetals.init.Materials;
import cyano.basemetals.items.MetalToolEffects;
import cyano.basemetals.material.MetalMaterial;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMetalAxe
extends ItemAxe {
    protected final MetalMaterial metal;
    protected final String repairOreDictName;
    protected final boolean regenerates;
    protected final long regenInterval = 200L;

    public ItemMetalAxe(MetalMaterial metal) {
        super(Materials.getToolMaterialFor(metal));
        this.metal = metal;
        this.func_77656_e(metal.getToolDurability());
        this.field_77864_a = metal.getToolEfficiency();
        this.repairOreDictName = "ingot" + metal.getCapitalizedName();
        this.regenerates = metal.equals(Materials.starsteel);
    }

    public Item.ToolMaterial func_150913_i() {
        return this.field_77862_b;
    }

    public int func_77619_b() {
        return this.field_77862_b.func_77995_e();
    }

    public String func_77861_e() {
        return this.field_77862_b.toString();
    }

    public boolean func_82789_a(ItemStack intputItem, ItemStack repairMaterial) {
        List acceptableItems = OreDictionary.getOres((String)this.repairOreDictName);
        for (ItemStack i : acceptableItems) {
            if (!ItemStack.func_179545_c((ItemStack)i, (ItemStack)repairMaterial)) continue;
            return true;
        }
        return false;
    }

    public boolean func_77644_a(ItemStack item, EntityLivingBase target, EntityLivingBase attacker) {
        super.func_77644_a(item, target, attacker);
        MetalToolEffects.extraEffectsOnAttack(this.metal, item, target, attacker);
        return true;
    }

    public void func_77622_d(ItemStack item, World world, EntityPlayer crafter) {
        super.func_77622_d(item, world, crafter);
        MetalToolEffects.extraEffectsOnCrafting(this.metal, item, world, crafter);
    }

    public void func_77663_a(ItemStack item, World world, Entity player, int inventoryIndex, boolean isHeld) {
        if (this.regenerates && !world.field_72995_K && isHeld && item.func_77952_i() > 0 && world.func_82737_E() % 200L == 0L) {
            item.func_77964_b(item.func_77952_i() - 1);
        }
    }

    public String getMaterialName() {
        return this.metal.getName();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        MetalToolEffects.addToolSpecialPropertiesToolTip(this.metal, list);
    }
}

