/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.registry;

import cyano.basemetals.registry.recipe.ArbitraryCrusherRecipe;
import cyano.basemetals.registry.recipe.ICrusherRecipe;
import cyano.basemetals.registry.recipe.OreDictionaryCrusherRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CrusherRecipeRegistry {
    private final List<ICrusherRecipe> recipes = new ArrayList<ICrusherRecipe>();
    private final Map<ItemLookupReference, ICrusherRecipe> recipeByInputCache = new HashMap<ItemLookupReference, ICrusherRecipe>();
    private final Map<ItemLookupReference, List<ICrusherRecipe>> recipeByOutputCache = new HashMap<ItemLookupReference, List<ICrusherRecipe>>();
    private static final Lock initLock = new ReentrantLock();
    private static CrusherRecipeRegistry instance = null;

    public static CrusherRecipeRegistry getInstance() {
        if (instance == null) {
            initLock.lock();
            try {
                if (instance == null) {
                    instance = new CrusherRecipeRegistry();
                }
            }
            finally {
                initLock.unlock();
            }
        }
        return instance;
    }

    public static void addNewCrusherRecipe(String oreDictionaryName, ItemStack output) {
        CrusherRecipeRegistry.getInstance().addRecipe(new OreDictionaryCrusherRecipe(oreDictionaryName, output));
    }

    public static void addNewCrusherRecipe(ItemStack input, ItemStack output) {
        CrusherRecipeRegistry.getInstance().addRecipe(new ArbitraryCrusherRecipe(input, output));
    }

    public static void addNewCrusherRecipe(final Item input, final ItemStack output) {
        CrusherRecipeRegistry.getInstance().addRecipe(new ICrusherRecipe(){

            @Override
            public ItemStack getOutput() {
                return output;
            }

            @Override
            public boolean isValidInput(ItemStack in) {
                return input.equals(in.func_77973_b());
            }

            @Override
            public Collection<ItemStack> getValidInputs() {
                return Arrays.asList(new ItemStack(input));
            }
        });
    }

    public static void addNewCrusherRecipe(final Block input, final ItemStack output) {
        CrusherRecipeRegistry.getInstance().addRecipe(new ICrusherRecipe(){

            @Override
            public ItemStack getOutput() {
                return output;
            }

            @Override
            public boolean isValidInput(ItemStack in) {
                return input.equals(Block.func_149634_a((Item)in.func_77973_b()));
            }

            @Override
            public Collection<ItemStack> getValidInputs() {
                return Arrays.asList(new ItemStack(input));
            }
        });
    }

    public void clearCache() {
        this.recipeByInputCache.clear();
        this.recipeByOutputCache.clear();
    }

    public void addRecipe(ICrusherRecipe crusherRecipe) {
        this.recipes.add(crusherRecipe);
    }

    public List<ICrusherRecipe> getRecipesForOutputItem(ItemStack output) {
        ItemLookupReference ref = new ItemLookupReference(output);
        if (this.recipeByOutputCache.containsKey(ref)) {
            List<ICrusherRecipe> recipeCache = this.recipeByOutputCache.get(ref);
            if (recipeCache.isEmpty()) {
                return null;
            }
            return recipeCache;
        }
        ArrayList<ICrusherRecipe> recipeCache = new ArrayList<ICrusherRecipe>();
        for (ICrusherRecipe r : this.recipes) {
            if (!ItemStack.func_179545_c((ItemStack)r.getOutput(), (ItemStack)output)) continue;
            recipeCache.add(r);
        }
        this.recipeByOutputCache.put(ref, recipeCache);
        if (recipeCache.isEmpty()) {
            return null;
        }
        return recipeCache;
    }

    public List<ICrusherRecipe> getRecipesForOutputItem(IBlockState output) {
        ItemLookupReference ref = new ItemLookupReference(output);
        if (this.recipeByOutputCache.containsKey(ref)) {
            List<ICrusherRecipe> recipeCache = this.recipeByOutputCache.get(ref);
            if (recipeCache.isEmpty()) {
                return null;
            }
            return recipeCache;
        }
        ArrayList<ICrusherRecipe> recipeCache = new ArrayList<ICrusherRecipe>();
        for (ICrusherRecipe r : this.recipes) {
            if (!ref.equals(r.getOutput())) continue;
            recipeCache.add(r);
        }
        this.recipeByOutputCache.put(ref, recipeCache);
        if (recipeCache.isEmpty()) {
            return null;
        }
        return recipeCache;
    }

    public ICrusherRecipe getRecipeForInputItem(ItemStack input) {
        ItemLookupReference ref = new ItemLookupReference(input);
        if (this.recipeByInputCache.containsKey(ref)) {
            return this.recipeByInputCache.get(ref);
        }
        for (ICrusherRecipe r : this.recipes) {
            if (!r.isValidInput(input)) continue;
            this.recipeByInputCache.put(ref, r);
            return r;
        }
        this.recipeByInputCache.put(ref, null);
        return null;
    }

    public ICrusherRecipe getRecipeForInputItem(IBlockState input) {
        ItemLookupReference ref = new ItemLookupReference(input);
        ItemStack stack = new ItemStack(input.func_177230_c(), 1, ref.metaData);
        if (this.recipeByInputCache.containsKey(ref)) {
            return this.recipeByInputCache.get(ref);
        }
        for (ICrusherRecipe r : this.recipes) {
            if (!r.isValidInput(stack)) continue;
            this.recipeByInputCache.put(ref, r);
            return r;
        }
        this.recipeByInputCache.put(ref, null);
        return null;
    }

    public Collection<ICrusherRecipe> getAllRecipes() {
        return Collections.unmodifiableList(this.recipes);
    }

    private static final class ItemLookupReference {
        final Item item;
        final int metaData;
        final int hashCache;

        public ItemLookupReference(ItemStack inputItem) {
            this.item = inputItem.func_77973_b();
            this.metaData = inputItem.func_77960_j();
            this.hashCache = this.item.func_77658_a().hashCode() + 57 * this.metaData;
        }

        public ItemLookupReference(IBlockState inputBlock) {
            this.item = Item.func_150898_a((Block)inputBlock.func_177230_c());
            this.metaData = inputBlock.func_177230_c().func_176201_c(inputBlock);
            this.hashCache = inputBlock.func_177230_c().func_149739_a().hashCode() + 57 * this.metaData;
        }

        public boolean equals(Object other) {
            if (other instanceof ItemLookupReference) {
                ItemLookupReference that = (ItemLookupReference)other;
                return this.hashCache == that.hashCache && this.item == that.item && this.metaData == that.metaData;
            }
            if (other instanceof ItemStack) {
                ItemStack that = (ItemStack)other;
                return this.item == that.func_77973_b() && this.metaData == that.func_77960_j();
            }
            return false;
        }

        public int hashCode() {
            return this.hashCache;
        }
    }
}

