/*
 * Decompiled with CFR 0.152.
 */
package person.mister.auw.tileEntity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import person.mister.auw.BaseMod;
import person.mister.auw.GuiModifySlot;
import person.mister.auw.GuiNamedTextField;
import person.mister.auw.tileEntity.GuiEditTileEntity;

public class GuiEditFurnace
extends GuiEditTileEntity {
    private int addX;
    private int addY;
    private int formatError = 0;
    private GuiScreen parent;
    private TileEntityFurnace furnace;
    private ItemStack[] items = new ItemStack[3];
    private String name;
    private GuiNamedTextField nameField;
    private short burnTime;
    private short cookTime;
    private GuiNamedTextField burnTimeField;
    private GuiNamedTextField cookTimeField;
    private boolean rPress;
    private boolean click;

    public GuiEditFurnace(GuiScreen parent, TileEntity furnace) {
        this.furnace = (TileEntityFurnace)furnace;
        this.parent = parent;
        if (furnace == null) {
            furnace = new TileEntityFurnace();
        }
        NBTTagCompound tags = new NBTTagCompound();
        furnace.func_145841_b(tags);
        if (tags.func_74764_b("CustomName")) {
            this.name = tags.func_74779_i("CustomName");
        }
        if (tags.func_74764_b("BurnTime")) {
            this.burnTime = tags.func_74765_d("BurnTime");
        }
        if (tags.func_74764_b("CookTime")) {
            this.cookTime = tags.func_74765_d("CookTime");
        }
        NBTTagList var2 = tags.func_150295_c("Items", 10);
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < 0 || var5 >= this.items.length) continue;
            this.items[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.textFields.clear();
        this.addX = this.field_146294_l / 2 - 160;
        this.addY = this.field_146295_m / 2 - 120;
        this.rPress = false;
        this.click = false;
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 52, this.field_146295_m - this.addY - 22, 50, 20, "Save"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 2, this.field_146295_m - this.addY - 22, 50, 20, "Cancel"));
        this.nameField = new GuiNamedTextField(this.field_146289_q, this.field_146294_l / 2 - 50, this.addY + 30, 100, 10, "Custom Name");
        if (this.name != null) {
            this.nameField.func_146180_a(this.name);
        }
        this.textFields.add(this.nameField);
        this.burnTimeField = new GuiNamedTextField(this.field_146289_q, this.field_146294_l / 2 - 80, this.addY + 55, 75, 10, "Burn Time");
        this.burnTimeField.func_146180_a("" + this.burnTime);
        this.textFields.add(this.burnTimeField);
        this.cookTimeField = new GuiNamedTextField(this.field_146289_q, this.field_146294_l / 2 + 10, this.addY + 55, 75, 10, "Cook Time");
        this.cookTimeField.func_146180_a("" + this.cookTime);
        this.textFields.add(this.cookTimeField);
        this.colorButton(this.addX + 220, this.addY + 25);
        this.updateFurnace();
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            this.updateFurnace();
            this.save();
            this.field_146297_k.func_147108_a(this.parent);
        } else if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    @Override
    public void func_73869_a(char key, int keyCode) {
        super.func_73869_a(key, keyCode);
        this.name = this.nameField.func_146179_b().isEmpty() ? null : this.nameField.func_146179_b();
        try {
            this.cookTime = Short.parseShort(this.cookTimeField.func_146179_b());
            if (this.formatError == 1) {
                this.formatError = 0;
            }
        }
        catch (NumberFormatException e) {
            this.cookTime = 0;
            if (this.formatError == 0) {
                e.printStackTrace();
            }
            this.formatError = 1;
        }
        try {
            this.burnTime = Short.parseShort(this.burnTimeField.func_146179_b());
            this.formatError = 0;
            if (this.formatError == 2) {
                this.formatError = 0;
            }
        }
        catch (NumberFormatException e) {
            this.burnTime = 0;
            if (this.formatError == 0) {
                e.printStackTrace();
            }
            this.formatError = 2;
        }
        if (keyCode == BaseMod.key.func_151463_i()) {
            this.rPress = true;
        }
        this.updateFurnace();
    }

    @Override
    public void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (button == 0) {
            this.click = true;
        }
        this.updateFurnace();
    }

    @Override
    public void func_73863_a(int x, int y, float par) {
        int var6;
        this.func_146276_q_();
        if (BaseMod.debugMode) {
            GuiEditFurnace.func_73734_a((int)this.addX, (int)this.addY, (int)(this.field_146294_l - this.addX), (int)(this.field_146295_m - this.addY), (int)-2005401788);
        }
        super.func_73863_a(x, y, par);
        int[] xPoses = new int[]{131 + this.addX, 131 + this.addX, 190 + this.addX};
        int[] yPoses = new int[]{117 + this.addY, 153 + this.addY, 135 + this.addY};
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/container/furnace.png"));
        int guiX = this.addX + 75;
        int guiY = this.addY + 100;
        this.func_73729_b(guiX, guiY, 0, 0, 176, 80);
        this.func_73729_b(guiX, guiY + 80, 0, 160, 176, 6);
        this.func_73732_a(this.field_146289_q, this.name, this.field_146294_l / 2 + 3, this.addY + 105, -1);
        if (this.furnace.func_145950_i()) {
            var6 = this.furnace.func_145955_e(12);
            this.func_73729_b(guiX + 56, guiY + 36 + 12 - var6, 176, 12 - var6, 14, var6 + 2);
        }
        var6 = this.furnace.func_145953_d(24);
        this.func_73729_b(guiX + 79, guiY + 34, 176, 14, var6 + 1, 16);
        for (int i = 0; i < this.items.length; ++i) {
            this.drawStack(this.items[i], xPoses[i], yPoses[i], x, y, false, false);
        }
        int index = -1;
        for (int i = 0; i < 3; ++i) {
            if (x <= xPoses[i] || x >= xPoses[i] + 18 || y <= yPoses[i] || y >= yPoses[i] + 18) continue;
            index = i;
        }
        if (index >= 0) {
            GL11.glPushAttrib((int)8256);
            try {
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                this.func_73733_a(xPoses[index], yPoses[index], xPoses[index] + 16, yPoses[index] + 16, -2130706433, -2130706433);
                if (this.items[index] != null) {
                    this.renderTooltip(this.items[index], x, y);
                }
                if (this.click && Mouse.isButtonDown((int)0) || this.rPress && Keyboard.isKeyDown((int)BaseMod.key.func_151463_i())) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiModifySlot(this, this.items[index], index){

                        @Override
                        public void save() {
                            ((GuiEditFurnace)GuiEditFurnace.this).items[this.slotIndex] = this.stack;
                        }
                    });
                }
            }
            catch (Exception e) {
                this.func_73731_b(this.field_146289_q, "ERR", index % 9 * 18 + this.addX + 80, index / 9 * 18 + this.addY + 50, 0xFF0000);
                this.func_73731_b(this.field_146289_q, "OR", index % 9 * 18 + this.addX + 80, index / 9 * 18 + this.addY + 59, 0xFF0000);
            }
            GL11.glPopAttrib();
        }
        if (this.formatError > 0) {
            this.func_73731_b(this.field_146289_q, "One of the numbers is formatted wrong", this.addX, this.addY, 0xFF0000);
        }
    }

    public void updateFurnace() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("id", "Furnace");
        tags.func_74768_a("x", this.furnace.field_145851_c);
        tags.func_74768_a("y", this.furnace.field_145848_d);
        tags.func_74768_a("z", this.furnace.field_145849_e);
        if (this.name != null && !this.name.isEmpty()) {
            tags.func_74778_a("CustomName", this.name);
        }
        tags.func_74777_a("BurnTime", this.burnTime);
        tags.func_74777_a("CookTime", this.cookTime);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.items.length; ++var3) {
            if (this.items[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.items[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        tags.func_74782_a("Items", (NBTBase)var2);
        this.furnace = new TileEntityFurnace();
        this.furnace.func_145839_a(tags);
    }

    @Override
    public void save() {
    }

    @Override
    public TileEntity getTileEntity() {
        return this.furnace;
    }

    @Override
    public int getBlockID() {
        return 61;
    }
}

