#version 120

/*
Chocapic13' shaders, derived from SonicEther v10 rc6
Place two leading Slashes in front of the following '#define' lines in order to disable an option.
*/

//disabling is done by adding "//" to the beginning of a line.

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES

#define LENS_EFFECTS
#define LENS_STRENGTH 0.62

//#define BLOOM								//do the "fog blur" in the same time
	#define B_HQ					
	//#define B_LQ			
	#define B_TRESH 0.4				
	#define B_RAD 20.0					//sampling circle size multiplier, don't affect performance
	#define B_INTENSITY 1.0		//basic multiplier

//#define DOF
	//lens properties
const float focal = 0.024;
float aperture = 0.009;	
const float sizemult = 100.0;
/*
Try different setting by replacing the values above by the values here
----------------------------------
"Near to human eye (for gameplay,default)":

const float focal = 0.024;
float aperture = 0.009;	
const float sizemult = 100.0;
----------------------------------
"Tilt shift (cinematics)":

const float focal = 0.3;
float aperture = 0.3;	
const float sizemult = 1.0;
----------------------------------
"Camera (cinematics)":

const float focal = 0.05;
float aperture = focal/7.0;	
const float sizemult = 100.0;
---------------------------------- 
*/
#define TONEMAP
#define TONEMAP_CURVE 2.0
#define CONTRAST 0.3
#define GAMMA 1.0							//1.0 = default Gamma. Higher values mean darker.
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES



varying vec4 texcoord;
varying vec3 sunlight;

uniform sampler2D depthtex2;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
vec3 sunPos = sunPosition;
uniform int fogMode;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float timefract = worldTime;

//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

// Standard depth function.
float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

	float matflag = texture2D(gaux1,texcoord.xy).g;

#ifdef BLOOM
	#ifdef B_LQ
		const vec2 offsets[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);
	#endif
	
	#ifdef B_HQ
		const vec2 offsets[60] = vec2[60](vec2( 0.0000, 0.2500 ),
									vec2( -0.2165, 0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2( 0.2165, -0.1250 ),
									vec2( 0.2165, 0.1250 ),
									vec2( 0.0000, 0.5000 ),
									vec2( -0.2500, 0.4330 ),
									vec2( -0.4330, 0.2500 ),
									vec2( -0.5000, 0.0000 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.2500, -0.4330 ),
									vec2( -0.0000, -0.5000 ),
									vec2( 0.2500, -0.4330 ),
									vec2( 0.4330, -0.2500 ),
									vec2( 0.5000, -0.0000 ),
									vec2( 0.4330, 0.2500 ),
									vec2( 0.2500, 0.4330 ),
									vec2( 0.0000, 0.7500 ),
									vec2( -0.2565, 0.7048 ),
									vec2( -0.4821, 0.5745 ),
									vec2( -0.6495, 0.3750 ),
									vec2( -0.7386, 0.1302 ),
									vec2( -0.7386, -0.1302 ),
									vec2( -0.6495, -0.3750 ),
									vec2( -0.4821, -0.5745 ),
									vec2( -0.2565, -0.7048 ),
									vec2( -0.0000, -0.7500 ),
									vec2( 0.2565, -0.7048 ),
									vec2( 0.4821, -0.5745 ),
									vec2( 0.6495, -0.3750 ),
									vec2( 0.7386, -0.1302 ),
									vec2( 0.7386, 0.1302 ),
									vec2( 0.6495, 0.3750 ),
									vec2( 0.4821, 0.5745 ),
									vec2( 0.2565, 0.7048 ),
									vec2( 0.0000, 1.0000 ),
									vec2( -0.2588, 0.9659 ),
									vec2( -0.5000, 0.8660 ),
									vec2( -0.7071, 0.7071 ),
									vec2( -0.8660, 0.5000 ),
									vec2( -0.9659, 0.2588 ),
									vec2( -1.0000, 0.0000 ),
									vec2( -0.9659, -0.2588 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.7071, -0.7071 ),
									vec2( -0.5000, -0.8660 ),
									vec2( -0.2588, -0.9659 ),
									vec2( -0.0000, -1.0000 ),
									vec2( 0.2588, -0.9659 ),
									vec2( 0.5000, -0.8660 ),
									vec2( 0.7071, -0.7071 ),
									vec2( 0.8660, -0.5000 ),
									vec2( 0.9659, -0.2588 ),
									vec2( 1.0000, -0.0000 ),
									vec2( 0.9659, 0.2588 ),
									vec2( 0.8660, 0.5000 ),
									vec2( 0.7071, 0.7071 ),
									vec2( 0.5000, 0.8660 ),
									vec2( 0.2588, 0.9659 ));
	#endif
	
#endif


#ifdef DOF

//hexagon pattern
const vec2 hex_offsets[60] = vec2[60] (	vec2(  0.2165,  0.1250 ),
									vec2(  0.0000,  0.2500 ),
									vec2( -0.2165,  0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2(  0.2165, -0.1250 ),
									vec2(  0.4330,  0.2500 ),
									vec2(  0.0000,  0.5000 ),
									vec2( -0.4330,  0.2500 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.0000, -0.5000 ),
									vec2(  0.4330, -0.2500 ),
									vec2(  0.6495,  0.3750 ),
									vec2(  0.0000,  0.7500 ),
									vec2( -0.6495,  0.3750 ),
									vec2( -0.6495, -0.3750 ),
									vec2( -0.0000, -0.7500 ),
									vec2(  0.6495, -0.3750 ),
									vec2(  0.8660,  0.5000 ),
									vec2(  0.0000,  1.0000 ),
									vec2( -0.8660,  0.5000 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.0000, -1.0000 ),
									vec2(  0.8660, -0.5000 ),
									vec2(  0.2163,  0.3754 ),
									vec2( -0.2170,  0.3750 ),
									vec2( -0.4333, -0.0004 ),
									vec2( -0.2163, -0.3754 ),
									vec2(  0.2170, -0.3750 ),
									vec2(  0.4333,  0.0004 ),
									vec2(  0.4328,  0.5004 ),
									vec2( -0.2170,  0.6250 ),
									vec2( -0.6498,  0.1246 ),
									vec2( -0.4328, -0.5004 ),
									vec2(  0.2170, -0.6250 ),
									vec2(  0.6498, -0.1246 ),
									vec2(  0.6493,  0.6254 ),
									vec2( -0.2170,  0.8750 ),
									vec2( -0.8663,  0.2496 ),
									vec2( -0.6493, -0.6254 ),
									vec2(  0.2170, -0.8750 ),
									vec2(  0.8663, -0.2496 ),
									vec2(  0.2160,  0.6259 ),
									vec2( -0.4340,  0.5000 ),
									vec2( -0.6500, -0.1259 ),
									vec2( -0.2160, -0.6259 ),
									vec2(  0.4340, -0.5000 ),
									vec2(  0.6500,  0.1259 ),
									vec2(  0.4325,  0.7509 ),
									vec2( -0.4340,  0.7500 ),
									vec2( -0.8665, -0.0009 ),
									vec2( -0.4325, -0.7509 ),
									vec2(  0.4340, -0.7500 ),
									vec2(  0.8665,  0.0009 ),
									vec2(  0.2158,  0.8763 ),
									vec2( -0.6510,  0.6250 ),
									vec2( -0.8668, -0.2513 ),
									vec2( -0.2158, -0.8763 ),
									vec2(  0.6510, -0.6250 ),
									vec2(  0.8668,  0.2513 ));

#endif

//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////

float distratio(vec2 pos, vec2 pos2, float ratio) {
float xvect = pos.x*ratio-pos2.x*ratio;
float yvect = pos.y-pos2.y;
return sqrt(xvect*xvect + yvect*yvect);
}

//circle position pattern (vec2 coordinate, size)
const vec3 pattern[16] = vec3[16](	vec3(0.1,0.1,0.02),
								vec3(-0.12,0.07,0.02),
								vec3(-0.11,-0.13,0.02),
								vec3(0.1,-0.1,0.02),
								
								vec3(0.07,0.15,0.02),
								vec3(-0.08,0.17,0.02),
								vec3(-0.14,-0.07,0.02),
								vec3(0.15,-0.19,0.02),
								
								vec3(0.012,0.15,0.02),
								vec3(-0.08,0.17,0.02),
								vec3(-0.14,-0.07,0.02),
								vec3(0.02,-0.17,0.021),
								
								vec3(0.10,0.05,0.02),
								vec3(-0.13,0.09,0.02),
								vec3(-0.05,-0.1,0.02),
								vec3(0.1,0.01,0.02)
								);
								
float gen_circular_lens(vec2 center, float size) {
return 1.0-pow(min(distratio(texcoord.xy,center,aspectRatio),size)/size,10.0);
}

vec2 noisepattern(vec2 pos) {
return vec2(abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f)),abs(fract(sin(dot(pos.yx ,vec2(18.9898f,28.633f))) * 4378.5453f)));
} 
void main() {
	vec2 fake_refract = vec2(sin(worldTime/15.0 + texcoord.x*75.0 + texcoord.y*32.0),cos(worldTime/15.0 + texcoord.y*75.0 + texcoord.x*32.0)) * isEyeInWater;
	vec3 color = texture2D(gaux2, texcoord.st + fake_refract * 0.007).rgb;
	
	int iswater = int(matflag > 0.04 && matflag < 0.07);


#ifdef DOF
	
	//Calculate pixel Circle of Confusion that will be used for bokeh depth of field
	float z = ld(texture2D(depthtex2, texcoord.st).r)*far;
	float focus = ld(texture2D(depthtex2, vec2(0.5)).r)*far;
	float pcoc = min(abs(aperture * (focal * (z - focus)) / (z * (focus - focal)))*sizemult,pw*10.0);		
	
	vec4 sample = vec4(0.0);
	vec3 bcolor = vec3(0.0);
	float nb = 0.0;
	vec2 bcoord = vec2(0.0);

	for ( int i = 0; i < 60; i++) {
		if (isEyeInWater > 0.9) {
			sample = texture2D(gaux2, texcoord.xy + hex_offsets[i]*0.01*vec2(1.0,aspectRatio) + fake_refract * 0.007);
			bcolor += sample.rgb;
		} else {
			sample = texture2D(gaux2, texcoord.xy + hex_offsets[i]*pcoc*vec2(1.0,aspectRatio) + fake_refract * 0.007);
			bcolor += sample.rgb;
		}
	}
	
	color.rgb = bcolor/60.0;
	
#endif
	
	float plum = luma(color.rgb);

#ifdef BLOOM
const int GL_LINEAR = 9729;
const int GL_EXP = 2048;
	//color.rgb = color.rgb*(1.0+(luma(color.rgb)-texture2D(gaux2,vec2(1.0)).a));
	vec3 blur = vec3(0.0);
	float depth_diff = clamp(pow(ld(texture2D(depthtex2, texcoord.st).r)*4.0,0.8),0.0,1.0)+0.1;
	float fog = 0.0;
	if (fogMode == 0) fog = 1.0-clamp(exp(-ld(texture2D(depthtex2, texcoord.st).r)),0.0,1.0);
	#ifdef B_LQ
			float scale = length(vec2(pw,ph));
			vec3 csample = vec3(0.0);
				for (int i=0; i < 25; i++) {
				vec2 coords = offsets[i];
				vec3 sample = texture2D(gaux2,texcoord.xy + coords*B_RAD*scale).rgb;
				csample += max(texture2D(gaux2,texcoord.xy + coords*B_RAD*scale).rgb-plum*0.75-B_TRESH,0.0) * (length(coords)+0.6)/2.0;
				blur += sample;
			}
			color += csample/25.0*B_INTENSITY;
		
		//fog blurring with the distance
		color.rgb = mix(color,blur/25.0,depth_diff*isEyeInWater*0.4+fog*(1.0-isEyeInWater)*rainStrength);
	#endif

	#ifdef B_HQ
			float scale = length(vec2(pw,ph));
			vec3 csample = vec3(0.0);
				for (int i=0; i < 60; i++) {
				vec2 coords = offsets[i];
				vec3 sample = texture2D(gaux2,texcoord.xy + coords*B_RAD*scale).rgb;
				csample += max(texture2D(gaux2,texcoord.xy + coords*B_RAD*scale).rgb-plum*0.75-B_TRESH,0.0) * (length(coords)+0.6)/2.0;
				blur += sample;
			}
			color += csample/60.0*B_INTENSITY;
		
		//fog blurring with the distance
		color.rgb = mix(color,blur/60.0,depth_diff*isEyeInWater*0.4+fog*(1.0-isEyeInWater)*rainStrength);
	#endif
	
#endif
		
#ifdef LENS_EFFECTS

	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z;
		lightPos = (lightPos + 1.0f)/2.0f;
		
	// For lens flare
	vec4 tpos2 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos2 = vec4(tpos2.xyz/tpos2.w,1.0);
	vec2 lightPos2 = tpos2.xy/-tpos2.z*0.8;
		lightPos2 = (lightPos2 + 1.0f)/2.0f;
		
	vec4 tpos1 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos1 = vec4(tpos1.xyz/tpos1.w,1.0);
	vec2 lightPos1 = tpos1.xy/-tpos1.z*0.6;
		lightPos1 = (lightPos1 + 1.0f)/2.0f;
		
	vec4 tpos3 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos3 = vec4(tpos3.xyz/tpos3.w,1.0);
	vec2 lightPos3 = tpos3.xy/-tpos3.z*0.35;
		lightPos3 = (lightPos3 + 1.0f)/2.0f;
		
	vec4 tpos4 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos4 = vec4(tpos4.xyz/tpos4.w,1.0);
	vec2 lightPos4 = tpos4.xy/-tpos4.z*0.23;
		lightPos4 = (lightPos4 + 1.0f)/2.0f;
		
	vec4 tpos5 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos5 = vec4(tpos5.xyz/tpos5.w,1.0);
	vec2 lightPos5 = tpos5.xy/-tpos5.z*0.15;
		lightPos5 = (lightPos5 + 1.0f)/2.0f;
		
	vec4 tpos6 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos6 = vec4(tpos6.xyz/tpos6.w,1.0);
	vec2 lightPos6 = tpos6.xy/-tpos6.z*0.2;
		lightPos6 = (lightPos6 + 1.0f)/2.0f;
		
	vec4 tpos7 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos7 = vec4(tpos7.xyz/tpos7.w,1.0);
	vec2 lightPos7 = tpos7.xy/-tpos7.z*0.4;
		lightPos7 = (lightPos7 + 1.0f)/2.0f;
		
	vec4 tpos8 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos8 = vec4(tpos8.xyz/tpos8.w,1.0);
	vec2 lightPos8 = tpos8.xy/-tpos8.z*0.95;
		lightPos8 = (lightPos8 + 1.0f)/2.0f;
		
	vec4 tpos9 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos9 = vec4(tpos9.xyz/tpos9.w,1.0);
	vec2 lightPos9 = tpos8.xy/-tpos9.z/100;
		lightPos9 = (lightPos9 + 1.0f)/2.0f;

    float xdist = abs(lightPos.x-texcoord.x);
    float ydist = abs(lightPos.y-texcoord.y);
    float xydist = distance(lightPos.xy,texcoord.xy);
    float xydistratio = distratio(lightPos.xy,texcoord.xy,aspectRatio);
    float xydistratio2 = distratio(lightPos2.xy,texcoord.xy,aspectRatio);
    float xydistratio1 = distratio(lightPos1.xy,texcoord.xy,aspectRatio);
    float xydistratio3 = distratio(lightPos3.xy,texcoord.xy,aspectRatio);
    float xydistratio4 = distratio(lightPos4.xy,texcoord.xy,aspectRatio);
    float xydistratio5 = distratio(lightPos5.xy,texcoord.xy,aspectRatio);
    float xydistratio6 = distratio(lightPos6.xy,texcoord.xy,aspectRatio);
    float xydistratio7 = distratio(lightPos7.xy,texcoord.xy,aspectRatio);
    float xydistratio8 = distratio(lightPos8.xy,texcoord.xy,aspectRatio);	
    float xydistratio9 = distratio(lightPos9.xy,texcoord.xy,aspectRatio);	

    float distof = min(min(1.0-lightPos.x,lightPos.x),min(1.0-lightPos.y,lightPos.y));
    float fading = clamp(1.0-step(distof,0.1)+pow(distof*10.0,5.0),0.0,1.0);

    float time = float(worldTime);
	float transition_fading = 1.0-(clamp((time-12000.0)/500.0,0.0,1.0)-clamp((time-13000.0)/500.0,0.0,1.0) + clamp((time-22500.0)/100.0,0.0,1.0)-clamp((time-23300.0)/200.0,0.0,1.0));

    float sunvisibility = min(texture2D(gaux2,vec2(0.0)).a*2.5,1.0) * fading * transition_fading;
	
    float dirtylens = 0.0;

    vec2 pos1 = noisepattern(vec2(0.6,-0.12));
    dirtylens += gen_circular_lens(pos1,0.05)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.3,-0.4));
    dirtylens += gen_circular_lens(pos1,0.015)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.8,-0.4));
    dirtylens += gen_circular_lens(pos1,0.02)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.9,-0.2));
    dirtylens += gen_circular_lens(pos1,0.03)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.9,-0.6));
    dirtylens += gen_circular_lens(pos1,0.04)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.2,-0.8));
    dirtylens += gen_circular_lens(pos1,0.04)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.5,-0.9));
    dirtylens += gen_circular_lens(pos1,0.05)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.5,-0.95));
    dirtylens += gen_circular_lens(pos1,0.02)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.6,-0.95));
    dirtylens += gen_circular_lens(pos1,0.02)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.7,-0.1));
    dirtylens += gen_circular_lens(pos1,0.035)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.9,-0.1));
    dirtylens += gen_circular_lens(pos1,0.02)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.2,-0.2));
    dirtylens += gen_circular_lens(pos1,0.037)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.4,-0.2));
    dirtylens += gen_circular_lens(pos1,0.02)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.95,-0.8));
    dirtylens += gen_circular_lens(pos1,0.03)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.99,-0.8));
    dirtylens += gen_circular_lens(pos1,0.04)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.99,0.99));
    dirtylens += gen_circular_lens(pos1,0.03)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.2,0.9));
    dirtylens += gen_circular_lens(pos1,0.043)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.4,0.99));
    dirtylens += gen_circular_lens(pos1,0.02)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.69,0.999));
    dirtylens += gen_circular_lens(pos1,0.02)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.69,0.99));
    dirtylens += gen_circular_lens(pos1,0.025)*sunvisibility;
	
    pos1 = noisepattern(vec2(-0.9,0.3));
    dirtylens += gen_circular_lens(pos1,0.03)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.9,0.3));
    dirtylens += gen_circular_lens(pos1,0.04)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.1,0.1));
    dirtylens += gen_circular_lens(pos1,0.05)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.1,0.15));
    dirtylens += gen_circular_lens(pos1,0.035)*sunvisibility;
	
    pos1 = noisepattern(vec2(0.15,0.13));
    dirtylens += gen_circular_lens(pos1,0.025)*sunvisibility;
	
	if (sunvisibility > 0.1) {
        float visibility = max(pow(max(1.0 - xydistratio/1.0,0.1),2.0)-0.1,0.0);
	    color += (dirtylens*visibility)*0.2*(TimeSunrise + TimeNoon + TimeSunset)*(1.0-rainStrength*1.0);
		color += (dirtylens*visibility)*vec3(0.25, 0.5, 0.7)*0.1*TimeMidnight*(1.0-rainStrength*1.0);
	}

if ((worldTime < 13000 || worldTime > 23000) && sunPos.z < 0 && isEyeInWater < 0.9){

    if (sunvisibility > 0.1) {
        float ratiolens = max(pow(max(1.0 - xydistratio/1.0,0.1),2.0)-0.1,0.0);
		color += ratiolens*0.2*sunvisibility * (1.0-rainStrength*1.0);
    }

    // Anamorphic Lens
    if (ydist < 0.27 && sunvisibility > 0.1) {
	
        float dist = distance(texcoord.st, vec2(0.5, 0.5));
        dist = 0.5 - dist;
	
	    vec3 lenscolor = vec3(0.3, 0.8, 1.5)*1.3*(TimeSunrise + TimeNoon + TimeSunset);
		
        float anamorphic_lens = max(pow(max(1.0 - ydist/1.412,0.01),8.0)-0.7,0.0);
        color += lenscolor*anamorphic_lens*dist*sunvisibility * (1.0-rainStrength*1.0);
    }

	// Big blue point
    if (xydistratio1 < 0.3 && sunvisibility > 0.1) {

	    vec3 lenscolor = vec3(0.3, 0.8, 1.5)*(TimeSunrise + TimeNoon + TimeSunset);
		
		float lens_strength = 1.5;
		lenscolor *= lens_strength;
	 
        float lens_flare1 = max(pow(max(1.0 - xydistratio1/1.512,0.1),2.0)-0.93,0.0);
        color += lenscolor*lens_flare1*sunvisibility * (1.0-rainStrength*1.0);
		
        float lens_flare2 = max(pow(max(1.0 - xydistratio1/1.512,0.1),8.0)-0.95,0.0);
        color += lenscolor*lens_flare2*5.0*sunvisibility * (1.0-rainStrength*1.0);
	
        float lens_flare3 = max(pow(max(1.0 - xydistratio1/1.512,0.1),8.0)-0.2,0.0);
        color += lenscolor*lens_flare3*0.1*sunvisibility * (1.0-rainStrength*1.0);
    }

    // Red point next to the big blue point
    if (xydistratio2 < 0.3 && sunvisibility > 0.1) {

	    vec3 lenscolor = vec3(1.0, 0.9, 0.9)*(TimeSunrise + TimeNoon + TimeSunset);
		
		float lens_strength = 0.6;
		lenscolor *= lens_strength;
	
        float lens_flare1 = max(pow(max(1.0 - xydistratio2/1.412,0.01),2.0)-0.9,0.0);
        color += lenscolor*lens_flare1*sunvisibility* (1.0-rainStrength*1.0);
    }
	
	// Red point near to the big blue point
    if (xydistratio3 < 0.5 && sunvisibility > 0.1) {
	
	    vec3 lenscolor = vec3(1.0, 0.9, 0.9)*(TimeSunrise + TimeNoon + TimeSunset);
		
		float lens_strength = 0.9;
		lenscolor *= lens_strength;
	
        float lens_flare1 = max(pow(max(1.0 - xydistratio3/1.412,0.01),2.0)-0.95,0.0);
        color += lenscolor*lens_flare1*sunvisibility* (1.0-rainStrength*1.0);

    }
	
	// Red point near to the big blue point
    if (xydistratio4 < 0.5 && sunvisibility > 0.1) {
	
	    vec3 lenscolor = vec3(1.0, 0.9, 0.9)*(TimeSunrise + TimeNoon + TimeSunset);
		
		float lens_strength = 0.6;
		lenscolor *= lens_strength;
	
        float lens_flare1 = max(pow(max(1.0 - xydistratio4/1.412,0.01),2.0)-0.9,0.0);
        color += lenscolor*lens_flare1*sunvisibility* (1.0-rainStrength*1.0);

    }
	
	////////////////////////////////////////////////////////////////////////////////
	
	// Little green point
    if (xydistratio5 < 0.5 && sunvisibility > 0.1) {
	
		vec3 lenscolor = vec3(0.5, 1.0, 0.2)*(TimeSunrise + TimeNoon + TimeSunset);
		
		float lens_strength = 1.5;
		lenscolor *= lens_strength;
		
        float lens_flare1 = max(pow(max(1.0 - xydistratio5/1.512,0.1),8.0)-0.95,0.0);
        color += lenscolor*lens_flare1*2.0*sunvisibility * (1.0-rainStrength*1.0);
	}
	
	// Bigger little blue point
    if (xydistratio8 < 0.5 && sunvisibility > 0.1) {
	
		vec3 lenscolor = vec3(0.3, 0.8, 1.5)*(TimeSunrise + TimeNoon + TimeSunset);
		
		float lens_strength = 1.5;
		lenscolor *= lens_strength;
		
        float lens_flare1 = max(pow(max(1.0 - xydistratio8/1.512,0.1),8.0)-0.925,0.0);
        color += lenscolor*lens_flare1*sunvisibility * (1.0-rainStrength*1.0);
	}
	
	// Bigger little blue point near at the sun
    if (xydistratio9 < 0.5 && sunvisibility > 0.1) {
	
		vec3 lenscolor = vec3(0.3, 0.8, 1.5)*(TimeSunrise + TimeNoon + TimeSunset);
		
		float lens_strength = 1.5;
		lenscolor *= lens_strength;
		
        float lens_flare1 = max(pow(max(1.0 - xydistratio9/1.512,0.1),8.0)-0.925,0.0);
        color += lenscolor*lens_flare1*sunvisibility * (1.0-rainStrength*1.0);
	}
}
	
//rain drops on screen

if (rainStrength > 0.01) {
    const float pi = 3.14159265359;
	float lightmap = pow(eyeBrightness.y/255.0, 6.0f);
	float fake_refract = 1.0-sin(worldTime/5.14159265359 + texcoord.x*30.0 + texcoord.y*30.0);
	float fake_refract2 = sin(worldTime/7.14159265359 + texcoord.x*20.0 + texcoord.y*20.0) * pow(eyeBrightness.y/255.0, 6.0f) * (1.0-TimeMidnight*0.7);
    vec3 watercolor = texture2D(gaux1, texcoord.st + fake_refract * 0.015 * lightmap).rgb;
    float raindrops = 0.0;
	float time2 = frameTimeCounter;

    float gen = cos(time2*pi)*0.5+0.5;
    vec2 pos = noisepattern(vec2(0.9347*floor(time2*0.5+0.5),-0.2533282*floor(time2*0.5+0.5)));
    raindrops += gen_circular_lens(pos,0.033)*gen*rainStrength;

    gen = cos(time2*pi)*0.5+0.5;
    pos = noisepattern(vec2(0.785282*floor(time2*0.5+0.5),-0.285282*floor(time2*0.5+0.5)));
    raindrops += gen_circular_lens(pos,0.033)*gen*rainStrength;

    gen = sin(time2*pi)*0.5+0.5;
    pos = noisepattern(vec2(-0.347*floor(time2*0.5+0.5),0.6847*floor(time2*0.5+0.5)));
    raindrops += gen_circular_lens(pos,0.033)*gen*rainStrength;

    gen = cos(time2*pi)*0.5+0.5;
    pos = noisepattern(vec2(0.3347*floor(time2*0.5+0.5),-0.2533282*floor(time2*0.5+0.5)));
    raindrops += gen_circular_lens(pos,0.033)*gen*rainStrength;

    gen = cos(time2*pi)*0.5+0.5;
    pos = noisepattern(vec2(0.385282*floor(time2*0.5+0.5),-0.285282*floor(time2*0.5+0.5)));
    raindrops += gen_circular_lens(pos,0.033)*gen*rainStrength;
     
	if (isEyeInWater < 0.9) {
        color += abs(fake_refract2)/25*raindrops;
	}
}
#endif

color = clamp(color,0.0,1.0);

float white = luma(color);
color = color*(1.0+pow(white,CONTRAST))/(2.0-CONTRAST);

color = pow(color,vec3(2.2));
#ifdef TONEMAP

color = color / (color + TONEMAP_CURVE) * (1.0+TONEMAP_CURVE);


#endif

    float dist = distance(texcoord.st, vec2(0.5, 0.5));
    dist = 0.8 - dist;
	
    color.r = color.r * dist;
    color.g = color.g * dist;
    color.b = color.b * dist;
	
	color.r = pow(color.r, 0.8);
	color.g = pow(color.g, 0.8);
	color.b = pow(color.b, 0.8);
	
    vec3 Gray = vec3(0.0, 0.3, 0.3);
    vec3 ColorScale = vec3(1.0, 1.0, 1.0);
    float Saturation = 1.2;

    // Color Matrix
    vec3 OutColor = color.rgb;
    
    // Offset & Scale
    OutColor = (OutColor * ColorScale);
    
    // Saturation
    float Luma = dot(OutColor, Gray);
    vec3 Chroma = OutColor - Luma;
    OutColor = (Chroma * Saturation) + Luma;
    
    color = OutColor;
	
#ifdef COLOR_SAT
vec3 input = color;
float rdist = max(color.r*sqrt(2.0)-length(color.gb),0.0)*(1.0/length(color));
float gdist = max(color.g*sqrt(2.0)-length(color.rb),0.0)*(1.0/length(color));
float bdist = max(color.b*sqrt(2.0)-length(color.rg),0.0)*(1.0/length(color));
color *= (vec3(rdist,gdist,bdist)+SAT)/SAT;

#endif
color = pow(color,vec3(1.0/2.2));
/*
	if (texcoord.x < 0.1 && texcoord.y < 0.1) color.rgb = vec3(texture2D(gaux2,vec2(1.0)).a);
*/

	
	gl_FragColor = vec4(color,1.0);
	
}
