/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;
import shadersmodcore.transform.Names;
import shadersmodcore.transform.SMCRenamerMethodAdaptor;

public class SMCRemap {
    private static boolean deobfuscatedEnv = false;
    private static Map<String, String> mapSrgToMcp = null;
    private static Map<String, String> mapMcpToSrg = null;
    public static Remapper remapper;
    public static Remapper remapperW;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readCSV(String fileName, Map<String, String[]> map) {
        BufferedReader rd = null;
        try {
            String line;
            rd = new BufferedReader(new FileReader(fileName));
            rd.readLine();
            while ((line = rd.readLine()) != null) {
                String[] tokens = line.split(",");
                if (tokens.length <= 1) continue;
                map.put(tokens[0], tokens);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String getNamePart(String fullName) {
        int i = fullName.lastIndexOf(47);
        if (i >= 0) {
            return fullName.substring(i + 1);
        }
        return fullName;
    }

    private static String getParent(String fullName) {
        int i = fullName.lastIndexOf(47);
        if (i >= 0) {
            return fullName.substring(0, i);
        }
        return "";
    }

    private static String getDesc(String desc, Map<String, String[]> mapC) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < desc.length()) {
            int p = desc.indexOf(76, i);
            if (p != -1) {
                int q = desc.indexOf(59, p + 1);
                if (q != -1) {
                    s.append(desc, i, p);
                    s.append('L');
                    s.append(SMCRemap.getClassPack(desc.substring(p + 1, q), mapC));
                    s.append(';');
                    i = q + 1;
                    continue;
                }
                return desc;
            }
            s.append(desc, i, desc.length());
            i = desc.length();
        }
        return s.toString();
    }

    private static String getClassPack(String fullName, Map<String, String[]> mapC) {
        String[] packrecord;
        String name = SMCRemap.getNamePart(fullName);
        String pack = SMCRemap.getParent(fullName);
        if (pack.equals("net/minecraft/src") && (packrecord = mapC.get(name)) != null && packrecord.length >= 2) {
            pack = packrecord[1];
        }
        return pack + "/" + name;
    }

    private static String stringForPrint(String s) {
        return s != null ? s : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseSrg(String inFileName, Map<String, String> mapLtoR, Map<String, String> mapRtoL) {
        BufferedReader rd = null;
        try {
            String line;
            rd = new BufferedReader(new FileReader(inFileName));
            while ((line = rd.readLine()) != null) {
                String nameL;
                String parentL;
                String[] tokens = Arrays.copyOf(line.split(" "), 10);
                if (tokens[0].equals("FD:")) {
                    parentL = SMCRemap.getParent(tokens[1]);
                    nameL = SMCRemap.getNamePart(tokens[1]);
                    String parentR = SMCRemap.getParent(tokens[2]);
                    String nameR = SMCRemap.getNamePart(tokens[2]);
                    mapLtoR.put(parentL + "." + nameL, nameR);
                    mapRtoL.put(parentR + "." + nameR, nameL);
                    continue;
                }
                if (!tokens[0].equals("MD:")) continue;
                parentL = SMCRemap.getParent(tokens[1]);
                nameL = SMCRemap.getNamePart(tokens[1]);
                String descL = tokens[2];
                String parentR = SMCRemap.getParent(tokens[3]);
                String nameR = SMCRemap.getNamePart(tokens[3]);
                String descR = tokens[4];
                mapLtoR.put(parentL + "." + nameL + descL, nameR);
                mapRtoL.put(parentR + "." + nameR + descR, nameL);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void addClassMap(String srcName, String srgName) {
        mapMcpToSrg.put(srcName, srgName);
        mapSrgToMcp.put(srgName, srcName);
    }

    public static void addInheritedMethod(String owner, String base, String name, String desc) {
        String srcName = mapSrgToMcp.get(base + "." + name + desc);
        mapMcpToSrg.put(owner + "." + srcName + desc, name);
        mapSrgToMcp.put(owner + "." + name + desc, srcName);
    }

    public static void addInheritedField(String owner, String base, String name) {
        String srcName = mapSrgToMcp.get(base + "." + name);
        mapMcpToSrg.put(owner + "." + srcName, name);
        mapSrgToMcp.put(owner + "." + name, srcName);
    }

    public static void initMap() {
        if (mapMcpToSrg == null) {
            mapMcpToSrg = new HashMap<String, String>();
            mapSrgToMcp = new HashMap<String, String>();
            SMCRemap.parseSrg("..\\build\\unpacked\\conf\\mcp-srg.srg", mapMcpToSrg, mapSrgToMcp);
            SMCRemap.addClassMap("net/minecraft/src/Config", "Config");
            SMCRemap.addClassMap("net/minecraft/src/CustomColorizer", "CustomColorizer");
            SMCRemap.addInheritedMethod(Names.WorldClient_, Names.World_, Names.WorldClient_getRainStrength, Names.WorldClient_getRainStrength_desc);
            SMCRemap.addInheritedMethod(Names.WorldClient_, Names.World_, Names.WorldClient_getCelestialAngle, Names.WorldClient_getCelestialAngle_desc);
            SMCRemap.addInheritedMethod(Names.EntityLivingBase_, Names.Entity_, Names.Entity_getBrightness, Names.Entity_getBrightness_desc);
            SMCRemap.addInheritedField(Names.GuiOptions_, Names.GuiScreen_, Names.GuiOptions_mc);
            SMCRemap.addInheritedField(Names.GuiOptions_, Names.GuiScreen_, Names.GuiOptions_width);
            SMCRemap.addInheritedField(Names.GuiOptions_, Names.GuiScreen_, Names.GuiOptions_height);
            SMCRemap.addInheritedField(Names.GuiOptions_, Names.GuiScreen_, Names.GuiOptions_buttonList);
        }
    }

    private static void putv(Map map, String key, String value) {
        String oldval = (String)map.get(key);
        if (oldval == null) {
            System.out.format("**** add  %s,%s\n", key, value);
            map.put(key, value);
        } else if (!oldval.equals(value)) {
            System.out.format("**** repl %s,%s %s\n", key, value, oldval);
            map.put(key, value);
        } else {
            System.out.format("**** same %s,%s\n", key, value);
        }
    }

    public static MethodVisitor getAdaptor(MethodVisitor mv) {
        if (!deobfuscatedEnv) {
            return mv;
        }
        return new SMCRenamerMethodAdaptor(mv);
    }

    static {
        Boolean deobEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        boolean bl = deobfuscatedEnv = deobEnv != null && deobEnv != false;
        if (!deobfuscatedEnv) {
            remapperW = remapper = new Remapper(){};
        } else {
            SMCRemap.initMap();
            remapper = new SimpleRemapper(mapMcpToSrg);
            remapperW = new SimpleRemapper(mapSrgToMcp);
        }
    }
}

