/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.commons.Remapper;
import shadersmodcore.loading.SMCFMLLoadingPlugin;
import shadersmodcore.loading.SMCLog;
import shadersmodcore.transform.SMCCV;
import shadersmodcore.transform.SMCTransformER;
import shadersmodcore.transform.SMCTransformRG;

public class SMCClassTransformer
implements IClassTransformer {
    protected static final Remapper remapper = FMLDeobfuscatingRemapper.INSTANCE;
    protected Map<String, CreateCV> ccvMap;
    protected Set<String> rpcSet = new HashSet<String>();

    public SMCClassTransformer() {
        this.rpcSet.add("net.minecraft.client.gui.GuiOptions");
        this.rpcSet.add("net.minecraft.client.renderer.EntityRenderer");
        this.rpcSet.add("net.minecraft.client.renderer.OpenGlHelper");
        this.rpcSet.add("net.minecraft.client.renderer.RenderBlocks");
        this.rpcSet.add("net.minecraft.client.renderer.RenderGlobal");
        this.rpcSet.add("net.minecraft.client.renderer.Tessellator");
        this.rpcSet.add("net.minecraft.client.renderer.texture.AbstractTexture");
        this.rpcSet.add("net.minecraft.client.renderer.texture.DynamicTexture");
        this.rpcSet.add("net.minecraft.client.renderer.texture.LayeredTexture");
        this.rpcSet.add("net.minecraft.client.renderer.texture.SimpleTexture");
        this.rpcSet.add("net.minecraft.client.renderer.texture.TextureAtlasSprite");
        this.rpcSet.add("net.minecraft.client.renderer.texture.TextureClock");
        this.rpcSet.add("net.minecraft.client.renderer.texture.TextureCompass");
        this.rpcSet.add("net.minecraft.client.renderer.texture.TextureManager");
        this.rpcSet.add("net.minecraft.client.renderer.texture.TextureMap");
        this.rpcSet.add("net.minecraft.client.renderer.texture.TextureObject");
        this.ccvMap = new HashMap<String, CreateCV>();
        this.ccvMap.put("net.minecraft.client.gui.GuiOptions", new CreateCV(){

            @Override
            public SMCCV create() {
                return new SMCCV();
            }
        });
        this.ccvMap.put("net.minecraft.client.renderer.EntityRenderer", new CreateCV(){

            @Override
            public SMCCV create() {
                return new SMCTransformER();
            }
        });
        this.ccvMap.put("net.minecraft.client.renderer.RenderBlocks", new CreateCV(){

            @Override
            public SMCCV create() {
                return new SMCCV();
            }
        });
        this.ccvMap.put("net.minecraft.client.renderer.RenderGlobal", new CreateCV(){

            @Override
            public SMCCV create() {
                return new SMCTransformRG();
            }
        });
        this.ccvMap.put("net.minecraft.client.renderer.Tessellator", new CreateCV(){

            @Override
            public SMCCV create() {
                return new SMCCV();
            }
        });
        this.ccvMap.put("net.minecraft.client.renderer.texture.AbstractTexture", new CreateCV(){

            @Override
            public SMCCV create() {
                return new SMCCV();
            }
        });
        this.ccvMap.put("net.minecraft.client.renderer.texture.DynamicTexture", new CreateCV(){

            @Override
            public SMCCV create() {
                return new SMCCV();
            }
        });
        this.ccvMap.put("net.minecraft.client.renderer.texture.SimpleTexture", new CreateCV(){

            @Override
            public SMCCV create() {
                return new SMCCV();
            }
        });
        this.ccvMap.put("net.minecraft.client.renderer.texture.TextureAtlasSprite", new CreateCV(){

            @Override
            public SMCCV create() {
                return new SMCCV();
            }
        });
        this.ccvMap.put("net.minecraft.client.renderer.texture.TextureManager", new CreateCV(){

            @Override
            public SMCCV create() {
                return new SMCCV();
            }
        });
        this.ccvMap.put("net.minecraft.client.renderer.texture.TextureMap", new CreateCV(){

            @Override
            public SMCCV create() {
                return new SMCCV();
            }
        });
        this.ccvMap.put("net.minecraft.client.renderer.texture.TextureObject", new CreateCV(){

            @Override
            public SMCCV create() {
                return new SMCCV();
            }
        });
    }

    public byte[] transform(String name1, String name2, byte[] byteArray) {
        if (this.rpcSet.contains(name2)) {
            return this.replaceClass(name1, name2, byteArray);
        }
        return byteArray;
    }

    public byte[] replaceClass(String name1, String name2, byte[] byteArray) {
        byte[] ret = byteArray;
        SMCLog.info("replace %s %s %d", name1, name2, byteArray.length);
        try {
            ZipFile zFile = new ZipFile(SMCFMLLoadingPlugin.coremodLocation);
            String name3 = name1.replace('.', '/').concat(".class");
            SMCLog.info("  open %s", name3);
            ZipEntry zEntry = zFile.getEntry(name3);
            if (zEntry != null) {
                int readlen;
                int size = (int)zEntry.getSize();
                byte[] newByteArray = new byte[size];
                InputStream input = zFile.getInputStream(zEntry);
                for (int pos = 0; pos < size; pos += readlen) {
                    readlen = input.read(newByteArray, pos, size - pos);
                    if (readlen != 0) continue;
                    throw new IOException();
                }
                ret = newByteArray;
                input.close();
                SMCLog.info("  replaced %d", size);
            }
            zFile.close();
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    protected static class CreateCV {
        protected CreateCV() {
        }

        public SMCCV create() {
            return new SMCCV();
        }
    }
}

