/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class KeyBindingRegistry {
    private static final KeyBindingRegistry INSTANCE = new KeyBindingRegistry();
    private Set<KeyHandler> keyHandlers = Sets.newLinkedHashSet();

    public static void registerKeyBinding(KeyHandler handler) {
        KeyBindingRegistry.instance().keyHandlers.add(handler);
        if (!handler.isDummy) {
            TickRegistry.registerTickHandler(handler, Side.CLIENT);
        }
    }

    @Deprecated
    public static KeyBindingRegistry instance() {
        return INSTANCE;
    }

    public void uploadKeyBindingsToGame(aui settings) {
        ArrayList harvestedBindings = Lists.newArrayList();
        for (KeyHandler key : this.keyHandlers) {
            for (atp kb : key.keyBindings) {
                harvestedBindings.add(kb);
            }
        }
        atp[] modKeyBindings = harvestedBindings.toArray(new atp[harvestedBindings.size()]);
        atp[] allKeys = new atp[settings.W.length + modKeyBindings.length];
        System.arraycopy(settings.W, 0, allKeys, 0, settings.W.length);
        System.arraycopy(modKeyBindings, 0, allKeys, settings.W.length, modKeyBindings.length);
        settings.W = allKeys;
        settings.a();
    }

    public static abstract class KeyHandler
    implements ITickHandler {
        protected atp[] keyBindings;
        protected boolean[] keyDown;
        protected boolean[] repeatings;
        private boolean isDummy;

        public KeyHandler(atp[] keyBindings, boolean[] repeatings) {
            assert (keyBindings.length == repeatings.length) : "You need to pass two arrays of identical length";
            this.keyBindings = keyBindings;
            this.repeatings = repeatings;
            this.keyDown = new boolean[keyBindings.length];
        }

        public KeyHandler(atp[] keyBindings) {
            this.keyBindings = keyBindings;
            this.isDummy = true;
        }

        public atp[] getKeyBindings() {
            return this.keyBindings;
        }

        @Override
        public final void tickStart(EnumSet<TickType> type, Object ... tickData) {
            this.keyTick(type, false);
        }

        @Override
        public final void tickEnd(EnumSet<TickType> type, Object ... tickData) {
            this.keyTick(type, true);
        }

        private void keyTick(EnumSet<TickType> type, boolean tickEnd) {
            for (int i = 0; i < this.keyBindings.length; ++i) {
                boolean state;
                atp keyBinding = this.keyBindings[i];
                int keyCode = keyBinding.d;
                boolean bl = state = keyCode < 0 ? Mouse.isButtonDown((int)(keyCode + 100)) : Keyboard.isKeyDown((int)keyCode);
                if (state == this.keyDown[i] && (!state || !this.repeatings[i])) continue;
                if (state) {
                    this.keyDown(type, keyBinding, tickEnd, state != this.keyDown[i]);
                } else {
                    this.keyUp(type, keyBinding, tickEnd);
                }
                if (!tickEnd) continue;
                this.keyDown[i] = state;
            }
        }

        public abstract void keyDown(EnumSet<TickType> var1, atp var2, boolean var3, boolean var4);

        public abstract void keyUp(EnumSet<TickType> var1, atp var2, boolean var3);

        @Override
        public abstract EnumSet<TickType> ticks();
    }
}

