/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public abstract class BlockFluidBase
extends aqw
implements IFluidBlock {
    protected static final Map<Integer, Boolean> defaultDisplacementIds = new HashMap<Integer, Boolean>();
    protected Map<Integer, Boolean> displacementIds = new HashMap<Integer, Boolean>();
    protected int quantaPerBlock = 8;
    protected float quantaPerBlockFloat = 8.0f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int tickRate = 20;
    protected int renderPass = 1;
    protected int maxScaledLight = 0;
    protected final String fluidName;

    public BlockFluidBase(int id, Fluid fluid, ajz material) {
        super(id, material);
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.b(true);
        this.C();
        this.fluidName = fluid.getName();
        this.density = fluid.density;
        this.maxScaledLight = fluid.luminosity;
        this.tickRate = fluid.viscosity / 200;
        fluid.setBlockID(id);
        this.displacementIds.putAll(defaultDisplacementIds);
    }

    public BlockFluidBase setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockFluidBase setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidBase setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidBase setRenderPass(int renderPass) {
        this.renderPass = renderPass;
        return this;
    }

    public BlockFluidBase setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(ace world, int x, int y, int z) {
        int bId = world.a(x, y, z);
        if (bId == 0) {
            return true;
        }
        if (bId == this.cF) {
            return false;
        }
        if (this.displacementIds.containsKey(bId)) {
            return this.displacementIds.get(bId);
        }
        ajz material = aqw.s[bId].cU;
        return !material.c() && material != ajz.D;
    }

    public boolean displaceIfPossible(abv world, int x, int y, int z) {
        int bId = world.a(x, y, z);
        if (bId == 0) {
            return true;
        }
        if (bId == this.cF) {
            return false;
        }
        if (this.displacementIds.containsKey(bId)) {
            if (this.displacementIds.get(bId).booleanValue()) {
                aqw.s[bId].c(world, x, y, z, world.h(x, y, z), 0);
                return true;
            }
            return false;
        }
        ajz material = aqw.s[bId].cU;
        if (material.c() || material == ajz.D) {
            return false;
        }
        aqw.s[bId].c(world, x, y, z, world.h(x, y, z), 0);
        return true;
    }

    public abstract int getQuantaValue(ace var1, int var2, int var3, int var4);

    public abstract boolean a(int var1, boolean var2);

    public abstract int getMaxRenderHeightMeta();

    public void a(abv world, int x, int y, int z) {
        world.a(x, y, z, this.cF, this.tickRate);
    }

    public void a(abv world, int x, int y, int z, int blockId) {
        world.a(x, y, z, this.cF, this.tickRate);
    }

    public boolean l() {
        return false;
    }

    public boolean b(ace world, int x, int y, int z) {
        return true;
    }

    public asu b(abv world, int x, int y, int z) {
        return null;
    }

    public int a(int par1, Random par2Random, int par3) {
        return 0;
    }

    public int a(Random par1Random) {
        return 0;
    }

    public int a(abv world) {
        return this.tickRate;
    }

    public void a(abv world, int x, int y, int z, nm entity, asz vec) {
        if (this.densityDir > 0) {
            return;
        }
        asz vec_flow = this.getFlowVector((ace)world, x, y, z);
        vec.c += vec_flow.c * (double)(this.quantaPerBlock * 4);
        vec.d += vec_flow.d * (double)(this.quantaPerBlock * 4);
        vec.e += vec_flow.e * (double)(this.quantaPerBlock * 4);
    }

    public int getLightValue(ace world, int x, int y, int z) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(world, x, y, z);
        }
        int data = world.h(x, y, z);
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public int d() {
        return FluidRegistry.renderIdFluid;
    }

    public boolean c() {
        return false;
    }

    public boolean b() {
        return false;
    }

    public float f(ace world, int x, int y, int z) {
        float lightUp;
        float lightThis = world.q(x, y, z);
        return lightThis > (lightUp = world.q(x, y + 1, z)) ? lightThis : lightUp;
    }

    public int e(ace world, int x, int y, int z) {
        int lightThis = world.h(x, y, z, 0);
        int lightUp = world.h(x, y + 1, z, 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    public int n() {
        return this.renderPass;
    }

    public boolean a(ace world, int x, int y, int z, int side) {
        if (world.a(x, y, z) != this.cF) {
            return !world.t(x, y, z);
        }
        ajz mat = world.g(x, y, z);
        return mat == this.cU ? false : super.a(world, x, y, z, side);
    }

    public static final int getDensity(ace world, int x, int y, int z) {
        aqw block = aqw.s[world.a(x, y, z)];
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).density;
    }

    public static double getFlowDirection(ace world, int x, int y, int z) {
        aqw block = aqw.s[world.a(x, y, z)];
        if (!(aqw.s[world.a(x, y, z)] instanceof BlockFluidBase)) {
            return -1000.0;
        }
        asz vec = ((BlockFluidBase)block).getFlowVector(world, x, y, z);
        return vec.c == 0.0 && vec.e == 0.0 ? -1000.0 : Math.atan2(vec.e, vec.c) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(ace world, int x, int y, int z, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(ace world, int x, int y, int z, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(ace world, int x, int y, int z) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public asz getFlowVector(ace world, int x, int y, int z) {
        asz vec = world.V().a(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, x, y, z);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = x;
            int z2 = z;
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y, z2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.g(x2, y, z2).c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y - 1, z2)) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.c((double)((x2 - x) * power), (double)((y - y) * power), (double)((z2 - z) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.c((double)((x2 - x) * power), (double)((y - y) * power), (double)((z2 - z) * power));
        }
        if (world.a(x, y + 1, z) == this.cF) {
            boolean flag = false;
            if (this.a_(world, x, y, z - 1, 2)) {
                flag = true;
            } else if (this.a_(world, x, y, z + 1, 3)) {
                flag = true;
            } else if (this.a_(world, x - 1, y, z, 4)) {
                flag = true;
            } else if (this.a_(world, x + 1, y, z, 5)) {
                flag = true;
            } else if (this.a_(world, x, y + 1, z - 1, 2)) {
                flag = true;
            } else if (this.a_(world, x, y + 1, z + 1, 3)) {
                flag = true;
            } else if (this.a_(world, x - 1, y + 1, z, 4)) {
                flag = true;
            } else if (this.a_(world, x + 1, y + 1, z, 5)) {
                flag = true;
            }
            if (flag) {
                vec = vec.a().c(0.0, -6.0, 0.0);
            }
        }
        vec = vec.a();
        return vec;
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidName);
    }

    static {
        defaultDisplacementIds.put(aqw.aJ.cF, false);
        defaultDisplacementIds.put(aqw.aQ.cF, false);
        defaultDisplacementIds.put(aqw.aI.cF, false);
        defaultDisplacementIds.put(aqw.aN.cF, false);
        defaultDisplacementIds.put(aqw.bc.cF, false);
    }
}

