/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Random;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BlockFluidClassic
extends BlockFluidBase {
    protected boolean[] isOptimalFlowDirection = new boolean[4];
    protected int[] flowCost = new int[4];
    protected FluidStack stack;

    public BlockFluidClassic(int id, Fluid fluid, ajz material) {
        super(id, fluid, material);
        this.stack = new FluidStack(fluid, 1000);
    }

    public BlockFluidClassic setFluidStack(FluidStack stack) {
        this.stack = stack;
        return this;
    }

    public BlockFluidClassic setFluidStackAmount(int amount) {
        this.stack.amount = amount;
        return this;
    }

    @Override
    public int getQuantaValue(ace world, int x, int y, int z) {
        if (world.a(x, y, z) == 0) {
            return 0;
        }
        if (world.a(x, y, z) != this.cF) {
            return -1;
        }
        int quantaRemaining = this.quantaPerBlock - world.h(x, y, z);
        return quantaRemaining;
    }

    @Override
    public boolean a(int meta, boolean fullHit) {
        return fullHit && meta == 0;
    }

    @Override
    public int getMaxRenderHeightMeta() {
        return 0;
    }

    @Override
    public int getLightValue(ace world, int x, int y, int z) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(world, x, y, z);
        }
        int data = this.quantaPerBlock - world.h(x, y, z) - 1;
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public void a(abv world, int x, int y, int z, Random rand) {
        int quantaRemaining = this.quantaPerBlock - world.h(x, y, z);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            int y2 = y - this.densityDir;
            if (world.a(x, y2, z) == this.cF || world.a(x - 1, y2, z) == this.cF || world.a(x + 1, y2, z) == this.cF || world.a(x, y2, z - 1) == this.cF || world.a(x, y2, z + 1) == this.cF) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((ace)world, x - 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((ace)world, x + 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((ace)world, x, y, z - 1, maxQuanta);
                maxQuanta = this.getLargerQuanta((ace)world, x, y, z + 1, maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.i(x, y, z);
                } else {
                    world.b(x, y, z, this.quantaPerBlock - expQuanta, 3);
                    world.a(x, y, z, this.cF, this.tickRate);
                    world.f(x, y, z, this.cF);
                }
            }
        } else if (quantaRemaining > this.quantaPerBlock) {
            world.b(x, y, z, 0, 3);
        }
        if (this.canDisplace((ace)world, x, y + this.densityDir, z)) {
            this.flowIntoBlock(world, x, y + this.densityDir, z, 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock((ace)world, x, y, z) || !this.isFlowingVertically((ace)world, x, y, z)) {
            boolean[] flowTo;
            if (world.a(x, y - this.densityDir, z) == this.cF) {
                flowMeta = 1;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, x, y, z))[0]) {
                this.flowIntoBlock(world, x - 1, y, z, flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, x + 1, y, z, flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, x, y, z - 1, flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, x, y, z + 1, flowMeta);
            }
        }
    }

    public boolean isFlowingVertically(ace world, int x, int y, int z) {
        return world.a(x, y + this.densityDir, z) == this.cF || world.a(x, y, z) == this.cF && this.canFlowInto(world, x, y + this.densityDir, z);
    }

    public boolean isSourceBlock(ace world, int x, int y, int z) {
        return world.a(x, y, z) == this.cF && world.h(x, y, z) == 0;
    }

    protected boolean[] getOptimalFlowDirections(abv world, int x, int y, int z) {
        int side;
        for (int side2 = 0; side2 < 4; ++side2) {
            this.flowCost[side2] = 1000;
            int x2 = x;
            int y2 = y;
            int z2 = z;
            switch (side2) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    ++x2;
                    break;
                }
                case 2: {
                    --z2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            if (!this.canFlowInto((ace)world, x2, y2, z2) || this.isSourceBlock((ace)world, x2, y2, z2)) continue;
            this.flowCost[side2] = this.canFlowInto((ace)world, x2, y2 + this.densityDir, z2) ? 0 : this.calculateFlowCost(world, x2, y2, z2, 1, side2);
        }
        int min = this.flowCost[0];
        for (side = 1; side < 4; ++side) {
            if (this.flowCost[side] >= min) continue;
            min = this.flowCost[side];
        }
        for (side = 0; side < 4; ++side) {
            this.isOptimalFlowDirection[side] = this.flowCost[side] == min;
        }
        return this.isOptimalFlowDirection;
    }

    protected int calculateFlowCost(abv world, int x, int y, int z, int recurseDepth, int side) {
        int cost = 1000;
        for (int adjSide = 0; adjSide < 4; ++adjSide) {
            int min;
            if (adjSide == 0 && side == 1 || adjSide == 1 && side == 0 || adjSide == 2 && side == 3 || adjSide == 3 && side == 2) continue;
            int x2 = x;
            int y2 = y;
            int z2 = z;
            switch (adjSide) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    ++x2;
                    break;
                }
                case 2: {
                    --z2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            if (!this.canFlowInto((ace)world, x2, y2, z2) || this.isSourceBlock((ace)world, x2, y2, z2)) continue;
            if (this.canFlowInto((ace)world, x2, y2 + this.densityDir, z2)) {
                return recurseDepth;
            }
            if (recurseDepth >= 4 || (min = this.calculateFlowCost(world, x2, y2, z2, recurseDepth + 1, adjSide)) >= cost) continue;
            cost = min;
        }
        return cost;
    }

    protected void flowIntoBlock(abv world, int x, int y, int z, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, x, y, z)) {
            world.f(x, y, z, this.cF, meta, 3);
        }
    }

    protected boolean canFlowInto(ace world, int x, int y, int z) {
        int bId = world.a(x, y, z);
        if (bId == 0) {
            return true;
        }
        if (bId == this.cF) {
            return true;
        }
        if (this.displacementIds.containsKey(bId)) {
            return (Boolean)this.displacementIds.get(bId);
        }
        ajz material = aqw.s[bId].cU;
        return !material.c() && material != ajz.h && material != ajz.i && material != ajz.D;
    }

    protected int getLargerQuanta(ace world, int x, int y, int z, int compare) {
        int quantaRemaining = this.getQuantaValue(world, x, y, z);
        if (quantaRemaining <= 0) {
            return compare;
        }
        return quantaRemaining >= compare ? quantaRemaining : compare;
    }

    @Override
    public FluidStack drain(abv world, int x, int y, int z, boolean doDrain) {
        if (!this.isSourceBlock((ace)world, x, y, z)) {
            return null;
        }
        if (doDrain) {
            world.i(x, y, z);
        }
        return this.stack.copy();
    }

    @Override
    public boolean canDrain(abv world, int x, int y, int z) {
        return this.isSourceBlock((ace)world, x, y, z);
    }
}

