/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class FluidRegistry {
    static int maxID = 0;
    static HashMap<String, Fluid> fluids = new HashMap();
    static BiMap<String, Integer> fluidIDs = HashBiMap.create();
    public static final Fluid WATER = new Fluid("water").setBlockID(aqw.G.cF);
    public static final Fluid LAVA = new Fluid("lava").setBlockID(aqw.I.cF).setLuminosity(15).setDensity(3000).setViscosity(6000);
    public static int renderIdFluid = -1;

    private FluidRegistry() {
    }

    static void initFluidIDs(BiMap<String, Integer> newfluidIDs) {
        maxID = newfluidIDs.size();
        fluidIDs.clear();
        fluidIDs.putAll(newfluidIDs);
    }

    public static boolean registerFluid(Fluid fluid) {
        if (fluidIDs.containsKey((Object)fluid.getName())) {
            return false;
        }
        fluids.put(fluid.getName(), fluid);
        fluidIDs.put((Object)fluid.getName(), (Object)(++maxID));
        MinecraftForge.EVENT_BUS.post(new FluidRegisterEvent(fluid.getName(), maxID));
        return true;
    }

    public static boolean isFluidRegistered(Fluid fluid) {
        return fluidIDs.containsKey((Object)fluid.getName());
    }

    public static boolean isFluidRegistered(String fluidName) {
        return fluidIDs.containsKey((Object)fluidName);
    }

    public static Fluid getFluid(String fluidName) {
        return fluids.get(fluidName);
    }

    public static Fluid getFluid(int fluidID) {
        return fluids.get(FluidRegistry.getFluidName(fluidID));
    }

    public static String getFluidName(int fluidID) {
        return (String)fluidIDs.inverse().get((Object)fluidID);
    }

    public static String getFluidName(FluidStack stack) {
        return FluidRegistry.getFluidName(stack.fluidID);
    }

    public static int getFluidID(String fluidName) {
        return (Integer)fluidIDs.get((Object)fluidName);
    }

    public static FluidStack getFluidStack(String fluidName, int amount) {
        if (!fluidIDs.containsKey((Object)fluidName)) {
            return null;
        }
        return new FluidStack(FluidRegistry.getFluidID(fluidName), amount);
    }

    public static Map<String, Fluid> getRegisteredFluids() {
        return ImmutableMap.copyOf(fluids);
    }

    public static Map<String, Integer> getRegisteredFluidIDs() {
        return ImmutableMap.copyOf(fluidIDs);
    }

    static {
        FluidRegistry.registerFluid(WATER);
        FluidRegistry.registerFluid(LAVA);
    }

    public static class FluidRegisterEvent
    extends Event {
        public final String fluidName;
        public final int fluidID;

        public FluidRegisterEvent(String fluidName, int fluidID) {
            this.fluidName = fluidName;
            this.fluidID = fluidID;
        }
    }
}

