/*
 * Decompiled with CFR 0.152.
 */
package karyonix.mcmod.installer;

import java.io.BufferedReader;
import java.io.IOException;
import karyonix.mcmod.installer.Json;

public class JsonParser {
    protected BufferedReader rd;
    String data;

    public JsonParser(BufferedReader rd) {
        this.rd = rd;
    }

    int peekChar() throws IOException {
        while (this.data == null || this.data.length() == 0) {
            this.data = this.rd.readLine();
            if (this.data == null) break;
        }
        if (this.data != null) {
            return this.data.charAt(0);
        }
        return 0;
    }

    void skip(int n) {
        if (this.data != null) {
            this.data = this.data.substring(n);
        }
    }

    void skipWS() throws IOException {
        while (this.peekChar() <= 32 && this.data != null) {
            this.skip(1);
        }
    }

    Json.JsValue getValue() throws IOException {
        this.skipWS();
        int c = this.peekChar();
        if (c == 34) {
            return this.getString();
        }
        if (c == 91) {
            return this.getArray();
        }
        if (c == 123) {
            return this.getObject();
        }
        if (c >= 48 && c <= 57 || c == 45) {
            return this.getNumber();
        }
        if (c == 116 || c == 102) {
            return this.getBoolean();
        }
        return null;
    }

    Json.JsString getString() {
        int pos = 1;
        int max = this.data.length();
        while (pos < max) {
            char c = this.data.charAt(pos);
            if (c == '\"') break;
            if (c == '\\') {
                pos += 2;
                continue;
            }
            ++pos;
        }
        if (pos < max) {
            Json.JsString jss = new Json.JsString();
            jss.str = this.data.substring(1, pos);
            this.skip(pos + 1);
            return jss;
        }
        return null;
    }

    Json.JsNumber getNumber() {
        int pos = 1;
        int max = this.data.length();
        while (pos < max) {
            char c = this.data.charAt(pos);
            if (c != '-' && c != '+' && c != '.' && (c < '0' || c > '9') && c != 'e' && c != 'E') break;
            ++pos;
        }
        if (pos <= max) {
            Json.JsNumber jsn = new Json.JsNumber();
            jsn.str = this.data.substring(0, pos);
            this.skip(pos);
            return jsn;
        }
        return null;
    }

    Json.JsBoolean getBoolean() {
        if (this.data.startsWith("true")) {
            Json.JsBoolean jsb = new Json.JsBoolean();
            jsb.str = "true";
            this.skip(4);
            return jsb;
        }
        if (this.data.startsWith("false")) {
            Json.JsBoolean jsb = new Json.JsBoolean();
            jsb.str = "false";
            this.skip(5);
            return jsb;
        }
        return null;
    }

    Json.JsArray getArray() throws IOException {
        char c;
        Json.JsArray jsa = new Json.JsArray();
        do {
            Json.JsValue jsv;
            this.skip(1);
            this.skipWS();
            c = this.data.charAt(0);
            if (c == ']' || (jsv = this.getValue()) == null) break;
            jsa.elements.add(jsv);
            this.skipWS();
        } while ((c = this.data.charAt(0)) == ',');
        this.skip(1);
        return jsa;
    }

    Json.JsField getField() throws IOException {
        Json.JsField jsf = new Json.JsField();
        Json.JsString name = this.getString();
        this.skipWS();
        this.skip(1);
        Json.JsValue value = this.getValue();
        jsf.name = name.str;
        jsf.value = value;
        return jsf;
    }

    Json.JsObject getObject() throws IOException {
        char c;
        Json.JsObject jso = new Json.JsObject();
        do {
            Json.JsField jsf;
            this.skipWS();
            this.skip(1);
            this.skipWS();
            c = this.data.charAt(0);
            if (c == '}' || (jsf = this.getField()) == null) break;
            jso.members.add(jsf);
            jso.membersMap.put(jsf.name, jsf);
            this.skipWS();
        } while ((c = this.data.charAt(0)) == ',');
        this.skip(1);
        return jso;
    }
}

