package com.example.examplemod;


import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer.EnumStatus;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;

/**
* Name and cast of this class are irrelevant
*/
public class EventHookContainerClass
{
/**
* The key is the @ForgeSubscribe annotation and the cast of the Event you put in as argument.
* The method name you pick does not matter. Method signature is public void, always.
*/
@SubscribeEvent
public void entityAttacked(LivingAttackEvent event)
{
/*
* You can then proceed to read and change the Event's fields where possible
*/
//EntityLiving attackedEnt = event.entityLiving;
	
//DamageSource attackSource = event.source;

/*
* Note this possibility to interrupt certain (not all) events
*/
if (event.isCancelable())
{
event.setCanceled(true);
}

/*
* Events may offer further fields and methods. Just read them, it should be obvious.
*/
}

/**
* To make sure you understand: You can mash together any events in a single class!
*/
@SubscribeEvent
public void onSleepyTime(PlayerSleepInBedEvent event)
{
event.result = EnumStatus.NOT_POSSIBLE_NOW;
}

@SubscribeEvent
public void PlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event)
{
	System.out.print("finding now logged in \n");
}

@SubscribeEvent
public void ServerConnectionFromClientEvent(PlayerEvent.PlayerLoggedInEvent event)
{
	System.out.print("finding now logging in \n");
}

}