/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.helper;

import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreed;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreedAir;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreedEnd;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreedFire;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreedForest;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreedGhost;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreedIce;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreedNether;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreedWater;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DragonBreedRegistry {
    private static DragonBreedRegistry instance;
    private Map<String, DragonBreed> breeds = new HashMap<String, DragonBreed>();

    public static DragonBreedRegistry getInstance() {
        if (instance == null) {
            instance = new DragonBreedRegistry();
        }
        return instance;
    }

    private DragonBreedRegistry() {
        this.add(new DragonBreedAir());
        this.add(new DragonBreedEnd());
        this.add(new DragonBreedFire());
        this.add(new DragonBreedIce());
        this.add(new DragonBreedGhost());
        this.add(new DragonBreedWater());
        this.add(new DragonBreedNether());
        this.add(new DragonBreedForest());
    }

    private void add(DragonBreed breed) {
        this.breeds.put(breed.getName(), breed);
    }

    public List<DragonBreed> getBreeds() {
        return new ArrayList<DragonBreed>(this.breeds.values());
    }

    public DragonBreed getBreedByName(String name) {
        return this.breeds.get(name);
    }
}

