/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

public class ColourARGB {
    public byte a;
    public byte r;
    public byte g;
    public byte b;

    public ColourARGB(int colourARGB) {
        this.a = (byte)(colourARGB >> 24);
        this.r = (byte)(colourARGB >> 16);
        this.g = (byte)(colourARGB >> 8);
        this.b = (byte)colourARGB;
    }

    public ColourARGB(byte a2, byte r2, byte g2, byte b2) {
        this.a = a2;
        this.r = r2;
        this.g = g2;
        this.b = b2;
    }

    public ColourARGB(ColourARGB colour) {
        this.a = colour.a;
        this.r = colour.r;
        this.g = colour.g;
        this.b = colour.b;
    }

    public ColourARGB copy() {
        return new ColourARGB(this);
    }

    public ColourARGB add(ColourARGB colour2) {
        this.a = (byte)(this.a + colour2.a);
        this.r = (byte)(this.r + colour2.r);
        this.g = (byte)(this.g + colour2.g);
        this.b = (byte)(this.b + colour2.b);
        return this;
    }

    public ColourARGB sub(ColourARGB colour2) {
        int ia2 = (this.a & 0xFF) - (colour2.a & 0xFF);
        int ir2 = (this.r & 0xFF) - (colour2.r & 0xFF);
        int ig2 = (this.g & 0xFF) - (colour2.g & 0xFF);
        int ib2 = (this.b & 0xFF) - (colour2.b & 0xFF);
        this.a = (byte)(ia2 < 0 ? 0 : ia2);
        this.r = (byte)(ir2 < 0 ? 0 : ir2);
        this.g = (byte)(ig2 < 0 ? 0 : ig2);
        this.b = (byte)(ib2 < 0 ? 0 : ib2);
        return this;
    }

    public ColourARGB invert() {
        this.a = (byte)(255 - (this.a & 0xFF));
        this.r = (byte)(255 - (this.r & 0xFF));
        this.g = (byte)(255 - (this.g & 0xFF));
        this.b = (byte)(255 - (this.b & 0xFF));
        return this;
    }

    public ColourARGB multiply(ColourARGB colour2) {
        return this.sub(colour2.copy().invert());
    }

    public ColourARGB scale(double d2) {
        this.a = (byte)((double)(this.a & 0xFF) * d2);
        this.r = (byte)((double)(this.r & 0xFF) * d2);
        this.g = (byte)((double)(this.g & 0xFF) * d2);
        this.b = (byte)((double)(this.b & 0xFF) * d2);
        return this;
    }

    public ColourARGB interpolate(ColourARGB colour2, double d2) {
        return this.add(colour2.copy().sub(this).scale(d2));
    }

    public int toInt() {
        return ((this.a & 0xFF) << 24) + ((this.r & 0xFF) << 16) + ((this.g & 0xFF) << 8) + (this.b & 0xFF);
    }

    public String toString() {
        return Integer.toHexString(this.toInt());
    }
}

