/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.BlockCoord;
import codechicken.core.CoreUtils;
import codechicken.core.ICustomPacketHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public final class PacketCustom {
    private String channel;
    private int type;
    private boolean isChunkDataPacket;
    private boolean incoming;
    private ByteArrayOutputStream dataarrayout;
    private DataOutputStream dataout;
    private DataInputStream datain;
    private static HashMap idhandlermap = new HashMap();

    private PacketCustom(ee packet) {
        this.incoming = true;
        this.channel = packet.a;
        this.datain = new DataInputStream(new ByteArrayInputStream(packet.c));
        this.type = this.readUnsignedByte();
    }

    public PacketCustom(String channel, int type) {
        this.channel = channel;
        this.type = type;
        this.incoming = false;
        this.isChunkDataPacket = false;
        this.dataarrayout = new ByteArrayOutputStream();
        this.dataout = new DataOutputStream(this.dataarrayout);
        this.writeByte(type);
    }

    public int getType() {
        return this.type;
    }

    public void setChunkDataPacket() {
        this.isChunkDataPacket = true;
    }

    public ee toPacket() {
        if (this.type == 0) {
            ModLoader.throwException("Custom Packet", new IllegalStateException("Type not set"));
            return null;
        }
        if (this.incoming) {
            ModLoader.throwException("Custom Packet", new IllegalStateException("Tried to write an incoming packet"));
            return null;
        }
        ee payload = new ee();
        payload.a = this.channel;
        payload.q = this.isChunkDataPacket;
        payload.c = this.dataarrayout.toByteArray();
        payload.b = payload.c.length;
        return payload;
    }

    public void writeBoolean(boolean b2) {
        try {
            this.dataout.writeBoolean(b2);
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
        }
    }

    public void writeByte(int b2) {
        try {
            this.dataout.writeByte(b2);
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
        }
    }

    public void writeShort(int s2) {
        try {
            this.dataout.writeShort(s2);
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
        }
    }

    public void writeInt(int i2) {
        try {
            this.dataout.writeInt(i2);
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
        }
    }

    public void writeFloat(float f2) {
        try {
            this.dataout.writeFloat(f2);
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
        }
    }

    public void writeDouble(double d2) {
        try {
            this.dataout.writeDouble(d2);
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
        }
    }

    public void writeLong(long l2) {
        try {
            this.dataout.writeLong(l2);
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
        }
    }

    public void writeByteArray(byte[] barray) {
        try {
            this.dataout.write(barray);
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
        }
    }

    public void writeCoord(int x2, int y2, int z2) {
        this.writeInt(x2);
        this.writeByte(y2);
        this.writeInt(z2);
    }

    public void writeCoord(BlockCoord coord) {
        this.writeCoord(coord.a, coord.b, coord.c);
    }

    public void writeString(String s2) {
        try {
            if (s2.length() > 65535) {
                throw new IOException("String length: " + s2.length() + "too long.");
            }
            this.dataout.writeShort(s2.length());
            this.dataout.writeChars(s2);
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
        }
    }

    public void writeItemStack(aan spawnstack) {
        if (spawnstack == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(spawnstack.c);
            this.writeByte(spawnstack.a);
            this.writeShort(spawnstack.i());
            this.writeNBTTagCompound(spawnstack.d);
        }
    }

    public void writeNBTTagCompound(ady compound) {
        try {
            if (compound == null) {
                this.writeShort(-1);
            } else {
                byte[] var3 = at.a(compound);
                this.writeShort((short)var3.length);
                this.writeByteArray(var3);
            }
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
        }
    }

    public boolean readBoolean() {
        try {
            return this.datain.readBoolean();
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
            return false;
        }
    }

    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public byte readByte() {
        try {
            return this.datain.readByte();
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
            return 0;
        }
    }

    public short readShort() {
        try {
            return this.datain.readShort();
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
            return 0;
        }
    }

    public int readInt() {
        try {
            return this.datain.readInt();
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
            return 0;
        }
    }

    public float readFloat() {
        try {
            return this.datain.readFloat();
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
            return 0.0f;
        }
    }

    public double readDouble() {
        try {
            return this.datain.readDouble();
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
            return 0.0;
        }
    }

    public long readLong() {
        try {
            return this.datain.readLong();
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
            return 0L;
        }
    }

    public char readChar() {
        try {
            return this.datain.readChar();
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
            return '\u0000';
        }
    }

    public BlockCoord readCoord() {
        return new BlockCoord(this.readInt(), this.readUnsignedByte(), this.readInt());
    }

    public byte[] readByteArray(int length) {
        try {
            byte[] barray = new byte[length];
            this.datain.readFully(barray, 0, length);
            return barray;
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
            return null;
        }
    }

    public String readString() {
        try {
            int length = this.datain.readUnsignedShort();
            char[] chars = new char[length];
            int i2 = 0;
            while (i2 < length) {
                chars[i2] = this.readChar();
                ++i2;
            }
            return new String(chars);
        }
        catch (IOException e2) {
            ModLoader.throwException("Custom Packet", e2);
            return null;
        }
    }

    public aan readItemStack() {
        aan var2 = null;
        short itemID = this.readShort();
        if (itemID >= 0) {
            byte stackSize = this.readByte();
            short damage = this.readShort();
            var2 = new aan(itemID, (int)stackSize, (int)damage);
            var2.d = this.readNBTTagCompound();
        }
        return var2;
    }

    public ady readNBTTagCompound() {
        short var2;
        block3: {
            try {
                var2 = this.readShort();
                if (var2 >= 0) break block3;
                return null;
            }
            catch (IOException e2) {
                ModLoader.throwException("Custom Packet", e2);
                return null;
            }
        }
        byte[] var3 = this.readByteArray(var2);
        return at.a(var3);
    }

    public static void recieve(yw source, ee packet) {
        HashMap map = (HashMap)idhandlermap.get(packet.a);
        if (map != null) {
            PacketCustom packetCustom = new PacketCustom(packet);
            ICustomPacketHandler handler = (ICustomPacketHandler)map.get(packetCustom.type);
            if (handler != null) {
                CoreUtils.handlePacket(source, packetCustom, handler);
            }
        }
    }

    public static void assignHandler(String channel, int firstID, int lastID, ICustomPacketHandler handler) {
        HashMap<Integer, ICustomPacketHandler> handlermap = (HashMap<Integer, ICustomPacketHandler>)idhandlermap.get(channel);
        if (handlermap == null) {
            handlermap = new HashMap<Integer, ICustomPacketHandler>();
            idhandlermap.put(channel, handlermap);
            ModLoader.registerPacketChannel(mod_CodeChickenCore.instance, channel);
        }
        ArrayList<Integer> newids = new ArrayList<Integer>();
        int i2 = firstID;
        while (i2 <= lastID) {
            if (handlermap.containsKey(i2)) {
                ModLoader.throwException("Custom Packet", new IllegalStateException("ID: " + i2 + " already mapped."));
                return;
            }
            if (i2 > 255) {
                ModLoader.throwException("Custom Packet", new IndexOutOfBoundsException("ID: " + i2 + " too large"));
                return;
            }
            newids.add(i2);
            ++i2;
        }
        for (Integer i3 : newids) {
            handlermap.put(i3, handler);
        }
    }
}

