/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.Quat;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class Vector3 {
    public double x;
    public double y;
    public double z;

    public Vector3() {
    }

    public Vector3(double d2, double d1, double d22) {
        this.x = d2;
        this.y = d1;
        this.z = d22;
    }

    public Vector3(Vector3 vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public Vector3 copy() {
        return new Vector3(this);
    }

    public static Vector3 fromEntity(nn e2) {
        return new Vector3(e2.o, e2.p, e2.q);
    }

    public static Vector3 fromEntityCenter(nn e2) {
        return new Vector3(e2.o, e2.p - (double)e2.H + (double)(e2.J / 2.0f), e2.q);
    }

    public static Vector3 fromTileEntity(kw e2) {
        return new Vector3(e2.j, e2.k, e2.l);
    }

    public static Vector3 fromTileEntityCenter(kw e2) {
        return new Vector3((double)e2.j + 0.5, (double)e2.k + 0.5, (double)e2.l + 0.5);
    }

    public static Vector3 fromVec3D(bo vec) {
        return new Vector3(vec.a, vec.b, vec.c);
    }

    public Vector3 set(double d2, double d1, double d22) {
        this.x = d2;
        this.y = d1;
        this.z = d22;
        return this;
    }

    public Vector3 set(Vector3 vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
        return this;
    }

    public double dotProduct(Vector3 vec) {
        double d2 = vec.x * this.x + vec.y * this.y + vec.z * this.z;
        if (d2 > 1.0 && d2 < 1.00001) {
            d2 = 1.0;
        } else if (d2 < -1.0 && d2 > -1.00001) {
            d2 = -1.0;
        }
        return d2;
    }

    public double dotProduct(double d2, double d1, double d22) {
        return d2 * this.x + d1 * this.y + d22 * this.z;
    }

    public Vector3 crossProduct(Vector3 vec) {
        double d2 = this.y * vec.z - this.z * vec.y;
        double d1 = this.z * vec.x - this.x * vec.z;
        double d22 = this.x * vec.y - this.y * vec.x;
        this.x = d2;
        this.y = d1;
        this.z = d22;
        return this;
    }

    public Vector3 add(double d2, double d1, double d22) {
        this.x += d2;
        this.y += d1;
        this.z += d22;
        return this;
    }

    public Vector3 add(Vector3 vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    public Vector3 subtract(Vector3 vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        return this;
    }

    public Vector3 multiply(double d2) {
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        return this;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double magSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 normalize() {
        double d2 = this.mag();
        if (d2 != 0.0) {
            this.multiply(1.0 / d2);
        }
        return this;
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Vector: " + new BigDecimal(this.x, cont) + ", " + new BigDecimal(this.y, cont) + ", " + new BigDecimal(this.z, cont);
    }

    public Vector3 perpendicular() {
        if (this.z == 0.0) {
            return this.zCrossProduct();
        }
        return this.xCrossProduct();
    }

    public Vector3 xCrossProduct() {
        double d2 = this.z;
        double d1 = -this.y;
        this.x = 0.0;
        this.y = d2;
        this.z = d1;
        return this;
    }

    public Vector3 zCrossProduct() {
        double d2 = this.y;
        double d1 = -this.x;
        this.x = d2;
        this.y = d1;
        this.z = 0.0;
        return this;
    }

    public Vector3 yCrossProduct() {
        double d2 = -this.z;
        double d1 = this.x;
        this.x = d2;
        this.y = 0.0;
        this.z = d1;
        return this;
    }

    public Vector3 rotate(double angle, Vector3 axis) {
        Quat.aroundAxis(axis.copy().normalize(), angle).rotate(this);
        return this;
    }

    public bo toVec3D() {
        return bo.b(this.x, this.y, this.z);
    }

    public double angle(Vector3 vec) {
        return Math.acos(this.copy().normalize().dotProduct(vec.copy().normalize()));
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }
}

