/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.DefaultOverlayRenderer;
import codechicken.nei.DropDownFile;
import codechicken.nei.GuiCraftingRecipe;
import codechicken.nei.GuiNEIControls;
import codechicken.nei.GuiNEISettings;
import codechicken.nei.GuiUsageRecipe;
import codechicken.nei.ICraftingHandler;
import codechicken.nei.IHandleTooltip;
import codechicken.nei.IInfiniteItemHandler;
import codechicken.nei.IStackPositioner;
import codechicken.nei.IUsageHandler;
import codechicken.nei.ItemHash;
import codechicken.nei.ItemInfo;
import codechicken.nei.LayoutManager;
import codechicken.nei.LayoutStyle;
import codechicken.nei.MultiItemRange;
import codechicken.nei.NEIConfig;
import codechicken.nei.NEIUtils;
import codechicken.nei.OffsetPositioner;
import codechicken.nei.SubSetRangeTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class API {
    public static void registerRecipeHandler(ICraftingHandler handler) {
        GuiCraftingRecipe.registerRecipeHandler(handler);
    }

    public static void registerUsageHandler(IUsageHandler handler) {
        GuiUsageRecipe.registerUsageHandler(handler);
    }

    public static void registerGuiOverlay(Class class1, String string) {
        API.registerGuiOverlay(class1, string, 5, 11);
    }

    public static void registerGuiOverlay(Class class1, String string, int x2, int y2) {
        API.registerGuiOverlay(class1, string, new OffsetPositioner(x2, y2));
    }

    public static void registerGuiOverlay(Class classz, String ident, IStackPositioner positioner) {
        DefaultOverlayRenderer.registerGuiOverlay(classz, ident, positioner);
    }

    public static void hideItem(int itemID) {
        ItemInfo.excludeIds.add(itemID);
    }

    public static void hideItems(Collection items) {
        ItemInfo.excludeIds.addAll(items);
    }

    public static void setOverrideName(int itemID, int itemDamage, String name) {
        ItemInfo.fallbackNames.put(new ItemHash(itemID, itemDamage), name);
    }

    public static void setItemDamageVariants(int itemID, ArrayList ranges) {
        ItemInfo.damageVariants.put(itemID, ranges);
    }

    public static void setItemDamageVariants(int itemID, Collection damages) {
        API.setItemDamageVariants(itemID, NEIUtils.concatIntegersToRanges(new ArrayList(damages)));
    }

    public static void setMaxDamageException(int itemID, int maxDamage) {
        ArrayList<int[]> damageset = new ArrayList<int[]>();
        int[] nArray = new int[2];
        nArray[1] = maxDamage;
        damageset.add(nArray);
        API.setItemDamageVariants(itemID, damageset);
    }

    public static void addNBTItem(aan item) {
        ArrayList<aan> datalist = (ArrayList<aan>)ItemInfo.itemcompounds.get(item.c);
        if (datalist == null) {
            datalist = new ArrayList<aan>();
            ItemInfo.itemcompounds.put(item.c, datalist);
        }
        datalist.add(item);
    }

    public static void addSetRange(String setname, MultiItemRange range) {
        SubSetRangeTag tag = DropDownFile.dropDownInstance.getTag(setname);
        tag.saveTag = false;
        tag.setRange(range);
        DropDownFile.dropDownInstance.updateState();
    }

    public static SubSetRangeTag getRangeTag(String tagname) {
        return DropDownFile.dropDownInstance.getTag(tagname);
    }

    public static void addToRange(String setname, MultiItemRange range) {
        SubSetRangeTag tag = DropDownFile.dropDownInstance.getTag(setname);
        if (tag.validranges == null) {
            tag.setRange(range);
        } else {
            tag.validranges.add(range);
        }
    }

    public static void addTooltipHandler(IHandleTooltip handler) {
        ItemInfo.tooltipHandlers.add(handler);
    }

    public static void addSetting(GuiNEISettings.NEIOption o2) {
        API.addSetting(GuiNEISettings.class, o2);
    }

    public static void addSetting(Class guiclass, GuiNEISettings.NEIOption o2) {
        LinkedList<GuiNEISettings.NEIOption> list = (LinkedList<GuiNEISettings.NEIOption>)GuiNEISettings.optionMap.get(guiclass);
        if (list == null) {
            list = new LinkedList<GuiNEISettings.NEIOption>();
            GuiNEISettings.optionMap.put(guiclass, list);
        }
        list.add(o2);
    }

    public static void addKeyBind(String ident, String desc, int defaultKey) {
        NEIConfig.setDefaultKeyBinding(ident, defaultKey);
        API.addKeyBind(GuiNEIControls.class, new GuiNEIControls.NEIKeyBind(ident, desc));
    }

    public static void addKeyBind(Class guiclass, GuiNEIControls.NEIKeyBind key) {
        LinkedList<GuiNEIControls.NEIKeyBind> list = (LinkedList<GuiNEIControls.NEIKeyBind>)GuiNEIControls.keyBindMap.get(guiclass);
        if (list == null) {
            list = new LinkedList<GuiNEIControls.NEIKeyBind>();
            GuiNEIControls.keyBindMap.put(guiclass, list);
        }
        list.add(key);
    }

    public static void addLayoutStyle(int styleID, LayoutStyle style) {
        LayoutManager.layoutStyles.put(styleID, style);
    }

    public static void addInfiniteItemHandler(IInfiniteItemHandler handler) {
        ItemInfo.infiniteHandlers.addFirst(handler);
    }
}

