/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.BrewingRecipeHandler;
import codechicken.nei.FuelUsageHandler;
import codechicken.nei.FurnaceRecipeHandler;
import codechicken.nei.GuiRecipe;
import codechicken.nei.IUsageHandler;
import codechicken.nei.ShapedRecipeHandler;
import codechicken.nei.ShapelessRecipeHandler;
import java.util.ArrayList;

public class GuiUsageRecipe
extends GuiRecipe {
    private ArrayList currenthandlers;
    private static ArrayList usagehandlers = new ArrayList();

    static {
        GuiUsageRecipe.registerUsageHandler(new ShapedRecipeHandler());
        GuiUsageRecipe.registerUsageHandler(new ShapelessRecipeHandler());
        GuiUsageRecipe.registerUsageHandler(new FurnaceRecipeHandler());
        GuiUsageRecipe.registerUsageHandler(new FuelUsageHandler());
        GuiUsageRecipe.registerUsageHandler(new BrewingRecipeHandler());
    }

    public GuiUsageRecipe(aan ingred, gb prevgui) {
        super(ingred, prevgui);
    }

    public static void registerUsageHandler(IUsageHandler handler) {
        if (!usagehandlers.contains(handler)) {
            usagehandlers.add(handler);
        }
    }

    public static boolean hasRecipe(aan ingredient) {
        for (IUsageHandler usagehandler : usagehandlers) {
            IUsageHandler handler = usagehandler.getUsageHandler(ingredient);
            if (handler.getNumRecipes() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList getCurrentRecipeHandlers() {
        if (this.currenthandlers == null) {
            this.currenthandlers = new ArrayList();
            for (IUsageHandler usagehandler : usagehandlers) {
                IUsageHandler handler = usagehandler.getUsageHandler(this.key);
                if (handler.getNumRecipes() <= 0) continue;
                this.currenthandlers.add(handler);
            }
        }
        return this.currenthandlers;
    }
}

