/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.GuiManager;
import codechicken.nei.InterActionMap;
import codechicken.nei.ItemPanelStack;
import codechicken.nei.NEIConfig;
import codechicken.nei.NEIController;
import codechicken.nei.NEIUtils;
import codechicken.nei.Widget;
import java.util.ArrayList;

public class ItemPanel
extends Widget {
    public static int page = 0;
    public int numPages = 0;
    public static final int ITEMSIZE = 18;
    public ItemPanelObject hoverItem = null;
    private int marginLeft;
    private int marginTop;
    private int columns;
    private int rows;
    private int itemsPerPage;

    @Override
    public void resize() {
        this.marginLeft = this.x + this.width % 18 / 2;
        this.marginTop = this.y + this.height % 18 / 2;
        this.columns = this.width / 18;
        this.rows = this.height / 18;
        this.itemsPerPage = this.rows * this.columns;
        this.numPages = (int)Math.ceil((float)NEIController.visibleitems.size() / (float)this.itemsPerPage);
        int n2 = page >= 0 ? (page < this.numPages ? page : 0) : (page = this.numPages - 1);
        if (this.numPages == 0) {
            page = 0;
        }
    }

    @Override
    public void draw(GuiManager gui, int mousex, int mousey) {
        ArrayList visibleitems = NEIController.visibleitems;
        if (visibleitems.size() == 0) {
            return;
        }
        int itemIndex = page * this.itemsPerPage;
        int lastIndex = this.itemsPerPage * (page + 1) < visibleitems.size() ? this.itemsPerPage * (page + 1) : visibleitems.size();
        int colIndex = 0;
        int rowIndex = 0;
        this.hoverItem = null;
        while (itemIndex < lastIndex) {
            ItemPanelObject item = (ItemPanelObject)visibleitems.get(itemIndex);
            int posX = this.marginLeft + colIndex * 18;
            int posY = this.marginTop + rowIndex * 18;
            if (mousex >= posX && mousex < posX + 18 && mousey >= posY && mousey < posY + 18) {
                this.hoverItem = item;
                gui.drawRect(posX - 1, posY - 1, 18, 18, -296397483);
            }
            item.draw(gui, posX, posY);
            ++itemIndex;
            if (++colIndex != this.columns) continue;
            colIndex = 0;
            ++rowIndex;
        }
    }

    @Override
    public boolean handleClick(int i2, int j2, int k2) {
        if (NEIUtils.getHeldItem() != null) {
            if (NEIConfig.isActionPermissable(InterActionMap.DELETE)) {
                if (k2 == 1) {
                    NEIUtils.decreaseSlotStack(-999);
                } else {
                    NEIUtils.deleteHeldItem();
                }
            } else {
                NEIUtils.dropHeldItem();
            }
            return true;
        }
        if (this.hoverItem != null) {
            this.hoverItem.handleClick(k2);
        }
        return true;
    }

    @Override
    public boolean onMouseWheel(int i2, int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        page += i2;
        return true;
    }

    public aan getStackUnderMouse() {
        return this.hoverItem instanceof ItemPanelStack ? ((ItemPanelStack)this.hoverItem).item : null;
    }

    public static interface ItemPanelObject {
        public void draw(GuiManager var1, int var2, int var3);

        public void drawTip(GuiManager var1, int var2, int var3);

        public void handleClick(int var1);
    }
}

