/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.API;
import codechicken.nei.Button;
import codechicken.nei.Button2ActiveState;
import codechicken.nei.DropDownWidget;
import codechicken.nei.GuiManager;
import codechicken.nei.InterActionMap;
import codechicken.nei.ItemPanel;
import codechicken.nei.LayoutStyle;
import codechicken.nei.LayoutStyleMinecraft;
import codechicken.nei.LayoutStyleTMIOld;
import codechicken.nei.NEIConfig;
import codechicken.nei.NEIController;
import codechicken.nei.NEIUtils;
import codechicken.nei.RenameableButton;
import codechicken.nei.SearchField;
import codechicken.nei.TextField;
import codechicken.nei.Widget;
import codechicken.nei.WidgetZOrder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class LayoutManager {
    public static int mousex;
    public static int mousey;
    static TreeSet drawWidgets;
    static TreeSet controlWidgets;
    public static GuiManager gui;
    public static ItemPanel itemPanel;
    public static DropDownWidget dropDown;
    public static TextField searchField;
    public static Button options;
    public static Button prev;
    public static Button next;
    public static RenameableButton[] stateButtons;
    public static Button[] deleteButtons;
    public static Button delete;
    public static Button2ActiveState creative;
    public static Button rain;
    public static Button magnet;
    public static Button dawn;
    public static Button noon;
    public static Button dusk;
    public static Button midnight;
    public static Button heal;
    public static HashMap layoutStyles;

    static {
        layoutStyles = new HashMap();
        API.addLayoutStyle(0, new LayoutStyleMinecraft());
        API.addLayoutStyle(1, new LayoutStyleTMIOld());
        LayoutManager.init();
    }

    public static boolean onClick(int mousex, int mousey, int button) {
        block5: {
            if (!NEIConfig.isHidden()) break block5;
            return false;
        }
        try {
            if (!NEIConfig.isEnabled()) {
                return options.contains(mousex, mousey) && options.handleClick(mousex, mousey, button);
            }
            boolean clickhandled = false;
            for (Widget widget : controlWidgets) {
                widget.onGuiClick(mousex, mousey);
                if (clickhandled || !widget.contains(mousex, mousey) || !widget.handleClick(mousex, mousey, button)) continue;
                clickhandled = true;
            }
            return clickhandled;
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean widgetContains(int mousex, int mousey) {
        try {
            Widget widget;
            if (!NEIConfig.isEnabled() || NEIConfig.isHidden()) {
                return false;
            }
            Iterator iterator = controlWidgets.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(widget = (Widget)iterator.next()).contains(mousex, mousey));
            return true;
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
            return false;
        }
    }

    public static boolean keyPress(int keyID, char keyChar) {
        block4: {
            if (NEIConfig.isEnabled() && !NEIConfig.isHidden()) break block4;
            return false;
        }
        try {
            boolean keyhandled = false;
            for (Widget widget : controlWidgets) {
                widget.onKeyPressed(keyID, keyChar);
                if (keyhandled || !widget.handleKeyPress(keyID, keyChar)) continue;
                keyhandled = true;
            }
            return keyhandled;
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
            return false;
        }
    }

    public static void mouseUp(int mousex, int mousey, int button) {
        try {
            if (!NEIConfig.isEnabled()) {
                return;
            }
            for (Widget widget : controlWidgets) {
                widget.mouseUp(mousex, mousey, button);
            }
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
        }
    }

    public static void draw(int mx2, int my2) {
        mousex = mx2;
        mousey = my2;
        LayoutManager.layout();
        try {
            if (!NEIConfig.isHidden()) {
                if (NEIConfig.isEnabled()) {
                    LayoutManager.drawWidgets(mousex, mousey);
                } else {
                    options.draw(gui, mousex, mousey);
                }
            }
            gui.enable2DRender();
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
        }
    }

    private static void drawWidgets(int mousex, int mousey) {
        LayoutManager.getLayoutStyle().drawBackground(gui);
        for (Widget widget : drawWidgets) {
            widget.draw(gui, mousex, mousey);
        }
    }

    public static void showToolTip(int i2, int j2, aak inventory, yu mouseoverslot) {
        if (!NEIConfig.isHidden() && NEIConfig.isEnabled()) {
            for (Widget widget : controlWidgets) {
                String tip;
                if (!widget.contains(i2, j2)) continue;
                if (widget instanceof DropDownWidget && LayoutManager.dropDown.hoverItem != null) {
                    gui.drawItemTip(i2, j2, LayoutManager.dropDown.hoverItem);
                    return;
                }
                if (widget instanceof ItemPanel && LayoutManager.itemPanel.hoverItem != null) {
                    LayoutManager.itemPanel.hoverItem.drawTip(gui, i2, j2);
                    return;
                }
                if (!(widget instanceof Button) || (tip = NEIController.getButtonTip((Button)widget)) == null) continue;
                gui.drawTip(i2, j2, tip);
                return;
            }
        }
        if (inventory.k() == null && mouseoverslot != null && mouseoverslot.c()) {
            gui.drawItemTip(i2, j2, mouseoverslot.b());
        }
    }

    public static void layout() {
        int windowWidth = LayoutManager.gui.window.q;
        int windowHeight = LayoutManager.gui.window.r;
        int containerWidth = LayoutManager.gui.window.b;
        int containerHeight = LayoutManager.gui.window.c;
        boolean sidesOffScreen = LayoutManager.gui.window.e - 4 < 76;
        LayoutManager.prev.width = LayoutManager.gui.window.e - 4;
        LayoutManager.prev.x = sidesOffScreen ? -1000 : (containerWidth + windowWidth) / 2 + 2;
        LayoutManager.next.x = LayoutManager.prev.x;
        LayoutManager.next.y = windowHeight - 28;
        LayoutManager.next.width = LayoutManager.prev.width;
        LayoutManager.options.x = sidesOffScreen ? -1000 : (NEIConfig.isEnabled() ? 0 : 6);
        LayoutManager.options.y = NEIConfig.isEnabled() ? windowHeight - 22 : windowHeight - 28;
        LayoutManager.delete.state = 4;
        if (NEIController.deleteMode) {
            LayoutManager.delete.state |= 1;
        } else if (LayoutManager.gui.window instanceof sr) {
            LayoutManager.delete.state |= 2;
        }
        LayoutManager.rain.state = 4;
        if (NEIUtils.isRaining()) {
            LayoutManager.rain.state |= 1;
        } else if (NEIConfig.isPropertyDisabled("rain")) {
            LayoutManager.rain.state |= 2;
        }
        LayoutManager.creative.state = 4;
        if (NEIUtils.getCreativeMode() != 0) {
            LayoutManager.creative.state |= 1;
        }
        if (NEIUtils.getCreativeMode() == 2) {
            LayoutManager.creative.state |= 8;
        }
        LayoutManager.magnet.state = 4 | (NEIConfig.getMagnetMode() ? 1 : 0);
        LayoutManager.dawn.state = NEIConfig.isPropertyDisabled("dawn") ? 2 : 0;
        LayoutManager.noon.state = NEIConfig.isPropertyDisabled("noon") ? 2 : 0;
        LayoutManager.dusk.state = NEIConfig.isPropertyDisabled("dusk") ? 2 : 0;
        LayoutManager.midnight.state = NEIConfig.isPropertyDisabled("midnight") ? 2 : 0;
        LayoutStyle style = LayoutManager.getLayoutStyle();
        style.reset();
        if (NEIConfig.isActionPermissable(InterActionMap.DELETE)) {
            LayoutManager.layoutButton(delete, style);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.RAIN)) {
            LayoutManager.layoutButton(rain, style);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.CREATIVE)) {
            LayoutManager.layoutButton(creative, style);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.MAGNET)) {
            LayoutManager.layoutButton(magnet, style);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.TIME)) {
            LayoutManager.layoutButton(dawn, style);
            LayoutManager.layoutButton(noon, style);
            LayoutManager.layoutButton(dusk, style);
            LayoutManager.layoutButton(midnight, style);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.HEAL)) {
            LayoutManager.layoutButton(heal, style);
        }
        if (sidesOffScreen) {
            LayoutManager.heal.x = -1000;
            LayoutManager.midnight.x = -1000;
            LayoutManager.dusk.x = -1000;
            LayoutManager.noon.x = -1000;
            LayoutManager.dawn.x = -1000;
            LayoutManager.magnet.x = -1000;
            LayoutManager.creative.x = -1000;
            LayoutManager.rain.x = -1000;
            LayoutManager.delete.x = -1000;
        }
        if (sidesOffScreen) {
            LayoutManager.itemPanel.x = -1000;
            LayoutManager.itemPanel.width = 5;
        } else {
            LayoutManager.itemPanel.x = (windowWidth + containerWidth) / 2 + 5;
            LayoutManager.itemPanel.width = windowWidth - 5 - LayoutManager.itemPanel.x;
        }
        LayoutManager.itemPanel.height = windowHeight - 30 - LayoutManager.itemPanel.y;
        itemPanel.resize();
        LayoutManager.prev.label = "Prev (" + (ItemPanel.page + 1) + "/" + LayoutManager.itemPanel.numPages + ")";
        LayoutManager.searchField.y = windowHeight - LayoutManager.searchField.height - 5;
        if (windowHeight - containerHeight <= 40 || sidesOffScreen) {
            LayoutManager.dropDown.x = -1000;
            dropDown.setDropDown(0);
            LayoutManager.searchField.x = -1000;
            LayoutManager.searchField.focused = false;
        } else {
            LayoutManager.dropDown.x = NEIConfig.getLayoutStyle() == 1 ? 93 : 90;
            LayoutManager.dropDown.width = LayoutManager.prev.x - LayoutManager.dropDown.x - 3;
            LayoutManager.searchField.x = (windowWidth - LayoutManager.searchField.width) / 2;
        }
        int maxWidth = 0;
        int i2 = 0;
        while (i2 < 7) {
            LayoutManager.deleteButtons[i2].x = -1000;
            ady statelist = NEIConfig.saveCompound.m("statename");
            NEIConfig.saveCompound.a("statename", (gh)statelist);
            String name = statelist.j("" + i2);
            if (statelist.b("" + i2) == null) {
                name = "" + (i2 + 1);
                statelist.a("" + i2, name);
            }
            LayoutManager.stateButtons[i2].label = String.valueOf(NEIConfig.isStateSaved(i2) ? "Load " : "Save ") + name;
            int width = gui.getTextWidth(LayoutManager.stateButtons[i2].label) + 26;
            if (width + 22 > LayoutManager.gui.window.e) {
                width = LayoutManager.gui.window.e - 22;
            }
            if (width > maxWidth) {
                maxWidth = width;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < 7) {
            if (sidesOffScreen) {
                LayoutManager.stateButtons[i2].x = -1000;
                LayoutManager.deleteButtons[i2].x = -1000;
            } else {
                LayoutManager.stateButtons[i2].x = 0;
                LayoutManager.stateButtons[i2].width = maxWidth;
                if (NEIConfig.isStateSaved(i2)) {
                    LayoutManager.deleteButtons[i2].x = LayoutManager.stateButtons[i2].width + 3;
                    LayoutManager.deleteButtons[i2].y = LayoutManager.stateButtons[i2].y + 2;
                }
            }
            ++i2;
        }
    }

    private static void layoutButton(Button button, LayoutStyle style) {
        style.position(button, gui);
    }

    private static void init() {
        itemPanel = new ItemPanel();
        dropDown = new DropDownWidget();
        searchField = new SearchField("search");
        options = new Button("Options", "options");
        prev = new Button("Prev", "prev");
        next = new Button("Next", "next");
        stateButtons = new RenameableButton[7];
        deleteButtons = new Button[7];
        int i2 = 0;
        while (i2 < 7) {
            LayoutManager.stateButtons[i2] = new RenameableButton("", "state" + i2);
            LayoutManager.deleteButtons[i2] = new Button("x", "delete" + i2);
            ++i2;
        }
        delete = new Button("delete");
        creative = new Button2ActiveState("creative");
        rain = new Button("rain");
        magnet = new Button("magnet");
        dawn = new Button("dawn");
        noon = new Button("noon");
        dusk = new Button("dusk");
        midnight = new Button("midnight");
        heal = new Button("heal");
        LayoutManager.delete.state |= 4;
        LayoutManager.creative.state |= 4;
        LayoutManager.rain.state |= 4;
        LayoutManager.magnet.state |= 4;
        LayoutManager.layoutZOrders();
        LayoutManager.setStaticDimensions();
    }

    private static void setStaticDimensions() {
        LayoutManager.prev.height = 28;
        LayoutManager.next.height = 28;
        LayoutManager.options.width = 80;
        LayoutManager.options.height = 22;
        LayoutManager.itemPanel.y = 30;
        LayoutManager.dropDown.height = 20;
        LayoutManager.searchField.height = 20;
        LayoutManager.searchField.width = 150;
        int i2 = 0;
        while (i2 < 7) {
            LayoutManager.stateButtons[i2].x = 0;
            LayoutManager.stateButtons[i2].y = 58 + i2 * 22;
            LayoutManager.stateButtons[i2].height = 20;
            LayoutManager.deleteButtons[i2].width = 16;
            LayoutManager.deleteButtons[i2].height = 16;
            ++i2;
        }
    }

    private static void layoutZOrders() {
        LayoutManager.dropDown.z = -5;
    }

    public static void reloadWidgets(GuiManager gui1) {
        gui = gui1;
        drawWidgets = new TreeSet(new WidgetZOrder(false));
        controlWidgets = new TreeSet(new WidgetZOrder(true));
        LayoutManager.addWidget(itemPanel);
        LayoutManager.addWidget(dropDown);
        LayoutManager.addWidget(searchField);
        LayoutManager.addWidget(options);
        LayoutManager.addWidget(prev);
        LayoutManager.addWidget(next);
        LayoutManager.getLayoutStyle().init();
        LayoutManager.layout();
        if (NEIConfig.isActionPermissable(InterActionMap.ITEM)) {
            int i2 = 0;
            while (i2 < 7) {
                LayoutManager.addWidget(deleteButtons[i2]);
                LayoutManager.addWidget(stateButtons[i2]);
                ++i2;
            }
        }
        if (NEIConfig.isActionPermissable(InterActionMap.DELETE)) {
            LayoutManager.addWidget(delete);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.TIME)) {
            LayoutManager.addWidget(dawn);
            LayoutManager.addWidget(noon);
            LayoutManager.addWidget(dusk);
            LayoutManager.addWidget(midnight);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.RAIN)) {
            LayoutManager.addWidget(rain);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.HEAL)) {
            LayoutManager.addWidget(heal);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.MAGNET)) {
            LayoutManager.addWidget(magnet);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.CREATIVE)) {
            LayoutManager.addWidget(creative);
        }
    }

    public static LayoutStyle getLayoutStyle() {
        LayoutStyle style = (LayoutStyle)layoutStyles.get(NEIConfig.getLayoutStyle());
        if (style == null) {
            style = (LayoutStyle)layoutStyles.get(0);
        }
        return style;
    }

    private static void addWidget(Widget widget) {
        drawWidgets.add(widget);
        controlWidgets.add(widget);
    }

    public static void tick() {
        try {
            if (!NEIConfig.isEnabled()) {
                return;
            }
            for (Widget widget : controlWidgets) {
                widget.update(gui);
            }
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean onMouseWheel(int i2) {
        try {
            Widget widget;
            if (NEIConfig.isHidden()) return false;
            if (!NEIConfig.isEnabled()) {
                return false;
            }
            Iterator iterator = controlWidgets.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(widget = (Widget)iterator.next()).onMouseWheel(i2, mousex, mousey));
            return true;
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
        }
        return false;
    }
}

