--[[

	Atlas World Events, a World of Warcraft map browser for world events
	Copyright 2011 ~ 2015 - Arith Hsu

	This file is a plugin of Atlas.

	Atlas World Events is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas World Events is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]
local BZ = Atlas_GetLocaleLibBabble("LibBabble-SubZone-3.0");
local AL = LibStub("AceLocale-3.0"):GetLocale("Atlas_WorldEvents");

local BLUE = "|cff6666ff";
local GREY = "|cff999999";
local GREN = "|cff66cc33";
local YELL = "|cffcccc00";
local _RED = "|cffcc6666";
local ORNG = "|cffcc9933";
local PURP = "|cff9900ff";
local WHIT = "|cffffffff";
local CYAN = "|cff11cfff";
local INVIS = "|c00000000";
local INDENT = "    ";
local DASH = GREY.." - ";

local myCategory = AL["World Events Maps"];

local myData = {
	Brewfest_Alliance_MajorCities = {
		ZoneName = { AL["Brewfest"].." - "..FACTION_ALLIANCE.." ("..AL["Major Cities"]..")" };
		Location = { BZ["Ironforge"].." / "..BZ["Stormwind City"].." / "..BZ["Darnassus"].." / "..BZ["The Exodar"] };
		{ ORNG..AL["Brewfest"].." - "..AL["Brewfest_Date"] };
		{ "" };
		{ BLUE..AL["Alliance Questline"] };
		{ YELL.." 1) "..AL["Quest: "]..AL["Brewfest!"] };
		{ BLUE..INDENT.." 1) "..AL["Start"]..": "..AL["Dwarf Commoner"] };
		{ GREY..INDENT..INDENT.."(30, 62) "..BZ["Ironforge"] };
		{ BLUE..INDENT.." 2) "..AL["Start"]..": "..AL["Gnome Commoner"] };
		{ GREY..INDENT..INDENT.."(57, 49) "..BZ["Ironforge"] };
		{ BLUE..INDENT.." 3) "..AL["Start"]..": "..AL["Human Commoner"] };
		{ GREY..INDENT..INDENT.."(61, 74) "..BZ["Stormwind City"] };
		{ BLUE..INDENT.." 4) "..AL["Start"]..": "..AL["Night Elf Commoner"] };
		{ GREY..INDENT..INDENT.."(44, 52) "..BZ["Darnassus"] };
		{ BLUE..INDENT.." 5) "..AL["Start"]..": "..AL["Draenei Commoner"] };
		{ GREY..INDENT..INDENT.."(60, 48), (51, 42) "..BZ["The Exodar"] };
		{ YELL.." 2) "..AL["Quest: "]..AL["Brew of the Month Club"] };
		{ BLUE..INDENT.." 6) "..AL["End"]..": "..AL["Larkin Thunderbrew"] };
		{ GREY..INDENT..INDENT.."(19, 53) "..BZ["Ironforge"] };	};
	Brewfest_Alliance = {
		ZoneName = { AL["Brewfest"].." - "..FACTION_ALLIANCE };
		Location = { BZ["Dun Morogh"] };
		{ ORNG..AL["Brewfest"].." - "..AL["Brewfest_Date"] };
		{ "" };
		{ BLUE..AL["Alliance Questline"] };
		{ YELL.." 1) "..AL["Quest: "]..AL["Brewfest!"] };
		{ BLUE..INDENT.." 1) "..AL["End"]..": "..AL["Ipfelkofer Ironkeg"] };
		{ GREY..INDENT..INDENT.."(55, 38) "..BZ["Dun Morogh"] };
		{ YELL.." 2) "..AL["Quest: "]..AL["Catch the Wild Wolpertinger!"] };
		{ YELL.." 3) "..AL["Quest: "]..AL["Pink Elekks On Parade"] };
		{ BLUE..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Goldark Snipehunter"] };
		{ GREY..INDENT..INDENT.."(55, 37) "..BZ["Dun Morogh"] };
		{ YELL.." 4) "..AL["Quest: "]..AL["Chug and Chuck!"] };
		{ BLUE..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Boxey Boltspinner"] };
		{ GREY..INDENT..INDENT.."(54, 38) "..BZ["Dun Morogh"] };
		{ YELL.." 5) "..AL["Quest: "]..AL["Now This is Ram Racing... Almost."] };
		{ BLUE..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Neill Ramstein"] };
		{ GREY..INDENT..INDENT.."(53, 38) "..BZ["Dun Morogh"] };
		{ YELL.." 6) "..AL["Quest: "]..AL["There and Back Again"] };
		{ BLUE..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Neill Ramstein"] };
		{ GREY..INDENT..INDENT.."(53, 38) "..BZ["Dun Morogh"] };
		{ BLUE..INDENT.." 2) "..AL["Flynn Firebrew"] };
		{ GREY..INDENT..INDENT.."(52, 51) "..BZ["Kharanos"]..", "..BZ["Dun Morogh"] };
		{ YELL.." 7) "..AL["Quest: "]..AL["A New Supplier of Souvenirs"] };
		{ BLUE..INDENT.." 1) "..AL["Start"]..": "..AL["Pol Amberstill"] };
		{ GREY..INDENT..INDENT.."(53, 38) "..BZ["Dun Morogh"] };
		{ BLUE..INDENT.." 1) "..AL["End"]..": "..AL["Belbi Quikswitch"] };
		{ GREY..INDENT..INDENT.."(56, 37) "..BZ["Dun Morogh"] };
		{ CYAN.." 8) "..AL["Quest: "]..AL["Bark for the Barleybrews!"] };
		{ BLUE..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Becan Barleybrew"] };
		{ GREY..INDENT..INDENT.."(56, 37) "..BZ["Dun Morogh"] };
		{ CYAN.." 9) "..AL["Quest: "]..AL["Bark for the Thunderbrews!"] };
		{ BLUE..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Daran Thunderbrew"] };
		{ GREY..INDENT..INDENT.."(56, 36) "..BZ["Dun Morogh"] };
		{ CYAN.."10) "..AL["Quest: "]..AL["Brew For Brewfest"] };
		{ BLUE..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Neill Ramstein"] };
		{ GREY..INDENT..INDENT.."(53, 38) "..BZ["Dun Morogh"] };
		{ CYAN.."11) "..AL["Quest: "]..AL["This One Time, When I Was Drunk..."] };
		{ BLUE..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Dark Iron Mole Machine Wreckage"] };
		{ GREY..INDENT..INDENT.."(56, 37) "..BZ["Dun Morogh"] };
		{ BLUE..INDENT.." 1) "..AL["End"].." / "..AL["End"]..": "..AL["Boxey Boltspinner"] };
		{ GREY..INDENT..INDENT.."(54, 38) "..BZ["Dun Morogh"] };
	};
	Brewfest_Horde_MajorCities = {
		ZoneName = { AL["Brewfest"].." - "..FACTION_HORDE.." ("..AL["Major Cities"]..")" };
		Location = { BZ["Orgrimmar"].." / "..BZ["Undercity"].." / "..BZ["Thunder Bluff"].." / "..BZ["Silvermoon City"] };
		{ ORNG..AL["Brewfest"].." - "..AL["Brewfest_Date"] };
		{ "" };
		{ BLUE..AL["Horde Questline"] };
		{ YELL.." 1) "..AL["Quest: "]..AL["Brewfest!"] };
		{ _RED..INDENT.." 1) "..AL["Start"]..": "..AL["Orc Commoner"] };
		{ GREY..INDENT..INDENT.."(51, 75) "..BZ["Orgrimmar"] };
		{ _RED..INDENT.." 2) "..AL["Start"]..": "..AL["Troll Commoner"] };
		{ GREY..INDENT..INDENT.."(49, 61) "..BZ["Orgrimmar"] };
		{ _RED..INDENT.." 3) "..AL["Start"]..": "..AL["Tauren Commoner"] };
		{ GREY..INDENT..INDENT.."(40, 48) "..BZ["Orgrimmar"] };
		{ _RED..INDENT.." 4) "..AL["Start"]..": "..AL["Forsaken Commoner"] };
		{ GREY..INDENT..INDENT.."(63, 48) "..BZ["Undercity"] };
		{ _RED..INDENT.." 5) "..AL["Start"]..": "..AL["Tauren Commoner"] };
		{ GREY..INDENT..INDENT.."(41, 55) "..BZ["Thunder Bluff"] };
		{ _RED..INDENT.." 6) "..AL["Start"]..": "..AL["Blood Elf Commoner"] };
		{ GREY..INDENT..INDENT.."(77, 57), (59, 60), (62, 73), (90, 57), "..BZ["Silvermoon City"] };
		{ YELL.." 2) "..AL["Quest: "]..AL["Brew of the Month Club"] };
		{ _RED..INDENT.." 7) "..AL["End"]..": "..AL["Ray'ma"] };
		{ GREY..INDENT..INDENT.."(50, 73) "..BZ["Orgrimmar"] };
	};
	Brewfest_Horde = {
		ZoneName = { AL["Brewfest"].." - "..FACTION_HORDE };
		Location = { BZ["Durotar"] };
		{ ORNG..AL["Brewfest"].." - "..AL["Brewfest_Date"] };
		{ "" };
		{ _RED..AL["Horde Questline"] };
		{ YELL.." 1) "..AL["Quest: "]..AL["Brewfest!"] };
		{ _RED..INDENT.." 1) "..AL["End"]..": "..AL["Tapper Swindlekeg"] };
		{ GREY..INDENT..INDENT.."(41, 18) "..BZ["Durotar"] };
		{ YELL.." 2) "..AL["Quest: "]..AL["Catch the Wild Wolpertinger!"] };
		{ YELL.." 3) "..AL["Quest: "]..AL["Pink Elekks On Parade"] };
		{ _RED..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Glodrak Huntsniper"] };
		{ GREY..INDENT..INDENT.."(41, 18) "..BZ["Durotar"] };
		{ YELL.." 4) "..AL["Quest: "]..AL["Chug and Chuck!"] };
		{ _RED..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Bizzle Quicklift"] };
		{ GREY..INDENT..INDENT.."(41, 17) "..BZ["Durotar"] };
		{ YELL.." 5) "..AL["Quest: "]..AL["Now This is Ram Racing... Almost."] };
		{ _RED..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Ram Master Ray"] };
		{ GREY..INDENT..INDENT.."(42, 17) "..BZ["Durotar"] };
		{ YELL.." 6) "..AL["Quest: "]..AL["There and Back Again"] };
		{ _RED..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Ram Master Ray"] };
		{ GREY..INDENT..INDENT.."(42, 17) "..BZ["Durotar"] };
		{ _RED..INDENT.." 2) "..AL["Bok Dropcertain"] };
		{ GREY..INDENT..INDENT.."(50, 13) "..BZ["Skull Rock"]..", "..BZ["Durotar"] };
		{ YELL.." 7) "..AL["Quest: "]..AL["A New Supplier of Souvenirs"] };
		{ _RED..INDENT.." 1) "..AL["Start"]..": "..AL["Driz Tumblequick"] };
		{ GREY..INDENT..INDENT.."(42, 17) "..BZ["Durotar"] };
		{ _RED..INDENT.." 1) "..AL["End"]..": "..AL["Blix Fixwidget"] };
		{ GREY..INDENT..INDENT.."(40, 17) "..BZ["Durotar"] };
		{ CYAN.." 8) "..AL["Quest: "]..AL["Bark for Drohn's Distillery!"] };
		{ _RED..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Cort Gorestein"] };
		{ GREY..INDENT..INDENT.."(40, 18) "..BZ["Durotar"] };
		{ CYAN.." 9) "..AL["Quest: "]..AL["Bark for T'chali's Voodoo Brewery!"] };
		{ _RED..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Ja'ron"] };
		{ GREY..INDENT..INDENT.."(40, 17) "..BZ["Durotar"] };
		{ CYAN.."10) "..AL["Quest: "]..AL["Brew For Brewfest"] };
		{ _RED..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Ram Master Ray"] };
		{ GREY..INDENT..INDENT.."(42, 17) "..BZ["Durotar"] };
		{ CYAN.."11) "..AL["Quest: "]..AL["This One Time, When I Was Drunk..."] };
		{ _RED..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Dark Iron Mole Machine Wreckage"] };
		{ GREY..INDENT..INDENT.."(41, 17) "..BZ["Durotar"] };
		{ _RED..INDENT.." 1) "..AL["End"].." / "..AL["End"]..": "..AL["Bizzle Quicklift"] };
		{ GREY..INDENT..INDENT.."(41, 17) "..BZ["Durotar"] };
	};
	WinterVeil_Alliance = {
		ZoneName = { AL["Feast of Winter Veil"].." - "..FACTION_ALLIANCE };
		Location = { BZ["Ironforge"].." / "..BZ["Hillsbrad Foothills"] };
		{ ORNG..AL["Feast of Winter Veil"].." - "..AL["Winter_Date"] };
		{ "" };
		{ BLUE..AL["Alliance Questline"] };
		{ YELL.." 1) "..AL["Quest: "]..AL["Greatfather Winter is Here!"] };
		{ BLUE..INDENT.." 1) "..AL["Start"]..": "..AL["Wulmort Jinglepocket"] };
		{ GREY..INDENT..INDENT.."(33, 67) "..BZ["Ironforge"] };
		{ BLUE..INDENT.." 2) "..AL["End"]..": "..AL["Greatfather Winter"] };
		{ GREY..INDENT..INDENT.."(33, 65) "..BZ["Ironforge"] };
		{ CYAN.." 2) "..AL["Quest: "]..AL["You're a Mean One..."].." ("..AL["Daily Group"]..")"; };
		{ BLUE..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Wulmort Jinglepocket"] };
		{ GREY..INDENT..INDENT.."(33, 67) "..BZ["Ironforge"] };
		{ WHIT..INDENT.." 1) "..AL["The Abominable Greench"] };
		{ GREY..INDENT..INDENT.."(43, 39) "..BZ["Growless Cave"]..", "..BZ["Hillsbrad Foothills"] };
		{ YELL.." 3) "..AL["Quest: "]..AL["A Smokywood Pastures' Thank You!"] };
		{ BLUE..INDENT.." 1) "..AL["Start"]..": "..AL["Wulmort Jinglepocket"] };
		{ GREY..INDENT..INDENT.."(33, 67) "..BZ["Ironforge"] };
		{ BLUE..INDENT.." 2) "..AL["End"]..": "..AL["Greatfather Winter"] };
		{ GREY..INDENT..INDENT.."(33, 65) "..BZ["Ironforge"] };
		{ YELL.." 4) "..AL["Quest: "]..AL["Treats for Greatfather Winter"] };
		{ BLUE..INDENT.." 2) "..AL["Start"].." / "..AL["End"]..": "..AL["Greatfather Winter"] };
		{ GREY..INDENT..INDENT.."(33, 65) "..BZ["Ironforge"] };
		{ YELL.." 5) "..AL["Quest: "]..AL["The Reason for the Season"] };
		{ BLUE..INDENT.." 3) "..AL["Start"]..": "..AL["Goli Krumn"] };
		{ GREY..INDENT..INDENT.."(29, 59) "..BZ["Ironforge"] };
		{ BLUE..INDENT.." 4) "..AL["End"]..": "..AL["Historian Karnik"] };
		{ GREY..INDENT..INDENT.."(71, 11) "..BZ["Ironforge"] };
		{ YELL.." 6) "..AL["Quest: "]..AL["The Feast of Winter Veil"] };
		{ BLUE..INDENT.." 4) "..AL["Start"]..": "..AL["Historian Karnik"] };
		{ GREY..INDENT..INDENT.."(71, 11) "..BZ["Ironforge"] };
		{ BLUE..INDENT.." 5) "..AL["End"]..": "..AL["Muradin Bronzebeard"] };
		{ GREY..INDENT..INDENT.."(39, 56) "..BZ["Ironforge"] };
	};
	WinterVeil_Horde = {
		ZoneName = { AL["Feast of Winter Veil"].." - "..FACTION_HORDE };
		Location = { BZ["Orgrimmar"].." / "..BZ["Thunder Bluff"].." / "..BZ["Hillsbrad Foothills"] };
		{ ORNG..AL["Feast of Winter Veil"].." - "..AL["Winter_Date"] };
		{ "" };
		{ BLUE..AL["Horde Questline"] };
		{ YELL.." 1) "..AL["Quest: "]..AL["Great-father Winter is Here!"] };
		{ _RED..INDENT.." 1) "..AL["Start"]..": "..AL["Kaymard Copperpinch"] };
		{ GREY..INDENT..INDENT.."(52, 77) "..BZ["Orgrimmar"] };
		{ _RED..INDENT.." 2) "..AL["End"]..": "..AL["Great-father Winter"] };
		{ GREY..INDENT..INDENT.."(49, 78) "..BZ["Orgrimmar"] };
		{ CYAN.." 2) "..AL["Quest: "]..AL["You're a Mean One..."].." ("..AL["Daily Group"]..")"; };
		{ _RED..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Kaymard Copperpinch"] };
		{ GREY..INDENT..INDENT.."(52, 77) "..BZ["Orgrimmar"] };
		{ WHIT..INDENT.." 1) "..AL["The Abominable Greench"] };
		{ GREY..INDENT..INDENT.."(43, 39) "..BZ["Growless Cave"]..", "..BZ["Hillsbrad Foothills"] };
		{ YELL.." 3) "..AL["Quest: "]..AL["A Smokywood Pastures' Thank You!"] };
		{ _RED..INDENT.." 1) "..AL["Start"]..": "..AL["Kaymard Copperpinch"] };
		{ GREY..INDENT..INDENT.."(52, 77) "..BZ["Orgrimmar"] };
		{ _RED..INDENT.." 2) "..AL["End"]..": "..AL["Great-father Winter"] };
		{ GREY..INDENT..INDENT.."(49, 78) "..BZ["Orgrimmar"] };
		{ YELL.." 4) "..AL["Quest: "]..AL["Treats for Great-father Winter"] };
		{ _RED..INDENT.." 2) "..AL["Start"].." / "..AL["End"]..": "..AL["Great-father Winter"] };
		{ GREY..INDENT..INDENT.."(49, 78) "..BZ["Orgrimmar"] };
		{ YELL.." 5) "..AL["Quest: "]..AL["The Reason for the Season"] };
		{ _RED..INDENT.." 3) "..AL["Start"]..": "..AL["Furmund"] };
		{ GREY..INDENT..INDENT.."(51, 71) "..BZ["Orgrimmar"] };
		{ _RED..INDENT.." 4) "..AL["End"]..": "..AL["Sagorne Creststrider"] };
		{ GREY..INDENT..INDENT.."(39, 47) "..BZ["Orgrimmar"] };
		{ YELL.." 6) "..AL["Quest: "]..AL["The Feast of Winter Veil"] };
		{ _RED..INDENT.." 4) "..AL["Start"]..": "..AL["Sagorne Creststrider"] };
		{ GREY..INDENT..INDENT.."(39, 47) "..BZ["Orgrimmar"] };
		{ _RED..INDENT.." 5) "..AL["End"]..": "..AL["Baine Bloodhoof"] };
		{ GREY..INDENT..INDENT.."(60, 51) "..BZ["Thunder Bluff"] };
	};
	DarkmoonFaire_Island = {
		ZoneName = { GetFactionInfoByID(909).." - "..BZ["Darkmoon Island"] };
		{ ORNG..AL["The first Sunday each month, last for a week"] };
		{ "" };
		{ BLUE.." A) "..AL["Entrance (Transported)"] };
		{ BLUE.." B) "..AL["Portals"] };
		{ BLUE.." 1) "..BZ["Deathmatch Pavilion"] };
		{ BLUE.." 2) "..AL["Petting Zoo"] };
		{ BLUE.." 3) "..AL["L90ETC Concert"] };
		{ "" };
		{ GREN.." 1) "..AL["Selina Dourman <Darkmoon Faire Information>"].." (56, 55)" };
		{ GREN.." 2) "..AL["Zina Sharpworth <Game Tokens>"].." (54, 53)" };
		{ GREN.." 3) "..AL["Mola <Whack-a-Mole>"].." (53, 55)" };
		{ INDENT..CYAN..AL["Quest: "]..AL["It's Hammer Time"] };
		{ GREN.." 4) "..AL["Maxima Blastenheimer <Darkmoon Faire Cannoneer>"].." (53, 56)" };
		{ INDENT..CYAN..AL["Quest: "]..AL["The Humanoid Cannonball"] };
		{ GREN.." 5) "..AL["Rinling"].." (49, 61)" };
		{ INDENT..CYAN..AL["Quest: "]..AL["He Shoots, He Scores!"] };
		{ GREN.." 6) "..AL["Sazz Coincatcher <Game Tokens>"].." (49, 62)" };
		{ GREN.." 7) "..AL["Gelvas Grimegate <Souvenir & Toy Prizes>"].." (48, 65)" };
		{ GREN.." 8) "..AL["Professor Thaddeus Paleo <Darkmoon Cards>"].." (52, 61)" };
		{ GREN.." 9) "..AL["Aimee <Pie, Pastry & Cakes>"].." (51, 63)" };
		{ GREN.."10) "..AL["Finlay Coolshot <Tonk Challenge>"].." (51, 65)" };
		{ INDENT..CYAN..AL["Quest: "]..AL["Tonk Commander"] };
		{ GREN.."11) "..AL["Stamp Thunderhorn <Food Vendor>"].." (53, 68)" };
		{ INDENT..AL["Quest: "]..AL["Putting the Crunch in the Frog"] };
		{ GREN.."12) "..AL["Chronos <He Who Never Forgets!>"].." (55, 71)" };
		{ INDENT..AL["Quest: "]..AL["Putting the Carnies Back Together Again"] };
		{ INDENT..AL["Quest: "]..AL["Keeping the Faire Sparkling"] };
		{ GREN.."13) "..AL["Sylannia <Drink Vendor>"].." (50, 69)" };
		{ GREN.."14) "..AL["Baruma <Replica Armor Prizes>"].." (48, 66)" };
		{ INDENT..GREN..AL["Barum <Replica Armor Prizes>"] };
		{ INDENT..GREN..AL["Daenrand Dawncrest <Heirloom Prizes>"] };
		{ INDENT..GREN..AL["Kerri Hicks <The Strongest Woman Alive!>"] };
		{ INDENT..AL["Quest: "]..AL["Test Your Strength"] };
		{ GREN.."15) "..AL["Lhara <Pet & Mount Prizes>"].." (48, 69)" };
		{ GREN.."16) "..AL["Boomie Sparks <Fireworks>"].." (48, 72)" };
		{ GREN.."17) "..AL["Trixi Sharpworth <Game Tokens>"].." (49, 76)" };
		{ GREN.."18) "..AL["Korgol Crushskull <The Pit Master>"].." (47, 79)" };
		{ GREN.."19) "..AL["Sayge"].." (53, 76)" };
		{ INDENT..AL["Quest: "]..AL["Putting Trash to Good Use"] };
		{ GREN.."20) "..AL["Jessica Rogers <Ring Toss>"].." (52, 78)" };
		{ INDENT..CYAN..AL["Quest: "]..AL["Target: Turtle"] };
		{ GREN.."21) "..AL["Tatia Brine <Fishing Supplies>"].." (53, 88)" };
		{ INDENT..GREN..AL["Steven Stagnaro <Fishing Trainer>"] };
		{ GREN.."22) "..AL["Teleportologist Fozlebub <Gone Fishin'>"].." (57, 90)" };
		{ GREN.."23) "..AL["Rona Greenteeth"].." (36, 58)" };
	};
	Hallow_End = {
		ZoneName = { AL["Hallow's End"].." - "..QUESTS_LABEL };
		{ ORNG..AL["Hallow's End"].." - "..AL["Hallow_Date"] };
		{ "" };
		{ _RED..AL["Horde Questline"] };
		{ YELL.." 1) "..AL["Quest: "]..AL["Masked Orphan Matron"] };
		{ _RED..INDENT.." 1) "..AL["Start"]..": "..AL["Orc Commoner"].." (51, 74), " };
		{ GREY..INDENT..INDENT..BZ["Valley of Strength"]..", "..BZ["Orgrimmar"] };
		{ _RED..INDENT.." 2) "..AL["End"]..": "..AL["Masked Orphan Matron"].." (52, 41), " };
		{ GREY..INDENT..INDENT..BZ["Razor Hill"]..", "..BZ["Durotar"] };
		{ _RED..INDENT.." 2')"..AL["End"]..": "..AL["Masked Orphan Matron"].." (61, 54), " };
		{ GREY..INDENT..INDENT..BZ["Brill"]..", "..BZ["Tirisfal Glades"] };
		{ _RED..INDENT.." 2\")"..AL["End"]..": "..AL["Masked Orphan Matron"].." (47, 47), " };
		{ GREY..INDENT..INDENT..BZ["Falconwing Square"]..", "..BZ["Silvermoon City"] };
		{ YELL.." 2) "..AL["Quest: "]..AL["Fire Training"] };
		{ _RED..INDENT.." 2) "..AL["Start"].." / "..AL["End"]..": "..AL["Masked Orphan Matron"].." (52, 41), " };
		{ GREY..INDENT..INDENT..BZ["Razor Hill"]..", "..BZ["Durotar"] };
		{ _RED..INDENT.." 2') "..AL["Start"].." / "..AL["End"]..": "..AL["Masked Orphan Matron"].." (61, 54), " };
		{ GREY..INDENT..INDENT..BZ["Brill"]..", "..BZ["Tirisfal Glades"] };
		{ _RED..INDENT.." 2\") "..AL["Start"].." / "..AL["End"]..": "..AL["Masked Orphan Matron"].." (47, 47), " };
		{ GREY..INDENT..INDENT..BZ["Falconwing Square"]..", "..BZ["Silvermoon City"] };
		{ CYAN.." 3) "..AL["Quest: "]..AL["\"Let the Fires Come!\""].." / "..AL["Stop the Fires!"] };
		{ _RED..INDENT.." 2) "..AL["Start"].." / "..AL["End"]..": "..AL["Masked Orphan Matron"].." (52, 41), " };
		{ GREY..INDENT..INDENT..BZ["Razor Hill"]..", "..BZ["Durotar"] };
		{ _RED..INDENT.." 2') "..AL["Start"].." / "..AL["End"]..": "..AL["Masked Orphan Matron"].." (61, 54), " };
		{ GREY..INDENT..INDENT..BZ["Brill"]..", "..BZ["Tirisfal Glades"] };
		{ _RED..INDENT.." 2\") "..AL["Start"].." / "..AL["End"]..": "..AL["Masked Orphan Matron"].." (47, 47), " };
		{ GREY..INDENT..INDENT..BZ["Falconwing Square"]..", "..BZ["Silvermoon City"] };
		{ YELL.." 4) "..AL["Quest: "]..AL["Hallow's End Treats for Spoops!"] };
		{ _RED..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Spoops"].." (71, 23), " };
		{ GREY..INDENT..INDENT..BZ["Valley of Honor"]..", "..BZ["Orgrimmar"] };
		{ WHIT..INDENT..AL["Orgrimmar Nougat"]..": " };
		{ _RED..INDENT..INDENT.." 1) "..AL["Innkeeper Gryshka"].." (53, 78), "..AL["Trick: "].."/flex" };
		{ GREY..INDENT..INDENT..BZ["Valley of Strength"]..", "..BZ["Orgrimmar"] };
		{ WHIT..INDENT..AL["Darkspear Gumdrop"]..": " };
		{ _RED..INDENT..INDENT.." 1) "..AL["Kali Remik"].." (32, 65), "..AL["Trick: "].."/train" };
		{ GREY..INDENT..INDENT..BZ["Valley of Spirits"]..", "..BZ["Orgrimmar"] };
		{ WHIT..INDENT..AL["Thunder Bluff Marzipan"]..": " };
		{ _RED..INDENT..INDENT.." 3) "..AL["Innkeeper Pala"].." (45, 63), "..AL["Trick: "].."/dance" };
		{ GREY..INDENT..INDENT..BZ["Thunder Bluff"] };
		{ WHIT..INDENT..AL["Undercity Mint"]..": " };
		{ _RED..INDENT..INDENT.." 4) "..AL["Innkeeper Norman"].." (67, 38), "..AL["Trick: "].."/chicken" };
		{ GREY..INDENT..INDENT..BZ["Undercity"] };
		{ "" };
		{ BLUE..AL["Alliance Questline"] };
		{ YELL.." 1) "..AL["Quest: "]..AL["Costumed Orphan Matron"] };
		{ BLUE..INDENT.." 1) "..AL["Start"]..": "..AL["Human Commoner"] };
		{ GREY..INDENT..INDENT..BZ["Stormwind City"] };
		{ BLUE..INDENT.." 2)"..AL["End"]..": "..AL["Costumed Orphan Matron"].." (43, 64), " };
		{ GREY..INDENT..INDENT..BZ["Goldshire"]..", "..BZ["Elwynn Forest"] };
		{ BLUE..INDENT.." 2')"..AL["End"]..": "..AL["Costumed Orphan Matron"].." (46, 53), " };
		{ GREY..INDENT..INDENT..BZ["Kharanos"]..", "..BZ["Dun Morogh"] };
		{ BLUE..INDENT.." 2\")"..AL["End"]..": "..AL["Costumed Orphan Matron"].." (49, 51), " };
		{ GREY..INDENT..INDENT..BZ["Azure Watch"]..", "..BZ["Azuremyst Isle"] };
		{ YELL.." 2) "..AL["Quest: "]..AL["Fire Brigade Practice"] };
		{ BLUE..INDENT.." 2) "..AL["Start"].." / "..AL["End"]..": "..AL["Costumed Orphan Matron"].." (43, 64), " };
		{ GREY..INDENT..INDENT..BZ["Goldshire"]..", "..BZ["Elwynn Forest"] };
		{ BLUE..INDENT.." 2') "..AL["Start"].." / "..AL["End"]..": "..AL["Costumed Orphan Matron"].." (46, 53), " };
		{ GREY..INDENT..INDENT..BZ["Kharanos"]..", "..BZ["Dun Morogh"] };
		{ BLUE..INDENT.." 2\") "..AL["Start"].." / "..AL["End"]..": "..AL["Costumed Orphan Matron"].." (49, 51), " };
		{ GREY..INDENT..INDENT..BZ["Azure Watch"]..", "..BZ["Azuremyst Isle"] };
		{ CYAN.." 3) "..AL["Quest: "]..AL["\"Let the Fires Come!\""].." / "..AL["Stop the Fires!"] };
		{ BLUE..INDENT.." 2) "..AL["Start"].." / "..AL["End"]..": "..AL["Costumed Orphan Matron"].." (43, 64), " };
		{ GREY..INDENT..INDENT..BZ["Goldshire"]..", "..BZ["Elwynn Forest"] };
		{ BLUE..INDENT.." 2') "..AL["Start"].." / "..AL["End"]..": "..AL["Costumed Orphan Matron"].." (46, 53), " };
		{ GREY..INDENT..INDENT..BZ["Kharanos"]..", "..BZ["Dun Morogh"] };
		{ BLUE..INDENT.." 2\") "..AL["Start"].." / "..AL["End"]..": "..AL["Costumed Orphan Matron"].." (49, 51), " };
		{ GREY..INDENT..INDENT..BZ["Azure Watch"]..", "..BZ["Azuremyst Isle"] };
		{ YELL.." 4) "..AL["Quest: "]..AL["Hallow's End Treats for Jesper!"] };
		{ BLUE..INDENT..AL["Start"].." / "..AL["End"]..": "..AL["Jesper"].." (57, 52), " };
		{ GREY..INDENT..INDENT..BZ["Cathedral Square"]..", "..BZ["Stormwind City"] };
		{ WHIT..INDENT..AL["Stormwind Nougat"]..": " };
		{ BLUE..INDENT..INDENT.." 1) "..AL["Innkeeper Allison"].." (60, 74), "..AL["Trick: "].."/flex" };
		{ GREY..INDENT..INDENT..BZ["Trade District"]..", "..BZ["Stormwind City"] };
		{ WHIT..INDENT..AL["Gnomeregan Gumdrop"]..": " };
		{ BLUE..INDENT..INDENT.." 3) "..AL["Talvash del Kissel"].." (64, 19), "..AL["Trick: "].."/train" };
		{ GREY..INDENT..INDENT..BZ["Hall of Explorers"]..", "..BZ["Ironforge"] };
		{ WHIT..INDENT..AL["Ironforge Mint"]..": " };
		{ BLUE..INDENT..INDENT.." 3) "..AL["Innkeeper Firebrew"].." (18, 51), "..AL["Trick: "].."/chiken" };
		{ GREY..INDENT..INDENT..BZ["Ironforge"] };
		{ WHIT..INDENT..AL["Darnassus Marzipan"]..": " };
		{ BLUE..INDENT..INDENT.." 4) "..AL["Innkeeper Saelienne"].." (62, 32), "..AL["Trick: "].."/dance" };
		{ GREY..INDENT..INDENT..BZ["Craftsmen's Terrace"]..", "..BZ["Darnassus"] };
	};
	Hallow_End_Alliance_Azeroth = {
		ZoneName = { AL["Hallow's End"].." - "..FACTION_ALLIANCE.." - "..BZ["Eastern Kingdoms"] };
		{ ORNG..AL["Hallow's End"].." - "..AL["Hallow_Date"] };
		{ "" };
		{ WHIT..AL["Candy Buckets"] };
		{ ORNG.." 1) "..BZ["Light's Hope Chapel"].." (75.6, 52.3), "..BZ["Eastern Plaguelands"] };
		{ BLUE.." 2) "..BZ["Chillwind Camp"].." (43.4, 84.4), "..BZ["Western Plaguelands"] };
		{ BLUE.." 3) "..BZ["Aerie Peak"].." (14.2, 44.7), "..BZ["The Hinterlands"] };
		{ BLUE.." 4) "..BZ["Stormfeather Outpost"].." (66.2, 44.4), "..BZ["The Hinterlands"] };
		{ BLUE.." 5) "..BZ["Refuge Pointe"].." (40.1, 49.0), "..BZ["Arathi Highlands"] };
		{ BLUE.." 6) "..BZ["Menethil Harbor"].." (10.8, 61.0), "..BZ["Wetlands"] };
		{ BLUE.." 7) "..BZ["Swiftgear Station"].." (26.1, 26.0), "..BZ["Wetlands"] };
		{ BLUE.." 8) "..BZ["Greenwarden's Grove"].." (58.2, 39.2), "..BZ["Wetlands"] };
		{ BLUE.." 9) "..BZ["Thundermar"].." (49.6, 30.4), "..BZ["Twilight Highlands"] };
		{ BLUE.."10) "..BZ["Victor's Point"].." (43.5, 57.3), "..BZ["Twilight Highlands"] };
		{ BLUE.."11) "..BZ["Firebeard's Patrol"].." (60.3, 58.2), "..BZ["Twilight Highlands"] };
		{ BLUE.."12) "..BZ["Highbank"].." (79.5, 78.5), "..BZ["Twilight Highlands"] };
		{ BLUE.."13) "..BZ["The Commons"].." (18.5, 50.9), "..BZ["Ironforge"] };
		{ BLUE.."14) "..BZ["Kharanos"].." (54.5, 50.8), "..BZ["Dun Morogh"] };
		{ BLUE.."15) "..BZ["Thelsamar"].." (35.5, 48.5), "..BZ["Loch Modan"] };
		{ BLUE.."16) "..BZ["Farstrider Lodge"].." (83.0, 63.5), "..BZ["Loch Modan"] };
		{ ORNG.."17) "..BZ["Iron Summit"].." (39.5, 66.1), "..BZ["Searing Gorge"] };
		{ BLUE.."18) "..BZ["Dragon's Mouth"].." (20.9, 56.3), "..BZ["Badlands"] };
		{ ORNG.."19) "..BZ["Fuselight"].." (65.8, 35.6), "..BZ["Badlands"] };
		{ BLUE.."20) "..BZ["Trade District"].." (60.5, 75.2), "..BZ["Stormwind City"] };
		{ BLUE.."21) "..BZ["Goldshire"].." (43.8, 66.0), "..BZ["Elwynn Forest"] };
		{ BLUE.."22) "..BZ["Lakeshire"].." (26.5, 41.5), "..BZ["Redridge Mountains"] };
		{ BLUE.."23) "..BZ["Sentinel Hill"].." (52.9, 53.7), "..BZ["Westfall"] };
		{ BLUE.."24) "..BZ["Darkshire"].." (73.8, 44.2), "..BZ["Duskwood"] };
		{ BLUE.."25) "..BZ["The Harborage"].." (28.9, 32.4), "..BZ["Swamp of Sorrows"] };
		{ ORNG.."26) "..BZ["Bogpaddle"].." (71.6, 14.1), "..BZ["Swamp of Sorrows"] };
		{ BLUE.."27) "..BZ["Nethergarde Keep"].." (60.7, 14.1), "..BZ["Blasted Lands"] };
		{ BLUE.."28) "..BZ["Surwich"].." (44.4, 87.6), "..BZ["Blasted Lands"] };
		{ BLUE.."29) "..BZ["Fort Livingston"].." (53.2, 67.0), "..BZ["Northern Stranglethorn"] };
		{ ORNG.."30) "..BZ["Booty Bay"].." (40.9, 73.7), "..BZ["The Cape of Stranglethorn"] };
		{ ORNG.."31) "..BZ["Deepmist Grotto"].." (63.5 60.2), "..BZ["Kelp'thar Forest"] };
		{ ORNG.."32) "..BZ["Silver Tide Hollow"].." (49.2, 41.8), "..BZ["Shimmering Expanse"] };
		{ BLUE.."34) "..BZ["Tranquil Wash"].." (49.7, 57.4), "..BZ["Shimmering Expanse"] };
		{ BLUE.."33) "..BZ["Darkbreak Cove"].." (54.7, 72.1), "..BZ["Abyssal Depths"] };
	};
	Hallow_End_Horde_Azeroth = {
		ZoneName = { AL["Hallow's End"].." - "..FACTION_HORDE.." - "..BZ["Eastern Kingdoms"] };
		{ ORNG..AL["Hallow's End"].." - "..AL["Hallow_Date"] };
		{ "" };
		{ WHIT..AL["Candy Buckets"] };
		{ _RED.." 1) "..BZ["Silvermoon City Inn"].." (79.4, 57.7), "..BZ["Silvermoon City"] };
		{ _RED.." 2) "..BZ["Wayfarer's Rest"].." (67.6, 72.9), "..BZ["Silvermoon City"] };
		{ _RED.." 3) "..BZ["Falconwing Square"].." (48.2, 47.9), "..BZ["Eversong Woods"] };
		{ _RED.." 4) "..BZ["Fairbreeze Village"].." (43.7, 71.0), "..BZ["Eversong Woods"] };
		{ _RED.." 5) "..BZ["Tranquillien"].." (48.7, 31.9), "..BZ["Ghostlands"] };
		{ ORNG.." 6) "..BZ["Light's Hope Chapel"].." (75.6, 52.3), "..BZ["Eastern Plaguelands"] };
		{ _RED.." 7) "..BZ["Brill"].." (61.0, 51.4), "..BZ["Tirisfal Glades"] };
		{ _RED.." 8) "..BZ["Trade Quarter"].." (67.7, 37.5), "..BZ["Undercity"] };
		{ _RED.." 9) "..BZ["The Bulwark"].." (83.0, 72.1), "..BZ["Tirisfal Glades"] };
		{ _RED.."10) "..BZ["Forsaken Rear Guard"].." (44.3, 20.3), "..BZ["Silverpine Forest"] };
		{ _RED.."11) "..BZ["The Sepulcher"].." (46.4, 42.7), "..BZ["Silverpine Forest"] };
		{ _RED.."12) "..BZ["Andorhal"].." (48.3, 63.7), "..BZ["Western Plaguelands"] };
		{ _RED.."13) "..BZ["Tarren Mill"].." (57.9, 47.3), "..BZ["Hillsbrad Foothills"] };
		{ _RED.."14) "..BZ["Eastpoint Tower"].." (60.3, 63.7), "..BZ["Hillsbrad Foothills"] };
		{ _RED.."15) "..BZ["Hiri'watha Research Station"].." (31.8, 57.9), "..BZ["The Hinterlands"] };
		{ _RED.."16) "..BZ["Hammerfall"].." (69.0, 33.3), "..BZ["Arathi Highlands"] };
		{ _RED.."17) "..BZ["Revantusk Village"].." (78.2, 81.5), "..BZ["The Hinterlands"] };
		{ _RED.."18) "..BZ["The Krazzworks"].." (75.4, 16.5), "..BZ["Twilight Highlands"] };
		{ _RED.."19) "..BZ["Bloodgulch"].." (53.4, 42.8), "..BZ["Twilight Highlands"] };
		{ _RED.."20) "..BZ["Dragonmaw Port"].." (75.3, 54.9), "..BZ["Twilight Highlands"] };
		{ _RED.."21) "..BZ["Crushblow"].." (45.1, 76.8), "..BZ["Twilight Highlands"] };
		{ ORNG.."22) "..BZ["Fuselight"].." (65.8, 35.6), "..BZ["Badlands"] };
		{ _RED.."23) "..BZ["New Kargath"].." (18.4, 42.7), "..BZ["Badlands"] };
		{ ORNG.."24) "..BZ["Iron Summit"].." (39.5, 66.1), "..BZ["Searing Gorge"] };
		{ ORNG.."25) "..BZ["Bogpaddle"].." (71.6, 14.1), "..BZ["Swamp of Sorrows"] };
		{ _RED.."26)"..BZ["Stonard"].." (46.9, 56.9), "..BZ["Swamp of Sorrows"] };
		{ _RED.."27) "..BZ["Dreadmaul Hold"].." (40.5, 11.3), "..BZ["Blasted Lands"] };
		{ _RED.."28)"..BZ["Grom'gol Base Camp"].." (37.4, 51.8), "..BZ["Northern Stranglethorn"] };
		{ _RED.."29) "..BZ["Hardwrench Hideaway"].." (35.0, 27.2), "..BZ["The Cape of Stranglethorn"] };
		{ ORNG.."30) "..BZ["Booty Bay"].." (40.9, 73.7), "..BZ["The Cape of Stranglethorn"] };
		{ ORNG.."31) "..BZ["Deepmist Grotto"].." (63.5 60.2), "..BZ["Kelp'thar Forest"] };
		{ ORNG.."32) "..BZ["Silver Tide Hollow"].." (49.2, 41.8), "..BZ["Shimmering Expanse"] };
		{ _RED.."33) "..BZ["Legion's Rest"].." (51.4, 62.3), "..BZ["Shimmering Expanse"] };
		{ _RED.."34) "..BZ["Tenebrous Cavern"].." (51.3, 60.5), "..BZ["Abyssal Depths"] };
	};
	Hallow_End_Alliance_Kalimdor = {
		ZoneName = { AL["Hallow's End"].." - "..FACTION_ALLIANCE.." - "..BZ["Kalimdor"] };
		{ ORNG..AL["Hallow's End"].." - "..AL["Hallow_Date"] };
		{ "" };
		{ WHIT..AL["Candy Buckets"] };
		{ BLUE.." 1) "..BZ["Blood Watch"].." (55.7, 60.0), "..BZ["Bloodmyst Isle"] };
		{ BLUE.." 2) "..BZ["The Exodar"].." (59.3, 18.5), "..BZ["Azuremyst Isle"] };
		{ BLUE.." 3) "..BZ["Azure Watch"].." (48.5, 49.0), "..BZ["Azuremyst Isle"] };
		{ BLUE.." 4) "..BZ["Craftsmen's Terrace"].." (62.2, 33.1), "..BZ["Darnassus"] };
		{ BLUE.." 5) "..BZ["Dolanaar"].." (55.4, 52.3), "..BZ["Teldrassil"] };
		{ BLUE.." 6) "..BZ["Lor'danel"].." (50.8, 18.8), "..BZ["Darkshore"] };
		{ ORNG.." 7) "..BZ["Whisperwind Grove"].." (44.7 29.0), "..BZ["Felwood"] };
		{ BLUE.." 8) "..BZ["Talonbranch Glade"].." (61.9, 26.7), "..BZ["Felwood"] };
		{ ORNG.." 9) "..BZ["Everlook"].." (59.8 51.1), "..BZ["Winterspring"] };
		{ ORNG.."10) "..BZ["Grove of Aessina"].." (18.6, 37.3), "..BZ["Mount Hyjal"] };
		{ ORNG.."11) "..BZ["Shrine of Aviana"].." (42.7, 45.7), "..BZ["Mount Hyjal"] };
		{ ORNG.."12) "..BZ["Nordrassil Inn"].." (63.1, 24.1), "..BZ["Mount Hyjal"] };
		{ BLUE.."13) "..BZ["Astranaar"].." (37.0, 49.3), "..BZ["Ashenvale"] };
		{ BLUE.."14) "..BZ["Stonetalon Peak"].." (40.6, 17.7), "..BZ["Desolace"] };
		{ BLUE.."15) "..BZ["Thal'darah Overlook"].." (39.5, 32.8), "..BZ["Stonetalon Mountains"] };
		{ BLUE.."16) "..BZ["Farwatcher's Glen"].." (31.5, 60.7), "..BZ["Stonetalon Mountains"] };
		{ BLUE.."17) "..BZ["Windshear Hold"].." (59.0, 56.3), "..BZ["Stonetalon Mountains"] };
		{ BLUE.."18) "..BZ["Northwatch Expedition Base Camp"].." (71.0, 79.0), "..BZ["Stonetalon Mountains"] };
		{ BLUE.."19) "..BZ["Nijel's Point"].." (66.3, 6.6), "..BZ["Desolace"] };
		{ ORNG.."20) "..BZ["Karnum's Glade"].." (56.7, 50.1), "..BZ["Desolace"] };
		{ ORNG.."21) "..BZ["Ratchet"].." (67.3, 74.6), "..BZ["Northern Barrens"] };
		{ BLUE.."22) "..BZ["Honor's Stand"].." (39.0, 11.0), "..BZ["Southern Barrens"] };
		{ BLUE.."23) "..BZ["Northwatch Hold"].." (65.6, 46.5), "..BZ["Southern Barrens"] };
		{ BLUE.."24) "..BZ["Fort Triumph"].." (49.0, 68.5), "..BZ["Southern Barrens"] };
		{ BLUE.."25) "..BZ["Theramore Isle"].." (66.6, 45.3), "..BZ["Dustwallow Marsh"] };
		{ ORNG.."26) "..BZ["Mudsprocket"].." (41.9, 74.1), "..BZ["Dustwallow Marsh"] };
		{ BLUE.."27) "..BZ["Dreamer's Rest"].." (51.1, 17.8), "..BZ["Feralas"] };
		{ BLUE.."28) "..BZ["Feathermoon Stronghold"].." (46.3, 45.2), "..BZ["Feralas"] };
		{ ORNG.."29) "..BZ["Cenarion Hold"].." (55.5, 36.8), "..BZ["Silithus"] };
		{ ORNG.."30) "..BZ["Marshal's Stand"].." (55.3, 62.1), "..BZ["Un'Goro Crater"] };
		{ ORNG.."31) "..BZ["Gadgetzan"].." (52.6, 27.1), "..BZ["Tanaris"] };
		{ ORNG.."32) "..BZ["Bootlegger Outpost"].." (55.7, 61.0), "..BZ["Tanaris"] };
		{ ORNG.."33) "..BZ["Oasis of Vir'sar"].." (26.6, 7.2), "..BZ["Uldum"] };
		{ ORNG.."34) "..BZ["Ramkahen"].." (54.7, 33.0), "..BZ["Uldum"] };
	};
	Hallow_End_Horde_Kalimdor = {
		ZoneName = { AL["Hallow's End"].." - "..FACTION_HORDE.." - "..BZ["Kalimdor"] };
		{ ORNG..AL["Hallow's End"].." - "..AL["Hallow_Date"] };
		{ "" };
		{ WHIT..AL["Candy Buckets"] };
		{ ORNG.." 1) "..BZ["Everlook"].." (59.8 51.1), "..BZ["Winterspring"] };
		{ ORNG.." 2) "..BZ["Whisperwind Grove"].." (44.7 29.0), "..BZ["Felwood"] };
		{ ORNG.." 3) "..BZ["Shrine of Aviana"].." (42.7, 45.7), "..BZ["Mount Hyjal"] };
		{ ORNG.." 4) "..BZ["Grove of Aessina"].." (18.6, 37.3), "..BZ["Mount Hyjal"] };
		{ ORNG.." 5) "..BZ["Nordrassil Inn"].." (63.1, 24.1), "..BZ["Mount Hyjal"] };
		{ _RED.." 6) "..BZ["Zoram'gar Outpost"].." (12.9, 34.1), "..BZ["Ashenvale"] };
		{ _RED.." 7) "..BZ["Hellscream's Watch"].." (38.6, 42.4), "..BZ["Ashenvale"] };
		{ _RED.." 8) "..BZ["Silverwind Refuge"].." (50.2, 67.3), "..BZ["Ashenvale"] };
		{ _RED.." 9) "..BZ["Splintertree Post"].." (73.9, 60.6), "..BZ["Ashenvale"] };
		{ _RED.."10) "..BZ["Bilgewater Harbor"].." (57.0 50.3), "..BZ["Azshara"] };
		{ _RED.."11) "..BZ["Valley of Strength"].." (53.6 78.7), "..BZ["Orgrimmar"] };
		{ _RED.."12) "..BZ["Razor Hill"].." (51.6, 41.6), "..BZ["Durotar"] };
		{ _RED.."13) "..BZ["Nozzlepot's Outpost"].." (62.5, 16.6), "..BZ["Northern Barrens"] };
		{ _RED.."14) "..BZ["Grol'dom Farm"].." (56.2, 40.0), "..BZ["Northern Barrens"] };
		{ _RED.."15) "..BZ["Crossroads"].." (49.5, 57.9), "..BZ["Northern Barrens"] };
		{ ORNG.."16) "..BZ["Ratchet"].." (67.3, 74.6), "..BZ["Northern Barrens"] };
		{ _RED.."17) "..BZ["Sun Rock Retreat"].." (50.4, 63.8), "..BZ["Stonetalon Mountains"] };
		{ _RED.."18) "..BZ["Krom'gar Fortress"].." (66.5, 64.2), "..BZ["Stonetalon Mountains"] };
		{ _RED.."19) "..BZ["Shadowprey Village"].." (24.1, 68.3), "..BZ["Desolace"] };
		{ ORNG.."20) "..BZ["Karnum's Glade"].." (56.7, 50.1), "..BZ["Desolace"] };
		{ _RED.."21) "..BZ["Thunder Bluff"].." (45.6, 64.9), "..BZ["Thunder Bluff"] };
		{ _RED.."22) "..BZ["Bloodhoof Village"].." (46.8, 60.4), "..BZ["Mulgore"] };
		{ _RED.."23) "..BZ["Hunter's Hill"].." (39.3, 20.1), "..BZ["Southern Barrens"] };
		{ _RED.."24) "..BZ["Desolation Hold"].." (40.7, 69.3), "..BZ["Southern Barrens"] };
		{ _RED.."25) "..BZ["Brackenwall Village"].." (36.8, 32.4), "..BZ["Dustwallow Marsh"] };
		{ ORNG.."26) "..BZ["Mudsprocket"].." (41.9, 74.1), "..BZ["Dustwallow Marsh"] };
		{ _RED.."27) "..BZ["Camp Ataya"].." (41.4, 15.7), "..BZ["Feralas"] };
		{ _RED.."28) "..BZ["Stonemaul Hold"].." (52.0, 47.6), "..BZ["Feralas"] };
		{ _RED.."29) "..BZ["Camp Mojache"].." (74.8, 45.1), "..BZ["Feralas"] };
		{ ORNG.."30) "..BZ["Cenarion Hold"].." (55.5, 36.8), "..BZ["Silithus"] };
		{ ORNG.."31) "..BZ["Marshal's Stand"].." (55.3, 62.1), "..BZ["Un'Goro Crater"] };
		{ ORNG.."32) "..BZ["Gadgetzan"].." (52.6, 27.1), "..BZ["Tanaris"] };
		{ ORNG.."33) "..BZ["Bootlegger Outpost"].." (55.7, 61.0), "..BZ["Tanaris"] };
		{ ORNG.."34) "..BZ["Oasis of Vir'sar"].." (26.6, 7.2), "..BZ["Uldum"] };
		{ ORNG.."35) "..BZ["Ramkahen"].." (54.7, 33.0), "..BZ["Uldum"] };
	};
	Hallow_End_Alliance_Northrend = {
		ZoneName = { AL["Hallow's End"].." - "..FACTION_ALLIANCE.." - "..BZ["Northrend"] };
		{ ORNG..AL["Hallow's End"].." - "..AL["Hallow_Date"] };
		{ "" };
		{ WHIT..AL["Candy Buckets"] };
		{ BLUE.." 1) "..BZ["Valiance Keep"].." (58.5, 67.8), "..BZ["Borean Tundra"] };
		{ BLUE.." 2) "..BZ["Fizzcrank Airstrip"].." (57.1, 18.8), "..BZ["Borean Tundra"] };
		{ ORNG.." 3) "..BZ["Unu'pe"].." (78.4 49.1), "..BZ["Borean Tundra"] };
		{ BLUE.." 4) "..BZ["Stars' Rest"].." (28.9, 56.2), "..BZ["Dragonblight"] };
		{ ORNG.." 5) "..BZ["Moa'ki Harbor"].." (48.1, 74.6), "..BZ["Dragonblight"] };
		{ ORNG.." 6) "..BZ["Wyrmrest Temple"].." (60.1, 53.4), "..BZ["Dragonblight"] };
		{ BLUE.." 7) "..BZ["Wintergarde Keep"].." (77.5, 51.2), "..BZ["Dragonblight"] };
		{ ORNG.." 8) "..BZ["Nesingwary Base Camp"].." (26.6, 59.2), "..BZ["Sholazar Basin"] };
		{ ORNG.." 9) "..BZ["The Legerdemain Lounge"].." (48.3, 40.8), "..BZ["Dalaran"] };
		{ ORNG.."10) "..BZ["The Underbelly"].." (37.8, 46.4), "..BZ["Dalaran"] };
		{ BLUE.."11) "..BZ["The Silver Enclave"].." (42.3, 63), "..BZ["Dalaran"] };
		{ BLUE.."12) "..BZ["Frosthold"].." (28.7, 74.2), "..BZ["The Storm Peaks"] };
		{ ORNG.."13) "..BZ["K3"].." (41, 85.8), "..BZ["The Storm Peaks"] };
		{ ORNG.."14) "..BZ["Bouldercrag's Refuge"].." (30.9, 37.1), "..BZ["The Storm Peaks"] };
		{ ORNG.."15) "..BZ["The Argent Stand"].." (40.8, 66.0), "..BZ["Zul'Drak"] };
		{ ORNG.."16) "..BZ["Zim'Torga"].." (59.3, 57.1), "..BZ["Zul'Drak"] };
		{ BLUE.."17) "..BZ["Amberpine Lodge"].." (31.9, 60.2), "..BZ["Grizzly Hills"] };
		{ BLUE.."18) "..BZ["Westfall Brigade"].." (59.6, 26.3), "..BZ["Grizzly Hills"] };
		{ ORNG.."19) "..BZ["Kamagua"].." (25.4, 59.8), "..BZ["Howling Fjord"] };
		{ BLUE.."20) "..BZ["Westguard Keep"].." (30.8, 41.4), "..BZ["Howling Fjord"] };
		{ BLUE.."21) "..BZ["Fort Wildervar"].." (60.4, 15.9), "..BZ["Howling Fjord"] };
		{ BLUE.."22) "..BZ["Valgarde"].." (58.3, 62.8), "..BZ["Howling Fjord"] };
	};
	Hallow_End_Horde_Northrend = {
		ZoneName = { AL["Hallow's End"].." - "..FACTION_HORDE.." - "..BZ["Northrend"] };
		{ ORNG..AL["Hallow's End"].." - "..AL["Hallow_Date"] };
		{ "" };
		{ WHIT..AL["Candy Buckets"] };
		{ _RED.." 1) "..BZ["Warsong Hold"].." (41.7, 54.4), "..BZ["Borean Tundra"] };
		{ _RED.." 2) "..BZ["Bor'gorok Outpost"].." (49.7 9.9), "..BZ["Borean Tundra"] };
		{ _RED.." 3) "..BZ["Taunka'le Village"].." (76.6, 37.4), "..BZ["Borean Tundra"] };
		{ ORNG.." 4) "..BZ["Unu'pe"].." (78.4 49.1), "..BZ["Borean Tundra"] };
		{ ORNG.." 5) "..BZ["Nesingwary Base Camp"].." (26.6, 59.2), "..BZ["Sholazar Basin"] };
		{ _RED.." 6) "..BZ["Agmar's Hammer"].." (37.8, 46.4), "..BZ["Dragonblight"] };
		{ ORNG.." 7) "..BZ["Moa'ki Harbor"].." (48.1, 74.6), "..BZ["Dragonblight"] };
		{ ORNG.." 8) "..BZ["Wyrmrest Temple"].." (60.1, 53.4), "..BZ["Dragonblight"] };
		{ _RED.." 9) "..BZ["Venomspite"].." (76.8, 63.2), "..BZ["Dragonblight"] };
		{ ORNG.."10) "..BZ["The Legerdemain Lounge"].." (48.3, 40.8), "..BZ["Dalaran"] };
		{ ORNG.."11) "..BZ["The Underbelly"].." (37.8, 46.4), "..BZ["Dalaran"] };
		{ _RED.."12) "..BZ["Sunreaver's Sanctuary"].." (66.8, 29.6), "..BZ["Dalaran"] };
		{ ORNG.."13) "..BZ["K3"].." (41, 85.8), "..BZ["The Storm Peaks"] };
		{ _RED.."14) "..BZ["Grom'arsh Crash-Site"].." (37, 49.5), "..BZ["The Storm Peaks"] };
		{ ORNG.."15) "..BZ["Bouldercrag's Refuge"].." (30.9, 37.1), "..BZ["The Storm Peaks"] };
		{ _RED.."16) "..BZ["Camp Tunka'lo"].." (67.6, 50.6), "..BZ["The Storm Peaks"] };
		{ ORNG.."17) "..BZ["The Argent Stand"].." (40.8, 66.0), "..BZ["Zul'Drak"] };
		{ ORNG.."18) "..BZ["Zim'Torga"].." (59.3, 57.1), "..BZ["Zul'Drak"] };
		{ _RED.."19) "..BZ["Conquest Hold"].." (20.8, 64.7), "..BZ["Grizzly Hills"] };
		{ _RED.."20) "..BZ["Camp Oneqwah"].." (65.3 47), "..BZ["Grizzly Hills"] };
		{ _RED.."21) "..BZ["Camp Winterhoof"].." (49.4, 10.7), "..BZ["Howling Fjord"] };
		{ _RED.."22) "..BZ["Vengeance Landing"].." (79.2, 30.6), "..BZ["Howling Fjord"] };
		{ ORNG.."23) "..BZ["Kamagua"].." (25.4, 59.8), "..BZ["Howling Fjord"] };
		{ _RED.."24) "..BZ["New Agamand"].." (52.1, 66.1), "..BZ["Howling Fjord"] };
	};
	Hallow_End_Alliance_Outland = {
		ZoneName = { AL["Hallow's End"].." - "..FACTION_ALLIANCE.." - "..BZ["Outland"] };
		{ ORNG..AL["Hallow's End"].." - "..AL["Hallow_Date"] };
		{ "" };
		{ WHIT..AL["Candy Buckets"] };
		{ ORNG.." 1) "..BZ["The Stormspire"].." (43.4, 36.1), "..BZ["Netherstorm"] };
		{ ORNG.." 2) "..BZ["Area 52"].." (32.1, 64.5), "..BZ["Netherstorm"] };
		{ ORNG.." 3) "..BZ["Evergrove"].." (62.9, 38.3), "..BZ["Blade's Edge Mountains"] };
		{ ORNG.." 4) "..BZ["Sylvanaar"].." (35.8, 63.7), "..BZ["Blade's Edge Mountains"] };
		{ ORNG.." 5) "..BZ["Toshley's Station"].." (61.1, 68.1), "..BZ["Blade's Edge Mountains"] };
		{ BLUE.." 6) "..BZ["Orebor Harborage"].." (41.9, 26.2), "..BZ["Zangarmarsh"] };
		{ BLUE.." 7) "..BZ["Telredor"].." (67.2, 48.9), "..BZ["Zangarmarsh"] };
		{ ORNG.." 8) "..BZ["Cenarion Refuge"].." (78.5, 62.9), "..BZ["Zangarmarsh"] };
		{ BLUE.." 9) "..BZ["Temple of Telhamat"].." (23.4, 36.4), "..BZ["Hellfire Peninsula"] };
		{ BLUE.."10) "..BZ["Honor Hold"].." (54.2, 63.7), "..BZ["Hellfire Peninsula"] };
		{ BLUE.."11) "..BZ["Telaar"].." (54.2, 75.9), "..BZ["Nagrand"] };
		{ ORNG.."12) "..BZ["Aldor Rise"].." (28.1, 49.0), "..BZ["Shattrath City"] };
		{ ORNG.."13) "..BZ["Scryer's Tier"].." (56.2, 81.8), "..BZ["Shattrath City"] };
		{ BLUE.."14) "..BZ["Allerian Stronghold"].." (56.6, 53.2), "..BZ["Terokkar Forest"] };
		{ BLUE.."15) "..BZ["Wildhammer Stronghold"].." (37.0, 58.3), "..BZ["Shadowmoon Valley"] };
		{ ORNG.."16) "..BZ["Altar of Sha'tar"].." (61.0, 28.2), "..BZ["Shadowmoon Valley"] };
		{ ORNG.."17) "..BZ["Sanctum of the Stars"].." (56.3, 59.8), "..BZ["Shadowmoon Valley"] };
	};
	Hallow_End_Horde_Outland = {
		ZoneName = { AL["Hallow's End"].." - "..FACTION_HORDE.." - "..BZ["Outland"] };
		{ ORNG..AL["Hallow's End"].." - "..AL["Hallow_Date"] };
		{ "" };
		{ WHIT..AL["Candy Buckets"] };
		{ ORNG.." 1) "..BZ["The Stormspire"].." (43.4, 36.1), "..BZ["Netherstorm"] };
		{ ORNG.." 2) "..BZ["Area 52"].." (32.1, 64.5), "..BZ["Netherstorm"] };
		{ ORNG.." 3) "..BZ["Evergrove"].." (62.9, 38.3), "..BZ["Blade's Edge Mountains"] };
		{ _RED.." 4) "..BZ["Thunderlord Stronghold"].." (53.4, 55.5), "..BZ["Blade's Edge Mountains"] };
		{ _RED.." 5) "..BZ["Mok'Nathal Village"].." (76.2, 60.4), "..BZ["Blade's Edge Mountains"] };
		{ _RED.." 6) "..BZ["Zabra'jin"].." (30.7, 50.9), "..BZ["Zangarmarsh"] };
		{ ORNG.." 7) "..BZ["Cenarion Refuge"].." (78.5, 62.9), "..BZ["Zangarmarsh"] };
		{ _RED.." 8) "..BZ["Falcon Watch"].." (26.9, 59.6), "..BZ["Hellfire Peninsula"] };
		{ _RED.." 9) "..BZ["Thrallmar"].." (56.8, 37.5), "..BZ["Hellfire Peninsula"] };
		{ _RED.."10) "..BZ["Garadar"].." (56.7, 34.6), "..BZ["Nagrand"] };
		{ ORNG.."11) "..BZ["Aldor Rise"].." (28.1, 49.0), "..BZ["Shattrath City"] };
		{ ORNG.."12) "..BZ["Scryer's Tier"].." (56.2, 81.8), "..BZ["Shattrath City"] };
		{ _RED.."13) "..BZ["Stonebreaker Hold"].." (48.8, 45.2), "..BZ["Terokkar Forest"] };
		{ _RED.."14) "..BZ["Shadowmoon Village"].." (30.3, 27.8), "..BZ["Shadowmoon Valley"] };
		{ ORNG.."15) "..BZ["Altar of Sha'tar"].." (61.0, 28.2), "..BZ["Shadowmoon Valley"] };
		{ ORNG.."16) "..BZ["Sanctum of the Stars"].." (56.3, 59.8), "..BZ["Shadowmoon Valley"] };
	};
	Hallow_End_Alliance_Pandaria = {
		ZoneName = { AL["Hallow's End"].." - "..FACTION_ALLIANCE.." - "..BZ["Pandaria"] };
		{ ORNG..AL["Hallow's End"].." - "..AL["Hallow_Date"] };
		{ "" };
		{ WHIT..AL["Candy Buckets"] };
		{ BLUE.." 1) "..BZ["Pearlfin Village"].." (59.6, 83.2), "..BZ["The Jade Forest"] };
		{ BLUE.." 2) "..BZ["Paw'don Village"].." (44.8, 84.4), "..BZ["The Jade Forest"] };
		{ ORNG.." 3) "..BZ["Jade Temple Grounds"].." (54.6, 63.3), "..BZ["The Jade Forest"] };
		{ ORNG.." 4) "..BZ["Dawn's Blossom"].." (45.7, 43.6), "..BZ["The Jade Forest"] };
		{ ORNG.." 5) "..BZ["Greenstone Village"].." (48.0, 34.6), "..BZ["The Jade Forest"] };
		{ ORNG.." 6) "..BZ["Tian Monastery"].." (41.6, 23.1), "..BZ["The Jade Forest"] };
		{ ORNG.." 7) "..BZ["Sri-La Village"].." (55.7, 24.4), "..BZ["The Jade Forest"] };
		{ ORNG.." 8) "..BZ["Zouchin Village"].." (62.3, 29), "..BZ["Kun-Lai Summit"] };
		{ ORNG.." 9) "..BZ["The Grummle Bazaar"].." (64.2, 61.2), "..BZ["Kun-Lai Summit"] };
		{ ORNG.."10) "..BZ["One Keg"].." (57.4, 59.9), "..BZ["Kun-Lai Summit"] };
		{ BLUE.."11) "..BZ["Westwind Rest"].." (54.1, 82.8), "..BZ["Kun-Lai Summit"] };
		{ ORNG.."12) "..BZ["Binan Village"].." (72.7, 92.2), "..BZ["Kun-Lai Summit"] };
		{ ORNG.."13) "..BZ["Longying Outpost"].." (71.1, 57.8), "..BZ["Townlong Steppes"] };
		{ ORNG.."14) "..BZ["Klaxxi'vess"].." (55.9, 32.2), "..BZ["Dread Wastes"] };
		{ ORNG.."15) "..BZ["Soggy's Gamble"].." (55.2, 71.2), "..BZ["Dread Wastes"] };
		{ ORNG.."16) "..BZ["Mistfall Village"].." (35.1, 77.7), "..BZ["Vale of Eternal Blossoms"] };
		{ BLUE.."17) "..BZ["Shrine of Seven Stars"].." (87.0, 69.0), "..BZ["Vale of Eternal Blossoms"] };
		{ ORNG.."18) "..BZ["Tavern in the Mists"].." (55.0, 72.2), "..BZ["The Veiled Stair"] };
		{ ORNG.."19) "..BZ["Stoneplow"].." (19.8, 55.7), "..BZ["Valley of the Four Winds"] };
		{ ORNG.."20) "..BZ["Pang's Stead"].." (83.6, 20.1), "..BZ["Valley of the Four Winds"] };
		{ ORNG.."21) "..BZ["Zhu's Watch"].." (75.9, 6.87), "..BZ["Krasarang Wilds"] };
		{ ORNG.."22) "..BZ["Marista"].." (51.4, 77.2), "..BZ["Krasarang Wilds"] };
	};		
	Hallow_End_Horde_Pandaria = {
		ZoneName = { AL["Hallow's End"].." - "..FACTION_HORDE.." - "..BZ["Pandaria"] };
		{ ORNG..AL["Hallow's End"].." - "..AL["Hallow_Date"] };
		{ "" };
		{ WHIT..AL["Candy Buckets"] };
		{ _RED.." 1) "..BZ["Honeydew Village"].." (28.4, 13.2), "..BZ["The Jade Forest"] };
		{ ORNG.." 2) "..BZ["Sri-La Village"].." (55.7, 24.4), "..BZ["The Jade Forest"] };
		{ ORNG.." 3) "..BZ["Tian Monastery"].." (41.6, 23.1), "..BZ["The Jade Forest"] };
		{ ORNG.." 4) "..BZ["Greenstone Village"].." (48.0, 34.6), "..BZ["The Jade Forest"] };
		{ ORNG.." 5) "..BZ["Dawn's Blossom"].." (45.7, 43.6), "..BZ["The Jade Forest"] };
		{ ORNG.." 6) "..BZ["Jade Temple Grounds"].." (54.6, 63.3), "..BZ["The Jade Forest"] };
		{ _RED.." 7) "..BZ["Grookin Hill"].." (28, 47.4), "..BZ["The Jade Forest"] };
		{ ORNG.." 8) "..BZ["Zouchin Village"].." (62.3, 29), "..BZ["Kun-Lai Summit"] };
		{ ORNG.." 9) "..BZ["The Grummle Bazaar"].." (64.2, 61.2), "..BZ["Kun-Lai Summit"] };
		{ ORNG.."10) "..BZ["One Keg"].." (57.4, 59.9), "..BZ["Kun-Lai Summit"] };
		{ _RED.."11) "..BZ["Eastwind Rest"].." (62.7, 80.5), "..BZ["Kun-Lai Summit"] };
		{ ORNG.."12) "..BZ["Binan Village"].." (72.7, 92.2), "..BZ["Kun-Lai Summit"] };
		{ ORNG.."13) "..BZ["Longying Outpost"].." (71.1, 57.8), "..BZ["Townlong Steppes"] };
		{ ORNG.."14) "..BZ["Klaxxi'vess"].." (55.9, 32.2), "..BZ["Dread Wastes"] };
		{ ORNG.."15) "..BZ["Soggy's Gamble"].." (55.2, 71.2), "..BZ["Dread Wastes"] };
		{ ORNG.."16) "..BZ["Mistfall Village"].." (35.1, 77.7), "..BZ["Vale of Eternal Blossoms"] };
		{ ORNG.."24) "..BZ["Marista"].." (51.4, 77.2), "..BZ["Krasarang Wilds"] };
		{ _RED.."17) "..BZ["Shrine of Two Moons"].." (61.9, 16.2), "..BZ["Vale of Eternal Blossoms"] };
		{ ORNG.."18) "..BZ["Tavern in the Mists"].." (55.0, 72.2), "..BZ["The Veiled Stair"] };
		{ ORNG.."19) "..BZ["Stoneplow"].." (19.8, 55.7), "..BZ["Valley of the Four Winds"] };
		{ ORNG.."20) "..BZ["Pang's Stead"].." (83.6, 20.1), "..BZ["Valley of the Four Winds"] };
		{ ORNG.."21) "..BZ["Zhu's Watch"].." (75.9, 6.87), "..BZ["Krasarang Wilds"] };
		{ _RED.."22) "..BZ["Thunder Cleft"].." (61.0, 25.1), "..BZ["Krasarang Wilds"] };
		{ _RED.."23) "..BZ["Dawnchaser Retreat"].." (28.2, 50.7), "..BZ["Krasarang Wilds"] };
	};
	Harvest = {
		ZoneName = { AL["Harvest Festival"] };
		Location = { BZ["Dun Morogh"].." / "..BZ["Western Plaguelands"].." / "..BZ["Durotar"].." / "..BZ["Ashenvale"] };
		{ ORNG..AL["Harvest Festival"].." - "..AL["Harvest_Date"] };
		{ "" };
		{ BLUE..AL["Alliance Questline"] };
		{ YELL.." 1) "..AL["Quest: "]..AL["Honoring a Hero"] };
		{ BLUE..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Wagner Hammerstrike"].." (60, 34), " };
		{ GREY..INDENT..INDENT..BZ["Dun Morogh"] };
		{ BLUE..INDENT.." 2) "..AL["Quest Destination"]..": "..BZ["Uther's Tomb"].." (52, 83)" };
		{ GREY..INDENT..INDENT..BZ["Western Plaguelands"] };
		{ "" };
		{ _RED..AL["Horde Questline"] };
		{ YELL.." 1) "..AL["Quest: "]..AL["Honoring a Hero"] };
		{ _RED..INDENT.." 1) "..AL["Start"].." / "..AL["End"]..": "..AL["Javnir Nashak"].." (46, 15), " };
		{ GREY..INDENT..INDENT..BZ["Durotar"] };
		{ _RED..INDENT.." 2) "..AL["Quest Destination"]..": "..BZ["Demon Fall Canyon"].." (54, 45)" };
		{ GREY..INDENT..INDENT..BZ["Ashenvale"] };
	};
	Love_Alliance_MajorCities = {
		ZoneName = { AL["Love is in the Air"].." - "..FACTION_ALLIANCE.." ("..AL["Major Cities"]..")" };
		Location = { BZ["Ironforge"].." / "..BZ["Stormwind City"].." / "..BZ["Darnassus"].." / "..BZ["The Exodar"] };
		{ ORNG..AL["Love is in the Air"].." - "..AL["Love_Date"] };
		{ "" };
		{ BLUE..AL["Alliance Questline"] };
		{ YELL.." 1) "..AL["Quest: "]..AL["Uncommon Scents"] };
		{ GREN..INDENT..AL["Start"]..": "..AL["Junior Detective"] };
		{ GREN..INDENT..INDENT.." 2) "..GREY.."(35, 69) "..BZ["Ironforge"] };
		{ GREN..INDENT..INDENT.." 6) "..GREY.."(76, 57) "..BZ["The Exodar"] };
		{ GREN..INDENT..INDENT.." 7) "..GREY.."(44, 56) "..BZ["Darnassus"] };
		{ GREN..INDENT..AL["End"]..": "..AL["Inspector Snip Snagglebolt"] };
		{ GREN..INDENT..INDENT.." 4) "..GREY.."(61, 75) "..BZ["Stormwind City"] };
		{ YELL.." 2) "..AL["Quest: "]..AL["Something Stinks"] };
		{ GREN..INDENT..AL["Start"].." / "..AL["End"]..": "..AL["Inspector Snip Snagglebolt"] };
		{ GREN..INDENT..INDENT.." 4) "..GREY.."(61, 75) "..BZ["Stormwind City"] };
		{ YELL.." 3) "..AL["Quest: "]..AL["Pilfering Perfume"] };
		{ GREN..INDENT..AL["Start"].." / "..AL["End"]..": "..AL["Inspector Snip Snagglebolt"] };
		{ GREN..INDENT..INDENT.." 4) "..GREY.."(61, 75) "..BZ["Stormwind City"] };
		{ YELL.." 4) "..AL["Quest: "]..AL["Fireworks At The Gilded Rose"] };
		{ GREN..INDENT..AL["Start"]..": "..AL["Inspector Snip Snagglebolt"] };
		{ GREN..INDENT..INDENT.." 4) "..GREY.."(61, 75) "..BZ["Stormwind City"] };
		{ GREN..INDENT..AL["End"]..": "..AL["Marion Sutton"] };
		{ GREN..INDENT..INDENT.." 4) "..GREY.."(60, 76) "..AL["The Gilded Rose"]..", "..BZ["Trade District"]..", "..BZ["Stormwind City"] };
		{ YELL.." 5) "..AL["Quest: "]..AL["Hot On The Trail"] };
		{ GREN..INDENT..AL["Start"].." / "..AL["End"]..": "..AL["Marion Sutton"] };
		{ GREN..INDENT..INDENT.." 4) "..GREY.."(60, 76) "..AL["The Gilded Rose"]..", "..BZ["Trade District"]..", "..BZ["Stormwind City"] };
		{ YELL.." 6) "..AL["Quest: "]..AL["A Friendly Chat..."] };
		{ GREN..INDENT..AL["Start"]..": "..AL["Marion Sutton"] };
		{ GREN..INDENT..INDENT.." 4) "..GREY.."(60, 76) "..AL["The Gilded Rose"]..", "..BZ["Trade District"]..", "..BZ["Stormwind City"] };
		{ GREN..INDENT..AL["End"]..": "..AL["Inspector Snip Snagglebolt"] };
		{ GREN..INDENT..INDENT.." 4) "..GREY.."(61, 75) "..BZ["Stormwind City"] };
		{ YELL.." 7) "..AL["Quest: "]..AL["Something is in the Air (and it Ain't Love)"] };
		{ WHIT..INDENT..AL["Start"]..": "..AL["Faded Lovely Greeting Card"] };
		{ GREN..INDENT..AL["End"]..": "..AL["Inspector Snip Snagglebolt"] };
		{ GREN..INDENT..INDENT.." 4) "..GREY.."(61, 75) "..BZ["Stormwind City"] };
		{ "" };
		{ BLUE..AL["Daily Quest"] };
		{ CYAN.." 1) "..AL["A gift for a Lord of Ironforge"] };
		{ GREN..INDENT..AL["Start"]..": "..AL["Kwee Q. Peddlefeet"] };
		{ GREN..INDENT..INDENT.." 1) "..GREY.."(33, 66) "..BZ["Ironforge"] };
		{ GREN..INDENT..AL["End"]..": "..AL["Muradin Bronzebeard"] };
		{ GREN..INDENT..INDENT.." 3) "..GREY.."(40, 55) "..BZ["Ironforge"] };
		{ CYAN.." 2) "..AL["A gift for a Lord of Stormwind"] };
		{ GREN..INDENT..AL["Start"]..": "..AL["Kwee Q. Peddlefeet"] };
		{ GREN..INDENT..INDENT.." 4) "..GREY.."(62, 75) "..BZ["Stormwind City"] };
		{ GREN..INDENT..AL["End"]..": "..AL["King Varian Wrynn"] };
		{ GREN..INDENT..INDENT.." 5) "..GREY.."(85, 31) "..BZ["Stormwind City"] };
		{ CYAN.." 3) "..AL["A Gift for the Prophet"] };
		{ GREN..INDENT..AL["Start"]..": "..AL["Kwee Q. Peddlefeet"] };
		{ GREN..INDENT..INDENT.." 6) "..GREY.."(73, 56) "..BZ["The Exodar"] };
		{ GREN..INDENT..AL["End"]..": "..AL["Prophet Velen"] };
		{ GREN..INDENT..INDENT..GREY.."(54, 55) "..BZ["Blood Watch"]..", "..BZ["Bloodmyst Isle"]..", "..BZ["The Exodar"] };
		{ CYAN.." 4) "..AL["A Gift for the High Priestess of Elune"] };
		{ GREN..INDENT..AL["Start"]..": "..AL["Kwee Q. Peddlefeet"] };
		{ GREN..INDENT..INDENT.." 7) "..GREY.."(45, 57) "..BZ["Darnassus"] };
		{ GREN..INDENT..AL["End"]..": "..AL["Tyrande Whisperwind"] };
		{ GREN..INDENT..INDENT.." 8) "..GREY.."(43, 77) "..BZ["Temple of the Moon"]..", "..BZ["Darnassus"] };
		{ CYAN.." 5) "..AL["Bonbon Blitz"] };
		{ CYAN.." 6) "..AL["A Perfect Puff of Perfume"] };
		{ CYAN.." 7) "..AL["A Cloudlet of Classy Cologne"] };
		{ GREN..INDENT..AL["Public Relations Agent"] };
		{ GREN..INDENT..INDENT.." 1) "..GREY.."(33, 66) "..BZ["Ironforge"] };
		{ GREN..INDENT..INDENT.." 4) "..GREY.."(62, 75) "..BZ["Stormwind City"] };
		{ GREN..INDENT..INDENT.." 6) "..GREY.."(73, 56) "..BZ["The Exodar"] };
		{ GREN..INDENT..INDENT.." 7) "..GREY.."(45, 57) "..BZ["Darnassus"] };
		{ CYAN.." 8) "..AL["Crushing the Crown"] };
		{ GREN..INDENT..AL["Inspector Snip Snagglebolt"] };
		{ GREN..INDENT..INDENT.." 4) "..GREY.."(61, 75) "..BZ["Stormwind City"] };
	};
	Love_Horde_MajorCities = {
		ZoneName = { AL["Love is in the Air"].." - "..FACTION_HORDE.." ("..AL["Major Cities"]..")" };
		Location = { BZ["Orgrimmar"].." / "..BZ["Undercity"].." / "..BZ["Thunder Bluff"].." / "..BZ["Silvermoon City"] };
		{ ORNG..AL["Love is in the Air"].." - "..AL["Love_Date"] };
		{ "" };
		{ BLUE..AL["Horde Questline"] };
		{ YELL.." 1) "..AL["Quest: "]..AL["Uncommon Scents"] };
		{ GREN..INDENT..AL["Start"]..": "..AL["Junior Detective"] };
		{ GREN..INDENT..INDENT.." 1) "..GREY.."(64, 37) "..BZ["Undercity"] };
		{ GREN..INDENT..INDENT.." 8) "..GREY.."(64, 70) "..BZ["Silvermoon City"] };
		{ GREN..INDENT..INDENT.."10) "..GREY.."(44, 55) "..BZ["Thunder Bluff"] };
		{ GREN..INDENT..AL["End"]..": "..AL["Detective Snap Snagglebolt"] };
		{ GREN..INDENT..INDENT.." 5) "..GREY.."(50, 75) "..BZ["Orgrimmar"] };
		{ YELL.." 2) "..AL["Quest: "]..AL["Something Stinks"] };
		{ GREN..INDENT..AL["Start"].." / "..AL["End"]..": "..AL["Detective Snap Snagglebolt"] };
		{ GREN..INDENT..INDENT.." 5) "..GREY.."(50, 75) "..BZ["Orgrimmar"] };
		{ YELL.." 3) "..AL["Quest: "]..AL["Pilfering Perfume"] };
		{ GREN..INDENT..AL["Start"].." / "..AL["End"]..": "..AL["Detective Snap Snagglebolt"] };
		{ GREN..INDENT..INDENT.." 5) "..GREY.."(50, 75) "..BZ["Orgrimmar"] };
		{ YELL.." 4) "..AL["Quest: "]..AL["Snivel's Sweetheart"] };
		{ GREN..INDENT..AL["Start"]..": "..AL["Detective Snap Snagglebolt"] };
		{ GREN..INDENT..INDENT.." 5) "..GREY.."(50, 75) "..BZ["Orgrimmar"] };
		{ GREN..INDENT..AL["End"]..": "..AL["Roka"] };
		{ GREN..INDENT..INDENT.." 6) "..GREY.."(57, 60) "..AL["Gotri's Traveling Gear"]..", "..BZ["The Drag"]..", "..BZ["Orgrimmar"] };
		{ YELL.." 5) "..AL["Quest: "]..AL["Hot On The Trail"] };
		{ GREN..INDENT..AL["Start"].." / "..AL["End"]..": "..AL["Roka"] };
		{ GREN..INDENT..INDENT.." 6) "..GREY.."(57, 60) "..AL["Gotri's Traveling Gear"]..", "..BZ["The Drag"]..", "..BZ["Orgrimmar"] };
		{ YELL.." 6) "..AL["Quest: "]..AL["A Friendly Chat..."] };
		{ GREN..INDENT..AL["Start"]..": "..AL["Roka"] };
		{ GREN..INDENT..INDENT.." 6) "..GREY.."(57, 60) "..AL["Gotri's Traveling Gear"]..", "..BZ["The Drag"]..", "..BZ["Orgrimmar"] };
		{ GREN..INDENT..AL["End"]..": "..AL["Detective Snap Snagglebolt"] };
		{ GREN..INDENT..INDENT.." 5) "..GREY.."(50, 75) "..BZ["Orgrimmar"] };
		{ YELL.." 7) "..AL["Quest: "]..AL["Something is in the Air (and it Ain't Love)"] };
		{ WHIT..INDENT..AL["Start"]..": "..AL["Faded Lovely Greeting Card"] };
		{ GREN..INDENT..AL["End"]..": "..AL["Detective Snap Snagglebolt"] };
		{ GREN..INDENT..INDENT.." 5) "..GREY.."(50, 75) "..BZ["Orgrimmar"] };
		{ "" };
		{ BLUE..AL["Daily Quest"] };
		{ CYAN.." 1) "..AL["A Gift for the Banshee Queen"] };
		{ GREN..INDENT..AL["Start"]..": "..AL["Kwee Q. Peddlefeet"] };
		{ GREN..INDENT..INDENT.." 2) "..GREY.."(66, 38) "..BZ["Undercity"] };
		{ GREN..INDENT..AL["End"]..": "..AL["Lady Sylvanas Windrunner"] };
		{ GREN..INDENT..INDENT.." 3) "..GREY.."(57, 91) "..BZ["Royal Quarter"]..", "..BZ["Undercity"] };
		{ CYAN.." 2) "..AL["A Gift for the Warchief"] };
		{ GREN..INDENT..AL["Start"]..": "..AL["Kwee Q. Peddlefeet"] };
		{ GREN..INDENT..INDENT.." 4) "..GREY.."(52, 76) "..BZ["Orgrimmar"] };
		{ GREN..INDENT..AL["End"]..": "..AL["King Varian Wrynn"] };
		{ GREN..INDENT..INDENT.." 5) "..GREY.."(85, 31) "..BZ["Orgrimmar"] };
		{ CYAN.." 3) "..AL["A Gift for the Regent Lord of Quel'Thalas"] };
		{ GREN..INDENT..AL["Start"]..": "..AL["Kwee Q. Peddlefeet"] };
		{ GREN..INDENT..INDENT.." 8) "..GREY.."(64, 66) "..BZ["Silvermoon City"] };
		{ GREN..INDENT..AL["End"]..": "..AL["Lor'themar Theron"] };
		{ GREN..INDENT..INDENT.." 9) "..GREY.."(54, 20) "..BZ["Silvermoon City"] };
		{ CYAN.." 4) "..AL["A Gift for the High Chieftain"] };
		{ GREN..INDENT..AL["Start"]..": "..AL["Kwee Q. Peddlefeet"] };
		{ GREN..INDENT..INDENT.."10) "..GREY.."(43, 52) "..BZ["Thunder Bluff"] };
		{ GREN..INDENT..AL["End"]..": "..AL["Baine Bloodhoof"] };
		{ GREN..INDENT..INDENT.."11) "..GREY.."(60, 51) "..BZ["Thunder Bluff"] };
		{ CYAN.." 5) "..AL["Bonbon Blitz"] };
		{ CYAN.." 6) "..AL["A Perfect Puff of Perfume"] };
		{ CYAN.." 7) "..AL["A Cloudlet of Classy Cologne"] };
		{ GREN..INDENT..AL["Public Relations Agent"] };
		{ GREN..INDENT..INDENT.." 2) "..GREY.."(66, 38) "..BZ["Undercity"] };
		{ GREN..INDENT..INDENT.." 4) "..GREY.."(52, 76) "..BZ["Orgrimmar"] };
		{ GREN..INDENT..INDENT.." 8) "..GREY.."(64, 66) "..BZ["Silvermoon City"] };
		{ GREN..INDENT..INDENT.."10) "..GREY.."(43, 52) "..BZ["Thunder Bluff"] };
		{ CYAN.." 8) "..AL["Crushing the Crown"] };
		{ GREN..INDENT..AL["Detective Snap Snagglebolt"] };
		{ GREN..INDENT..INDENT.." 5) "..GREY.."(50, 75) "..BZ["Orgrimmar"] };
	};
	Lunar_Azeroth = {
		ZoneName = { AL["Lunar Festival"].." - "..BZ["Eastern Kingdoms"] };
		{ ORNG..AL["Lunar Festival"].." - "..AL["Lunar_Date"] };
		{ "" };
		{ WHIT.." 1) "..AL["Elder Hammershout"]	..DASH..BLUE..BZ["Stormwind City"]..", "..BZ["Elwynn Forest"] };
		{ GREY..INDENT..AL["(Outside the city gate)"] };
		{ WHIT.." 2) "..AL["Elder Stormbrow"]	..DASH..BZ["Goldshire"]..", "..BZ["Elwynn Forest"] };
		{ WHIT.." 3) "..AL["Elder Skychaser"]	..DASH..BZ["Sentinel Hill"]..", "..BZ["Westfall"] };
		{ WHIT.." 4) "..AL["Elder Winterhoof"]	..DASH..BZ["Booty Bay"]..", "..BZ["The Cape of Stranglethorn"] };
		{ GREY..INDENT..AL["(On the roof of the bank)"] };
		{ WHIT.." 5) "..AL["Elder Starglade"]	..DASH..BZ["Zul'Gurub"]..", "..BZ["Northern Stranglethorn"] };
		{ GREY..INDENT..AL["(Outside the gate)"] };
		{ WHIT.." 6) "..AL["Elder Bellowrage"]	..DASH..BZ["The Dark Portal"]..", "..BZ["Blasted Lands"] };
		{ WHIT.." 7) "..AL["Elder Starsong"]	..DASH..ORNG..BZ["The Temple of Atal'Hakkar"]..", "..BZ["Swamp of Sorrows"] };
		{ WHIT.." 8) "..AL["Elder Rumblerock"]	..DASH..BZ["Dreadmaul Rock"]..", "..BZ["Burning Steppes"] };
		{ WHIT.." 9) "..AL["Elder Dawnstrider"]	..DASH..BZ["Flame Crest"]..", "..BZ["Burning Steppes"] };
		{ WHIT.."10) "..AL["Elder Stonefort"]	..DASH..ORNG..BZ["Blackrock Spire"].." ("..AL["Lower"].."), "..BZ["Burning Steppes"].." / "..BZ["Searing Gorge"] };
		{ GREY..INDENT.."("..BZ["Hordemar City"]..")" };
		{ WHIT.."11) "..AL["Elder Morndeep"]	..DASH..ORNG..BZ["Blackrock Depths"]..", "..BZ["Burning Steppes"].." / "..BZ["Searing Gorge"] };
		{ GREY..INDENT.."("..BZ["Ring of the Law"]..")" };
		{ WHIT.."12) "..AL["Elder Ironband"]	..DASH..BZ["Blackchar Cave"]..", "..BZ["Searing Gorge"] };
		{ WHIT.."13) "..AL["Elder Goldwell"] 	..DASH..BZ["Kharanos"]..", "..BZ["Dun Morogh"] };
		{ WHIT.."14) "..AL["Elder Bronzebeard"]	..DASH..BLUE..BZ["Ironforge"]..", "..BZ["Dun Morogh"] };
		{ GREY..INDENT.."("..BZ["The Mystic Ward"]..")" };
		{ WHIT.."15) "..AL["Elder Silvervein"]	..DASH..BZ["Thelsamar"]..", "..BZ["Loch Modan"] };
		{ WHIT.."16) "..AL["Elder Highpeak"]	..DASH..BZ["The Creeping Ruin"]..", "..BZ["The Hinterlands"] };
		{ WHIT.."17) "..AL["Elder Snowcrown"]	..DASH..BZ["Light's Hope Chapel"]..", "..BZ["Eastern Plaguelands"] };
		{ WHIT.."18) "..AL["Elder Windrun"]	..DASH..BZ["Crown Guard Tower"]..", "..BZ["Eastern Plaguelands"] };
		{ WHIT.."19) "..AL["Elder Farwhisper"]	..DASH..ORNG..BZ["Stratholme"]..DASH..BZ["Crusaders' Square"]..", "..BZ["Eastern Plaguelands"] };
		{ GREY..INDENT.."("..BZ["Festival Lane"]..")" };
		{ WHIT.."20) "..AL["Elder Moonstrike"]	..DASH..BZ["Scholomance"]..", "..BZ["Western Plaguelands"] };
		{ GREY..INDENT..AL["(The roof of Scholomance, outside the dungeon)"] };
		{ WHIT.."21) "..AL["Elder Meadowrun"]	..DASH..BZ["The Weeping Cave"]..", "..BZ["Western Plaguelands"] };
		{ WHIT.."22) "..AL["Elder Graveborn"]	..DASH..BZ["Brill"]..", "..BZ["Tirisfal Glades"] };
		{ WHIT.."23) "..AL["Elder Darkcore"]	..DASH..BLUE..BZ["Ruins of Lordaeron"]..", "..BZ["Undercity"]..", "..BZ["Tirisfal Glades"] };
		{ GREY..INDENT..AL["(On the ground)"] };
		{ WHIT.."24) "..AL["Elder Obsidian"]	..DASH..BZ["The Sepulcher"]..", "..BZ["Silverpine Forest"] };
		{ WHIT.."25) "..AL["Moonlance the Elder"] ..DASH..BZ["Biel'aran Ridge"]..", "..BZ["Shimmering Expanse"]..", "..BZ["Vashj'ir"] };
		{ WHIT.."26) "..AL["Firebeard the Elder"] ..DASH..BZ["Dunwald Town Square"]..", "..BZ["Twilight Highlands"] };
		{ WHIT.."27) "..AL["Darkfeather the Elder"] ..DASH..BZ["Thundermar Ruins"]..", "..BZ["Twilight Highlands"] };
	};
	Lunar_Kalimdor = {
		ZoneName = { AL["Lunar Festival"].." - "..BZ["Kalimdor"] };
		{ ORNG..AL["Lunar Festival"].." - "..AL["Lunar_Date"] };
		{ "" };
		{ GREN.." 1') "..AL["Valadar Starsong"]..DASH..BZ["Nighthaven"]..", "..BZ["Moonglade"] };
		{ GREY..INDENT..AL["Quest: Elune's Blessing"] };
		{ GREN..INDENT..AL["Fariel Starsong"]..DASH..BZ["Nighthaven"]..", "..BZ["Moonglade"] };
		{ GREN.." 2') "..AL["Omen"]..DASH..AL["Southeast coast of the Lake Elune'ara"]..", "..BZ["Moonglade"] };
		{ "" };
		{ WHIT.." 1) "..AL["Elder Bladeleaf"]	..DASH..BZ["Dolanaar"]..", "..BZ["Teldrassil"] };
		{ WHIT.." 2) "..AL["Elder Bladeswift"]	..DASH..BLUE..BZ["Darnassus"]..", "..BZ["Teldrassil"] };
		{ GREY..INDENT.."("..BZ["Cenarion Enclave"]..")" };
		{ WHIT.." 3) "..AL["Elder Starweave"]	..DASH..BZ["Lor'danel"]..", "..BZ["Darkshore"] };
		{ WHIT.." 4) "..AL["Elder Riversong"]	..DASH..BZ["Astranaar"]..", "..BZ["Ashenvale"] };
		{ WHIT.." 5) "..AL["Elder Nightwind"]	..DASH..BZ["Jaedenar"]..", "..BZ["Felwood"] };
		{ WHIT.." 6) "..AL["Elder Brightspear"]	..DASH..BZ["The Ruins of Kel'Theril"]..", "..BZ["Winterspring"] };
		{ WHIT.." 7) "..AL["Elder Stonespire"]	..DASH..BZ["Everlook"]..", "..BZ["Winterspring"] };
		{ WHIT.." 8) "..AL["Elder Skygleam"]	..DASH..BZ["Ravencrest Monument"]..", "..BZ["Azshara"] };
		{ WHIT.." 9) "..AL["Elder Darkhorn"]	..DASH..BLUE..BZ["Orgrimmar"]..", "..BZ["Durotar"] };
		{ GREY..INDENT..AL["(Next to the flight master)"] };
		{ WHIT.."10) "..AL["Runetotem the Elder"]	..DASH..BZ["Razor Hill"]..", "..BZ["Durotar"] };
		{ WHIT.."11) "..AL["Elder Windtotem"]	..DASH..BZ["Ratchet"]..", "..BZ["Northern Barrens"] };
		{ WHIT.."12) "..AL["Elder Moonwarden"]	..DASH..BZ["The Crossroads"]..", "..BZ["Northern Barrens"] };
		{ WHIT.."13) "..AL["Elder High Mountain"]	..DASH..BZ["Vendetta Point"]..", "..BZ["Southern Barrens"] };
		{ WHIT.."14) "..AL["Elder Bloodhoof"]	..DASH..BZ["Bloodhoof Village"]..", "..BZ["Mulgore"] };
		{ WHIT.."15) "..AL["Elder Ezra Wheathoof"]	..DASH..BLUE..BZ["Thunder Bluff"]..", "..BZ["Mulgore"] };
		{ GREY..INDENT.."("..BZ["Elder Rise"]..")" };
		{ WHIT.."16) "..AL["Elder Skyseer"]	..DASH..BZ["Freewind Post"]..", "..BZ["Thousand Needles"] };
		{ WHIT.."17) "..AL["Elder Morningdew"]	..DASH..BZ["Fizzle & Pozzik's Speedbarge"]..", "..BZ["Thousand Needles"] };
		{ WHIT.."18) "..AL["Elder Dreamseer"]	..DASH..BZ["Gadgetzan"]..", "..BZ["Tanaris"] };
		{ WHIT.."19) "..AL["Elder Wildmane"]	..DASH..ORNG..BZ["Zul'Farrak"]..", "..BZ["Tanaris"] };
		{ WHIT.."20) "..AL["Elder Ragetotem"]	..DASH..BZ["Valley of the Watchers"]..", "..BZ["Tanaris"] };
		{ WHIT.."21) "..AL["Elder Thunderhorn"]	..DASH..BZ["The Slithering Scar"]..", "..BZ["Un'Goro Crater"] };
		{ WHIT.."22) "..AL["Elder Bladesing"]	..DASH..BZ["Cenarion Hold"]..", "..BZ["Silithus"] };
		{ WHIT.."23) "..AL["Elder Primestone"]	..DASH..BZ["The Crystal Vale"]..", "..BZ["Silithus"] };
		{ WHIT.."24) "..AL["Grimtotem Elder"]	..DASH..BZ["Lariss Pavilion"]..", "..BZ["Feralas"] };
		{ WHIT.."25) "..AL["Elder Mistwalker"]	..DASH..BZ["Dire Maul"]..", "..BZ["Feralas"] };
		{ GREY..INDENT.."("..BZ["The Maul"]..", "..BZ["Broken Commons"]..")" };
		{ WHIT.."26) "..AL["Elder Splitrock"]	..DASH..ORNG..BZ["Maraudon"]..", "..BZ["Desolace"] };
		{ WHIT.."27) "..AL["Evershade the Elder"]..DASH..BZ["Nordrassil"]..", "..BZ["Mount Hyjal"] };
		{ WHIT.."28) "..AL["Windsong the Elder"]..DASH..BZ["Sanctuary of Malorne"]..", "..BZ["Mount Hyjal"] };
		{ WHIT.."29) "..AL["Menkhaf the Elder"]	..DASH..BZ["Khartut's Tomb"]..", "..BZ["Uldum"] };
		{ WHIT.."30) "..AL["Sekhemi the Elder"]	..DASH..BZ["Ruins of Ammon"]..", "..BZ["Uldum"] };
	};
	Lunar_Northrend = {
		ZoneName = { AL["Lunar Festival"].." - "..BZ["Northrend"] };
		{ ORNG..AL["Lunar Festival"].." - "..AL["Lunar_Date"] };
		{ "" };
		{ WHIT.." 1) "..AL["Elder Sardis"]	..DASH..BZ["Valiance Keep"]..", "..BZ["Borean Tundra"] };
		{ WHIT.." 3) "..AL["Elder Pamuya"]	..DASH..BZ["Warsong Hold"]..", "..BZ["Borean Tundra"] };
		{ WHIT.." 4) "..AL["Elder Northal"]	..DASH..BZ["Transitus Shield"]..", "..BZ["Borean Tundra"] };
		{ WHIT.." 5) "..AL["Elder Igasho"]	..DASH..ORNG..BZ["The Nexus"]..", "..BZ["Borean Tundra"] };
		{ GREY..INDENT.."("..BZ["The Singing Grove"]..")" };
		{ WHIT.." 2) "..AL["Elder Arp"]	..DASH..BZ["D.E.H.T.A. Encampment"]..", "..BZ["Borean Tundra"] };
		{ WHIT.." 6) "..AL["Elder Sandrene"]	..DASH..BZ["Lakeside Landing"]..", "..BZ["Sholazar Basin"] };
		{ WHIT.." 7) "..AL["Elder Wanikaya"]	..DASH..BZ["Rainspeaker Rapids"]..", "..BZ["Sholazar Basin"] };
		{ WHIT.." 8) "..AL["Elder Bluewolf"]	..DASH.._RED..BZ["Wintergrasp Fortress"]..", "..BZ["Wintergrasp"] };
		{ GREY..INDENT..AL["(Inside the fortress)"] };
		{ WHIT.." 9) "..AL["Elder Nurgen"]	..DASH..ORNG..BZ["Azjol-Nerub"]..", "..BZ["Dragonblight"] };
		{ GREY..INDENT.."("..BZ["The Brood Pit"]..")" };
		{ WHIT.."10) "..AL["Elder Morthie"]	..DASH..BZ["Stars' Rest"]..", "..BZ["Dragonblight"] };
		{ WHIT.."11) "..AL["Elder Skywarden"]	..DASH..BZ["Agmar's Hammer"]..", "..BZ["Dragonblight"] };
		{ WHIT.."12) "..AL["Elder Thoim"]	..DASH..BZ["Moa'ki Harbor"]..", "..BZ["Dragonblight"] };
		{ WHIT.."13) "..AL["Elder Graymane"]	..DASH..BZ["K3"]..", "..BZ["The Storm Peaks"] };
		{ WHIT.."14) "..AL["Elder Fargal"]	..DASH..BZ["Frosthold"]..", "..BZ["The Storm Peaks"] };
		{ WHIT.."15) "..AL["Elder Stonebeard"]	..DASH..BZ["Bouldercrag's Refuge"]..", "..BZ["The Storm Peaks"] };
		{ WHIT.."16) "..AL["Elder Yurauk"]	..DASH..ORNG..BZ["Halls of Stone"]..", "..BZ["The Storm Peaks"] };
		{ GREY..INDENT.."("..BZ["Crystalline Quarry"]..")" };
		{ WHIT.."17) "..AL["Elder Muraco"]	..DASH..BZ["Camp Tunka'lo"]..", "..BZ["The Storm Peaks"] };
		{ WHIT.."18) "..AL["Elder Ohanzee"]	..DASH..ORNG..BZ["Gundrak"]..", "..BZ["Zul'Drak"] };
		{ GREY..INDENT.."("..BZ["Pool of Twisted Reflections"]..")" };
		{ WHIT.."19) "..AL["Elder Tauros"]	..DASH..BZ["Zim'Torga"]..", "..BZ["Zul'Drak"] };
		{ WHIT.."20) "..AL["Elder Kilias"]	..DASH..ORNG..BZ["Drak'Tharon Keep"]..", "..BZ["Zul'Drak"] };
		{ GREY..INDENT.."("..BZ["Raptor Pens"]..")" };
		{ WHIT.."21) "..AL["Elder Beldak"]	..DASH..BZ["Westfall Brigade Encampment"]..", "..BZ["Grizzly Hills"] };
		{ WHIT.."22) "..AL["Elder Whurain"]	..DASH..BZ["Camp Oneqwah"]..", "..BZ["Grizzly Hills"] };
		{ WHIT.."23) "..AL["Elder Lunaro"]	..DASH..BZ["Ruins of Tethys"]..", "..BZ["Grizzly Hills"] };
		{ WHIT.."24) "..AL["Elder Jarten"]	..DASH..ORNG..BZ["Utgarde Keep"]..", "..BZ["Howling Fjord"] };
		{ GREY..INDENT.."("..BZ["Njorn Stair"]..")" };
		{ WHIT.."25) "..AL["Elder Chogan'gada"]	..DASH..ORNG..BZ["Utgarde Pinnacle"]..", "..BZ["Howling Fjord"] };
	};
	Lunar_Deepholm = {
		ZoneName = { AL["Lunar Festival"].." - "..BZ["Deepholm"] };
		{ ORNG..AL["Lunar Festival"].." - "..AL["Lunar_Date"] };
		{ "" };
		{ WHIT.." 1) "..AL["Elder Stonebrand"]	..DASH..BZ["Temple of Earth"] };
		{ WHIT.." 2) "..AL["Elder Deepforge"]	..DASH..BZ["Stonehearth"] };
	};
	MidSummer_Azeroth = {
		ZoneName = { AL["Midsummer Fire Festival"].." - "..BZ["Eastern Kingdoms"] };
		{ ORNG..AL["Midsummer Fire Festival"].." - "..AL["Midsummer_Date"] };
		{ "" };
		{ ORNG.." 1) "..BZ["Court of the Sun"].." (70, 43), "..BZ["Silvermoon City"] };
		{ _RED.." 2) "..BZ["North Sanctum"].." (46, 50), "..BZ["Eversong Woods"] };
		{ _RED.." 3) "..BZ["Tranquillien"].." (46, 26), "..BZ["Ghostlands"] };
		{ BLUE.." 4) "..BZ["Chillwind Camp"].." (43, 82), "..BZ["Western Plaguelands"] };
		{ _RED.." 5) "..BZ["The Bulwark"].." (29, 57), "..BZ["Western Plaguelands"] };
		{ _RED.." 6) "..BZ["Brill"].." (57, 52), "..BZ["Tirisfal Glades"] };
		{ ORNG.." 7) "..BZ["Ruins of Lordaeron"].." (68, 9), "..BZ["Tirisfal Glades"] };
		{ _RED.." 8) "..BZ["The Sepulcher"].." (49, 38), "..BZ["Silverpine Forest"] };
		{ _RED.." 9) "..BZ["Tarren Mill"].." (58, 25), "..BZ["Hillsbrad Foothills"] };
		{ BLUE.."10) "..BZ["Aerie Peak"].." (14, 50), "..BZ["The Hinterlands"] };
		{ _RED.."11) "..BZ["Revantusk Village"].." (76, 74), "..BZ["The Hinterlands"] };
		{ _RED.."12) "..BZ["Hammerfall"].." (74, 41), "..BZ["Arathi Highlands"] };
		{ BLUE.."13) "..BZ["Refuge Pointe"].." (50, 44), "..BZ["Arathi Highlands"] };
		{ BLUE.."14) "..BZ["Thundermar"].." (47, 28), "..BZ["Twilight Highlands"] };
		{ _RED.."15) "..BZ["Bloodgulch"].." (53, 46), "..BZ["Twilight Highlands"] };
		{ BLUE.."16) "..BZ["Menethil Harbor"].." (13, 47), "..BZ["Wetlands"] };
		{ ORNG.."17) "..BZ["Hall of Explorers"].." (64, 25), "..BZ["Ironforge"] };
		{ BLUE.."18) "..BZ["Kharanos"].." (46, 46), "..BZ["Dun Morogh"] };
		{ BLUE.."19) "..BZ["Thelsamar"].." (32, 40), "..BZ["Loch Modan"] };
		{ _RED.."20) "..BZ["New Kargath"].." (23, 37), "..BZ["Badlands"] };
		{ BLUE.."21) "..BZ["Dragon's Mouth"].." (18, 56), "..BZ["Badlands"] };
		{ _RED.."22) "..BZ["Flame Crest"].." (51, 29), "..BZ["Burning Steppes"] };
		{ BLUE.."23) "..BZ["Morgan's Vigil"].." (68, 60), "..BZ["Burning Steppes"] };
		{ BLUE.."24) "..BZ["Lakeshire"].." (25, 53), "..BZ["Redridge Mountains"] };
		{ BLUE.."25) "..BZ["Bogpaddle"].." (70, 15), "..BZ["Swamp of Sorrows"] };
		{ _RED.."26) "..BZ["Bogpaddle"].." (76, 13), "..BZ["Swamp of Sorrows"] };
		{ BLUE.."27) "..BZ["Nethergarde Supply Camps"].." (55, 15), "..BZ["Blasted Lands"] };
		{ _RED.."28) "..BZ["Dreadmaul Hold"].." (46, 14), "..BZ["Blasted Lands"] };
		{ BLUE.."29) "..BZ["Darkshire"].." (73, 55), "..BZ["Duskwood"] };
		{ BLUE.."30) "..BZ["Goldshire"].." (43, 65), "..BZ["Elwynn Forest"] };
		{ ORNG.."31) "..BZ["The Canals"].." (49, 72), "..BZ["Stormwind City"] };
		{ BLUE.."32) "..BZ["Moonbrook"].." (45, 62), "..BZ["Westfall"] };
		{ _RED.."33) "..BZ["Grom'gol Base Camp"].." (40, 51), "..BZ["Northern Stranglethorn"] };
		{ BLUE.."34) "..BZ["Fort Livingston"].." (51, 63), "..BZ["Northern Stranglethorn"] };
		{ BLUE.."35) "..BZ["Wild Shore"].." (51, 67), "..BZ["The Cape of Stranglethorn"] };
		{ _RED.."36) "..BZ["Wild Shore"].." (50, 70), "..BZ["The Cape of Stranglethorn"] };
		{ PURP.."37) "..BZ["Silver Tide Hollow"].."(49, 42), "..BZ["Shimmering Expanse"]..", "..BZ["Vashj'ir"] };
		{ "" };
		{ _RED..AL["Red: "]..FACTION_HORDE };
		{ BLUE..AL["Blue: "]..FACTION_ALLIANCE };
		{ ORNG..AL["Orange: "]..AL["Major Cities"] };
		{ PURP..AL["Purple: "]..FACTION_STANDING_LABEL4 };
	
	};
	MidSummer_Kalimdor = {
		ZoneName = { AL["Midsummer Fire Festival"].." - "..BZ["Kalimdor"] };
		{ ORNG..AL["Midsummer Fire Festival"].." - "..AL["Midsummer_Date"] };
		{ "" };
		{ BLUE.." 1) "..BZ["Dolanaar"].." (54, 52), "..BZ["Teldrassil"] };
		{ ORNG.." 2) "..BZ["Warrior's Terrace"].." (62, 49), "..BZ["Darnassus"] };
		{ ORNG.." 3) "..BZ["The Crystal Hall"].." (41, 26), "..BZ["The Exodar"] };
		{ BLUE.." 4) "..BZ["Azure Watch"].." (44, 53), "..BZ["Azuremyst Isle"] };
		{ BLUE.." 5) "..BZ["Blood Watch"].." (55, 69), "..BZ["Bloodmyst Isle"] };
		{ BLUE.." 6) "..BZ["Lor'danel"].." (49, 23), "..BZ["Darkshore"] };
		{ _RED.." 7) "..BZ["Everlook"].." (58, 47), "..BZ["Winterspring"] };
		{ BLUE.." 8) "..BZ["Everlook"].." (61, 47), "..BZ["Winterspring"] };
		{ PURP.." 9) "..BZ["Nordrassil"].." (63, 23), "..BZ["Mount Hyjal"] };
		{ _RED.."10) "..BZ["Bilgewater Harbor"].." (60, 53), "..BZ["Azshara"] };
		{ ORNG.."11) "..BZ["Valley of Wisdom"].." (47, 38), "..BZ["Orgrimmar"] };
		{ _RED.."12) "..BZ["Razor Hill"].." (52, 47), "..BZ["Durotar"] };
		{ _RED.."13) "..BZ["The Crossroads"].." (50, 55), "..BZ["Northern Barrens"] };
		{ BLUE.."14) "..BZ["Forest Song"].." (87, 42), "..BZ["Ashenvale"] };
		{ _RED.."15) "..BZ["Silverwind Refuge"].." (51, 66), "..BZ["Ashenvale"] };
		{ _RED.."16) "..BZ["Sun Rock Retreat"].." (53, 62), "..BZ["Stonetalon Mountains"] };
		{ BLUE.."17) "..BZ["Mirkfallon Lake"].." (49, 51), "..BZ["Stonetalon Mountains"] };
		{ BLUE.."18) "..BZ["Nijel's Point"].." (65, 17), "..BZ["Desolace"] };
		{ _RED.."19) "..BZ["Shadowprey Village"].." (26, 76), "..BZ["Desolace"] };
		{ ORNG.."20) "..BZ["Spirit Rise"].." (21, 26), "..BZ["Thunder Bluff"] };
		{ _RED.."21) "..BZ["Bloodhoof Village"].." (51, 60), "..BZ["Mulgore"] };
		{ _RED.."22) "..BZ["Desolation Hold"].." (40, 67), "..BZ["Southern Barrens"] };
		{ BLUE.."23) "..BZ["Fort Triumph"].." (48, 72), "..BZ["Southern Barrens"] };
		{ _RED.."24) "..BZ["Brackenwall Village"].." (33, 30), "..BZ["Dustwallow Marsh"] };
		{ BLUE.."25) "..BZ["Theramore Isle"].." (62, 40), "..BZ["Dustwallow Marsh"] };
		{ BLUE.."26) "..BZ["Gadgetzan"].." (52, 30), "..BZ["Tanaris"] };
		{ _RED.."27) "..BZ["Gadgetzan"].." (49, 28), "..BZ["Tanaris"] };
		{ BLUE.."28) "..BZ["Vir'naal Oasis"].." (53, 32), "..BZ["Uldum"] };
		{ _RED.."29) "..BZ["Vir'naal Oasis"].." (53, 34), "..BZ["Uldum"] };
		{ _RED.."30) "..BZ["Marshal's Stand"].." (56, 66), "..BZ["Un'Goro Crater"] };
		{ _RED.."31) "..BZ["Marshal's Stand"].." (60, 63), "..BZ["Un'Goro Crater"] };
		{ BLUE.."32) "..BZ["Cenarion Hold"].." (60, 33), "..BZ["Silithus"] };
		{ _RED.."33) "..BZ["Cenarion Hold"].." (51, 41), "..BZ["Silithus"] };
		{ BLUE.."34) "..BZ["Feathermoon Stronghold"].." (47, 44), "..BZ["Feralas"] };
		{ _RED.."35) "..BZ["Camp Mojache"].." (72, 47), "..BZ["Feralas"] };
		{ "" };
		{ _RED..AL["Red: "]..FACTION_HORDE };
		{ BLUE..AL["Blue: "]..FACTION_ALLIANCE };
		{ ORNG..AL["Orange: "]..AL["Major Cities"] };
		{ PURP..AL["Purple: "]..FACTION_STANDING_LABEL4 };
	};
	MidSummer_Outland = {
		ZoneName = { AL["Midsummer Fire Festival"].." - "..BZ["Outland"] };
		{ ORNG..AL["Midsummer Fire Festival"].." - "..AL["Midsummer_Date"] };
		{ "" };
		{ BLUE.." 1) "..BZ["Honor Hold"].." (62, 58), "..BZ["Hellfire Peninsula"] };
		{ _RED.." 2) "..BZ["Thrallmar"].." (55, 40), "..BZ["Hellfire Peninsula"] };
		{ BLUE.." 3) "..BZ["Telredor"].." (69, 52), "..BZ["Zangarmarsh"] };
		{ _RED.." 4) "..BZ["Zabra'jin"].." (36, 52), "..BZ["Zangarmarsh"] };
		{ BLUE.." 5) "..BZ["Sylvanaar"].." (42, 66), "..BZ["Blade's Edge Mountains"] };
		{ _RED.." 6) "..BZ["Thunderlord Stronghold"].." (50, 59), "..BZ["Blade's Edge Mountains"] };
		{ BLUE.." 7) "..BZ["Area 52"].." (31, 63), "..BZ["Netherstorm"] };
		{ _RED.." 8) "..BZ["Area 52"].." (32, 68), "..BZ["Netherstorm"] };
		{ BLUE.." 9) "..BZ["Telaar"].." (50, 70), "..BZ["Nagrand"] };
		{ _RED.."10) "..BZ["Garadar"].." (51, 34), "..BZ["Nagrand"] };
		{ _RED.."11) "..BZ["Stonebreaker Hold"].." (52, 43), "..BZ["Terokkar Forest"] };
		{ BLUE.."12) "..BZ["Allerian Stronghold"].." (55, 55), "..BZ["Terokkar Forest"] };
		{ _RED.."13) "..BZ["Shadowmoon Village"].." (33, 30), "..BZ["Shadowmoon Valley"] };
		{ BLUE.."14) "..BZ["Wildhammer Stronghold"].." (40, 55), "..BZ["Shadowmoon Valley"] };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ _RED..AL["Red: "]..FACTION_HORDE };
		{ BLUE..AL["Blue: "]..FACTION_ALLIANCE };
		{ ORNG..AL["Orange: "]..AL["Major Cities"] };
	};
	MidSummer_Northrend = {
		ZoneName = { AL["Midsummer Fire Festival"].." - "..BZ["Northrend"] };
		{ ORNG..AL["Midsummer Fire Festival"].." - "..AL["Midsummer_Date"] };
		{ "" };
		{ BLUE.." 1) "..BZ["Fizzcrank Airstrip"].." (55, 20), "..BZ["Borean Tundra"] };
		{ _RED.." 2) "..BZ["Bor'gorok Outpost"].." (51, 12), "..BZ["Borean Tundra"] };
		{ BLUE.." 3) "..BZ["River's Heart"].." (47, 66), "..BZ["Sholazar Basin"] };
		{ _RED.." 4) "..BZ["River's Heart"].." (47, 62), "..BZ["Sholazar Basin"] };
		{ _RED.." 5) "..BZ["Agmar's Hammer"].." (39, 48), "..BZ["Dragonblight"] };
		{ BLUE.." 6) "..BZ["Wintergarde Keep"].." (75, 44), "..BZ["Dragonblight"] };
		{ BLUE.." 7) "..BZ["Windrunner's Overlook"].." (78, 75), "..BZ["Crystalsong Forest"] };
		{ _RED.." 8) "..BZ["Sunreaver's Command"].." (80, 53), "..BZ["Crystalsong Forest"] };
		{ _RED.." 9) "..BZ["K3"].." (40, 86), "..BZ["The Storm Peaks"] };
		{ BLUE.."10) "..BZ["K3"].." (42, 87), "..BZ["The Storm Peaks"] };
		{ BLUE.."11) "..BZ["The Argent Stand"].." (41, 61), "..BZ["Zul'Drak"] };
		{ _RED.."12) "..BZ["The Argent Stand"].." (43, 71), "..BZ["Zul'Drak"] };
		{ _RED.."13) "..BZ["Conquest Hold"].." (19, 61), "..BZ["Grizzly Hills"] };
		{ BLUE.."14) "..BZ["Amberpine Lodge"].." (34, 61), "..BZ["Grizzly Hills"] };
		{ _RED.."15) "..BZ["Camp Winterhoof"].." (48, 13), "..BZ["Howling Fjord"] };
		{ BLUE.."16) "..BZ["Fort Wildervar"].." (58, 16), "..BZ["Howling Fjord"] };
		{ "" };
		{ "" };
		{ "" };
		{ _RED..AL["Red: "]..FACTION_HORDE };
		{ BLUE..AL["Blue: "]..FACTION_ALLIANCE };
		{ ORNG..AL["Orange: "]..AL["Major Cities"] };
	};
	MidSummer_Azeroth_MajorCities = {
		ZoneName = { AL["Midsummer Fire Festival"].." - "..BZ["Eastern Kingdoms"].." ("..AL["Major Cities"]..")" };
		{ ORNG..AL["Midsummer Fire Festival"].." - "..AL["Midsummer_Date"] };
		{ "" };
		{ BLUE.." 1) "..BZ["Hall of Explorers"]..", "..BZ["Ironforge"] };
		{ BLUE.." 2) "..BZ["Mage Quarter"]..", "..BZ["Stormwind City"] };
		{ _RED.." 3) "..BZ["Court of the Sun"]..", "..BZ["Silvermoon City"] };
		{ _RED.." 4) "..BZ["Ruins of Lordaeron"]..", "..BZ["Undercity"] };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ _RED..AL["Red: "]..FACTION_HORDE };
		{ BLUE..AL["Blue: "]..FACTION_ALLIANCE };
		{ ORNG..AL["Orange: "]..AL["Major Cities"] };
	};
	MidSummer_Kalimdor_MajorCities = {
		ZoneName = { AL["Midsummer Fire Festival"].." - "..BZ["Kalimdor"].." ("..AL["Major Cities"]..")" };
		{ ORNG..AL["Midsummer Fire Festival"].." - "..AL["Midsummer_Date"] };
		{ "" };
		{ BLUE.." 1) "..BZ["Warrior's Terrace"].." (63, 47), "..BZ["Darnassus"] };
		{ BLUE.." 2) "..BZ["The Crystal Hall"].." (41, 26), "..BZ["The Exodar"] };
		{ _RED.." 3) "..BZ["Valley of Wisdom"].." (47, 38), "..BZ["Orgrimmar"] };
		{ _RED.." 4) "..BZ["Spirit Rise"].." (21, 26), "..BZ["Thunder Bluff"] };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ _RED..AL["Red: "]..FACTION_HORDE };
		{ BLUE..AL["Blue: "]..FACTION_ALLIANCE };
		{ ORNG..AL["Orange: "]..AL["Major Cities"] };
	};
	MidSummer_Deepholm = {
		ZoneName = { AL["Midsummer Fire Festival"].." - "..BZ["Deepholm"] };
		{ ORNG..AL["Midsummer Fire Festival"].." - "..AL["Midsummer_Date"] };
		{ "" };
		{ PURP.." 1) "..BZ["Temple of Earth"].." (49, 51)" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ PURP..AL["Purple: "]..FACTION_STANDING_LABEL4 };
	};
	MidSummer_Pandaria = {
		ZoneName = { AL["Midsummer Fire Festival"].." - "..BZ["Pandaria"] };
		{ ORNG..AL["Midsummer Fire Festival"].." - "..AL["Midsummer_Date"] };
		{ "" };
		{ PURP.." 1) "..BZ["Dawn's Blossom"].." (47.2, 47.2), "..BZ["The Jade Forest"] };
		{ PURP.." 2) "..BZ["Zhu's Watch"].." (74.0, 9.49), "..BZ["Krasarang Wilds"] };
		{ PURP.." 3) "..BZ["Halfhill"].." (51.8, 51.4), "..BZ["Valley of the Four Winds"] };
		{ PURP.." 4) "..BZ["Soggy's Gamble"].." (56.1, 69.5), "..BZ["Dread Wastes"] };
		{ PURP.." 5) "..BZ["Longying Outpost"].." (71.5, 56.3), "..BZ["Townlong Steppes"] };
		{ PURP.." 6) "..BZ["Binan Village"].." (71.1, 90.9), "..BZ["Kun-Lai Summit"] };
		{ PURP.." 7) "..BZ["Mogu'shan Palace"].." (77.8, 33.9), "..BZ["Vale of Eternal Blossoms"] };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ "" };
		{ PURP..AL["Purple: "]..FACTION_STANDING_LABEL4 };
	};
};


Atlas_RegisterPlugin("Atlas_WorldEvents", myCategory, myData);
