/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.versionchecker.client.gui;

import com.dynious.versionchecker.lib.Resources;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiScroll {
    protected final Minecraft client;
    protected final int listWidth;
    protected final int listHeight;
    protected final int top;
    protected final int bottom;
    private final int right;
    protected final int left;
    protected final int slotHeight;
    private int scrollUpActionId;
    private int scrollDownActionId;
    protected int mouseX;
    protected int mouseY;
    private float initialMouseClickY = -2.0f;
    private float scrollFactor;
    private float scrollDistance;
    private int selectedIndex = -1;
    private long lastClickTime = 0L;
    private boolean isSelectable = true;
    private boolean hasCustomHeader;
    private int customHeaderHeight;
    public boolean disableInput = false;
    protected int horizontalPadding;
    protected int verticalPadding;

    public GuiScroll(Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight) {
        this.client = client;
        this.listWidth = width;
        this.listHeight = height;
        this.top = top;
        this.bottom = bottom;
        this.slotHeight = entryHeight;
        this.left = left;
        this.right = width + this.left;
    }

    public void setSelectable(boolean isSelectable) {
        this.isSelectable = isSelectable;
    }

    protected void setHasCustomHeader(boolean hasCustomHeader, int customHeaderHeight) {
        this.hasCustomHeader = hasCustomHeader;
        this.customHeaderHeight = hasCustomHeader ? customHeaderHeight : 0;
    }

    public void setPadding(int horizontalPadding, int verticalPadding) {
        this.horizontalPadding = horizontalPadding;
        this.verticalPadding = verticalPadding;
    }

    protected abstract int getSize();

    protected int getSlotHeight(int slotIndex) {
        return this.slotHeight;
    }

    protected abstract void elementClicked(int var1, boolean var2);

    protected abstract boolean isSelected(int var1);

    protected int getContentHeight() {
        int contentHeight = 0;
        for (int slotIndex = 0; slotIndex < this.getSize(); ++slotIndex) {
            contentHeight += this.getSlotHeight(slotIndex);
        }
        return contentHeight + this.customHeaderHeight;
    }

    protected abstract void drawBackground();

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, int var5, Tessellator var6);

    protected void drawCustomHeader(int maxX, int topY, Tessellator tesselator) {
    }

    protected void onMouseDownOutsideOfSlots(int relativeX, int relativeY) {
    }

    protected void drawForeground(int mouseX, int mouseY) {
    }

    public int getSlotIndexAtPosition(int x, int y) {
        int minX = this.left + 1 + this.horizontalPadding;
        int maxX = this.left + this.listWidth - 7 - this.horizontalPadding;
        if (this.mouseX >= minX && this.mouseX <= maxX) {
            int relativeY = y - this.top - this.customHeaderHeight - this.verticalPadding + (int)this.scrollDistance;
            int currentTopY = 0;
            for (int slotIndex = 0; slotIndex < this.getSize(); ++slotIndex) {
                int currentBottomY = currentTopY + this.getSlotHeight(slotIndex);
                if (relativeY >= currentTopY && relativeY < currentBottomY) {
                    return slotIndex;
                }
                currentTopY = currentBottomY;
            }
        }
        return -1;
    }

    public void registerScrollButtons(List p_22240_1_, int scrollUpActionId, int scrollDownActionId) {
        this.scrollUpActionId = scrollUpActionId;
        this.scrollDownActionId = scrollDownActionId;
    }

    private void applyScrollLimits() {
        float maxScrollDistance = this.getMaxScrollDistance();
        this.scrollDistance = maxScrollDistance > 0.0f ? Math.max(0.0f, Math.min(this.getMaxScrollDistance(), this.scrollDistance)) : maxScrollDistance / 2.0f;
    }

    public void actionPerformed(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == this.scrollUpActionId) {
                this.scrollDistance -= (float)(this.slotHeight * 2 / 3);
                this.initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            } else if (button.field_146127_k == this.scrollDownActionId) {
                this.scrollDistance += (float)(this.slotHeight * 2 / 3);
                this.initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            }
        }
    }

    public float getMaxScrollDistance() {
        return this.getContentHeight() - this.getVisibleHeight() + this.verticalPadding * 2;
    }

    public int getVisibleHeight() {
        return this.bottom - this.top;
    }

    public int getScrollBarHeight() {
        int scrollBarHeight = (int)((float)(this.getVisibleHeight() * this.getVisibleHeight()) / (float)this.getContentHeight());
        scrollBarHeight = Math.max(32, Math.min(this.getVisibleHeight() - 8, scrollBarHeight));
        return scrollBarHeight;
    }

    public void drawScreen(int mouseX, int mouseY, float p_22243_3_) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.drawBackground();
        int listLength = this.getSize();
        int scrollBarXStart = this.left + this.listWidth - 6;
        int scrollBarXEnd = scrollBarXStart + 6;
        int boxLeft = this.left + this.horizontalPadding;
        int boxRight = scrollBarXStart - 1 - this.horizontalPadding;
        if (!this.disableInput) {
            if (Mouse.isButtonDown((int)0)) {
                if (this.initialMouseClickY == -1.0f) {
                    if (mouseX >= scrollBarXStart && mouseX <= scrollBarXEnd && mouseY >= this.top && mouseY <= this.bottom) {
                        this.scrollFactor = -1.0f / ((float)(this.getVisibleHeight() - this.getScrollBarHeight()) / Math.max(1.0f, this.getMaxScrollDistance()));
                        this.initialMouseClickY = mouseY;
                    } else {
                        int clickedSlotIndex = this.getSlotIndexAtPosition(mouseX, mouseY);
                        if (clickedSlotIndex >= 0) {
                            boolean isDoubleClick = clickedSlotIndex == this.selectedIndex && System.currentTimeMillis() - this.lastClickTime < 250L;
                            this.elementClicked(clickedSlotIndex, isDoubleClick);
                            this.selectedIndex = clickedSlotIndex;
                            this.lastClickTime = System.currentTimeMillis();
                        } else {
                            this.onMouseDownOutsideOfSlots(mouseX - boxLeft, mouseY - this.top + (int)this.scrollDistance);
                        }
                        this.initialMouseClickY = -2.0f;
                    }
                } else if (this.initialMouseClickY >= 0.0f) {
                    this.scrollDistance -= ((float)mouseY - this.initialMouseClickY) * this.scrollFactor;
                    this.initialMouseClickY = mouseY;
                }
            } else {
                while (Mouse.next()) {
                    int deltaZ = -Mouse.getEventDWheel();
                    deltaZ = deltaZ > 0 ? 1 : (deltaZ < 0 ? -1 : 0);
                    this.scrollDistance += this.getSize() < 20 ? (float)(deltaZ * this.slotHeight * 2) : (float)(deltaZ * this.getContentHeight()) / 20.0f;
                }
                this.initialMouseClickY = -1.0f;
            }
        }
        this.applyScrollLimits();
        Tessellator tesselator = Tessellator.field_78398_a;
        if (this.client.field_71441_e != null) {
            this.drawGradientRect(this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
        } else {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2912);
            this.client.field_71446_o.func_110577_a(Gui.field_110325_k);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float var17 = 32.0f;
            tesselator.func_78382_b();
            tesselator.func_78378_d(0x202020);
            tesselator.func_78374_a((double)this.left, (double)this.bottom, 0.0, (double)((float)this.left / var17), (double)((float)(this.bottom + (int)this.scrollDistance) / var17));
            tesselator.func_78374_a((double)this.right, (double)this.bottom, 0.0, (double)((float)this.right / var17), (double)((float)(this.bottom + (int)this.scrollDistance) / var17));
            tesselator.func_78374_a((double)this.right, (double)this.top, 0.0, (double)((float)this.right / var17), (double)((float)(this.top + (int)this.scrollDistance) / var17));
            tesselator.func_78374_a((double)this.left, (double)this.top, 0.0, (double)((float)this.left / var17), (double)((float)(this.top + (int)this.scrollDistance) / var17));
            tesselator.func_78381_a();
        }
        int topOffsetByScrollDistance = this.top - (int)this.scrollDistance;
        if (this.hasCustomHeader) {
            this.drawCustomHeader(boxRight, topOffsetByScrollDistance, tesselator);
        }
        int drawY = topOffsetByScrollDistance + this.customHeaderHeight + this.verticalPadding;
        for (int slotIndex = 0; slotIndex < listLength; ++slotIndex) {
            int curSlotHeight = this.getSlotHeight(slotIndex);
            if (drawY <= this.bottom && drawY + curSlotHeight >= this.top) {
                if (this.isSelectable && this.isSelected(slotIndex)) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3553);
                    tesselator.func_78382_b();
                    tesselator.func_78378_d(0x808080);
                    tesselator.func_78374_a((double)boxLeft, (double)(drawY + curSlotHeight + 2), 0.0, 0.0, 1.0);
                    tesselator.func_78374_a((double)boxRight, (double)(drawY + curSlotHeight + 2), 0.0, 1.0, 1.0);
                    tesselator.func_78374_a((double)boxRight, (double)(drawY - 2), 0.0, 1.0, 0.0);
                    tesselator.func_78374_a((double)boxLeft, (double)(drawY - 2), 0.0, 0.0, 0.0);
                    tesselator.func_78378_d(0);
                    tesselator.func_78374_a((double)(boxLeft + 1), (double)(drawY + curSlotHeight + 1), 0.0, 0.0, 1.0);
                    tesselator.func_78374_a((double)(boxRight - 1), (double)(drawY + curSlotHeight + 1), 0.0, 1.0, 1.0);
                    tesselator.func_78374_a((double)(boxRight - 1), (double)(drawY - 1), 0.0, 1.0, 0.0);
                    tesselator.func_78374_a((double)(boxLeft + 1), (double)(drawY - 1), 0.0, 0.0, 0.0);
                    tesselator.func_78381_a();
                    GL11.glEnable((int)3553);
                }
                this.drawSlot(slotIndex, boxLeft, boxRight, drawY, drawY + curSlotHeight, tesselator);
            }
            drawY += curSlotHeight;
        }
        GL11.glDisable((int)2929);
        int fadeGradientHeight = 4;
        if (this.client.field_71441_e == null) {
            this.overlayBackground();
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        tesselator.func_78382_b();
        tesselator.func_78384_a(0, 0);
        tesselator.func_78374_a((double)this.left, (double)(this.top + fadeGradientHeight), 0.0, 0.0, 1.0);
        tesselator.func_78374_a((double)this.right, (double)(this.top + fadeGradientHeight), 0.0, 1.0, 1.0);
        tesselator.func_78384_a(0, 255);
        tesselator.func_78374_a((double)this.right, (double)this.top, 0.0, 1.0, 0.0);
        tesselator.func_78374_a((double)this.left, (double)this.top, 0.0, 0.0, 0.0);
        tesselator.func_78381_a();
        tesselator.func_78382_b();
        tesselator.func_78384_a(0, 255);
        tesselator.func_78374_a((double)this.left, (double)this.bottom, 0.0, 0.0, 1.0);
        tesselator.func_78374_a((double)this.right, (double)this.bottom, 0.0, 1.0, 1.0);
        tesselator.func_78384_a(0, 0);
        tesselator.func_78374_a((double)this.right, (double)(this.bottom - fadeGradientHeight), 0.0, 1.0, 0.0);
        tesselator.func_78374_a((double)this.left, (double)(this.bottom - fadeGradientHeight), 0.0, 0.0, 0.0);
        tesselator.func_78381_a();
        float maxScrollDistance = this.getMaxScrollDistance();
        if (maxScrollDistance > 0.0f) {
            int scrollBarHeight = this.getScrollBarHeight();
            int scrollBarTop = (int)(this.scrollDistance * (float)(this.getVisibleHeight() - scrollBarHeight) / maxScrollDistance + (float)this.top);
            scrollBarTop = Math.max(this.top, scrollBarTop);
            tesselator.func_78382_b();
            tesselator.func_78384_a(0, 255);
            tesselator.func_78374_a((double)scrollBarXStart, (double)this.bottom, 0.0, 0.0, 1.0);
            tesselator.func_78374_a((double)scrollBarXEnd, (double)this.bottom, 0.0, 1.0, 1.0);
            tesselator.func_78374_a((double)scrollBarXEnd, (double)this.top, 0.0, 1.0, 0.0);
            tesselator.func_78374_a((double)scrollBarXStart, (double)this.top, 0.0, 0.0, 0.0);
            tesselator.func_78381_a();
            tesselator.func_78382_b();
            tesselator.func_78384_a(0x808080, 255);
            tesselator.func_78374_a((double)scrollBarXStart, (double)(scrollBarTop + scrollBarHeight), 0.0, 0.0, 1.0);
            tesselator.func_78374_a((double)scrollBarXEnd, (double)(scrollBarTop + scrollBarHeight), 0.0, 1.0, 1.0);
            tesselator.func_78374_a((double)scrollBarXEnd, (double)scrollBarTop, 0.0, 1.0, 0.0);
            tesselator.func_78374_a((double)scrollBarXStart, (double)scrollBarTop, 0.0, 0.0, 0.0);
            tesselator.func_78381_a();
            tesselator.func_78382_b();
            tesselator.func_78384_a(0xC0C0C0, 255);
            tesselator.func_78374_a((double)scrollBarXStart, (double)(scrollBarTop + scrollBarHeight - 1), 0.0, 0.0, 1.0);
            tesselator.func_78374_a((double)(scrollBarXEnd - 1), (double)(scrollBarTop + scrollBarHeight - 1), 0.0, 1.0, 1.0);
            tesselator.func_78374_a((double)(scrollBarXEnd - 1), (double)scrollBarTop, 0.0, 1.0, 0.0);
            tesselator.func_78374_a((double)scrollBarXStart, (double)scrollBarTop, 0.0, 0.0, 0.0);
            tesselator.func_78381_a();
        }
        this.drawForeground(mouseX, mouseY);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    public void overlayBackground() {
        this.client.field_71446_o.func_110577_a(Resources.GUI_WINDOW);
        GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
        Gui.func_146110_a((int)(this.left - 10), (int)(this.top - this.slotHeight), (float)0.0f, (float)0.0f, (int)(this.listWidth + 20), (int)this.slotHeight, (float)220.0f, (float)160.0f);
        Gui.func_146110_a((int)(this.left - 10), (int)(this.top + this.listHeight), (float)0.0f, (float)(this.listHeight + this.slotHeight), (int)(this.listWidth + 20), (int)this.slotHeight, (float)220.0f, (float)160.0f);
    }

    protected void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par5 & 0xFF) / 255.0f;
        float f4 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)par3, (double)par2, 0.0);
        tessellator.func_78377_a((double)par1, (double)par2, 0.0);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)par1, (double)par4, 0.0);
        tessellator.func_78377_a((double)par3, (double)par4, 0.0);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }
}

