/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.versionchecker.config;

import com.dynious.versionchecker.VersionChecker;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static Configuration configFile;

    public static void init(FMLPreInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)new ConfigHandler());
        configFile = new Configuration(event.getSuggestedConfigurationFile());
        ConfigHandler.syncConfig();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("VersionChecker")) {
            ConfigHandler.syncConfig();
        }
    }

    public static void syncConfig() {
        VersionChecker.disableNEMCheck = ConfigHandler.getConfiguration("Disable NEM Check", false, "Disable checking against the NotEnoughMods database.");
        if (configFile.hasChanged()) {
            configFile.save();
        }
    }

    private static int getConfiguration(String setting, int defaultSetting, String comment) {
        return configFile.get("general", setting, defaultSetting, comment).getInt(defaultSetting);
    }

    private static boolean getConfiguration(String setting, boolean defaultSetting, String comment) {
        return configFile.get("general", setting, defaultSetting, comment).getBoolean(defaultSetting);
    }
}

