/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.versionchecker.handler;

import com.dynious.versionchecker.api.Update;
import com.dynious.versionchecker.checker.UpdateChecker;
import com.dynious.versionchecker.handler.LogHandler;
import com.dynious.versionchecker.handler.UpdateHandler;
import com.dynious.versionchecker.helper.ModHelper;
import com.dynious.versionchecker.helper.WebHelper;
import com.dynious.versionchecker.lib.Strings;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class IMCHandler {
    public static void processMessages(List<FMLInterModComms.IMCMessage> messageList) {
        for (FMLInterModComms.IMCMessage message : messageList) {
            if (message.key.equalsIgnoreCase("addUpdate")) {
                LogHandler.info("Received update from mod " + message.getSender());
                if (message.isNBTMessage()) {
                    IMCHandler.processAddUpdateMessage(message.getNBTValue(), message.getSender());
                    continue;
                }
                if (!message.isStringMessage()) continue;
                IMCHandler.processAddUpdateMessage(message.getStringValue(), message.getSender());
                continue;
            }
            if (message.key.equalsIgnoreCase("addVersionCheck")) {
                LogHandler.info("Received version check from mod " + message.getSender());
                if (!message.isStringMessage()) continue;
                IMCHandler.processVersionCheckMessage(message.getSender(), message.getStringValue());
                continue;
            }
            if (!message.key.equalsIgnoreCase("addCurseCheck")) continue;
            LogHandler.info("Received curse check from mod " + message.getSender());
            if (!message.isNBTMessage()) continue;
            IMCHandler.processCurseCheckMessage(message.getSender(), message.getNBTValue());
        }
    }

    public static void processAddUpdateMessage(NBTTagCompound tag, String sender) {
        Update update = new Update(sender);
        update.displayName = tag.func_74764_b("modDisplayName") ? tag.func_74779_i("modDisplayName") : ModHelper.getModContainer(sender).getName();
        update.oldVersion = tag.func_74764_b("oldVersion") ? tag.func_74779_i("oldVersion") : ModHelper.getModContainer(sender).getVersion();
        if (tag.func_74764_b("newVersion")) {
            update.newVersion = tag.func_74779_i("newVersion");
        }
        if (tag.func_74764_b("updateUrl")) {
            update.updateURL = tag.func_74779_i("updateUrl");
        }
        if (tag.func_74764_b("isDirectLink")) {
            update.isDirectLink = tag.func_74767_n("isDirectLink");
        }
        if (tag.func_74764_b("changeLog")) {
            update.changeLog = tag.func_74779_i("changeLog");
        }
        if (tag.func_74764_b("newFileName")) {
            update.newFileName = tag.func_74779_i("newFileName");
        }
        UpdateHandler.addUpdate(update);
    }

    public static void processAddUpdateMessage(String string, String sender) {
        Update update = Update.createFromJson(string);
        if (update != null) {
            if (update.displayName == null) {
                update.displayName = ModHelper.getModContainer(sender).getName();
            }
            if (update.oldVersion == null) {
                update.oldVersion = ModHelper.getModContainer(sender).getVersion();
            }
            UpdateHandler.addUpdate(update);
        }
    }

    public static void processVersionCheckMessage(String sender, String url) {
        UpdateChecker.addModToCheck(sender, url);
    }

    public static void processCurseCheckMessage(String sender, NBTTagCompound tag) {
        if (tag.func_74764_b("curseProjectName") && tag.func_74764_b("curseFilenameParser")) {
            String curseProjectName = tag.func_74779_i("curseProjectName");
            String latestFilename = WebHelper.getLatestFilenameFromCurse("http://minecraft.curseforge.com/mc-mods/" + curseProjectName + "/files/latest");
            if (latestFilename != null) {
                String fileNameParser = tag.func_74779_i("curseFilenameParser");
                int i = fileNameParser.indexOf(91);
                int o = fileNameParser.indexOf(93);
                if (i != -1 && o != -1) {
                    String version = latestFilename.replace(fileNameParser.substring(0, i), "").replace(fileNameParser.substring(o + 1, fileNameParser.length()), "");
                    if (version.equals(tag.func_74764_b("oldVersion") ? tag.func_74779_i("oldVersion") : ModHelper.getModContainer(sender).getVersion())) {
                        return;
                    }
                    Update update = new Update(sender);
                    update.newVersion = version;
                    update.updateURL = "http://minecraft.curseforge.com/mc-mods/" + curseProjectName + "/files/latest";
                    update.isDirectLink = true;
                    update.newFileName = latestFilename;
                    update.changeLog = StatCollector.func_74838_a((String)Strings.CURSE_UPDATE);
                    update.displayName = tag.func_74764_b("modDisplayName") ? tag.func_74779_i("modDisplayName") : ModHelper.getModContainer(sender).getName();
                    update.oldVersion = tag.func_74764_b("oldVersion") ? tag.func_74779_i("oldVersion") : ModHelper.getModContainer(sender).getVersion();
                    update.updateType = Update.UpdateType.CURSE;
                    UpdateHandler.addUpdate(update);
                    return;
                }
            }
        }
        LogHandler.error(String.format("An error was encountered when fetching latest version from Curse for %s!", sender));
    }
}

