/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.versionchecker.helper;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import org.lwjgl.Sys;

public class DesktopHelper {
    public static final File MOD_FOLDER = new File("mods");

    public static void openFolderInExplorer(File file) {
        Desktop desktop;
        Object[] fileBrowsers = new String[]{"gentoo", "xfe", "nautilus", "dolphin", "andromeda", "pcmanfm", "spacefm", "thunar", "caja", "dino", "xdg-open"};
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(file.toURI());
            }
            catch (IOException e) {
                Sys.openURL((String)("file://" + file.getAbsolutePath()));
            }
        } else {
            String osName = System.getProperty("os.name");
            try {
                if (osName.contains("nix") || osName.contains("nux")) {
                    boolean found = false;
                    for (String string : fileBrowsers) {
                        if (found) continue;
                        boolean bl = found = Runtime.getRuntime().exec(new String[]{"which", string}).waitFor() == 0;
                        if (!found) continue;
                        Runtime.getRuntime().exec(new String[]{string, file.getAbsolutePath()});
                    }
                    if (!found) {
                        throw new Exception(Arrays.toString(fileBrowsers));
                    }
                }
            }
            catch (Exception e) {
                Logger.getGlobal().severe("Could not open File Browser properly, please report your file browser and your OS to the Version Checker Github!");
            }
        }
    }
}

