/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.versionchecker.helper;

import com.dynious.versionchecker.api.Update;
import com.dynious.versionchecker.handler.LogHandler;
import com.dynious.versionchecker.helper.ModHelper;
import cpw.mods.fml.common.ModContainer;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class WebHelper {
    public static void openWebpage(URI uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Object[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "seamonkey", "galeon", "kazehakase", "mozilla", "netscape", "google-chrome", "google-chrome-stable"};
            String osName = System.getProperty("os.name");
            try {
                if (osName.contains("nix") || osName.contains("nux")) {
                    boolean found = false;
                    for (String string : browsers) {
                        if (found) continue;
                        boolean bl = found = Runtime.getRuntime().exec(new String[]{"which", string}).waitFor() == 0;
                        if (!found) continue;
                        Runtime.getRuntime().exec(new String[]{string, uri.toURL().toString()});
                    }
                    if (!found) {
                        throw new Exception(Arrays.toString(browsers));
                    }
                }
            }
            catch (Exception e) {
                Logger.getGlobal().severe("Could not open URI properly, please report your browser and your OS to the Version Checker Github!");
            }
        }
    }

    public static void openWebpage(URL url) {
        try {
            WebHelper.openWebpage(url.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static void openWebpage(String string) {
        try {
            WebHelper.openWebpage(new URI(string));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static boolean downloadUpdate(Update update) {
        ModContainer mod = ModHelper.getModContainer(update.MOD_ID);
        if (mod != null && mod.getSource() != null && mod.getSource().isFile()) {
            String fileName = "";
            if (update.newFileName != null && !update.newFileName.isEmpty()) {
                fileName = mod.getSource().getParent() + File.separator + update.newFileName;
            } else {
                String newFileName;
                fileName = mod.getSource().getAbsolutePath();
                if (fileName.equalsIgnoreCase(newFileName = fileName.replace(update.oldVersion, update.newVersion))) {
                    int i = newFileName.lastIndexOf(".");
                    newFileName = i == -1 ? newFileName + "-new" : newFileName.substring(0, i) + "-new" + newFileName.substring(i);
                }
                fileName = newFileName;
            }
            try {
                URL url = new URL(update.updateURL);
                File file = WebHelper.downloadFileFromURL(url, update, mod, fileName);
                if (file != null && file.exists() && file.length() > 0L) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static File downloadFileFromURL(URL url, Update update, ModContainer mod, String fileName) throws IOException {
        File newFile = new File(fileName);
        FileUtils.copyURLToFile((URL)url, (File)newFile);
        return newFile;
    }

    public static String getLatestFilenameFromCurse(String urlString) {
        try {
            while (urlString != null && !urlString.isEmpty()) {
                URL url = new URL(urlString);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setInstanceFollowRedirects(false);
                urlString = connection.getHeaderField("Location");
                if (urlString == null || !urlString.endsWith(".jar") && !urlString.endsWith(".zip")) continue;
                return urlString.substring(urlString.lastIndexOf("/") + 1);
            }
        }
        catch (MalformedURLException e) {
            LogHandler.error("Malformed URL was given when searching in Curse database!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

