//*****************************************************************************
//                  Copyright (c) 2007, Lexmark International, Inc.           
//     THIS IS AN UNPUBLISHED WORK CONTAINING CONFIDENTIAL AND PROPRIETARY     
//        INFORMATION WHICH IS THE PROPERTY OF LEXMARK INTERNATIONAL, INC.     
//                                                                             
//   ANY DISCLOSURE, USE, OR REPRODUCTION, WITHOUT WRITTEN AUTHORIZATION FROM  
//              LEXMARK INTERNATIONAL, INC., IS STRICTLY PROHIBITED.           
//*****************************************************************************
//
// JSW.js handles the user interactions and information updates on the 
// JSWDialog.
//
//****************************************************************************

// Global variable to this java script
var hideInkStatus = true;

// Cache previous update values
var oldPage = 0;
var oldCopy = 0;
var oldPercent = 0;

// Cache element nodes for quick access during updates
var elementCurrentPage = null;
var elementCurrentCopy = null;
var elementProgressPercent = null;
var elementProgressBar = null;

//-----------------------------------------------------------------------------
// JSWLoaded()
//  Handle the onload event to load job name, total pages, and total copies 
//  onto the JWS dialog.
//-----------------------------------------------------------------------------
function JSWLoaded()
{
	var elementFilePath = document.getElementById("FilePath");
	if (elementFilePath != null)
	{
        var jobName = parent.CommonJS.GetJobName();
	    elementFilePath.innerHTML = jobName;
	}

	var elementTotalPage = document.getElementById("TotalPage");
	if (elementTotalPage != null)
	{
	    var totalPages = parent.CommonJS.GetTotalPages();
	    elementTotalPage.innerHTML = totalPages;
	}

	var elementTotalCopy = document.getElementById("TotalCopy");
	if (elementTotalCopy != null)
	{
	    var totalCopies = parent.CommonJS.GetTotalCopies();
	    elementTotalCopy.innerHTML = totalCopies;
	}

    // Locate the document nodes that we will be interested in during updates
	elementCurrentPage = document.getElementById("CurrentPage");	
	elementCurrentCopy = document.getElementById("CurrentCopy");
	elementProgressPercent = document.getElementById("ProgressPercent");
	elementProgressBar = document.getElementById("JSWProgress");
	
	// Hide the billboard page info controls if necessary
	var showPageInfo = parent.CommonJS.GetShowPageInfo();
	if(!showPageInfo)
	{
	    // Hide page count control if it exists
	    var elementPageCount = document.getElementById("PageCount");
	    if(elementPageCount != null)
	    {
	        elementPageCount.style.display = "none";
	    }
	    // Hide copy count control if it exists
	    var elementCopyCount = document.getElementById("CopyCount");
	    if(elementCopyCount != null)
	    {
	        elementCopyCount.style.display = "none";
	    }
	}
	
    // Initialize the billboard navigation arrow state.
    var backButton = document.getElementById("LeftArrow");
    var forwardButton = document.getElementById("RightArrow");
    var enableNav = parent.CommonJS.GetEnableNavigation();
	backButton.enable(enableNav);
	forwardButton.enable(enableNav);

	// Hide the billboard navigation controls if necessary
    var showNav = parent.CommonJS.GetShowNavigation();
    if(!showNav)
    {
        backButton.style.display = "none";
        forwardButton.style.display = "none";
    }
    
	UpdateJSWInfo();
}

//-----------------------------------------------------------------------------
// UpdateJSWInfo()
//  Update JSW information on the JSW dialog including currentPage, currentCopy,
//  and progressPercent.  Only updates nodes that differ from their previous
//  values.
//-----------------------------------------------------------------------------
function UpdateJSWInfo()
{
    var currentPage = parent.CommonJS.GetCurrentPage();
    if((currentPage != oldPage) && (elementCurrentPage != null))
    {	    
        oldPage = currentPage;
        elementCurrentPage.innerHTML = currentPage;
    }

    var currentCopy = parent.CommonJS.GetCurrentCopy();
    if ((currentCopy != oldCopy) && (elementCurrentCopy != null))
    {
        oldCopy = currentCopy;
        elementCurrentCopy.innerHTML = currentCopy;
    }

    var progressPercent = parent.CommonJS.GetProgressPercent();
    if(progressPercent != oldPercent)
    {
        oldPercent = progressPercent;
        if (elementProgressPercent != null)
        {
            elementProgressPercent.innerHTML = progressPercent;
        }

        if (elementProgressBar != null)
        {
            elementProgressBar.Update(progressPercent);
        }
    }
}

//-----------------------------------------------------------------------------
// CancelButtonClick()
//  Handle onclick event for JSW dialog CancelButton.  It makes a call to the
//  controller JSWCallback method with CBCancelJob(=9) as the status value.
//-----------------------------------------------------------------------------
function CancelButtonClick()
{
    var CBCancelJob = 9; // predefined constant in guiinfo.h
    parent.CommonJS.JSWAction(CBCancelJob);
}

//-----------------------------------------------------------------------------
// AppearanceButtonClick()
//  Handle onclick event for JSW dialog AppearanceButton.
//-----------------------------------------------------------------------------
function AppearanceButtonClick()
{
    var CBShowAppearanceDlg = 1111; // predefined constant in JSWProxy.cpp
    parent.CommonJS.JSWAction(CBShowAppearanceDlg);
}

//-----------------------------------------------------------------------------
// InkStatusClick()
//  Handle onclick event for JSW dialog InkStatus link.  Initially, the ink
//  status will be hidden on the Billboard. Then if the user clicks the link,
//  the ink status will be displayed on Billboard.  Subsequent clicks on the
//  link will alternate ink status to be hidden or displayed on the Billboard.
//-----------------------------------------------------------------------------
function InkStatusClick()
{
    if (hideInkStatus)
    {
        parent.CommonJS.BBAction("INK_STATUS", 0);
        hideInkStatus = false;
    }
    else
    {
        parent.CommonJS.BBAction("CURRENT", 0);
        hideInkStatus = true;
    }
}
