//*****************************************************************************
//                  Copyright (c) 2007, Lexmark International, Inc.           
//     THIS IS AN UNPUBLISHED WORK CONTAINING CONFIDENTIAL AND PROPRIETARY     
//        INFORMATION WHICH IS THE PROPERTY OF LEXMARK INTERNATIONAL, INC.     
//                                                                             
//   ANY DISCLOSURE, USE, OR REPRODUCTION, WITHOUT WRITTEN AUTHORIZATION FROM  
//              LEXMARK INTERNATIONAL, INC., IS STRICTLY PROHIBITED.           
//*****************************************************************************
//
//  controls.js contains methods to support various html / javascript controls
//
//****************************************************************************

// InitInkTank
//   A method that initializes an InkTank control.
// Params:
//   elemID - the ID of the control to initialize  
function InitInkTank(elemID)
{
  obj = this.document.getElementById(elemID);
  UpdateInkTank(obj);
}

// UpdateInkTank
//   A method that updates the display of an InkTank control.
// Params:
//   obj - the element to be updated
function UpdateInkTank(obj)
{
  tankID = parseInt(obj.tankID);
  img = CommonJS.GetInkImage(tankID);
  obj.src = 'Images/' + img;
  /* Debugging only! * /
  obj.alt = img;  // Sets the alt-text to the image name */
  
  if(img != "")
  {
    obj.style.display = 'inline';         
  }
  else
  {
    obj.style.display = 'none';         
  }
}

// UpdateAllInkTanks
//   A method that updates the display of all InkTank controls.
function UpdateAllInkTanks()
{
  for(frameIdx = 0; frameIdx < document.frames.length; frameIdx++)
  {
    inktanks = document.frames[frameIdx].document.getElementsByName("InkTank");
    for(i = 0; i < inktanks.length; i++)
    {
      UpdateInkTank(inktanks[i]);
    }
  } 
}

// LoadImageButton
//   A method for turning an <img> node into an image button. Sets the initial
//   image and adds handlers for the various state changes. Used by image 
//   buttons generated by controls.xsl
//  Params:
//   context    The window the image button is contained in
//   buttonID   The id of the <img> tag.
// 	 enabled	Flag indicating whether or not the buttons are enabled
function LoadImageButton(context, buttonID, enabled)
{
    // Find the <img> tag
    button = context.document.getElementById(buttonID);
    
    // Set the initial image
    button.src = button.imageUp;
    
    // Add a 'hover' handler.
    button.onmouseover = function()
    {
        if(!this.disabled)
        {
            this.src = this.imageHover;
        }
    }
    
    // Add a 'mouseout' handler.
    button.onmouseout = function()
    {
        if(!this.disabled)
        {
            this.src = this.imageUp;
        }
    }
    
    // Add a 'push' handler.
    button.onmousedown = function()
    {
        if(!this.disabled)
        {
            this.src = this.imageDown;
        }
    }
    
    // Add a 'release' handler.
    button.onmouseup = function()
    {
        if(!this.disabled)
        {
            this.src = this.imageHover;
        }
    }
       
    // Add a method for enabling / disabling the button.
    button.enable = function(enable)
    {
        if(this.disabled && enable)
        {
            this.disabled = false;
            this.src = this.imageUp;
        }
        else if(!this.disabled && !enable)
        {
            this.src = this.imageDisable;
            this.disabled = true;
        }      
    }

    // Add a generic handler for click if one hasn't already been assigned
    if(button.onclick == null)
    {
        button.onclick = function()
        {
            // IE5.0 workaround - disabled items still process 'onclick' 
            // messages in IE5.0
            if(!this.disabled)
            {
                // Invoke the ButtonClick method on this button
                parent.CommonJS.BBAction.call(this, this.action, parseInt(this.actionID));
            }
        }
    }
    else
    {
        // IE5.0 workaround - disabled items still process 'onclick' 
        // messages in IE5.0
        button.onClickHandler = button.onclick;
        button.onclick = function()
        {
            if(!this.disabled)
            {
                this.onClickHandler();
            }
        }
    }
    
    if(!enabled)
    {
        button.enable(false);
    }
}

// InitProgressBar
//   A method for turning a <table> node into a progress bar. Adds an 'Update'
//   method that may be used to change the progress bar percentage. Used by 
//   progress bars generated by controls.xsl.
//  Params:
//   barID  The id of the <table> tag.
function InitProgressBar(barID)
{
  // Find the progress bar
  bar = this.document.getElementById(barID);

  // Give it an 'Update' method
  bar.Update = function(percent)
  {
    // Find the xxxx_Fill sub-node
    fill = this.document.getElementById(barID + "_Fill");
    // Adjust its width to match the percentage
    fill.style.width = percent + "%";

    // Find the various sub-nodes
    var transition = this.document.getElementById(barID + "_Transition");
    var empty = this.document.getElementById(barID + "_Empty");
    var nearEmpty = this.document.getElementById(barID + "_NearEmpty");
    var nearFull = this.document.getElementById(barID + "_NearFull");
    var farEmpty = this.document.getElementById(barID + "_FarEmpty");
    var farFull = this.document.getElementById(barID + "_FarFull");
    
    // State manipulation: 2 special cases, 0% and 100%
    if(percent == 0)
    {
        // 0% - Should not be filled at all
        // Hide the transition image (no filled section to transition from)
        transition.style.visibility = 'hidden';
        
        // Make sure the 'unfilled' section is displayed
        empty.style.display = 'block';
        
        // Show the 'unfilled' end caps
        nearEmpty.style.display = 'block';
        nearFull.style.display = 'none';
        farEmpty.style.display = 'block';
        farFull.style.display = 'none';
    }
    else if(percent == 100)
    {
        // 100% - Should be completely filled
        // Hide the transition image (no unfilled section to transition to)
        transition.style.visibility = 'hidden';
        
        // Make sure the 'unfilled' section is hidden
        empty.style.display = 'none';    

        // Show the 'filled' end caps
        nearEmpty.style.display = 'none';
        nearFull.style.display = 'block';
        farEmpty.style.display = 'none';
        farFull.style.display = 'block';
    }
    else /* 0 < percent < 100 */
    {
        // Partial percentage - should be partially filled
        // Show the transition image between the filled & unfilled sections
        transition.style.visibility = 'visible';
        
        // Make sure the 'unfilled' section is displayed
        empty.style.display = 'block';
        
        // Show the 'filled' near end cap
        nearEmpty.style.display = 'none';
        nearFull.style.display = 'block';

        // Show the 'unfilled' far end cap
        farEmpty.style.display = 'block';
        farFull.style.display = 'none';
    }
  }
}