<?xml version="1.0" encoding="iso-8859-1"?>
<!-- **************************************************************************
                  Copyright (c) 2007, Lexmark International, Inc.           
     THIS IS AN UNPUBLISHED WORK CONTAINING CONFIDENTIAL AND PROPRIETARY     
        INFORMATION WHICH IS THE PROPERTY OF LEXMARK INTERNATIONAL, INC.     
                                                                             
   ANY DISCLOSURE, USE, OR REPRODUCTION, WITHOUT WRITTEN AUTHORIZATION FROM  
              LEXMARK INTERNATIONAL, INC., IS STRICTLY PROHIBITED.           
*************************************************************************** -->
<!-- 
This file contains transformations for the following controls:
InkTank
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html"/>

  <!-- InkTank - Matching template that produces an 'img' element that indicates 
       the current fill level of the specified ink tank.
  -->
  <xsl:template match="InkTank">
    <xsl:call-template name="InkTank">
      <xsl:with-param name="tankID"><xsl:value-of select="@tankID"/></xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <!-- InkTank - Callable template that produces an 'img' element that indicates 
       the current fill level of the specified ink tank.
  -->
  <xsl:template name="InkTank">
    <xsl:param name="tankID" />
    <xsl:element name="img">
      <xsl:attribute name="id">
        <xsl:value-of select="concat(generate-id(.),$tankID)"/>
      </xsl:attribute>
      <xsl:attribute name="name">InkTank</xsl:attribute>
      <xsl:attribute name="tankID">
        <xsl:value-of select="$tankID"/>
      </xsl:attribute>
      <xsl:attribute name="style">display:none</xsl:attribute>
      <xsl:attribute name="class">InkTank</xsl:attribute>
    </xsl:element>
    <xsl:element name="script">
      <xsl:attribute name="type">text/javascript</xsl:attribute>
      parent.InitInkTank.call(this, '<xsl:value-of select="concat(generate-id(.),$tankID)"/>');
    </xsl:element>
  </xsl:template>

  <!-- InkTankTable - Produces a 'table' element that contains 'img' elements 
       indicating the current fill level of the ink tanks.
  -->
  <xsl:template match="InkTankTable">
    <xsl:element name="table">
      <xsl:attribute name="cellpadding">0</xsl:attribute>
      <xsl:attribute name="cellspacing">0</xsl:attribute>
      <!-- Force 'ltr' mode so that the tanks are always displayed in the same 
      order-->
      <xsl:attribute name="dir">ltr</xsl:attribute>
      <xsl:element name="tr">
        <xsl:element name="td">
          <xsl:call-template name="InkTank">
            <xsl:with-param name="tankID">1</xsl:with-param>
          </xsl:call-template>
        </xsl:element>
        <xsl:element name="td">
          <xsl:attribute name="class">
            <xsl:value-of select="@spacer-class"/>
          </xsl:attribute>
          <!-- Cell must have content or it will be ignored -->
          <xsl:element name="div">
            <xsl:attribute name="class">
              <xsl:value-of select="@spacer-class"/>
            </xsl:attribute>
          </xsl:element>
        </xsl:element>
        <xsl:element name="td">
          <xsl:call-template name="InkTank">
            <xsl:with-param name="tankID">0</xsl:with-param>
          </xsl:call-template>
        </xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:template>

<!-- Image button (requires controls.js) - Produces an 'img' element that 
       acts like a button, along with javascript to initialize the necessary 
       event handlers. The 'img' element receives the non-HTML attributes: 
         imageUp      - Image to show in the default state
         imageDown    - Image to show when the button is pressed
         imageHover   - Image to show when the button is moused over
         imageDisable - Image to show when the button is disabled
       This ImageButton has to ways of defining behavior when clicked:
         A custom onclick handler may be added by specifying a value for the
         onclick attribute: 
            <ImageButton onclick="ButtonClickMethod()">
         There is also a default onclick handler that will be called if one is
         not specified. In that case, the Action and ActionID sub-elements must
         be specified. These values will be passed as parameters to BBAction in
         the default handler: 
            <ImageButton>
              <Action>NEXT</Action>
              <ActionID>0</ActionID>
            </ImageButton>
  -->
  <xsl:template match="ImageButton">
    <xsl:element name="img">
      <xsl:copy-of select="@id"/>
      <xsl:choose>
        <!-- Add a custom onclick handler -->
        <xsl:when test="@onclick != ''">
          <xsl:copy-of select="@onclick"/>
        </xsl:when>
        <!-- Or add the parameters for the default BBAction handler -->
        <xsl:otherwise>
          <xsl:attribute name="action">
            <xsl:value-of select="Action"/>
          </xsl:attribute>
          <xsl:attribute name="actionID">
            <xsl:value-of select="ActionID"/>            
          </xsl:attribute>
        </xsl:otherwise>
      </xsl:choose>       
      <xsl:attribute name="alt">
        <xsl:apply-templates select="Text"/>
      </xsl:attribute>
      <xsl:attribute name="imageUp">
        <xsl:value-of select="ImageUp"/>
      </xsl:attribute>
      <xsl:attribute name="imageDown">
        <xsl:value-of select="ImageDown"/>
      </xsl:attribute>
      <xsl:attribute name="imageHover">
        <xsl:value-of select="ImageHover"/>
      </xsl:attribute>
      <xsl:attribute name="imageDisable">
        <xsl:value-of select="ImageDisable"/>
      </xsl:attribute>
      <xsl:attribute name="class">
        <xsl:value-of select="CSSClass"/>
      </xsl:attribute>
    </xsl:element>
    <xsl:element name="script">
      <xsl:attribute name="type">text/javascript</xsl:attribute>
      <xsl:variable name="enabled">
        <xsl:choose>
          <xsl:when test="Enabled = 'false'">false</xsl:when>
          <xsl:otherwise>true</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      parent.LoadImageButton(window, '<xsl:value-of select="@id"/>', <xsl:value-of select="$enabled"/>);
    </xsl:element>
  </xsl:template>

  <!-- Progress bar (requires controls.js) - Produces a 'table' element that 
       acts like a progress bar, along with javascript to initialize the 
       control. The 'table' element is given an 'Update' method that can be
       used to update the progress percentage. The progress bar requires that
       seven images be specified - a left end cap (both full and empty), 
       right end cap (both full and empty), filled section, empty section, 
       and transition. The filled and empty section images will  be tiled to 
       make up the main body of the progress bar.
       Sample usage:
        <ProgressBar id="SampleProgress">
          <NearEndCapEmpty>Images\left_end_e.gif</NearEndCapEmpty>
          <NearEndCapFull>Images\left_end_f.gif</NearEndCapFull>
          <Filled>Images\filled.gif</Filled>
          <Transition>Images\trans.gif</Transition>
          <Empty>Images\empty.gif</Empty>
          <FarEndCapEmpty>Images\right_end_e.gif</FarEndCapEmpty>
          <FarEndCapFull>Images\right_end_f.gif</FarEndCapFull>
        </ProgressBar>
  -->
  <xsl:template match="ProgressBar">
    <xsl:element name="table">
      <xsl:copy-of select="@id" />
      <xsl:attribute name="style">width:100%</xsl:attribute>
      <xsl:attribute name="cellpadding">0</xsl:attribute>
      <xsl:attribute name="cellspacing">0</xsl:attribute>
      <xsl:element name="tr">
        <!-- Left end caps -->
        <xsl:element name="td">
          <xsl:attribute name="id"><xsl:value-of select="@id"/>_NearEmpty</xsl:attribute>
          <xsl:attribute name="style">width:0%</xsl:attribute>
          <xsl:element name="img">
            <xsl:attribute name="src">
              <xsl:value-of select="NearEndCapEmpty"/>
            </xsl:attribute>
          </xsl:element>
        </xsl:element>
        <xsl:element name="td">
          <xsl:attribute name="id"><xsl:value-of select="@id"/>_NearFull</xsl:attribute>
          <xsl:attribute name="style">width:0%;display:none</xsl:attribute>
          <xsl:element name="img">
            <xsl:attribute name="src">
              <xsl:value-of select="NearEndCapFull"/>
            </xsl:attribute>
          </xsl:element>
        </xsl:element>
        <!-- filled section -->
        <xsl:element name="td">
          <xsl:attribute name="id"><xsl:value-of select="@id"/>_Fill</xsl:attribute>
          <xsl:attribute name="style">
            width:0%;
            background-image:url(<xsl:value-of select="Filled"/>);
            background-repeat:repeat-x;
          </xsl:attribute>
        </xsl:element>
        <!-- Transition & un-filled section -->
        <xsl:element name="td">
          <xsl:attribute name="id"><xsl:value-of select="@id"/>_Empty</xsl:attribute>
          <xsl:attribute name="style">
            <!-- Width is unspecified so that this section grows / shrinks as needed. -->
            background-image:url(<xsl:value-of select="Empty"/>);
            background-repeat:repeat-x;
          </xsl:attribute>
          <!-- Stick the transition image on the 'unfilled' background -->
          <xsl:element name="img">
            <xsl:attribute name="id"><xsl:value-of select="@id"/>_Transition</xsl:attribute>
            <xsl:attribute name="src">
              <xsl:value-of select="Transition"/>
            </xsl:attribute>
            <xsl:attribute name="style">visibility:hidden</xsl:attribute>
          </xsl:element>
        </xsl:element>
        <!-- Right end caps -->
        <xsl:element name="td">
          <xsl:attribute name="id"><xsl:value-of select="@id"/>_FarEmpty</xsl:attribute>
          <xsl:attribute name="style">width:0%</xsl:attribute>
          <xsl:element name="img">
            <xsl:attribute name="src">
              <xsl:value-of select="FarEndCapEmpty"/>
            </xsl:attribute>
          </xsl:element>
        </xsl:element>
        <xsl:element name="td">
          <xsl:attribute name="id"><xsl:value-of select="@id"/>_FarFull</xsl:attribute>
          <xsl:attribute name="style">width:0%;display:none</xsl:attribute>
          <xsl:element name="img">
            <xsl:attribute name="src">
              <xsl:value-of select="FarEndCapFull"/>
            </xsl:attribute>
          </xsl:element>
        </xsl:element>
      </xsl:element>
    </xsl:element>
    <xsl:element name="script">
      <xsl:attribute name="type">text/javascript</xsl:attribute>
      parent.InitProgressBar.call(this, '<xsl:value-of select="@id"/>');
    </xsl:element>
  </xsl:template>
</xsl:stylesheet>
