<?xml version="1.0" encoding="iso-8859-1"?>
<!-- **************************************************************************
                  Copyright (c) 2007, Lexmark International, Inc.           
     THIS IS AN UNPUBLISHED WORK CONTAINING CONFIDENTIAL AND PROPRIETARY     
        INFORMATION WHICH IS THE PROPERTY OF LEXMARK INTERNATIONAL, INC.     
                                                                             
   ANY DISCLOSURE, USE, OR REPRODUCTION, WITHOUT WRITTEN AUTHORIZATION FROM  
              LEXMARK INTERNATIONAL, INC., IS STRICTLY PROHIBITED.           
*************************************************************************** -->
<!--
This file contains the translations necessary for writing out the dir attribute
using the appropriate RTL or LTR value from strings.xml. It also contains the
translations necessary for replacing string ID's with their localized values.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!-- Variables for 'right' and 'left' that swap in RTL locales. Used for 
       automatically swapping text-align values -->
  <xsl:variable name="near_edge">
    <xsl:choose>
      <xsl:when test="$local_doc/StringTable/readingorder/@value = 'rtl'">right</xsl:when>
      <xsl:otherwise>left</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="far_edge">
    <xsl:choose>
      <xsl:when test="$local_doc/StringTable/readingorder/@value = 'rtl'">left</xsl:when>
      <xsl:otherwise>right</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <!-- Template for writing out a text-align style value. Converts from generic
  'near' and 'far' to 'left' and 'right' (depending on RTL) -->
  <xsl:template name="write-text-align">
    <xsl:text>text-align:</xsl:text>
    <xsl:choose>
      <xsl:when test="../@text-align = 'near'">
        <xsl:value-of select="$near_edge"/>
      </xsl:when>
      <xsl:when test="../@text-align = 'far'">
        <xsl:value-of select="$far_edge"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>center</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>; </xsl:text>
  </xsl:template>

  <!-- Template for adding to the style attribute -->
  <xsl:template match="@style | @text-align">
    <!-- complex test - only want to run this if we're the style attribute, or 
    if there's no style attribute and we're the text-align attribute -->
    <xsl:if test="
      ( name() = 'style' ) or 
      ( not(../@style) and name() = 'text-align' )
      ">
      <xsl:attribute name="style">
        <xsl:if test="../@text-align">
          <xsl:call-template name="write-text-align"></xsl:call-template>
        </xsl:if>
        <xsl:value-of select="../@style"/>
      </xsl:attribute>
    </xsl:if>
  </xsl:template>
  
  <!-- Template for adding the dir="RTL" attribute to an element -->
  <xsl:template name="reading_order">
    <xsl:attribute name="dir">
      <xsl:value-of select="$local_doc/StringTable/readingorder/@value" />
    </xsl:attribute>
  </xsl:template>

  <!-- Template for replacing text nodes with their localized equivalents -->
  <xsl:template match="Text | ContentText">
    <xsl:call-template name="InsertLocalizedString" />
  </xsl:template>

  <!-- Callable template for translating the current node's value into 
       localized text -->
  <xsl:template name="InsertLocalizedString">
    <xsl:apply-templates select="$local_doc/StringTable">
      <xsl:with-param name="stringID">
        <xsl:value-of select="." />
      </xsl:with-param>
    </xsl:apply-templates>
  </xsl:template>
  
  <!-- Key for string lookups -->
  <xsl:key name="StringLookup" match="//string" use="@id" />

</xsl:stylesheet>