-- The 365Install.exe will invoke this lua file to execute installation operation.

require "luafiles.365Defs"
require "luafiles.Common"

function WriteLogMsg(msg)
	WriteFile( "c:\\b5m120\\365_lua_install.log", msg )
end

-- Installation interfaces definition.
function FileInstall(bUpdateCfg)

	-- Copy cfg if necessary.
	if true == bUpdateCfg then
		--local str365Setting = CLuaPathMgr:GetConfigPath()
		--str365Setting = str365Setting..WEATHER365_SETTING
		local str365Setting = GetConfigPath()
		CLuaFileHelper:CopyFile2FileEx( g_strSrcResDir..WEATHER365_CFG, 		str365Setting..WEATHER365_CFG )

		WriteLogMsg( "FileInstall::GetSettingPath: "..str365Setting )
	end

	-- Copy 365Weather.exe to "365Weather".
	CLuaFileHelper:CopyFile2FileEx( g_strSrcResDir..WEATHER365_EXE, 			g_strInstDir..WEATHER365_EXE )

	-- Copy other exe, dll files to "365Weather\Application\Default".
	CLuaFileHelper:CopyFile2FileEx( g_strSrcResDir..WEATHER365_UNINST, 			g_str365App..WEATHER365_UNINST )
	CLuaFileHelper:CopyFile2FileEx( g_strSrcResDir..WEATHER_UPDATE_DLL, 		g_str365App..WEATHER_UPDATE_DLL )
	CLuaFileHelper:CopyFile2FileEx( g_strSrcResDir..WEATHER_APP_DLL, 			g_str365App..WEATHER_APP_DLL )
	CLuaFileHelper:CopyFile2FileEx( g_strSrcResDir..WEATHER_EXTRACT_DLL, 		g_str365App..WEATHER_EXTRACT_DLL )
	CLuaFileHelper:CopyFile2FileEx( g_strSrcResDir..WEATHER_RES_CFG_DLL, 		g_str365App..WEATHER_RES_CFG_DLL )
	CLuaFileHelper:CopyFile2FileEx( g_strSrcResDir..WEATHER365_BUG_REPORT, 		g_str365App..WEATHER365_BUG_REPORT )
	CLuaFileHelper:CopyFile2FileEx( g_strSrcResDir..WEATHER365_UNIST_MGR, 		g_str365App..WEATHER365_UNIST_MGR )

	-- Copy "resource" folder to "365Weather\resource".
	CLuaFileHelper:CopyDirEx( g_strSrcResDir..WEATHER365_RESOURCE, 				g_str365App..WEATHER365_RESOURCE )

	-- Copy "luafiles" folder to "365Weather\luafiles".
	CLuaFileHelper:CopyDirEx( g_strSrcResDir..WEATHER365_LUAFILES,				g_str365App..WEATHER365_LUAFILES )

	-- Copy files to "365Weather\Application\Default".
	CLuaFileHelper:CopyFile2FileEx( g_strSrcResDir..W365_CRX_POSITION, 			g_str365App..W365_CRX_POSITION )

	WriteLogMsg( "FileInstall::Finished. g_strSrcResDir: "..g_strSrcResDir.."g_str365App: "..g_str365App )

end


function RegInstall(bDesktopShortcut, bAutoRun)

	-- If silent, nonofficial, green installation, don't write uninstall register.
	-- Unistall register info.
	if true == bDesktopShortcut then
		local strUnistReg = REG_ITEM_UNINSTALL_32BIT..SLASH..APP_NAME
		CLuaRegCommon:WriteRegValue( HKEY_CURRENT_USER, strUnistReg, "DisplayName", 	APP_NAME )
		CLuaRegCommon:WriteRegValue( HKEY_CURRENT_USER, strUnistReg, "DisplayIcon", 	g_str365App..WEATHER365_EXE )
		CLuaRegCommon:WriteRegValue( HKEY_CURRENT_USER, strUnistReg, "Publisher", 		COMPANY_NAME )
		CLuaRegCommon:WriteRegValue( HKEY_CURRENT_USER, strUnistReg, "UninstallString", g_str365App..WEATHER365_UNINST )
		CLuaRegCommon:WriteRegValue( HKEY_CURRENT_USER, strUnistReg, "URLInfoAbout", 	COMPANY_URL )
		CLuaRegCommon:WriteRegValue( HKEY_CURRENT_USER, strUnistReg, "DisplayVersion", 	WEATHER365_VERSION )

		WriteLogMsg( "RegInstall::strUnistReg: "..strUnistReg )
	end

	-- Auto run.
	if true == bAutoRun then
		local keyValue = QUOTES..g_strInstDir..WEATHER365_EXE..QUOTES.." \\autorun"
		CLuaRegCommon:WriteRegValue( HKEY_CURRENT_USER, REG_ITEM_AUTO_RUN, APP_NAME, keyValue );

		WriteLogMsg( "RegInstall::bAutoRun: true. subKey: "..REG_ITEM_AUTO_RUN.."; KeyName: "..APP_NAME.."; KeyValue: "..keyValue )
	end

	WriteLogMsg( "RegInstall::Finished." )

end

function ShortcutInstall(bDesktopShortcut, bAddTaskbar)

	local strStartmenu 	= CLuaPathMgr:GetStartmemuPath()
	local strDesktop 	= CLuaPathMgr:GetDesktopPath()

	-- Start menu.
	strStartmenu = strStartmenu..SLASH..APP_NAME
	CLuaFileHelper:CreateDir( strStartmenu )
	CLuaUtils:CreateShortcut( g_strInstDir..WEATHER365_EXE, 		"", g_strInstDir, 	WEATHER365_CLIENT_CN, 	g_strInstDir..WEATHER365_EXE, 		strStartmenu..WEATHER365_LNK )
	CLuaUtils:CreateShortcut( g_str365App..WEATHER365_UNINST, 		"", g_str365App, 	WEATHER365_UNINST_CN, 	g_str365App..WEATHER365_UNINST, 	strStartmenu..WEATHER365_UNINST_LNK )

	-- Desktop shortcut.
	if true == bDesktopShortcut then
		CLuaUtils:CreateShortcut( g_strInstDir..WEATHER365_EXE, 	"", g_strInstDir, 	WEATHER365_CLIENT_CN, 	g_strInstDir..WEATHER365_EXE, 		strDesktop..WEATHER365_LNK )

		WriteLogMsg( "ShortcutInstall::bDesktopShortcut: true. Shortcut path: "..strDesktop..WEATHER365_LNK )
	end

	-- Pin to taskbar.
	if true == bAddTaskbar then
		CLuaUtils:AddToTaskbar( strStartmenu..WEATHER365_LNK );

		WriteLogMsg( "ShortcutInstall::bAddTaskbar: true. Taskbar path: "..strStartmenu..WEATHER365_LNK )
	end

	WriteLogMsg( "ShortcutInstall: Finished." )

end

-- Chrome core installation.
function Chrome360Install()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 2 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS
	local strSubKey 	= "Software\\360Chrome\\Chrome\\Extensions\\"

	WriteLogMsg( "Chrome360Install::strUserData: "..strUserData )
	WriteLogMsg( "Chrome360Install::strPrefs: "..strPrefs )
	WriteLogMsg( "Chrome360Install::strExtension: "..strExtension )
	WriteLogMsg( "Chrome360Install::strSubKey: "..strSubKey )

	CLuaChromeCoreInstall:UpdatePreferences( strPrefs, 				g_strSrcResDir..EXTENSION_CHROME..SETTING_JSON, EXTENSION_ID )
	CLuaChromeCoreInstall:UpdateRegInfo( strSubKey..EXTENSION_ID, 	g_str365App..W365_CRX_POSITION, 				WEATHER365_VERSION )
	CLuaChromeCoreInstall:CopyExtensionFiles( g_strSrcResDir..EXTENSION_CHROME..EXTENSION_ID, 		strExtension, 	EXTENSION_ID )

	WriteLogMsg( "Chrome360Install: Finished." )

end


function Safe360Install()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 3 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS
	local strSubKey 	= "Software\\360\\360se6\\Chrome\\Extensions\\"

	WriteLogMsg( "Safe360Install::strUserData: "..strUserData )
	WriteLogMsg( "Safe360Install::strPrefs: "..strPrefs )
	WriteLogMsg( "Safe360Install::strExtension: "..strExtension )
	WriteLogMsg( "Safe360Install::strSubKey: "..strSubKey )

	CLuaChromeCoreInstall:UpdatePreferences( strPrefs, 				g_strSrcResDir..EXTENSION_CHROME..SETTING_JSON, EXTENSION_ID )
	CLuaChromeCoreInstall:UpdateRegInfo( strSubKey..EXTENSION_ID, 	g_str365App..W365_CRX_POSITION, 				WEATHER365_VERSION )
	CLuaChromeCoreInstall:CopyExtensionFiles( g_strSrcResDir..EXTENSION_CHROME..EXTENSION_ID, 		strExtension, 	EXTENSION_ID )

	WriteLogMsg( "Safe360Install: Finished." )

end


function CaimaoInstall()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 6 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS

	WriteLogMsg( "CaimaoInstall::strUserData: "..strUserData )
	WriteLogMsg( "CaimaoInstall::strPrefs: "..strPrefs )
	WriteLogMsg( "CaimaoInstall::strExtension: "..strExtension )

	CLuaChromeCoreInstall:UpdatePreferences( strPrefs, 				g_strSrcResDir..EXTENSION_CHROME..SETTING_JSON, EXTENSION_ID )
	CLuaChromeCoreInstall:CopyExtensionFiles( g_strSrcResDir..EXTENSION_CHROME..EXTENSION_ID, 		strExtension, 	EXTENSION_ID )

	WriteLogMsg( "CaimaoInstall: Finished." )

end


function ChromeInstall()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 1 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS
	local strSubKey 	= "Software\\Google\\Chrome\\Extensions\\"

	WriteLogMsg( "ChromeInstall::strUserData: "..strUserData )
	WriteLogMsg( "ChromeInstall::strPrefs: "..strPrefs )
	WriteLogMsg( "ChromeInstall::strExtension: "..strExtension )
	WriteLogMsg( "ChromeInstall::strSubKey: "..strSubKey )

	CLuaChromeCoreInstall:UpdatePreferences( strPrefs, 				g_strSrcResDir..EXTENSION_CHROME..SETTING_JSON, EXTENSION_ID )
	CLuaChromeCoreInstall:UpdateRegInfo( strSubKey..EXTENSION_ID, 	g_str365App..W365_CRX_POSITION, 				WEATHER365_VERSION )
	CLuaChromeCoreInstall:CopyExtensionFiles( g_strSrcResDir..EXTENSION_CHROME..EXTENSION_ID, 		strExtension, 	EXTENSION_ID )

	WriteLogMsg( "ChromeInstall: Finished." )

end


function CoolnovoInstall()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 7 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS

	WriteLogMsg( "CoolnovoInstall::strUserData: "..strUserData )
	WriteLogMsg( "CoolnovoInstall::strPrefs: "..strPrefs )
	WriteLogMsg( "CoolnovoInstall::strExtension: "..strExtension )

	CLuaChromeCoreInstall:UpdatePreferences( strPrefs, 				g_strSrcResDir..EXTENSION_CHROME..SETTING_JSON, EXTENSION_ID )
	CLuaChromeCoreInstall:CopyExtensionFiles( g_strSrcResDir..EXTENSION_CHROME..EXTENSION_ID, 		strExtension, 	EXTENSION_ID )

	WriteLogMsg( "CoolnovoInstall: Finished." )

end


function LiebaoInstall()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 4 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS

	WriteLogMsg( "LiebaoInstall::strUserData: "..strUserData )
	WriteLogMsg( "LiebaoInstall::strPrefs: "..strPrefs )
	WriteLogMsg( "LiebaoInstall::strExtension: "..strExtension )

	CLuaChromeCoreInstall:UpdatePreferences( strPrefs, 				g_strSrcResDir..EXTENSION_CHROME..SETTING_JSON, EXTENSION_ID )
	CLuaChromeCoreInstall:CopyExtensionFiles( g_strSrcResDir..EXTENSION_CHROME..EXTENSION_ID, 		strExtension, 	EXTENSION_ID )

	WriteLogMsg( "LiebaoInstall: Finished." )

end


function TaobaoInstall()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 5 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS

	WriteLogMsg( "TaobaoInstall::strUserData: "..strUserData )
	WriteLogMsg( "TaobaoInstall::strPrefs: "..strPrefs )
	WriteLogMsg( "TaobaoInstall::strExtension: "..strExtension )

	CLuaChromeCoreInstall:UpdatePreferences( strPrefs, 				g_strSrcResDir..EXTENSION_CHROME..SETTING_JSON, EXTENSION_ID )
	CLuaChromeCoreInstall:CopyExtensionFiles( g_strSrcResDir..EXTENSION_CHROME..EXTENSION_ID, 		strExtension, 	EXTENSION_ID )

	WriteLogMsg( "TaobaoInstall: Finished." )

end


function TheworldInstall()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 8 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS
	local strSubKey 	= "Software\\TheWorld Chrome\\Chrome\\Extensions\\"

	WriteLogMsg( "TheworldInstall::strUserData: "..strUserData )
	WriteLogMsg( "TheworldInstall::strPrefs: "..strPrefs )
	WriteLogMsg( "TheworldInstall::strExtension: "..strExtension )
	WriteLogMsg( "TheworldInstall::strSubKey: "..strSubKey )

	CLuaChromeCoreInstall:UpdatePreferences( strPrefs, 				g_strSrcResDir..EXTENSION_CHROME..SETTING_JSON, EXTENSION_ID )
	CLuaChromeCoreInstall:UpdateRegInfo( strSubKey..EXTENSION_ID, 	g_str365App..W365_CRX_POSITION, 				WEATHER365_VERSION )
	CLuaChromeCoreInstall:CopyExtensionFiles( g_strSrcResDir..EXTENSION_CHROME..EXTENSION_ID, 		strExtension, 	EXTENSION_ID )

	WriteLogMsg( "TheworldInstall: Finished." )

end

-- End of installation interface definition.


-- The client will invoke the follows interfaces.
function Weather365Install( bDesktopShortcut, 	-- Create destop shortcut or not?
							bAddTaskbar,		-- Add to taskbar or not? For windows 7 or higher only.
							bAutoRun,			-- Auto run 365WeatherMain.exe while turning on computer or not?
							bInstallService,	-- Install service or not? Install by default.
							bInstallCfg,		-- Update config or not? Update/Repair not update.
							strInstDir,		-- Installation path.
							callBack			-- Progressbar callback function. Sliently installation is NULL.
						   )

	g_strInstDir		= strInstDir..WEATHER365
	g_strSrcResDir 		= CLuaPathMgr:GetCurProPath()
	g_str365App 		= strInstDir..WEATHER365_APP_DEFAULT
	WriteLogMsg( "365Install: g_str365App"..g_str365App )

	-- Start to install.
	-- Start with 5, since the first 5 percent is used to init the progressbar.
	for i = 5, 100 do

		-- Report the installation progress position.
		if nil ~= callBack then
			callBack( i )
		end

		if 15 == i then
			FileInstall( bInstallCfg )
		end

		if 30 == i then
			--SogouInstall()
		end

		if 35 == i then
			ChromeInstall()
		end

		if 40 == i then
			Chrome360Install()
		end

		if 45 == i then
			Safe360Install()
		end

		if 50== i then
			LiebaoInstall()
		end

		if 55 == i then
			TaobaoInstall()
		end

		if 60 == i then
			TheworldInstall()
		end

		if 65 == i then
			CaimaoInstall()
		end

		if 70 == i then
			CoolnovoInstall()
		end

		if 75 == i then
			--FirefoxInstall()
		end

		if 80 == i then
			--IEInstall()
		end

		if 85 == i then
			--MaxthonInstall()
		end


		if 90 == i then
			RegInstall( bDesktopShortcut, bAutoRun )
		end

		if 99 == i then
			ShortcutInstall( bDesktopShortcut, bAddTaskbar )
		end

	end

end
