-- The 365Uninst.exe will invoke this lua file to execute uninstallation operation.

require "luafiles.365Defs"
require "luafiles.Common"

function WriteLogMsg(msg)
	WriteFile( "c:\\b5m120\\365_lua_uninstall.log", msg )
end

-- Uninstallation interfaces definition.
function FileUninstall( bUpdateCfg , bDelTemFile )

	-- Delete "365Weather" folder.
	CLuaFileHelper:DelAllFiles( g_str365App )
	--local str365 = CLuaFileHelper:GetParentDir( g_str365App )
	--CLuaFileHelper:DelDir( str365 )
	CLuaFileHelper:DelDir( g_str365App )

	--WriteLogMsg( "FileUninstall::str365: "..str365 )

	-- Delete "365Setting" folder.
	if true == bUpdateCfg then
		--local strSetting = CLuaPathMgr:GetConfigPath()
		--strSetting = strSetting..WEATHER365_SETTING
		local strSetting = GetConfigPath()
		CLuaFileHelper:DelDir( strSetting )

		WriteLogMsg( "FileUninstall::strSetting: "..strSetting )
	end

	if true == bDelTemFile then
		local strTempFile = CLuaPathMgr:GetTemAllUserAppDataPath()
		strTempFile = strTempFile..WEATHER365
		CLuaFileHelper:DelAllFiles( strTempFile )

		CLuaFileHelper:DelDir( strTempFile )

		WriteLogMsg( "FileUninstall::strTempFile: "..strTempFile )
	end

	WriteLogMsg( "FileUninstall::Finished." )

end


function RegUninstall( bAutoRun )

	-- Remove Unistall register info.
	CLuaRegCommon:DeleteRegValue( HKEY_CURRENT_USER, REG_ITEM_UNINSTALL_32BIT, APP_NAME, true )

	WriteLogMsg( "RegUninstall::SubKey: "..REG_ITEM_UNINSTALL_32BIT.."; KeyName: "..APP_NAME )

	-- Remove Autorun register info.
	CLuaRegCommon:DeleteRegValue( HKEY_CURRENT_USER, REG_ITEM_AUTO_RUN, APP_NAME )

	WriteLogMsg( "RegUninstall::SubKey: "..REG_ITEM_AUTO_RUN.."; KeyName: "..APP_NAME )

	WriteLogMsg( "RegUninstall::Finished." )

end


function ShortcutUninstall(bDesktopShortcut, bAddTaskbar)

	local strStartmenu 	= CLuaPathMgr:GetStartmemuPath()
	local strDesktop 	= CLuaPathMgr:GetDesktopPath()
	local strTaskbar	= CLuaPathMgr:GetRoamingPath()
	strTaskbar = strTaskbar..TASKBAR_PATH..WEATHER365_LNK

	-- Remove Start menu.
	CLuaFileHelper:DelDir( strStartmenu..SLASH..APP_NAME )

	-- Remove Desktop shortcut.
	CLuaFileHelper:DelFile( strDesktop..WEATHER365_LNK )

	-- Unpin from taskbar.
	CLuaUtils:RemoveFromTaskbar( strTaskbar );

	WriteLogMsg( "ShortcutUninstall: Finished. strStartmenu: "..strStartmenu.."; strDesktop: "..strDesktop.."; strTaskbar: "..strTaskbar )

end

-- Chrome core installation.
function Chrome360Uninstall()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 2 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS
	local strSubKey 	= "Software\\360Chrome\\Chrome\\Extensions\\"

	WriteLogMsg( "Chrome360Uninstall::strUserData: "..strUserData )
	WriteLogMsg( "Chrome360Uninstall::strPrefs: "..strPrefs )
	WriteLogMsg( "Chrome360Uninstall::strExtension: "..strExtension )
	WriteLogMsg( "Chrome360Uninstall::strSubKey: "..strSubKey )

	CLuaChromeCoreInstall:RemovePreferences( strPrefs, 	EXTENSION_ID )
	CLuaChromeCoreInstall:RemoveRegInfo( strSubKey, 	EXTENSION_ID )
	CLuaChromeCoreInstall:RemoveExtensionFiles( strExtension..SLASH..EXTENSION_ID )

	WriteLogMsg( "Chrome360Uninstall: Finished." )

end


function Safe360Uninstall()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 3 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS
	local strSubKey 	= "Software\\360\\360se6\\Chrome\\Extensions\\"

	WriteLogMsg( "Safe360Uninstall::strUserData: "..strUserData )
	WriteLogMsg( "Safe360Uninstall::strPrefs: "..strPrefs )
	WriteLogMsg( "Safe360Uninstall::strExtension: "..strExtension )
	WriteLogMsg( "Safe360Uninstall::strSubKey: "..strSubKey )

	CLuaChromeCoreInstall:RemovePreferences( strPrefs, 	EXTENSION_ID )
	CLuaChromeCoreInstall:RemoveRegInfo( strSubKey, 	EXTENSION_ID )
	CLuaChromeCoreInstall:RemoveExtensionFiles( strExtension..SLASH..EXTENSION_ID )

	WriteLogMsg( "Safe360Uninstall: Finished." )

end


function CaimaoUninstall()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 6 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS

	WriteLogMsg( "CaimaoUninstall::strUserData: "..strUserData )
	WriteLogMsg( "CaimaoUninstall::strPrefs: "..strPrefs )
	WriteLogMsg( "CaimaoUninstall::strExtension: "..strExtension )

	CLuaChromeCoreInstall:RemovePreferences( strPrefs, EXTENSION_ID )
	CLuaChromeCoreInstall:RemoveExtensionFiles( strExtension..SLASH..EXTENSION_ID )

	WriteLogMsg( "CaimaoUninstall: Finished." )

end


function ChromeUninstall()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 1 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS
	local strSubKey 	= "Software\\Google\\Chrome\\Extensions\\"

	WriteLogMsg( "ChromeUninstall::strUserData: "..strUserData )
	WriteLogMsg( "ChromeUninstall::strPrefs: "..strPrefs )
	WriteLogMsg( "ChromeUninstall::strExtension: "..strExtension )
	WriteLogMsg( "ChromeUninstall::strSubKey: "..strSubKey )

	CLuaChromeCoreInstall:RemovePreferences( strPrefs, 	EXTENSION_ID )
	CLuaChromeCoreInstall:RemoveRegInfo( strSubKey, 	EXTENSION_ID )
	CLuaChromeCoreInstall:RemoveExtensionFiles( strExtension..SLASH..EXTENSION_ID )

	WriteLogMsg( "ChromeUninstall: Finished." )

end


function CoolnovoUninstall()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 7 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS

	WriteLogMsg( "CoolnovoUninstall::strUserData: "..strUserData )
	WriteLogMsg( "CoolnovoUninstall::strPrefs: "..strPrefs )
	WriteLogMsg( "CoolnovoUninstall::strExtension: "..strExtension )

	CLuaChromeCoreInstall:RemovePreferences( strPrefs, EXTENSION_ID )
	CLuaChromeCoreInstall:RemoveExtensionFiles( strExtension..SLASH..EXTENSION_ID )

	WriteLogMsg( "CoolnovoUninstall: Finished." )

end


function LiebaoUninstall()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 4 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS

	WriteLogMsg( "LiebaoUninstall::strUserData: "..strUserData )
	WriteLogMsg( "LiebaoUninstall::strPrefs: "..strPrefs )
	WriteLogMsg( "LiebaoUninstall::strExtension: "..strExtension )

	CLuaChromeCoreInstall:RemovePreferences( strPrefs, EXTENSION_ID )
	CLuaChromeCoreInstall:RemoveExtensionFiles( strExtension..SLASH..EXTENSION_ID )

	WriteLogMsg( "LiebaoUninstall: Finished." )

end


function TaobaoUninstall()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 5 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS

	WriteLogMsg( "TaobaoUninstall::strUserData: "..strUserData )
	WriteLogMsg( "TaobaoUninstall::strPrefs: "..strPrefs )
	WriteLogMsg( "TaobaoUninstall::strExtension: "..strExtension )

	CLuaChromeCoreInstall:RemovePreferences( strPrefs, EXTENSION_ID )
	CLuaChromeCoreInstall:RemoveExtensionFiles( strExtension..SLASH..EXTENSION_ID )

	WriteLogMsg( "TaobaoUninstall: Finished." )

end


function TheworldUninstall()

	local strUserData 	= CLuaPathMgr:GetChromeUserDataPath( 8 )
	local strPrefs 		= strUserData..DEFAULT_PREFERENCES
	local strExtension 	= strUserData..DEFAULT_EXTENSIONS
	local strSubKey 	= "Software\\TheWorld Chrome\\Chrome\\Extensions\\"

	WriteLogMsg( "TheworldUninstall::strUserData: "..strUserData )
	WriteLogMsg( "TheworldUninstall::strPrefs: "..strPrefs )
	WriteLogMsg( "TheworldUninstall::strExtension: "..strExtension )
	WriteLogMsg( "TheworldUninstall::strSubKey: "..strSubKey )

	CLuaChromeCoreInstall:RemovePreferences( strPrefs, 	EXTENSION_ID )
	CLuaChromeCoreInstall:RemoveRegInfo( strSubKey, 	EXTENSION_ID )
	CLuaChromeCoreInstall:RemoveExtensionFiles( strExtension..SLASH..EXTENSION_ID )

	WriteLogMsg( "TheworldUninstall: Finished." )

end
-- End of installation interface definition.


-- The client will invoke the follows interfaces.
function Weather365Uninstall( bRemoveCfg,		-- Remove config or not? Uninstalling before intallation will not.
							  callBack,			-- Progressbar callback function. Sliently uninstallation is NULL.
							  bDelTemFile       -- delete C:\ProgramData temp files
							)

	g_str365App = CLuaPathMgr:GetAppPath(APP_NAME, WEATHER365)
	--g_str365App = g_str365App..WEATHER365_APP_DEFAULT
	g_str365App = g_str365App..WEATHER365
	WriteLogMsg( "365Uninstall: g_str365App: "..g_str365App )

	-- Start to uninstall.
	-- Start with 5, since the first 5 percent is used to init the progressbar.
	for i = 5, 100 do

		-- Report the uninstallation progress position.
		if nil ~= callBack then
			callBack( i )
		end

		if 5 == i then
			ShortcutUninstall()
		end

		if 10 == i then
			--ServiceUninstall()
		end


		if 25 == i then
			--MaxthonUninstall()
		end


		if 30 == i then
			--SogouUninstall()
		end

		if 35 == i then
			ChromeUninstall()
		end

		if 40 == i then
			Chrome360Uninstall()
		end

		if 45 == i then
			Safe360Uninstall()
		end

		if 50 == i then
			LiebaoUninstall()
		end

		if 55 == i then
			TaobaoUninstall()
		end

		if 60 == i then
			TheworldUninstall()
		end

		if 65 == i then
			CaimaoUninstall()
		end

		if 70 == i then
			CoolnovoUninstall()
		end

		if 75 == i then
			--FirefoxUninstall()
		end

		if 80 == i then
			--IEUninstall()
		end

		if 85 == i then
			FileUninstall( bRemoveCfg , bDelTemFile)
		end

		if 99 == i then
			RegUninstall()
		end

	end

end
