/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.actions;

import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.actions.FixProjectAction;
import com.android.ide.eclipse.adt.internal.sdk.AdtConsoleSdkLog;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import com.android.sdklib.io.FileOp;
import com.android.sdkuilib.internal.repository.ui.AdtUpdateDialog;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.android.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class AddSupportJarAction
implements IObjectActionDelegate {
    private static final String VENDOR_ID = "android";
    private static final String SUPPORT_ID = "support";
    private static final String COMPATIBILITY_ID = "compatibility";
    private static final String FD_GRIDLAYOUT = "gridlayout";
    private static final String FD_V7 = "v7";
    private static final String FD_V4 = "v4";
    private static final String ANDROID_SUPPORT_V4_JAR = "android-support-v4.jar";
    private ISelection mSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.mSelection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.mSelection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                AddSupportJarAction.install(project);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mSelection = selection;
    }

    public static boolean install(IProject project) {
        File jarPath = AddSupportJarAction.installSupport(-1);
        if (jarPath != null) {
            try {
                return AddSupportJarAction.copyJarIntoProject(project, jarPath) != null;
            }
            catch (Exception e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
        }
        return false;
    }

    @Nullable
    public static File installSupport(int minimumRevision) {
        AdtUpdateDialog window;
        Pair result;
        File path;
        Sdk sdk = Sdk.getCurrent();
        if (sdk == null) {
            AdtPlugin.printErrorToConsole(AddSupportJarAction.class.getSimpleName(), "Error: Android SDK is not loaded yet.");
            return null;
        }
        String sdkLocation = sdk.getSdkLocation();
        if (minimumRevision > 0 && (path = AddSupportJarAction.getSupportJarFile()) != null) {
            assert (path.exists());
            int installedRevision = AddSupportJarAction.getInstalledRevision();
            if (installedRevision != -1 && minimumRevision <= installedRevision) {
                return path;
            }
        }
        if (!((Boolean)(result = (window = new AdtUpdateDialog(AdtPlugin.getShell(), (ILogger)new AdtConsoleSdkLog(), sdkLocation)).installExtraPackage(VENDOR_ID, SUPPORT_ID)).getFirst()).booleanValue()) {
            AdtPlugin.printErrorToConsole("Failed to install Android Support library", new Object[0]);
            return null;
        }
        File path2 = new File((File)result.getSecond(), FD_V4);
        File jarPath = new File(path2, ANDROID_SUPPORT_V4_JAR);
        if (!jarPath.isFile()) {
            AdtPlugin.printErrorToConsole("Android Support Jar not found:", jarPath.getAbsolutePath());
            return null;
        }
        return jarPath;
    }

    public static int getInstalledRevision() {
        Sdk sdk = Sdk.getCurrent();
        if (sdk != null) {
            String sdkLocation = sdk.getSdkLocation();
            SdkManager manager = SdkManager.createManager((String)sdkLocation, (ILogger)NullLogger.getLogger());
            Map versions = manager.getExtrasVersions();
            Integer version = (Integer)versions.get("android/support");
            if (version == null) {
                version = (Integer)versions.get("android/compatibility");
            }
            if (version != null) {
                return version;
            }
        }
        return -1;
    }

    public static boolean installGridLayoutLibrary(IProject project, boolean waitForFinish) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            IProject libraryProject;
            File libraryPath;
            File supportPath = AddSupportJarAction.getSupportPackageDir();
            if (!supportPath.isDirectory()) {
                File path = AddSupportJarAction.installSupport(8);
                if (path == null) {
                    return false;
                }
                assert (path.equals(supportPath));
            }
            if (!(libraryPath = new File(supportPath, FD_V7 + File.separator + FD_GRIDLAYOUT)).isDirectory()) {
                File path = AddSupportJarAction.installSupport(-1);
                if (path == null) {
                    return false;
                }
                assert (path.equals(libraryPath)) : path;
            }
            if ((libraryProject = AddSupportJarAction.createLibraryProject(libraryPath, project, waitForFinish)) != null) {
                return AddSupportJarAction.addLibraryDependency(libraryProject, project, waitForFinish);
            }
        }
        return false;
    }

    private static File getSupportPackageDir() {
        Sdk sdk = Sdk.getCurrent();
        if (sdk != null) {
            String sdkLocation = sdk.getSdkLocation();
            SdkManager manager = SdkManager.createManager((String)sdkLocation, (ILogger)NullLogger.getLogger());
            Map versions = manager.getExtrasVersions();
            Integer version = (Integer)versions.get("android/support");
            if (version != null) {
                File supportPath = new File(sdkLocation, "extras" + File.separator + VENDOR_ID + File.separator + SUPPORT_ID);
                return supportPath;
            }
            version = (Integer)versions.get("android/compatibility");
            if (version != null) {
                File supportPath = new File(sdkLocation, "extras" + File.separator + VENDOR_ID + File.separator + COMPATIBILITY_ID);
                return supportPath;
            }
        }
        return null;
    }

    @Nullable
    public static File getSupportJarFile() {
        File path;
        File supportDir = AddSupportJarAction.getSupportPackageDir();
        if (supportDir != null && (path = new File(supportDir, FD_V4 + File.separator + ANDROID_SUPPORT_V4_JAR)).exists()) {
            return path;
        }
        return null;
    }

    private static IProject createLibraryProject(File libraryPath, IProject project, boolean waitForFinish) {
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            String name = AdtUtils.getUniqueProjectName("gridlayout_v7", "_");
            IProject newProject = root.getProject(name);
            IProjectDescription description = workspace.newProjectDescription(name);
            String[] natures = new String[]{"com.android.ide.eclipse.adt.AndroidNature", "org.eclipse.jdt.core.javanature"};
            description.setNatureIds(natures);
            newProject.create(description, (IProgressMonitor)monitor);
            IFileSystem fileSystem = EFS.getLocalFileSystem();
            IFileStore sourceDir = fileSystem.getStore(libraryPath.toURI());
            IFileStore destDir = fileSystem.getStore(newProject.getLocationURI());
            sourceDir.copy(destDir, 2, null);
            destDir.getChild("src").mkdir(0, null);
            ProjectState state = Sdk.getProjectState(project);
            String target = state.getProperties().getProperty("target");
            if (target != null && target.length() > 0) {
                ProjectProperties properties = ProjectProperties.load((String)libraryPath.getPath(), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.PROJECT);
                ProjectPropertiesWorkingCopy copy = properties.makeWorkingCopy();
                copy.setProperty("target", target);
                try {
                    copy.save();
                }
                catch (Exception e) {
                    AdtPlugin.log(e, null, new Object[0]);
                }
            }
            newProject.open((IProgressMonitor)monitor);
            return newProject;
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
            return null;
        }
    }

    public static boolean addLibraryDependency(final IProject libraryProject, final IProject dependentProject, boolean waitForFinish) {
        Job job = new Job("Add Support Library Dependency to Project"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Add library dependency to project build path", 3);
                    monitor.worked(1);
                    ProjectState state = Sdk.getProjectState(dependentProject);
                    ProjectPropertiesWorkingCopy mPropertiesWorkingCopy = state.getProperties().makeWorkingCopy();
                    int nextVersion = 1;
                    for (String property : mPropertiesWorkingCopy.keySet()) {
                        String s;
                        int version;
                        if (!property.startsWith("android.library.reference.") || (version = Integer.parseInt(s = property.substring("android.library.reference.".length()))) < nextVersion) continue;
                        nextVersion = version + 1;
                    }
                    IPath relativePath = libraryProject.getLocation().makeRelativeTo(dependentProject.getLocation());
                    mPropertiesWorkingCopy.setProperty("android.library.reference." + nextVersion, relativePath.toString());
                    try {
                        mPropertiesWorkingCopy.save();
                        IResource projectProp = dependentProject.findMember("project.properties");
                        projectProp.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        String msg = String.format("Failed to save %1$s for project %2$s", "project.properties", dependentProject.getName());
                        AdtPlugin.log(e, msg, new Object[0]);
                    }
                    Job fix = FixProjectAction.createFixProjectJob(libraryProject);
                    fix.schedule();
                    fix.join();
                    monitor.worked(1);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    Status status = new Status(4, "com.android.ide.eclipse.adt", 4, "Failed", (Throwable)e);
                    return status;
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
        };
        job.schedule();
        if (waitForFinish) {
            try {
                job.join();
                return job.getState() == 0;
            }
            catch (InterruptedException e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
        }
        return true;
    }

    private static IResource copyJarIntoProject(IProject project, File jarPath) throws IOException, CoreException {
        IFile destFile;
        IPath loc;
        File destPath;
        FileOp f;
        IFolder resFolder = project.getFolder("libs");
        if (!resFolder.exists()) {
            resFolder.create(1, true, null);
        }
        if (!(f = new FileOp()).isFile(destPath = (loc = (destFile = resFolder.getFile(jarPath.getName())).getLocation()).toFile()) || !f.isSameFile(jarPath, destPath)) {
            f.copyFile(jarPath, destPath);
            resFolder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        return destFile;
    }

    public void init(IWorkbenchWindow window) {
    }
}

