/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.actions;

import com.android.annotations.NonNull;
import com.android.ide.eclipse.adt.internal.project.AndroidNature;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class FixProjectAction
implements IObjectActionDelegate {
    private ISelection mSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.mSelection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.mSelection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                this.fixProject(project);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mSelection = selection;
    }

    private void fixProject(IProject project) {
        FixProjectAction.createFixProjectJob(project).schedule();
    }

    @NonNull
    public static Job createFixProjectJob(final @NonNull IProject project) {
        return new Job("Fix Project Properties"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (monitor != null) {
                        monitor.beginTask("Fix Project Properties", 6);
                    }
                    ProjectHelper.fixProject(project);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    ProjectHelper.fixProjectNatureOrder(project);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    AndroidNature.configureResourceManagerBuilder(project);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    AndroidNature.configurePreBuilder(project);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    AndroidNature.configureApkBuilder(project);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (JavaModelException e) {
                    IJavaModelStatus iJavaModelStatus = e.getJavaModelStatus();
                    return iJavaModelStatus;
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    return iStatus;
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
        };
    }

    public void init(IWorkbenchWindow window) {
    }
}

