/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AndroidPrintStream;
import com.android.ide.eclipse.adt.internal.build.AaptExecException;
import com.android.ide.eclipse.adt.internal.build.AaptResultException;
import com.android.ide.eclipse.adt.internal.build.DexException;
import com.android.ide.eclipse.adt.internal.build.DexWrapper;
import com.android.ide.eclipse.adt.internal.build.Messages;
import com.android.ide.eclipse.adt.internal.build.NativeLibInJarException;
import com.android.ide.eclipse.adt.internal.build.ProguardExecException;
import com.android.ide.eclipse.adt.internal.build.ProguardResultException;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.build.ApkBuilder;
import com.android.sdklib.build.ApkCreationException;
import com.android.sdklib.build.DuplicateFileException;
import com.android.sdklib.build.RenderScriptProcessor;
import com.android.sdklib.build.SealedApkException;
import com.android.sdklib.internal.build.DebugKeyProvider;
import com.android.sdklib.util.GrabProcessOutput;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.IPreferenceStore;

public class BuildHelper {
    private static final String CONSOLE_PREFIX_DX = "Dx";
    private static final String TEMP_PREFIX = "android_";
    private static final String COMMAND_CRUNCH = "crunch";
    private static final String COMMAND_PACKAGE = "package";
    @NonNull
    private final ProjectState mProjectState;
    @NonNull
    private final IProject mProject;
    @NonNull
    private final BuildToolInfo mBuildToolInfo;
    @NonNull
    private final AndroidPrintStream mOutStream;
    @NonNull
    private final AndroidPrintStream mErrStream;
    private final boolean mForceJumbo;
    private final boolean mDisableDexMerger;
    private final boolean mVerbose;
    private final boolean mDebugMode;
    private final Set<String> mCompiledCodePaths = new HashSet<String>();
    public static final boolean BENCHMARK_FLAG = false;
    public static long sStartOverallTime = 0L;
    public static long sStartJavaCTime = 0L;
    private static final int MILLION = 1000000;
    private String mProguardFile;

    public BuildHelper(@NonNull ProjectState projectState, @NonNull BuildToolInfo buildToolInfo, @NonNull AndroidPrintStream outStream, @NonNull AndroidPrintStream errStream, boolean forceJumbo, boolean disableDexMerger, boolean debugMode, boolean verbose, ResourceMarker resMarker) throws CoreException {
        this.mProjectState = projectState;
        this.mProject = projectState.getProject();
        this.mBuildToolInfo = buildToolInfo;
        this.mOutStream = outStream;
        this.mErrStream = errStream;
        this.mDebugMode = debugMode;
        this.mVerbose = verbose;
        this.mForceJumbo = forceJumbo;
        this.mDisableDexMerger = disableDexMerger;
        this.gatherPaths(resMarker);
    }

    public void updateCrunchCache() throws AaptExecException, AaptResultException {
        long startCrunchTime = 0L;
        IFolder resFolder = this.mProject.getFolder("/res");
        ArrayList<String> resPaths = new ArrayList<String>();
        resPaths.add(resFolder.getLocation().toOSString());
        IFolder binFolder = BaseProjectHelper.getAndroidOutputFolder(this.mProject);
        IFolder cacheFolder = binFolder.getFolder("res/crunch");
        String cachePath = cacheFolder.getLocation().toOSString();
        this.executeAapt(COMMAND_CRUNCH, "", resPaths, "", cachePath, "", 0);
    }

    public void packageResources(IFile manifestFile, List<IProject> libProjects, String resFilter, int versionCode, String outputFolder, String outputFilename) throws AaptExecException, AaptResultException {
        long startPackageTime = 0L;
        IFolder binFolder = BaseProjectHelper.getAndroidOutputFolder(this.mProject);
        IFolder cacheFolder = binFolder.getFolder("res/crunch");
        IFolder bcFolder = binFolder.getFolder("res/bc");
        IFolder resFolder = this.mProject.getFolder("/res");
        IFolder assetsFolder = this.mProject.getFolder("/assets");
        if (!assetsFolder.exists()) {
            assetsFolder = null;
        }
        ArrayList<String> osResPaths = new ArrayList<String>();
        IPath resLocation = resFolder.getLocation();
        IPath manifestLocation = manifestFile.getLocation();
        if (resLocation != null && manifestLocation != null) {
            this.addFolderToList(osResPaths, cacheFolder);
            this.addFolderToList(osResPaths, bcFolder);
            osResPaths.add(resLocation.toOSString());
            if (libProjects != null) {
                for (IProject lib : libProjects) {
                    IFolder libBinFolder = BaseProjectHelper.getAndroidOutputFolder(lib);
                    IFolder libCacheFolder = libBinFolder.getFolder("res/crunch");
                    this.addFolderToList(osResPaths, libCacheFolder);
                    IFolder libBcFolder = libBinFolder.getFolder("res/bc");
                    this.addFolderToList(osResPaths, libBcFolder);
                    IFolder libResFolder = lib.getFolder("/res");
                    this.addFolderToList(osResPaths, libResFolder);
                }
            }
            String osManifestPath = manifestLocation.toOSString();
            String osAssetsPath = null;
            if (assetsFolder != null) {
                osAssetsPath = assetsFolder.getLocation().toOSString();
            }
            this.executeAapt(COMMAND_PACKAGE, osManifestPath, osResPaths, osAssetsPath, String.valueOf(outputFolder) + File.separator + outputFilename, resFilter, versionCode);
        }
    }

    private void addFolderToList(List<String> pathList, IFolder folder) {
        File testFile = new File(folder.getLocation().toOSString());
        if (testFile.isDirectory()) {
            pathList.add(testFile.getAbsolutePath());
        }
    }

    public void finalDebugPackage(String intermediateApk, String dex, String output, List<IProject> libProjects, ResourceMarker resMarker) throws ApkCreationException, DebugKeyProvider.KeytoolException, AndroidLocation.AndroidLocationException, NativeLibInJarException, DuplicateFileException, CoreException {
        AdtPlugin adt = AdtPlugin.getDefault();
        if (adt == null) {
            return;
        }
        IPreferenceStore store = adt.getPreferenceStore();
        String keystoreOsPath = store.getString("com.android.ide.eclipse.adt.customDebugKeyStore");
        if (keystoreOsPath == null || !new File(keystoreOsPath).isFile()) {
            keystoreOsPath = DebugKeyProvider.getDefaultKeyStoreOsPath();
            AdtPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, this.mProject, Messages.ApkBuilder_Using_Default_Key);
        } else {
            AdtPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, this.mProject, String.format(Messages.ApkBuilder_Using_s_To_Sign, keystoreOsPath));
        }
        ApkBuilder.SigningInfo info = ApkBuilder.getDebugKey((String)keystoreOsPath, (PrintStream)(this.mVerbose ? this.mOutStream : null));
        this.finalPackage(intermediateApk, dex, output, libProjects, info != null ? info.key : null, info != null ? info.certificate : null, resMarker);
    }

    public void finalPackage(String intermediateApk, String dex, String output, List<IProject> libProjects, PrivateKey key, X509Certificate certificate, ResourceMarker resMarker) throws NativeLibInJarException, ApkCreationException, DuplicateFileException, CoreException {
        try {
            ApkBuilder apkBuilder = new ApkBuilder(output, intermediateApk, dex, key, certificate, (PrintStream)(this.mVerbose ? this.mOutStream : null));
            apkBuilder.setDebugMode(this.mDebugMode);
            Collection<String> pathsCollection = this.mCompiledCodePaths;
            if (this.mProguardFile != null) {
                pathsCollection = Collections.singletonList(this.mProguardFile);
                this.mProguardFile = null;
            }
            for (String path : pathsCollection) {
                File file = new File(path);
                if (file.isFile()) {
                    ApkBuilder.JarStatus jarStatus = apkBuilder.addResourcesFromJar(file);
                    if (jarStatus.getNativeLibs().size() <= 0) continue;
                    String libName = file.getName();
                    String msg = String.format("Native libraries detected in '%1$s'. See console for more information.", libName);
                    ArrayList<String> consoleMsgs = new ArrayList<String>();
                    consoleMsgs.add(String.format("The library '%1$s' contains native libraries that will not run on the device.", libName));
                    if (jarStatus.hasNativeLibsConflicts()) {
                        consoleMsgs.add("Additionally some of those libraries will interfer with the installation of the application because of their location in lib/");
                        consoleMsgs.add("lib/ is reserved for NDK libraries.");
                    }
                    consoleMsgs.add("The following libraries were found:");
                    for (String lib : jarStatus.getNativeLibs()) {
                        consoleMsgs.add(" - " + lib);
                    }
                    String[] consoleStrings = consoleMsgs.toArray(new String[consoleMsgs.size()]);
                    if (jarStatus.hasNativeLibsConflicts() || AdtPrefs.getPrefs().getBuildForceErrorOnNativeLibInJar()) {
                        throw new NativeLibInJarException(jarStatus, msg, libName, consoleStrings);
                    }
                    if (resMarker != null) {
                        resMarker.setWarning((IResource)this.mProject, msg);
                    }
                    String[] stringArray = consoleStrings;
                    int n = consoleStrings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        this.mOutStream.println(string);
                        ++n2;
                    }
                    continue;
                }
                if (!file.isDirectory()) continue;
                apkBuilder.addSourceFolder(file);
            }
            IResource libFolder = this.mProject.findMember("libs");
            if (libFolder != null && libFolder.exists() && libFolder.getType() == 2) {
                apkBuilder.addNativeLibraries(libFolder.getLocation().toFile());
            }
            if (this.mProjectState.getRenderScriptSupportMode()) {
                File rsLibs;
                IFolder androidOutputFolder = BaseProjectHelper.getAndroidOutputFolder(this.mProject);
                IFolder rsLibFolder = androidOutputFolder.getFolder("rsLibs");
                File rsLibFolderFile = rsLibFolder.getLocation().toFile();
                if (rsLibFolderFile.isDirectory()) {
                    apkBuilder.addNativeLibraries(rsLibFolderFile);
                }
                if ((rsLibs = RenderScriptProcessor.getSupportNativeLibFolder((String)this.mBuildToolInfo.getLocation().getAbsolutePath())).isDirectory()) {
                    apkBuilder.addNativeLibraries(rsLibs);
                }
            }
            if (libProjects != null) {
                for (IProject lib : libProjects) {
                    libFolder = lib.findMember("libs");
                    if (libFolder == null || !libFolder.exists() || libFolder.getType() != 2) continue;
                    apkBuilder.addNativeLibraries(libFolder.getLocation().toFile());
                }
            }
            apkBuilder.sealApk();
        }
        catch (SealedApkException sealedApkException) {}
    }

    public void setProguardOutput(String proguardFile) {
        this.mProguardFile = proguardFile;
    }

    public Collection<String> getCompiledCodePaths() {
        return this.mCompiledCodePaths;
    }

    public void runProguard(List<File> proguardConfigs, File inputJar, Collection<String> jarFiles, File obfuscatedJar, File logOutput) throws ProguardResultException, ProguardExecException, IOException {
        String msg;
        IAndroidTarget target = Sdk.getCurrent().getTarget(this.mProject);
        ArrayList<String> command = new ArrayList<String>();
        command.add(AdtPlugin.getOsAbsoluteProguard());
        for (File configFile : proguardConfigs) {
            command.add("-include");
            command.add(this.quotePath(configFile.getAbsolutePath()));
        }
        command.add("-injars");
        StringBuilder sb = new StringBuilder(this.quotePath(inputJar.getAbsolutePath()));
        for (String jarFile : jarFiles) {
            sb.append(File.pathSeparatorChar);
            sb.append(this.quotePath(jarFile));
        }
        command.add(this.quoteWinArg(sb.toString()));
        command.add("-outjars");
        command.add(this.quotePath(obfuscatedJar.getAbsolutePath()));
        command.add("-libraryjars");
        sb = new StringBuilder(this.quotePath(target.getPath(1)));
        IAndroidTarget.IOptionalLibrary[] libraries = target.getOptionalLibraries();
        if (libraries != null) {
            IAndroidTarget.IOptionalLibrary[] iOptionalLibraryArray = libraries;
            int n = libraries.length;
            int n2 = 0;
            while (n2 < n) {
                IAndroidTarget.IOptionalLibrary lib = iOptionalLibraryArray[n2];
                sb.append(File.pathSeparatorChar);
                sb.append(this.quotePath(lib.getJarPath()));
                ++n2;
            }
        }
        command.add(this.quoteWinArg(sb.toString()));
        if (logOutput != null) {
            if (!logOutput.isDirectory()) {
                logOutput.mkdirs();
            }
            command.add("-dump");
            command.add(new File(logOutput, "dump.txt").getAbsolutePath());
            command.add("-printseeds");
            command.add(new File(logOutput, "seeds.txt").getAbsolutePath());
            command.add("-printusage");
            command.add(new File(logOutput, "usage.txt").getAbsolutePath());
            command.add("-printmapping");
            command.add(new File(logOutput, "mapping.txt").getAbsolutePath());
        }
        String[] commandArray = null;
        if (SdkConstants.currentPlatform() == 2) {
            commandArray = this.createWindowsProguardConfig(command);
        }
        if (commandArray == null) {
            commandArray = command.toArray(new String[command.size()]);
        }
        String[] envp = null;
        TreeMap<String, String> envMap = new TreeMap<String, String>(System.getenv());
        if (!envMap.containsKey("PROGUARD_HOME")) {
            envMap.put("PROGUARD_HOME", String.valueOf(Sdk.getCurrent().getSdkLocation()) + "tools" + File.separator + "proguard");
            envp = new String[envMap.size()];
            int i = 0;
            for (Map.Entry entry : envMap.entrySet()) {
                envp[i++] = String.format("%1$s=%2$s", entry.getKey(), entry.getValue());
            }
        }
        if (AdtPrefs.getPrefs().getBuildVerbosity() == AdtPrefs.BuildVerbosity.VERBOSE) {
            sb = new StringBuilder();
            String[] stringArray = commandArray;
            int n = commandArray.length;
            int entry = 0;
            while (entry < n) {
                String c = stringArray[entry];
                sb.append(c).append(' ');
                ++entry;
            }
            AdtPlugin.printToConsole(this.mProject, sb.toString());
        }
        int execError = 1;
        try {
            Process process = Runtime.getRuntime().exec(commandArray, envp);
            ArrayList<String> results = new ArrayList<String>();
            execError = BuildHelper.grabProcessOutput(this.mProject, process, results);
            if (this.mVerbose) {
                for (String resultString : results) {
                    this.mOutStream.println(resultString);
                }
            }
            if (execError != 0) {
                throw new ProguardResultException(execError, results.toArray(new String[results.size()]));
            }
        }
        catch (IOException e) {
            msg = String.format(Messages.Proguard_Exec_Error, commandArray[0]);
            throw new ProguardExecException(msg, e);
        }
        catch (InterruptedException e) {
            msg = String.format(Messages.Proguard_Exec_Error, commandArray[0]);
            throw new ProguardExecException(msg, e);
        }
    }

    private String[] createWindowsProguardConfig(List<String> command) throws IOException {
        String launcher = AdtPlugin.readFile(new File(command.get(0)));
        if (launcher.contains("%*")) {
            return null;
        }
        String[] commandArray = new String[3];
        commandArray[0] = command.get(0);
        commandArray[1] = command.get(1);
        File argsFile = File.createTempFile(TEMP_PREFIX, ".pro");
        argsFile.deleteOnExit();
        FileWriter fw = new FileWriter(argsFile);
        int i = 2;
        while (i < command.size()) {
            String s = command.get(i);
            fw.write(s);
            fw.write(s.startsWith("-") ? 32 : 10);
            ++i;
        }
        fw.close();
        commandArray[2] = "@" + argsFile.getAbsolutePath();
        return commandArray;
    }

    private String quotePath(String path) {
        if (path.indexOf(32) != -1) {
            path = String.valueOf('\'') + path + '\'';
        }
        return path;
    }

    private String quoteWinArg(String path) {
        if (path.indexOf(39) != -1 && SdkConstants.currentPlatform() == 2) {
            path = String.valueOf('\"') + path + '\"';
        }
        return path;
    }

    public void executeDx(IJavaProject javaProject, Collection<String> inputPaths, String osOutFilePath) throws CoreException, DexException {
        Sdk sdk = Sdk.getCurrent();
        DexWrapper wrapper = sdk.getDexWrapper(this.mBuildToolInfo);
        if (wrapper == null) {
            throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", Messages.ApkBuilder_UnableBuild_Dex_Not_loaded));
        }
        try {
            this.mOutStream.setPrefix(CONSOLE_PREFIX_DX);
            this.mErrStream.setPrefix(CONSOLE_PREFIX_DX);
            IFolder binFolder = BaseProjectHelper.getAndroidOutputFolder(javaProject.getProject());
            File binFile = binFolder.getLocation().toFile();
            File dexedLibs = new File(binFile, "dexedLibs");
            if (!dexedLibs.exists()) {
                dexedLibs.mkdir();
            }
            ArrayList<String> finalInputPaths = new ArrayList<String>(inputPaths.size());
            if (this.mDisableDexMerger || inputPaths.size() == 1) {
                finalInputPaths.addAll(inputPaths);
            } else {
                for (String input : inputPaths) {
                    File inputFile = new File(input);
                    if (inputFile.isDirectory()) {
                        finalInputPaths.add(input);
                        continue;
                    }
                    if (!inputFile.isFile()) continue;
                    String fileName = this.getDexFileName(inputFile);
                    File dexedLib = new File(dexedLibs, fileName);
                    String dexedLibPath = dexedLib.getAbsolutePath();
                    if (!dexedLib.isFile() || dexedLib.lastModified() < inputFile.lastModified()) {
                        int res;
                        if (this.mVerbose) {
                            this.mOutStream.println(String.format("Pre-Dexing %1$s -> %2$s", input, fileName));
                        }
                        if (dexedLib.isFile()) {
                            dexedLib.delete();
                        }
                        if ((res = wrapper.run(dexedLibPath, Collections.singleton(input), this.mForceJumbo, this.mVerbose, this.mOutStream, this.mErrStream)) != 0) {
                            String message = String.format(Messages.Dalvik_Error_d, res);
                            throw new DexException(message);
                        }
                    } else if (this.mVerbose) {
                        this.mOutStream.println(String.format("Using Pre-Dexed %1$s <- %2$s", fileName, input));
                    }
                    finalInputPaths.add(dexedLibPath);
                }
            }
            if (this.mVerbose) {
                for (String input : finalInputPaths) {
                    this.mOutStream.println("Input: " + input);
                }
            }
            int res = wrapper.run(osOutFilePath, finalInputPaths, this.mForceJumbo, this.mVerbose, this.mOutStream, this.mErrStream);
            this.mOutStream.setPrefix(null);
            this.mErrStream.setPrefix(null);
            if (res != 0) {
                String message = String.format(Messages.Dalvik_Error_d, res);
                throw new DexException(message);
            }
        }
        catch (DexException e) {
            throw e;
        }
        catch (Throwable t) {
            String message = t.getMessage();
            if (message == null) {
                message = t.getClass().getCanonicalName();
            }
            message = String.format(Messages.Dalvik_Error_s, message);
            throw new DexException(message, t);
        }
    }

    private String getDexFileName(File inputFile) {
        String name = inputFile.getName();
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        HashFunction hashFunction = Hashing.md5();
        HashCode hashCode = hashFunction.hashString((CharSequence)inputFile.getAbsolutePath());
        return String.valueOf(name) + "-" + hashCode.toString() + ".jar";
    }

    private void executeAapt(String aaptCommand, String osManifestPath, List<String> osResPaths, String osAssetsPath, String osOutFilePath, String configFilter, int versionCode) throws AaptExecException, AaptResultException {
        IAndroidTarget target = Sdk.getCurrent().getTarget(this.mProject);
        String aapt = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.AAPT);
        ArrayList<String> commandArray = new ArrayList<String>();
        commandArray.add(aapt);
        commandArray.add(aaptCommand);
        if (AdtPrefs.getPrefs().getBuildVerbosity() == AdtPrefs.BuildVerbosity.VERBOSE) {
            commandArray.add("-v");
        }
        for (String path : osResPaths) {
            commandArray.add("-S");
            commandArray.add(path);
        }
        if (aaptCommand.equals(COMMAND_PACKAGE)) {
            commandArray.add("-f");
            commandArray.add("--no-crunch");
            if (osResPaths.size() > 1) {
                commandArray.add("--auto-add-overlay");
            }
            if (this.mDebugMode) {
                commandArray.add("--debug-mode");
            }
            if (versionCode > 0) {
                commandArray.add("--version-code");
                commandArray.add(Integer.toString(versionCode));
            }
            if (configFilter != null) {
                commandArray.add("-c");
                commandArray.add(configFilter);
            }
            commandArray.add("-M");
            commandArray.add(osManifestPath);
            if (osAssetsPath != null) {
                commandArray.add("-A");
                commandArray.add(osAssetsPath);
            }
            commandArray.add("-I");
            commandArray.add(target.getPath(1));
            commandArray.add("-F");
            commandArray.add(osOutFilePath);
        } else if (aaptCommand.equals(COMMAND_CRUNCH)) {
            commandArray.add("-C");
            commandArray.add(osOutFilePath);
        }
        String[] command = commandArray.toArray(new String[commandArray.size()]);
        if (AdtPrefs.getPrefs().getBuildVerbosity() == AdtPrefs.BuildVerbosity.VERBOSE) {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = command;
            int n = command.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                sb.append(c);
                sb.append(' ');
                ++n2;
            }
            AdtPlugin.printToConsole(this.mProject, sb.toString());
        }
        long startAaptTime = 0L;
        try {
            Process process = Runtime.getRuntime().exec(command);
            ArrayList<String> stdErr = new ArrayList<String>();
            int returnCode = BuildHelper.grabProcessOutput(this.mProject, process, stdErr);
            if (this.mVerbose) {
                for (String stdErrString : stdErr) {
                    this.mOutStream.println(stdErrString);
                }
            }
            if (returnCode != 0) {
                throw new AaptResultException(returnCode, stdErr.toArray(new String[stdErr.size()]));
            }
        }
        catch (IOException e) {
            String msg = String.format(Messages.AAPT_Exec_Error_s, command[0]);
            throw new AaptExecException(msg, e);
        }
        catch (InterruptedException e) {
            String msg = String.format(Messages.AAPT_Exec_Error_s, command[0]);
            throw new AaptExecException(msg, e);
        }
    }

    private void gatherPaths(ResourceMarker resMarker) throws CoreException {
        IClasspathEntry[] classpaths;
        IJavaProject javaProject;
        IPath path;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource outputResource = wsRoot.findMember(path = (javaProject = JavaCore.create((IProject)this.mProject)).getOutputLocation());
        if (outputResource != null && outputResource.getType() == 2) {
            this.mCompiledCodePaths.add(outputResource.getLocation().toOSString());
        }
        if ((classpaths = javaProject.readRawClasspath()) != null) {
            IClasspathEntry[] iClasspathEntryArray = classpaths;
            int n = classpaths.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.isExported() || e.getEntryKind() == 5 && e.getPath().toString().equals("com.android.ide.eclipse.adt.DEPENDENCIES")) {
                    this.handleCPE(e, javaProject, wsRoot, resMarker);
                }
                ++n2;
            }
        }
    }

    private void handleCPE(IClasspathEntry entry, IJavaProject javaProject, IWorkspaceRoot wsRoot, ResourceMarker resMarker) {
        if (entry.getEntryKind() == 4) {
            entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
        }
        if (entry.getEntryKind() == 2) {
            IProject refProject = wsRoot.getProject(entry.getPath().lastSegment());
            try {
                IJavaProject refJavaProject;
                IPath path;
                IResource outputResource;
                if (refProject.hasNature("org.eclipse.jdt.core.javanature") && !refProject.hasNature("com.android.ide.eclipse.adt.AndroidNature") && (outputResource = wsRoot.findMember(path = (refJavaProject = JavaCore.create((IProject)refProject)).getOutputLocation())) != null && outputResource.getType() == 2) {
                    this.mCompiledCodePaths.add(outputResource.getLocation().toOSString());
                }
            }
            catch (CoreException coreException) {}
        } else if (entry.getEntryKind() == 1) {
            this.handleClasspathLibrary(entry, wsRoot, resMarker);
        } else if (entry.getEntryKind() == 5) {
            try {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject);
                if (container != null && container.getKind() == 1) {
                    IClasspathEntry[] entries;
                    IClasspathEntry[] iClasspathEntryArray = entries = container.getClasspathEntries();
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry cpe = iClasspathEntryArray[n2];
                        this.handleCPE(cpe, javaProject, wsRoot, resMarker);
                        ++n2;
                    }
                }
            }
            catch (JavaModelException jme) {
                AdtPlugin.log(jme, "Failed to resolve ClasspathContainer: %s", entry.getPath());
            }
        }
    }

    private void handleClasspathLibrary(IClasspathEntry e, IWorkspaceRoot wsRoot, ResourceMarker resMarker) {
        IPath path = e.getPath();
        IResource resource = wsRoot.findMember(path);
        if (resource == null || resource.getType() != 4) {
            if ("jar".equalsIgnoreCase(path.getFileExtension())) {
                if (resource != null && resource.exists() && resource.getType() == 1) {
                    this.mCompiledCodePaths.add(resource.getLocation().toOSString());
                } else {
                    String osFullPath = path.toOSString();
                    File f = new File(osFullPath);
                    if (f.isFile()) {
                        this.mCompiledCodePaths.add(osFullPath);
                    } else {
                        String message = String.format(Messages.Couldnt_Locate_s_Error, path);
                        this.mOutStream.println(message);
                        if (resMarker != null) {
                            resMarker.setWarning((IResource)this.mProject, message);
                        }
                    }
                }
            } else if (resource != null && resource.exists() && resource.getType() == 2) {
                this.mCompiledCodePaths.add(resource.getLocation().toOSString());
            } else {
                String osFullPath = path.toOSString();
                File f = new File(osFullPath);
                if (f.isDirectory()) {
                    this.mCompiledCodePaths.add(osFullPath);
                }
            }
        }
    }

    public static boolean checkFileForPackaging(IFile file) {
        String name = file.getName();
        String ext = file.getFileExtension();
        return ApkBuilder.checkFileForPackaging((String)name, (String)ext);
    }

    public static boolean checkFolderForPackaging(IFolder folder) {
        String name = folder.getName();
        return ApkBuilder.checkFolderForPackaging((String)name);
    }

    public static List<IJavaProject> getJavaProjects(List<IProject> projects) throws CoreException {
        ArrayList<IJavaProject> list = new ArrayList<IJavaProject>();
        for (IProject p : projects) {
            if (!p.isOpen() || !p.hasNature("org.eclipse.jdt.core.javanature")) continue;
            list.add(JavaCore.create((IProject)p));
        }
        return list;
    }

    public static final int grabProcessOutput(final IProject project, Process process, final ArrayList<String> stderr) throws InterruptedException {
        return GrabProcessOutput.grabProcessOutput((Process)process, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(){

            public void out(@Nullable String line) {
                if (line != null) {
                    AdtPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, project, line);
                }
            }

            public void err(@Nullable String line) {
                if (line != null) {
                    stderr.add(line);
                    if (AdtPrefs.BuildVerbosity.VERBOSE == AdtPrefs.getPrefs().getBuildVerbosity()) {
                        AdtPlugin.printErrorToConsole(project, new Object[]{line});
                    }
                }
            }
        });
    }

    public static interface ResourceMarker {
        public void setWarning(IResource var1, String var2);
    }
}

