/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build;

import com.android.annotations.NonNull;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.build.BuildHelper;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.sdklib.build.RenderScriptProcessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class RenderScriptLauncher
implements RenderScriptProcessor.CommandLineLauncher {
    private static Pattern sLlvmPattern1 = Pattern.compile("^(.+?):(\\d+):(\\d+):\\s(.+)$");
    @NonNull
    private final IProject mProject;
    @NonNull
    private final IFolder mSourceOutFolder;
    @NonNull
    private final IFolder mResOutFolder;
    @NonNull
    private final IProgressMonitor mMonitor;
    private final boolean mVerbose;

    public RenderScriptLauncher(@NonNull IProject project, @NonNull IFolder sourceOutFolder, @NonNull IFolder resOutFolder, @NonNull IProgressMonitor monitor, boolean verbose) {
        this.mProject = project;
        this.mSourceOutFolder = sourceOutFolder;
        this.mResOutFolder = resOutFolder;
        this.mMonitor = monitor;
        this.mVerbose = verbose;
    }

    public void launch(File executable, List<String> arguments, Map<String, String> envVariableMap) throws IOException, InterruptedException {
        try {
            if (this.mVerbose) {
                StringBuilder sb = new StringBuilder(executable.getAbsolutePath());
                for (String c : arguments) {
                    sb.append(' ').append(c);
                }
                String cmd_line = sb.toString();
                AdtPlugin.printToConsole(this.mProject, cmd_line);
            }
            String[] commandArray = new String[1 + arguments.size()];
            commandArray[0] = executable.getAbsolutePath();
            System.arraycopy(arguments.toArray(), 0, commandArray, 1, arguments.size());
            ProcessBuilder processBuilder = new ProcessBuilder(commandArray);
            Map<String, String> processEnvs = processBuilder.environment();
            for (Map.Entry<String, String> entry : envVariableMap.entrySet()) {
                processEnvs.put(entry.getKey(), entry.getValue());
            }
            Process p = processBuilder.start();
            ArrayList<String> stdErr = new ArrayList<String>();
            int returnCode = BuildHelper.grabProcessOutput(this.mProject, p, stdErr);
            if (stdErr.size() > 0) {
                boolean parsingError = this.parseLlvmOutput(stdErr);
                if (returnCode != 0) {
                    if (parsingError || this.mVerbose) {
                        if (parsingError) {
                            AdtPlugin.printErrorToConsole(this.mProject, stdErr.toArray());
                            BaseProjectHelper.markResource((IResource)this.mProject, "com.android.ide.eclipse.common.rsProblem", "Unparsed Renderscript error! Check the console for output.", 2);
                        } else {
                            AdtPlugin.printToConsole(this.mProject, stdErr.toArray());
                        }
                    }
                    return;
                }
            } else if (returnCode != 0) {
                String msg = String.format("Error executing Renderscript: Return code %1$d", returnCode);
                BaseProjectHelper.markResource((IResource)this.mProject, "com.android.ide.eclipse.common.aidlProblem", msg, 2);
                return;
            }
        }
        catch (IOException e) {
            String msg = String.format("Error executing Renderscript. Please check %1$s is present at %2$s", executable.getName(), executable.getAbsolutePath());
            AdtPlugin.log(4, msg, new Object[0]);
            BaseProjectHelper.markResource((IResource)this.mProject, "com.android.ide.eclipse.common.rsProblem", msg, 2);
            throw e;
        }
        catch (InterruptedException e) {
            String msg = String.format("Error executing Renderscript. Please check %1$s is present at %2$s", executable.getName(), executable.getAbsolutePath());
            AdtPlugin.log(4, msg, new Object[0]);
            BaseProjectHelper.markResource((IResource)this.mProject, "com.android.ide.eclipse.common.rsProblem", msg, 2);
            throw e;
        }
        try {
            this.mSourceOutFolder.refreshLocal(1, this.mMonitor);
            this.mResOutFolder.refreshLocal(1, this.mMonitor);
        }
        catch (CoreException e) {
            AdtPlugin.log(e, "failed to refresh folders", new Object[0]);
        }
    }

    private boolean parseLlvmOutput(ArrayList<String> lines) {
        if (lines.size() == 0) {
            return false;
        }
        String rootPath = this.mProject.getLocation().toOSString();
        int rootPathLength = rootPath.length();
        boolean parsing = false;
        int i = 0;
        while (i < lines.size()) {
            String p = lines.get(i);
            Matcher m = sLlvmPattern1.matcher(p);
            if (m.matches()) {
                String filePath = m.group(1);
                if (!filePath.startsWith(rootPath)) {
                    parsing = true;
                } else {
                    if ((filePath = filePath.substring(rootPathLength)).startsWith(File.separator)) {
                        filePath = filePath.substring(1);
                    }
                    IFile f = this.mProject.getFile((IPath)new Path(filePath));
                    String lineStr = m.group(2);
                    String msg = m.group(4);
                    int line = 0;
                    try {
                        line = Integer.parseInt(lineStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return true;
                    }
                    BaseProjectHelper.markResource((IResource)f, "com.android.ide.eclipse.common.rsProblem", msg, line, 2);
                }
            } else {
                parsing = true;
            }
            ++i;
        }
        return parsing;
    }
}

