/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build.builders;

import com.android.annotations.NonNull;
import com.android.ide.eclipse.adt.internal.build.builders.ChangedFileSet;
import com.android.ide.eclipse.adt.internal.build.builders.JavaResChangedSet;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

class ChangedFileSetHelper {
    static final ChangedFileSet MANIFEST = new ChangedFileSet("manifest", "AndroidManifest.xml");
    static final ChangedFileSet NATIVE_LIBS = new ChangedFileSet("nativeLibs", "libs/*/*.so", "libs/*/gdbserver");

    ChangedFileSetHelper() {
    }

    static ChangedFileSet getJavaResCfs(@NonNull IProject project) {
        IPath projectPath = project.getFullPath();
        List<IPath> srcPaths = BaseProjectHelper.getSourceClasspaths(project);
        ArrayList<String> paths = new ArrayList<String>(srcPaths.size());
        for (IPath path : srcPaths) {
            paths.add(String.valueOf(path.makeRelativeTo(projectPath).toString()) + "/**");
        }
        return new JavaResChangedSet("javaRes", paths.toArray(new String[paths.size()]));
    }

    static ChangedFileSet getResCfs(@NonNull IProject project) {
        String path = ChangedFileSetHelper.getRelativeAndroidOut(project);
        ChangedFileSet set = new ChangedFileSet("resources", "res/**", "assets/**", String.valueOf(path) + '/' + "res/bc" + "/**");
        set.setOutput(String.valueOf(path) + '/' + "resources.ap_");
        return set;
    }

    static ChangedFileSet getMergedManifestCfs(@NonNull IProject project) {
        String path = ChangedFileSetHelper.getRelativeAndroidOut(project);
        ChangedFileSet set = new ChangedFileSet("mergedManifest", String.valueOf(path) + '/' + "AndroidManifest.xml");
        return set;
    }

    static ChangedFileSet getTextSymbols(@NonNull IProject project) {
        String path = ChangedFileSetHelper.getRelativeAndroidOut(project);
        ChangedFileSet set = new ChangedFileSet("textSymbols", String.valueOf(path) + '/' + "R.txt");
        return set;
    }

    static ChangedFileSet getByteCodeCfs(@NonNull IProject project) {
        String path = ChangedFileSetHelper.getRelativeJavaCOut(project);
        ChangedFileSet set = new ChangedFileSet("compiledCode", String.valueOf(path) + "/**/*" + ".class");
        return set;
    }

    static ChangedFileSet getFullResCfs(@NonNull IProject project) {
        String path = ChangedFileSetHelper.getRelativeAndroidOut(project);
        ChangedFileSet set = new ChangedFileSet("libResources", "res/**", String.valueOf(path) + '/' + "res" + "/**");
        return set;
    }

    static ChangedFileSet getCodeCfs(@NonNull IProject project) {
        String path = ChangedFileSetHelper.getRelativeJavaCOut(project);
        ChangedFileSet set = new ChangedFileSet("classAndJars", String.valueOf(path) + "/**/*" + ".class", "libs/*.jar");
        path = ChangedFileSetHelper.getRelativeAndroidOut(project);
        set.setOutput(String.valueOf(path) + '/' + "classes.dex");
        return set;
    }

    private static String getRelativePath(@NonNull IProject project, @NonNull IResource resource) {
        return resource.getFullPath().makeRelativeTo(project.getFullPath()).toString();
    }

    private static String getRelativeAndroidOut(@NonNull IProject project) {
        IFolder folder = BaseProjectHelper.getAndroidOutputFolder(project);
        return ChangedFileSetHelper.getRelativePath(project, (IResource)folder);
    }

    private static String getRelativeJavaCOut(@NonNull IProject project) {
        IFolder folder = BaseProjectHelper.getJavaOutputFolder(project);
        return ChangedFileSetHelper.getRelativePath(project, (IResource)folder);
    }
}

