/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlCharacterMatcher;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.formatting.EclipseXmlFormatPreferences;
import com.android.utils.Pair;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class AndroidXmlAutoEditStrategy
implements IAutoEditStrategy {
    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void customizeDocumentCommand(IDocument document, DocumentCommand c) {
        block26: {
            if (!AndroidXmlAutoEditStrategy.isSmartInsertMode()) {
                return;
            }
            if (!(document instanceof IStructuredDocument)) {
                return;
            }
            doc = (IStructuredDocument)document;
            if (c.length != 0) return;
            if (c.text == null) return;
            if (TextUtilities.endsWith((String[])doc.getLegalLineDelimiters(), (String)c.text) == -1) return;
            modelManager = StructuredModelManager.getModelManager();
            model = modelManager.getModelForRead(doc);
            if (model == null) return;
            try {
                block27: {
                    block29: {
                        block28: {
                            offset = c.offset;
                            lineStart = AndroidXmlAutoEditStrategy.findLineStart((IDocument)doc, offset);
                            textStart = AndroidXmlAutoEditStrategy.findTextStart((IDocument)doc, lineStart, offset);
                            region = doc.getRegionAtCharacterOffset(textStart);
                            if (region == null || !region.getType().equals("XML_TAG_NAME")) break block27;
                            balance = AndroidXmlAutoEditStrategy.getBalance(doc, textStart, offset);
                            tagBalance = (Integer)balance.getFirst();
                            bracketBalance = (Integer)balance.getSecond();
                            lineIndent = "";
                            if (textStart > lineStart) {
                                lineIndent = doc.get(lineStart, textStart - lineStart);
                            }
                            addIndent = false;
                            if (bracketBalance >= 0) break block28;
                            left = AndroidXmlAutoEditStrategy.getRegionAt(doc, offset, true);
                            if (left != null && (left.getType().equals("XML_TAG_CLOSE") || left.getType().equals("XML_EMPTY_TAG_CLOSE"))) {
                                targetBalance = 0;
                                right = AndroidXmlAutoEditStrategy.getRegionAt(doc, offset, false);
                                if (right != null && right.getType().equals("XML_END_TAG_OPEN")) {
                                    targetBalance = -1;
                                }
                                if ((openTag = AndroidXmlCharacterMatcher.findTagBackwards(doc, offset, targetBalance)) != -1) {
                                    lineIndent = AndroidXmlEditor.getIndentAtOffset((IDocument)doc, openTag);
                                }
                            }
                            break block29;
                        }
                        if (tagBalance > 0 || bracketBalance > 0) {
                            addIndent = true;
                        }
                    }
                    sb = new StringBuilder(c.text);
                    sb.append(lineIndent);
                    oneIndentUnit = EclipseXmlFormatPreferences.create().getOneIndentUnit();
                    if (addIndent) {
                        sb.append(oneIndentUnit);
                    }
                    left = AndroidXmlAutoEditStrategy.getRegionAt(doc, offset, true);
                    right = AndroidXmlAutoEditStrategy.getRegionAt(doc, offset, false);
                    if (left != null && right != null && left.getType().equals("XML_TAG_CLOSE") && right.getType().equals("XML_END_TAG_OPEN")) {
                        if (tagBalance > 0 && bracketBalance < 0) {
                            sb.append(oneIndentUnit);
                        }
                        c.caretOffset = offset + sb.length();
                        c.shiftsCaret = false;
                        sb.append(TextUtilities.getDefaultLineDelimiter((IDocument)doc));
                        sb.append(lineIndent);
                    }
                    c.text = sb.toString();
                    return;
                }
                if (region == null || !region.getType().equals("XML_CONTENT")) ** GOTO lbl-1000
                text = region.getText();
                regionStart = region.getStartOffset();
                delta = offset - regionStart;
                inWhitespacePrefix = true;
                i = 0;
                n = Math.min(delta, text.length());
                if (true) ** GOTO lbl77
lbl-1000:
                // 1 sources

                {
                    block30: {
                        this.copyPreviousLineIndentation((IDocument)doc, c);
                        return;
                        do {
                            if (!Character.isWhitespace(ch = text.charAt(i))) {
                                inWhitespacePrefix = false;
                                break;
                            }
                            ++i;
lbl77:
                            // 2 sources

                        } while (i < n);
                        if (!inWhitespacePrefix || (previous = region.getPrevious()) == null || previous.getType() != "XML_TAG_NAME" || (last = (subRegions = previous.getRegions()).get(subRegions.size() - 1)).getType() != "XML_TAG_CLOSE" && last.getType() != "XML_EMPTY_TAG_CLOSE") break block30;
                        v0 = wasClose = last.getType() == "XML_EMPTY_TAG_CLOSE";
                        if (wasClose) break block26;
                        i = subRegions.size() - 2;
                        if (true) ** GOTO lbl98
                    }
                    ** try [egrp 2[TRYBLOCK] [1 : 1059->1077)] { 
lbl85:
                    // 1 sources

                    this.copyPreviousLineIndentation((IDocument)doc, c);
                    return;
                }
            }
lbl87:
            // 2 sources

            catch (BadLocationException e) {
                AdtPlugin.log(e, null, new Object[0]);
                return;
            }
            finally {
                model.releaseFromRead();
            }
            do {
                if ((type = (current = subRegions.get(i)).getType()) != "XML_TAG_NAME") {
                    wasClose = type == "XML_END_TAG_OPEN";
                    break;
                }
                --i;
lbl98:
                // 2 sources

            } while (i >= 0);
        }
        begin = AndroidXmlCharacterMatcher.findTagBackwards(doc, previous.getStartOffset() + last.getStart(), 0);
        prevLineStart = AndroidXmlAutoEditStrategy.findLineStart((IDocument)doc, begin);
        prevTextStart = AndroidXmlAutoEditStrategy.findTextStart((IDocument)doc, prevLineStart, begin);
        lineIndent = "";
        if (prevTextStart > prevLineStart) {
            lineIndent = doc.get(prevLineStart, prevTextStart - prevLineStart);
        }
        sb = new StringBuilder(c.text);
        sb.append(lineIndent);
        i = delta;
        n = text.length();
        while (i < n) {
            ch = text.charAt(i);
            if (ch != ' ') break;
            ++c.length;
            ++i;
        }
        addIndent = last.getType() == "XML_TAG_CLOSE" && wasClose == false;
        whitespaceToEndTag = true;
        i = delta;
        while (i < text.length()) {
            ch = text.charAt(i);
            if (ch == '\n' || !Character.isWhitespace(ch)) {
                whitespaceToEndTag = false;
                break;
            }
            ++i;
        }
        if (whitespaceToEndTag && (next = region.getNext()) != null && next.getType() == "XML_TAG_NAME" && (nextType = next.getRegions().get(0).getType()) == "XML_END_TAG_OPEN") {
            addIndent = false;
        }
        if (addIndent) {
            sb.append(EclipseXmlFormatPreferences.create().getOneIndentUnit());
        }
        c.text = sb.toString();
    }

    public static int findLineStart(IDocument document, int offset) throws BadLocationException {
        offset = Math.max(0, Math.min(offset, document.getLength() - 1));
        IRegion info = document.getLineInformationOfOffset(offset);
        return info.getOffset();
    }

    public static int findTextStart(IDocument document, int lineStart, int lineEnd) throws BadLocationException {
        int offset = lineStart;
        while (offset < lineEnd) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return lineEnd;
    }

    private void copyPreviousLineIndentation(IDocument doc, DocumentCommand command) throws BadLocationException {
        if (command.offset == -1 || doc.getLength() == 0) {
            return;
        }
        int lineStart = AndroidXmlAutoEditStrategy.findLineStart(doc, command.offset);
        int textStart = AndroidXmlAutoEditStrategy.findTextStart(doc, lineStart, command.offset);
        StringBuilder sb = new StringBuilder(command.text);
        if (textStart > lineStart) {
            sb.append(doc.get(lineStart, textStart - lineStart));
        }
        command.text = sb.toString();
    }

    private static ITextRegion getRegionAt(IStructuredDocument doc, int offset, boolean biasLeft) {
        IStructuredDocumentRegion region;
        if (biasLeft) {
            --offset;
        }
        if ((region = doc.getRegionAtCharacterOffset(offset)) != null) {
            return region.getRegionAtCharacterOffset(offset);
        }
        return null;
    }

    private static Pair<Integer, Integer> getBalance(IStructuredDocument doc, int start, int end) {
        int tagBalance = 0;
        int bracketBalance = 0;
        IStructuredDocumentRegion region = doc.getRegionAtCharacterOffset(start);
        if (region != null) {
            boolean inOpenTag = true;
            while (region != null && region.getStartOffset() < end) {
                int regionStart = region.getStartOffset();
                ITextRegionList subRegions = region.getRegions();
                int i = 0;
                int n = subRegions.size();
                while (i < n) {
                    ITextRegion subRegion = subRegions.get(i);
                    int subRegionStart = regionStart + subRegion.getStart();
                    int subRegionEnd = regionStart + subRegion.getEnd();
                    if (subRegionEnd >= start && subRegionStart < end) {
                        String type = subRegion.getType();
                        if ("XML_TAG_OPEN".equals(type)) {
                            ++bracketBalance;
                            inOpenTag = true;
                        } else if ("XML_TAG_CLOSE".equals(type)) {
                            --bracketBalance;
                            tagBalance = inOpenTag ? ++tagBalance : --tagBalance;
                        } else if ("XML_END_TAG_OPEN".equals(type)) {
                            ++bracketBalance;
                            inOpenTag = false;
                        } else if ("XML_EMPTY_TAG_CLOSE".equals(type)) {
                            --bracketBalance;
                        }
                    }
                    ++i;
                }
                region = region.getNext();
            }
        }
        return Pair.of((Object)tagBalance, (Object)bracketBalance);
    }

    private static boolean isSmartInsertMode() {
        ITextEditor textEditor = AdtUtils.getActiveTextEditor();
        if (textEditor instanceof ITextEditorExtension3) {
            ITextEditorExtension3 editor = (ITextEditorExtension3)textEditor;
            return editor.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return true;
    }
}

