/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.internal.editors.ui.ErrorImageComposite;
import com.google.common.collect.Maps;
import java.net.URL;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class IconFactory {
    public static final int COLOR_RED = 4;
    public static final int COLOR_GREEN = 6;
    public static final int COLOR_BLUE = 10;
    public static final int COLOR_DEFAULT = 2;
    public static final int SHAPE_CIRCLE = 67;
    public static final int SHAPE_RECT = 82;
    public static final int SHAPE_DEFAULT = 67;
    private static IconFactory sInstance;
    private Map<String, Image> mIconMap = Maps.newHashMap();
    private Map<URL, Image> mUrlMap = Maps.newHashMap();
    private Map<String, ImageDescriptor> mImageDescMap = Maps.newHashMap();
    private Map<Image, Image> mErrorIcons;
    private Map<Image, Image> mWarningIcons;

    private IconFactory() {
    }

    public static synchronized IconFactory getInstance() {
        if (sInstance == null) {
            sInstance = new IconFactory();
        }
        return sInstance;
    }

    public void dispose() {
        for (Image icon : this.mIconMap.values()) {
            if (icon == null) continue;
            icon.dispose();
        }
        this.mIconMap.clear();
        for (Image icon : this.mUrlMap.values()) {
            if (icon == null) continue;
            icon.dispose();
        }
        this.mUrlMap.clear();
        if (this.mErrorIcons != null) {
            for (Image icon : this.mErrorIcons.values()) {
                if (icon == null) continue;
                icon.dispose();
            }
            this.mErrorIcons = null;
        }
        if (this.mWarningIcons != null) {
            for (Image icon : this.mWarningIcons.values()) {
                if (icon == null) continue;
                icon.dispose();
            }
            this.mWarningIcons = null;
        }
    }

    public Image getIcon(String osName) {
        return this.getIcon(osName, 2, 67);
    }

    public Image getIcon(String osName, int color, int shape) {
        String key = String.valueOf(Character.toString((char)shape)) + Integer.toString(color) + osName;
        Image icon = this.mIconMap.get(key);
        if (icon == null && !this.mIconMap.containsKey(key)) {
            ImageDescriptor id = this.getImageDescriptor(osName, color, shape);
            if (id != null) {
                icon = id.createImage();
            }
            this.mIconMap.put(key, icon);
        }
        return icon;
    }

    public ImageDescriptor getImageDescriptor(String osName) {
        return this.getImageDescriptor(osName, 2, 67);
    }

    public ImageDescriptor getImageDescriptor(String osName, int color, int shape) {
        String key = String.valueOf(Character.toString((char)shape)) + Integer.toString(color) + osName;
        ImageDescriptor id = this.mImageDescMap.get(key);
        if (id == null && !this.mImageDescMap.containsKey(key)) {
            id = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.android.ide.eclipse.adt", (String)String.format("/icons/%1$s.png", osName));
            if (id == null) {
                id = new LetterImageDescriptor(osName.charAt(0), color, shape);
            }
            this.mImageDescMap.put(key, id);
        }
        return id;
    }

    @Nullable
    public Image getIcon(@NonNull String osName, @Nullable String fallback) {
        String key = osName;
        Image icon = this.mIconMap.get(key);
        if (icon == null && !this.mIconMap.containsKey(key)) {
            ImageDescriptor id = this.getImageDescriptor(osName, fallback);
            if (id != null) {
                icon = id.createImage();
            }
            this.mIconMap.put(key, icon);
        }
        return icon;
    }

    @Nullable
    public ImageDescriptor getImageDescriptor(@NonNull String key, @Nullable String fallbackKey) {
        ImageDescriptor id = this.mImageDescMap.get(key);
        if (id == null && !this.mImageDescMap.containsKey(key)) {
            id = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.android.ide.eclipse.adt", (String)String.format("/icons/%1$s.png", key));
            if (id == null) {
                if (fallbackKey == null) {
                    return null;
                }
                id = this.getImageDescriptor(fallbackKey);
            }
            this.mImageDescMap.put(key, id);
        }
        return id;
    }

    public Image getIcon(URL url) {
        Image image = this.mUrlMap.get(url);
        if (image == null) {
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
            image = descriptor.createImage();
            this.mUrlMap.put(url, image);
        }
        return image;
    }

    @NonNull
    public Image addErrorIcon(@NonNull Image image) {
        Image combined;
        if (this.mErrorIcons != null) {
            combined = this.mErrorIcons.get(image);
            if (combined != null) {
                return combined;
            }
        } else {
            this.mErrorIcons = new IdentityHashMap<Image, Image>();
        }
        combined = new ErrorImageComposite(image, false).createImage();
        this.mErrorIcons.put(image, combined);
        return combined;
    }

    @NonNull
    public Image addWarningIcon(@NonNull Image image) {
        Image combined;
        if (this.mWarningIcons != null) {
            combined = this.mWarningIcons.get(image);
            if (combined != null) {
                return combined;
            }
        } else {
            this.mWarningIcons = new IdentityHashMap<Image, Image>();
        }
        combined = new ErrorImageComposite(image, true).createImage();
        this.mWarningIcons.put(image, combined);
        return combined;
    }

    private static class LetterImageDescriptor
    extends ImageDescriptor {
        private final char mLetter;
        private final int mColor;
        private final int mShape;

        public LetterImageDescriptor(char letter, int color, int shape) {
            this.mLetter = Character.toUpperCase(letter);
            this.mColor = color;
            this.mShape = shape;
        }

        public ImageData getImageData() {
            int backgroundPixel;
            Display display = Display.getCurrent();
            if (display == null) {
                return null;
            }
            Image image = new Image((Device)display, 15, 15);
            GC gc = new GC((Drawable)image);
            gc.setAdvanced(true);
            gc.setAntialias(1);
            gc.setTextAntialias(1);
            RGB backgroundRgb = new RGB(254, 254, 254);
            Color backgroundColor = new Color((Device)display, backgroundRgb);
            gc.setBackground(backgroundColor);
            gc.fillRectangle(0, 0, 15, 15);
            gc.setBackground(display.getSystemColor(1));
            if (this.mShape == 67) {
                gc.fillOval(0, 0, 14, 14);
            } else if (this.mShape == 82) {
                gc.fillRoundRectangle(0, 0, 14, 14, 4, 4);
            }
            gc.setForeground(display.getSystemColor(2));
            gc.setLineWidth(1);
            if (this.mShape == 67) {
                gc.drawOval(0, 0, 14, 14);
            } else if (this.mShape == 82) {
                gc.drawRoundRectangle(0, 0, 14, 14, 4, 4);
            }
            Font font = display.getSystemFont();
            FontData[] fds = font.getFontData();
            fds[0].setStyle(1);
            fds[0].setHeight((int)(864.0 / (double)display.getDPI().y));
            font = new Font((Device)display, fds);
            gc.setFont(font);
            gc.setForeground(display.getSystemColor(this.mColor));
            int ofx = 0;
            int ofy = 0;
            if (SdkConstants.CURRENT_PLATFORM == 2) {
                ofx = 1;
                ofy = -1;
            } else if (SdkConstants.CURRENT_PLATFORM == 3) {
                if (this.mLetter != 'T' && this.mLetter != 'V') {
                    ofy = -1;
                }
                if (this.mLetter == 'I') {
                    ofx = -2;
                }
            }
            String s = Character.toString(this.mLetter);
            Point p = gc.textExtent(s);
            int tx = (15 + ofx - p.x) / 2;
            int ty = (15 + ofy - p.y) / 2;
            gc.drawText(s, tx, ty, true);
            font.dispose();
            gc.dispose();
            ImageData data = image.getImageData();
            image.dispose();
            backgroundColor.dispose();
            data.transparentPixel = backgroundPixel = data.palette.getPixel(backgroundRgb);
            return data;
        }
    }
}

